/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.util.concurrent.atomic.AtomicInteger;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.IntIndex;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.persist.BitMapCachedObject;
import org.hsqldb.persist.BlockObjectStore;
import org.hsqldb.persist.CachedObjectBase;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.DataSpaceManager;
import org.hsqldb.persist.DirectoryBlockCachedObject;
import org.hsqldb.persist.IntArrayCachedObject;
import org.hsqldb.persist.TableSpaceManager;
import org.hsqldb.persist.TableSpaceManagerBlocks;

public class DataSpaceManagerBlocks
implements DataSpaceManager {
    DataFileCache cache;
    TableSpaceManagerBlocks defaultSpaceManager;
    TableSpaceManagerBlocks directorySpaceManager;
    IntKeyHashMap spaceManagerList;
    BlockObjectStore rootStore;
    BlockObjectStore directoryStore;
    BlockObjectStore bitMapStore;
    IntArrayCachedObject rootBlock;
    AtomicInteger spaceIdSequence = new AtomicInteger(8);
    IntIndex emptySpaceList;
    int released = 0;
    static final int blockSize = 2048;
    static final int fileBlockItemCountLimit = 65536;
    int bitmapIntSize;
    int bitmapStorageSize;
    int fileBlockItemCount;
    int fileBlockSize;
    int dataFileScale;
    BlockAccessor ba;

    public DataSpaceManagerBlocks(DataFileCache dataFileCache) {
        this.cache = dataFileCache;
        this.dataFileScale = this.cache.getDataFileScale();
        this.fileBlockSize = this.cache.database.logger.getDataFileSpaces() * 1024 * 1024;
        this.fileBlockItemCount = this.fileBlockSize / this.dataFileScale;
        this.bitmapIntSize = this.fileBlockItemCount / 32;
        this.bitmapStorageSize = 4 * this.bitmapIntSize;
        if (this.bitmapStorageSize < 4096) {
            this.bitmapStorageSize = 4096;
        }
        this.ba = new BlockAccessor();
        this.spaceManagerList = new IntKeyHashMap();
        this.emptySpaceList = new IntIndex(32, false);
        this.directorySpaceManager = new TableSpaceManagerBlocks(this, 1, this.fileBlockSize, 16, this.dataFileScale, 0);
        this.defaultSpaceManager = new TableSpaceManagerBlocks(this, 7, this.fileBlockSize, this.cache.database.logger.propMaxFreeBlocks, this.dataFileScale, this.cache.database.logger.propMinReuse);
        this.spaceManagerList.put(1, this.directorySpaceManager);
        this.spaceManagerList.put(7, this.defaultSpaceManager);
        this.rootStore = new BlockObjectStore(this.cache, this.directorySpaceManager, IntArrayCachedObject.class, 8192, 2048);
        this.directoryStore = new BlockObjectStore(this.cache, this.directorySpaceManager, DirectoryBlockCachedObject.class, 24576, 2048);
        this.bitMapStore = new BlockObjectStore(this.cache, this.directorySpaceManager, BitMapCachedObject.class, this.bitmapStorageSize, this.bitmapIntSize);
        if (this.cache.spaceManagerPosition == 0L) {
            this.initialiseNewSpaceDirectory();
            this.cache.spaceManagerPosition = this.rootBlock.getPos() * (long)this.dataFileScale;
        } else {
            long l = this.cache.spaceManagerPosition / (long)this.dataFileScale;
            this.rootBlock = (IntArrayCachedObject)this.rootStore.get(l, true);
            if (this.getBlockIndexLimit() == 0) {
                throw Error.error(452);
            }
            this.initialiseSpaceList();
            this.initialiseTableSpace(this.directorySpaceManager);
            this.initialiseTableSpace(this.defaultSpaceManager);
        }
    }

    private void initialiseNewSpaceDirectory() {
        long l = this.cache.getFileFreePos();
        long l2 = l / (long)this.fileBlockSize + 1L;
        long l3 = this.cache.enlargeFileSpace(l2 * (long)this.fileBlockSize - l);
        this.defaultSpaceManager.initialiseFileBlock(null, l3, this.cache.getFileFreePos());
        long l4 = l2;
        long l5 = this.calculateDirectorySpaceBlocks(l2);
        l3 = this.cache.enlargeFileSpace(l5 * (long)this.fileBlockSize);
        this.directorySpaceManager.initialiseFileBlock(null, l3, this.cache.getFileFreePos());
        IntArrayCachedObject intArrayCachedObject = new IntArrayCachedObject(2048);
        this.rootStore.add(intArrayCachedObject, true);
        this.rootBlock = intArrayCachedObject;
        this.createFileBlocksInDirectory((int)l4, (int)l5, 1);
        this.createFileBlocksInDirectory(0, (int)l4, 7);
    }

    private long calculateDirectorySpaceBlocks(long l) {
        long l2 = this.calculateDirectorySpaceSize(l);
        long l3 = l2 / (long)this.fileBlockSize + 1L;
        l2 += this.calculateDirectorySpaceSize(l3);
        l3 = l2 / (long)this.fileBlockSize + 1L;
        return l3;
    }

    private long calculateDirectorySpaceSize(long l) {
        long l2 = ArrayUtil.getBinaryMultipleCeiling(l + 1L, 2048L);
        long l3 = 4L * l2;
        l3 += 12L * l2;
        return l3 += (long)this.bitmapStorageSize * (l + 1L);
    }

    private void ensureDirectorySpaceAvailable(int n) {
        int n2 = this.bitmapStorageSize * n + 24576;
        if (!this.directorySpaceManager.hasFileRoom(n2)) {
            int n3 = this.getBlockIndexLimit();
            int n4 = n2 / this.fileBlockSize + 1;
            long l = this.cache.enlargeFileSpace((long)n4 * (long)this.fileBlockSize);
            this.directorySpaceManager.addFileBlock(l, l + (long)n4 * (long)this.fileBlockSize);
            this.createFileBlocksInDirectory(n3, n4, 1);
            n3 = this.getBlockIndexLimit();
            if ((long)n3 * (long)this.fileBlockSize != this.cache.getFileFreePos()) {
                this.cache.logSevereEvent("space manager end file pos different from data file: " + n3 * this.fileBlockSize + ", " + this.cache.getFileFreePos(), null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFileBlocks(int n, int n2) {
        this.cache.writeLock.lock();
        try {
            long l = this.getExistingBlockIndex(n, n2);
            if (l > 0L) {
                long l2 = l * (long)this.fileBlockSize;
                return l2;
            }
            long l3 = this.getNewFileBlocks(n, n2);
            return l3;
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    private long getNewFileBlocks(int n, int n2) {
        this.ensureDirectorySpaceAvailable(n2);
        return this.getNewFileBlocksNoCheck(n, n2);
    }

    private long getNewFileBlocksNoCheck(int n, int n2) {
        long l = this.getBlockIndexLimit();
        long l2 = l * (long)this.fileBlockSize;
        long l3 = l2 + (long)n2 * (long)this.fileBlockSize - this.cache.getFileFreePos();
        if (l3 > 0L) {
            this.cache.enlargeFileSpace(l3);
        }
        this.createFileBlocksInDirectory((int)l, n2, n);
        return l2;
    }

    private void createFileBlocksInDirectory(int n, int n2, int n3) {
        for (int i = 0; i < n2; ++i) {
            this.createFileBlockInDirectory(n + i, n3);
        }
    }

    private void createFileBlockInDirectory(int n, int n2) {
        BitMapCachedObject bitMapCachedObject = new BitMapCachedObject(this.bitmapIntSize);
        this.bitMapStore.add(bitMapCachedObject, false);
        int n3 = (int)(bitMapCachedObject.getPos() * (long)this.dataFileScale / 4096L);
        int n4 = n % 2048;
        DirectoryBlockCachedObject directoryBlockCachedObject = this.getDirectory(n, true);
        if (directoryBlockCachedObject == null) {
            this.createDirectory(n);
            directoryBlockCachedObject = this.getDirectory(n, true);
        }
        directoryBlockCachedObject.getTableIdArray()[n4] = n2;
        directoryBlockCachedObject.getBitmapAddressArray()[n4] = n3;
        directoryBlockCachedObject.setChanged(true);
        directoryBlockCachedObject.keepInMemory(false);
    }

    private DirectoryBlockCachedObject getDirectory(int n, boolean bl) {
        int n2 = n / 2048;
        long l = this.rootBlock.getIntArray()[n2];
        if (l == 0L) {
            return null;
        }
        DirectoryBlockCachedObject directoryBlockCachedObject = (DirectoryBlockCachedObject)this.directoryStore.get(l *= (long)(4096 / this.dataFileScale), bl);
        return directoryBlockCachedObject;
    }

    private void createDirectory(int n) {
        int n2;
        DirectoryBlockCachedObject directoryBlockCachedObject = new DirectoryBlockCachedObject(2048);
        this.directoryStore.add(directoryBlockCachedObject, false);
        int n3 = n / 2048;
        this.rootBlock.getIntArray()[n3] = n2 = (int)(directoryBlockCachedObject.getPos() * (long)this.dataFileScale / 4096L);
        this.rootBlock.setChanged(true);
    }

    private int getBlockIndexLimit() {
        int n;
        int n2;
        int[] nArray = this.rootBlock.getIntArray();
        for (n2 = 0; n2 < nArray.length && nArray[n2] != 0; ++n2) {
        }
        if (n2 == 0) {
            return 0;
        }
        long l = nArray[--n2];
        DirectoryBlockCachedObject directoryBlockCachedObject = (DirectoryBlockCachedObject)this.directoryStore.get(l *= (long)(4096 / this.dataFileScale), false);
        int[] nArray2 = directoryBlockCachedObject.getBitmapAddressArray();
        for (n = 0; n < nArray2.length && nArray2[n] != 0; ++n) {
        }
        return n2 * 2048 + n;
    }

    private void initialiseSpaceList() {
        boolean bl;
        int n = 7;
        this.ba.initialise(false);
        while (bl = this.ba.nextBlock()) {
            int n2 = this.ba.getTableId();
            if (n2 > n) {
                n = n2;
            }
            if (n2 != 0) continue;
            this.emptySpaceList.addUnique(this.ba.currentBlockIndex);
        }
        this.ba.reset();
        this.spaceIdSequence.set(n + 2 & 0xFFFFFFFE);
    }

    private int getExistingBlockIndex(int n, int n2) {
        int n3 = this.emptySpaceList.removeFirstConsecutiveKeys(n2, -1);
        if (n3 > 0) {
            this.setDirectoryBlocksAsTable(n, n3, n2);
        }
        return n3;
    }

    private void setDirectoryBlocksAsTable(int n, int n2, int n3) {
        int n4 = -1;
        CachedObjectBase cachedObjectBase = null;
        for (int i = n2; i < n2 + n3; ++i) {
            if (n4 != i / 2048) {
                if (cachedObjectBase != null) {
                    cachedObjectBase.keepInMemory(false);
                }
                cachedObjectBase = this.getDirectory(i, true);
                n4 = i / 2048;
            }
            int n5 = i % 2048;
            ((DirectoryBlockCachedObject)cachedObjectBase).getTableIdArray()[n5] = n;
        }
        cachedObjectBase.keepInMemory(false);
    }

    @Override
    public TableSpaceManager getDefaultTableSpace() {
        return this.defaultSpaceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableSpaceManager getTableSpace(int n) {
        if (n == 7) {
            return this.defaultSpaceManager;
        }
        if (n >= this.spaceIdSequence.get()) {
            this.spaceIdSequence.set(n + 2 & 0xFFFFFFFE);
        }
        this.cache.writeLock.lock();
        try {
            TableSpaceManagerBlocks tableSpaceManagerBlocks = (TableSpaceManagerBlocks)this.spaceManagerList.get(n);
            if (tableSpaceManagerBlocks == null) {
                int n2 = this.cache.database.logger.propMinReuse;
                tableSpaceManagerBlocks = new TableSpaceManagerBlocks(this, n, this.fileBlockSize, this.cache.database.logger.propMaxFreeBlocks, this.dataFileScale, n2);
                this.initialiseTableSpace(tableSpaceManagerBlocks);
                this.spaceManagerList.put(n, tableSpaceManagerBlocks);
            }
            TableSpaceManagerBlocks tableSpaceManagerBlocks2 = tableSpaceManagerBlocks;
            return tableSpaceManagerBlocks2;
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    @Override
    public int getNewTableSpaceID() {
        return this.spaceIdSequence.getAndAdd(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeTableSpace(int n) {
        if (n == 7 || n == 1) {
            return;
        }
        this.cache.writeLock.lock();
        try {
            TableSpaceManager tableSpaceManager = (TableSpaceManager)this.spaceManagerList.get(n);
            if (tableSpaceManager != null) {
                tableSpaceManager.reset();
                this.spaceManagerList.remove(n);
            }
            IntIndex intIndex = new IntIndex(16, false);
            this.ba.initialise(true);
            while (this.ba.nextBlockForTable(n)) {
                intIndex.addUnsorted(this.ba.currentBlockIndex);
                this.ba.setTable(0);
                this.emptySpaceList.addUnique(this.ba.currentBlockIndex);
            }
            this.ba.reset();
            this.cache.releaseRange(intIndex, this.fileBlockItemCount);
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeTableSpace(int n, DoubleIntIndex doubleIntIndex, long l, long l2, boolean bl) {
        int n2;
        if (doubleIntIndex.size() == 0 && l == l2) {
            return;
        }
        doubleIntIndex.compactLookupAsIntervals();
        if (!bl && (n2 = doubleIntIndex.capacity() - doubleIntIndex.size()) > doubleIntIndex.capacity() / 4) {
            doubleIntIndex.setValuesSearchTarget();
            doubleIntIndex.sort();
            return;
        }
        this.cache.writeLock.lock();
        try {
            int n3;
            this.ba.initialise(true);
            int[] nArray = doubleIntIndex.getKeys();
            int[] nArray2 = doubleIntIndex.getValues();
            for (int i = 0; i < doubleIntIndex.size(); ++i) {
                int n4 = nArray[i];
                n3 = nArray2[i];
                this.freeTableSpacePart(n4, n3);
            }
            long l3 = l / (long)this.dataFileScale;
            n3 = (int)((l2 - l) / (long)this.dataFileScale);
            this.freeTableSpacePart(l3, n3);
            this.ba.reset();
        }
        finally {
            this.cache.writeLock.unlock();
        }
        doubleIntIndex.clear();
        doubleIntIndex.setValuesSearchTarget();
    }

    private void freeTableSpacePart(long l, int n) {
        while (n > 0) {
            int n2 = (int)(l / (long)this.fileBlockItemCount);
            int n3 = (int)(l % (long)this.fileBlockItemCount);
            int n4 = this.fileBlockItemCount - n3;
            if (n4 > n) {
                n4 = n;
            }
            this.ba.moveToBlock(n2);
            int n5 = this.ba.setRange(n3, n4);
            if (n5 != n4) {
                this.ba.unsetRange(n3, n4);
                this.cache.logSevereEvent("space manager error - recovered", null);
            }
            n -= n4;
            l += (long)n4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findTableSpace(long l) {
        int n = (int)(l / (long)this.fileBlockItemCount);
        this.cache.writeLock.lock();
        try {
            this.ba.initialise(false);
            boolean bl = this.ba.moveToBlock(n);
            if (!bl) {
                this.ba.reset();
                int n2 = 7;
                return n2;
            }
            int n3 = this.ba.getTableId();
            this.ba.reset();
            int n4 = n3;
            return n4;
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLostBlocksSize() {
        long l = 0L;
        this.cache.writeLock.lock();
        try {
            boolean bl;
            this.ba.initialise(false);
            while (bl = this.ba.nextBlock()) {
                if (this.ba.getTableId() == 1) continue;
                l += (long)(this.ba.getFreeSpaceValue() * this.dataFileScale);
                if (this.ba.getTableId() != 0) continue;
                l += (long)this.fileBlockSize;
            }
            this.ba.reset();
        }
        finally {
            this.cache.writeLock.unlock();
        }
        return l;
    }

    @Override
    public int getFileBlockSize() {
        return this.fileBlockSize;
    }

    @Override
    public boolean isModified() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialiseSpaces() {
        this.cache.writeLock.lock();
        try {
            Iterator iterator = this.spaceManagerList.values().iterator();
            while (iterator.hasNext()) {
                TableSpaceManagerBlocks tableSpaceManagerBlocks = (TableSpaceManagerBlocks)iterator.next();
                this.initialiseTableSpace(tableSpaceManagerBlocks);
            }
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        this.cache.writeLock.lock();
        try {
            Iterator iterator = this.spaceManagerList.values().iterator();
            while (iterator.hasNext()) {
                TableSpaceManagerBlocks tableSpaceManagerBlocks = (TableSpaceManagerBlocks)iterator.next();
                tableSpaceManagerBlocks.reset();
            }
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    @Override
    public boolean isMultiSpace() {
        return true;
    }

    @Override
    public int getFileBlockItemCount() {
        return this.fileBlockItemCount;
    }

    @Override
    public DirectoryBlockCachedObject[] getDirectoryList() {
        int n = 0;
        int[] nArray = this.rootBlock.getIntArray();
        while (nArray[n] != 0) {
            ++n;
        }
        DirectoryBlockCachedObject[] directoryBlockCachedObjectArray = new DirectoryBlockCachedObject[n];
        for (int i = 0; i < directoryBlockCachedObjectArray.length; ++i) {
            directoryBlockCachedObjectArray[i] = this.getDirectory(i * 2048, false);
        }
        return directoryBlockCachedObjectArray;
    }

    private void initialiseTableSpace(TableSpaceManagerBlocks tableSpaceManagerBlocks) {
        char c;
        int n = tableSpaceManagerBlocks.getSpaceID();
        char c2 = '\u0000';
        int n2 = -1;
        int n3 = tableSpaceManagerBlocks.getFileBlockIndex();
        if (n3 >= 0) {
            this.ba.initialise(false);
            c = this.ba.moveToBlock(n3);
            if (c != '\u0000' && this.ba.getTableId() == n && this.ba.getFreeBlockValue() > '\u0000') {
                n2 = n3;
            }
            this.ba.reset();
        }
        if (n2 < 0) {
            this.ba.initialise(false);
            while (this.ba.nextBlockForTable(n)) {
                c = this.ba.getFreeBlockValue();
                if (c <= c2) continue;
                n2 = this.ba.currentBlockIndex;
                c2 = c;
            }
            this.ba.reset();
        }
        if (n2 < 0) {
            return;
        }
        this.ba.initialise(true);
        this.ba.moveToBlock(n2);
        c = this.ba.getFreeBlockValue();
        long l = (long)n2 * (long)this.fileBlockSize;
        int n4 = this.ba.unsetRange(this.fileBlockItemCount - c, c);
        if (n4 == c) {
            tableSpaceManagerBlocks.initialiseFileBlock(null, l + (long)(this.fileBlockSize - c * this.dataFileScale), l + (long)this.fileBlockSize);
        } else {
            this.cache.logSevereEvent("space manager error - recovered", null);
        }
        this.ba.reset();
    }

    private class BlockAccessor {
        boolean currentKeep;
        int currentBlockIndex = -1;
        int currentDirIndex = -1;
        int currentBlockOffset = -1;
        DirectoryBlockCachedObject currentDir = null;
        BitMapCachedObject currentBitMap = null;

        private BlockAccessor() {
        }

        void initialise(boolean bl) {
            this.currentKeep = bl;
        }

        boolean nextBlock() {
            boolean bl = this.moveToBlock(this.currentBlockIndex + 1);
            return bl;
        }

        boolean nextBlockForTable(int n) {
            do {
                boolean bl;
                if (bl = this.moveToBlock(this.currentBlockIndex + 1)) continue;
                return false;
            } while (this.getTableId() != n);
            return true;
        }

        boolean moveToBlock(int n) {
            if (this.currentBlockIndex != n) {
                this.endBlockUpdate();
                this.currentBitMap = null;
                if (this.currentDirIndex != n / 2048) {
                    this.reset();
                    this.currentDirIndex = n / 2048;
                    this.currentDir = DataSpaceManagerBlocks.this.getDirectory(n, this.currentKeep);
                }
                if (this.currentDir == null) {
                    this.reset();
                    return false;
                }
                this.currentBlockIndex = n;
                this.currentBlockOffset = n % 2048;
                long l = this.currentDir.getBitmapAddressArray()[this.currentBlockOffset];
                if (l == 0L) {
                    this.reset();
                    return false;
                }
                if (this.currentKeep) {
                    this.currentBitMap = (BitMapCachedObject)DataSpaceManagerBlocks.this.bitMapStore.get(l *= (long)(4096 / DataSpaceManagerBlocks.this.dataFileScale), true);
                }
            }
            return true;
        }

        int setRange(int n, int n2) {
            this.currentBitMap.setChanged(true);
            return this.currentBitMap.bitMap.setRange(n, n2);
        }

        int unsetRange(int n, int n2) {
            this.currentBitMap.setChanged(true);
            return this.currentBitMap.bitMap.unsetRange(n, n2);
        }

        void reset() {
            this.endBlockUpdate();
            if (this.currentDir != null && this.currentKeep) {
                this.currentDir.keepInMemory(false);
            }
            this.currentBlockIndex = -1;
            this.currentDirIndex = -1;
            this.currentBlockOffset = -1;
            this.currentDir = null;
            this.currentBitMap = null;
        }

        private void endBlockUpdate() {
            if (this.currentBitMap == null) {
                return;
            }
            if (!this.currentBitMap.hasChanged()) {
                this.currentBitMap.keepInMemory(false);
                return;
            }
            int n = this.currentBitMap.bitMap.countSetBits();
            int n2 = this.currentBitMap.bitMap.countSetBitsEnd();
            this.currentBitMap.keepInMemory(false);
            if (n == DataSpaceManagerBlocks.this.fileBlockItemCount) {
                this.setTable(0);
                DataSpaceManagerBlocks.this.emptySpaceList.addUnique(this.currentBlockIndex);
                ++DataSpaceManagerBlocks.this.released;
                return;
            }
            this.currentDir.getFreeSpaceArray()[this.currentBlockOffset] = (char)n;
            this.currentDir.getFreeBlockArray()[this.currentBlockOffset] = (char)n2;
            this.currentDir.setChanged(true);
        }

        void setTable(int n) {
            this.currentDir.getTableIdArray()[this.currentBlockOffset] = n;
            this.currentDir.getFreeSpaceArray()[this.currentBlockOffset] = '\u0000';
            this.currentDir.getFreeBlockArray()[this.currentBlockOffset] = '\u0000';
            this.currentDir.setChanged(true);
            this.currentBitMap.bitMap.reset();
            this.currentBitMap.setChanged(true);
        }

        int getTableId() {
            return this.currentDir.getTableIdArray()[this.currentBlockOffset];
        }

        char getFreeSpaceValue() {
            return this.currentDir.getFreeSpaceArray()[this.currentBlockOffset];
        }

        char getFreeBlockValue() {
            return this.currentDir.getFreeBlockArray()[this.currentBlockOffset];
        }
    }
}

