/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.common.components;

import fi.kanta.common.components.IXPathHelper;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.exception.UtilException;
import fi.kanta.common.util.HL7NamespaceContext;
import fi.kanta.common.util.InternalServiceError;
import java.util.ArrayList;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathHelper
implements IXPathHelper {
    Logger log = Logger.getLogger(XPathHelper.class);
    private LogHelper logHelper = new LogHelper();
    private XPath codeXpath = XPathFactory.newInstance().newXPath();
    private XPath codeXpathDN = XPathFactory.newInstance().newXPath();

    public XPathHelper() {
        this.codeXpathDN.setNamespaceContext(new HL7NamespaceContext());
    }

    @Override
    public String getCode(String logId, Element element, String expression) throws UtilException {
        String retStr = null;
        try {
            retStr = this.codeXpath.evaluate(expression, element);
        }
        catch (NumberFormatException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2010");
            error.setCommonError(true);
            throw new UtilException(error, (Throwable)ex);
        }
        catch (XPathExpressionException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2010");
            error.setCommonError(true);
            throw new UtilException(error, (Throwable)ex);
        }
        return retStr;
    }

    @Override
    public String getCodeDN(String logId, Element element, String expression) throws UtilException {
        String retStr = null;
        try {
            retStr = this.codeXpathDN.evaluate(expression, element);
        }
        catch (NumberFormatException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2010");
            error.setCommonError(true);
            throw new UtilException(error, (Throwable)ex);
        }
        catch (XPathExpressionException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2010");
            error.setCommonError(true);
            throw new UtilException(error, (Throwable)ex);
        }
        return retStr;
    }

    @Override
    public String getCode(String logId, Node node, String expression) throws UtilException {
        String retStr = null;
        try {
            retStr = this.codeXpath.evaluate(expression, node);
        }
        catch (NumberFormatException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2010");
            error.setCommonError(true);
            throw new UtilException(error, (Throwable)ex);
        }
        catch (XPathExpressionException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2010");
            error.setCommonError(true);
            throw new UtilException(error, (Throwable)ex);
        }
        return retStr;
    }

    @Override
    public String getCodeDN(String logId, Node node, String expression) throws UtilException {
        String retStr = null;
        try {
            retStr = this.codeXpathDN.evaluate(expression, node);
        }
        catch (NumberFormatException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2010");
            error.setCommonError(true);
            throw new UtilException(error, (Throwable)ex);
        }
        catch (XPathExpressionException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2010");
            error.setCommonError(true);
            throw new UtilException(error, (Throwable)ex);
        }
        return retStr;
    }

    @Override
    public String getCode(String logId, Document document, String expression) throws UtilException {
        String retStr = null;
        try {
            retStr = this.codeXpath.evaluate(expression, document);
        }
        catch (NumberFormatException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2010");
            error.setCommonError(true);
            throw new UtilException(error, (Throwable)ex);
        }
        catch (XPathExpressionException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2010");
            error.setCommonError(true);
            throw new UtilException(error, (Throwable)ex);
        }
        return retStr;
    }

    @Override
    public String getCodeDN(String logId, Document document, String expression) throws UtilException {
        String retStr = null;
        try {
            retStr = this.codeXpathDN.evaluate(expression, document);
        }
        catch (NumberFormatException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2010");
            error.setCommonError(true);
            throw new UtilException(error, (Throwable)ex);
        }
        catch (XPathExpressionException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2010");
            error.setCommonError(true);
            throw new UtilException(error, (Throwable)ex);
        }
        return retStr;
    }

    @Override
    public String getUniqueCodesFromNodeList(String logId, Document document, String expression) throws UtilException {
        StringBuffer retStr = new StringBuffer();
        ArrayList<String> nodevalues = new ArrayList<String>();
        String t = "";
        boolean exists = false;
        try {
            NodeList nodes = (NodeList)this.codeXpath.evaluate(expression, document, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                exists = false;
                String tt = nodes.item(i).getTextContent();
                for (int j = 0; j < nodevalues.size(); ++j) {
                    t = (String)nodevalues.get(j);
                    if (!t.equals(tt)) continue;
                    exists = true;
                }
                if (exists) continue;
                nodevalues.add(tt);
                if (i > 0) {
                    retStr.append(" ");
                }
                retStr.append(tt);
            }
        }
        catch (NumberFormatException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2010");
            error.setCommonError(true);
            throw new UtilException(error, (Throwable)ex);
        }
        catch (XPathExpressionException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2010");
            error.setCommonError(true);
            throw new UtilException(error, (Throwable)ex);
        }
        return retStr.toString();
    }

    @Override
    public String getUniqueCodesFromNodeListDN(String logId, Document document, String expression) throws UtilException {
        StringBuffer retStr = new StringBuffer();
        ArrayList<String> nodevalues = new ArrayList<String>();
        String t = "";
        boolean exists = false;
        try {
            NodeList nodes = (NodeList)this.codeXpathDN.evaluate(expression, document, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                exists = false;
                String tt = nodes.item(i).getTextContent();
                for (int j = 0; j < nodevalues.size(); ++j) {
                    t = (String)nodevalues.get(j);
                    if (!t.equals(tt)) continue;
                    exists = true;
                }
                if (exists) continue;
                nodevalues.add(tt);
                if (i > 0) {
                    retStr.append(" ");
                }
                retStr.append(tt);
            }
        }
        catch (NumberFormatException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2010");
            error.setCommonError(true);
            throw new UtilException(error, (Throwable)ex);
        }
        catch (XPathExpressionException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2010");
            error.setCommonError(true);
            throw new UtilException(error, (Throwable)ex);
        }
        return retStr.toString();
    }

    @Override
    public NodeList getNodeList(String logId, Document document, String expression) throws UtilException {
        NodeList nodes;
        try {
            nodes = (NodeList)this.codeXpath.evaluate(expression, document, XPathConstants.NODESET);
        }
        catch (XPathExpressionException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2010");
            error.setCommonError(true);
            throw new UtilException(error, (Throwable)ex);
        }
        return nodes;
    }

    @Override
    public NodeList getNodeListDN(String logId, Document document, String expression) throws UtilException {
        NodeList nodes;
        try {
            nodes = (NodeList)this.codeXpathDN.evaluate(expression, document, XPathConstants.NODESET);
        }
        catch (XPathExpressionException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2010");
            error.setCommonError(true);
            throw new UtilException(error, (Throwable)ex);
        }
        return nodes;
    }

    @Override
    public Node getNode(String logId, Document document, String expression) throws UtilException {
        Node node = null;
        try {
            node = (Node)this.codeXpath.evaluate(expression, document, XPathConstants.NODE);
        }
        catch (XPathExpressionException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2010");
            error.setCommonError(true);
            throw new UtilException(error, (Throwable)ex);
        }
        return node;
    }

    @Override
    public Node getNodeDN(String logId, Document document, String expression) throws UtilException {
        Node node = null;
        try {
            node = (Node)this.codeXpathDN.evaluate(expression, document, XPathConstants.NODE);
        }
        catch (XPathExpressionException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2010");
            error.setCommonError(true);
            throw new UtilException(error, (Throwable)ex);
        }
        return node;
    }

    @Override
    public NodeList getNodeList(String logId, Element element, String expression) throws UtilException {
        NodeList nodes;
        try {
            nodes = (NodeList)this.codeXpath.evaluate(expression, element, XPathConstants.NODESET);
        }
        catch (XPathExpressionException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2010");
            error.setCommonError(true);
            throw new UtilException(error, (Throwable)ex);
        }
        return nodes;
    }

    @Override
    public NodeList getNodeListDN(String logId, Element element, String expression) throws UtilException {
        NodeList nodes;
        try {
            nodes = (NodeList)this.codeXpathDN.evaluate(expression, element, XPathConstants.NODESET);
        }
        catch (XPathExpressionException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2010");
            error.setCommonError(true);
            throw new UtilException(error, (Throwable)ex);
        }
        return nodes;
    }

    @Override
    public ArrayList getUniqueIIvaluesFromNodeListDN(String logId, Document document, String expression) throws UtilException {
        ArrayList<Object> rval = new ArrayList<Object>();
        try {
            NodeList nodes = (NodeList)this.codeXpathDN.evaluate(expression, document, XPathConstants.NODESET);
            String nodeName = "";
            int y = nodes.getLength();
            for (int i = 0; i < y; ++i) {
                Node node = nodes.item(i);
                NamedNodeMap map = node.getAttributes();
                String root = "";
                String extension = "";
                int x = map.getLength();
                for (int j = 0; j < x; ++j) {
                    Node attrNode = map.item(j);
                    nodeName = attrNode.getNodeName();
                    if (nodeName.equals("root")) {
                        root = attrNode.getNodeValue();
                    }
                    if (!nodeName.equals("extension")) continue;
                    extension = attrNode.getNodeValue();
                }
                Object value = "";
                value = extension.length() > 0 ? root + "." + extension : root;
                rval.add(value);
            }
        }
        catch (NumberFormatException e) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2010");
            error.setCommonError(true);
            throw new UtilException(error, (Throwable)e);
        }
        catch (XPathExpressionException e) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2010");
            error.setCommonError(true);
            throw new UtilException(error, (Throwable)e);
        }
        return rval;
    }

    @Override
    public ArrayList getUniqueCVvaluesFromNodeListDN(String logId, Document document, String expression, String separator) throws UtilException {
        ArrayList<String> rval = new ArrayList<String>();
        try {
            NodeList nodes = (NodeList)this.codeXpathDN.evaluate(expression, document, XPathConstants.NODESET);
            String nodeName = "";
            int y = nodes.getLength();
            for (int i = 0; i < y; ++i) {
                Node node = nodes.item(i);
                NamedNodeMap map = node.getAttributes();
                String root = "";
                String extension = "";
                int x = map.getLength();
                for (int j = 0; j < x; ++j) {
                    Node attrNode = map.item(j);
                    nodeName = attrNode.getNodeName();
                    if (nodeName.equals("codeSystem")) {
                        root = attrNode.getNodeValue();
                    }
                    if (!nodeName.equals("code")) continue;
                    extension = attrNode.getNodeValue();
                }
                Object value = "";
                value = extension.length() > 0 ? root + separator + extension : root;
                rval.add((String)value);
            }
        }
        catch (NumberFormatException e) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2010");
            error.setCommonError(true);
            throw new UtilException(error, (Throwable)e);
        }
        catch (XPathExpressionException e) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2010");
            error.setCommonError(true);
            throw new UtilException(error, (Throwable)e);
        }
        return rval;
    }
}

