/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.client;

import fi.kanta.arkistopalvelu.exception.CodeFetcherException;
import fi.kanta.arkistopalvelu.util.ErrorWrapperArchive;
import fi.kanta.arkistopalvelu.util.configurations.ArkistopalveluConfigManager;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.util.InternalServiceError;
import fi.kanta.koodistopalvelu.webservices.peruskoodisto.BasicCodeIn;
import fi.kanta.koodistopalvelu.webservices.peruskoodisto.BasicCodeResponse;
import fi.kanta.koodistopalvelu.webservices.peruskoodisto.Peruskoodisto;
import fi.kanta.koodistopalvelu.webservices.peruskoodisto.Peruskoodisto_Service;
import java.util.List;
import javax.xml.ws.BindingProvider;
import org.apache.log4j.Logger;

public class FetchCodesClient {
    private static final Logger LOGGER = Logger.getLogger(FetchCodesClient.class);
    private ArkistopalveluConfigManager configManager;
    private LogHelper logHelper;
    private ErrorWrapperArchive errorWrapper = ErrorWrapperArchive.getInstance();
    private String logId;
    private List<BasicCodeIn> codes;

    public FetchCodesClient(String logId, List<BasicCodeIn> codesIn) {
        this.configManager = ArkistopalveluConfigManager.getInstance();
        this.logId = logId;
        this.codes = codesIn;
        this.logHelper = new LogHelper();
    }

    public List<BasicCodeResponse> call() throws CodeFetcherException {
        List retValues = null;
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)this.logHelper.formatMsgBgn(this.logId));
            }
            String urlStr = this.configManager.getArkistoProperties("20").getPeruskoodistourl();
            Peruskoodisto_Service service = new Peruskoodisto_Service();
            Peruskoodisto koodisto = service.getPeruskoodisto();
            BindingProvider bp = (BindingProvider)koodisto;
            bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", urlStr);
            retValues = koodisto.getBasicCode(this.codes, "20");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)this.logHelper.formatMsgEnd(this.logId));
            }
        }
        catch (ClassCastException ex) {
            InternalServiceError error = this.errorWrapper.getError("1016");
            LOGGER.error((Object)this.logHelper.formatMsg(this.logId, error), (Throwable)ex);
            throw new CodeFetcherException(error, ex);
        }
        return retValues;
    }
}

