/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.client;

import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import fi.kanta.arkistopalvelu.exception.KoostekantaException;
import fi.kanta.arkistopalvelu.exception.SaveException;
import fi.kanta.arkistopalvelu.util.ErrorWrapperArchive;
import fi.kanta.arkistopalvelu.util.configurations.ArkistopalveluConfigManager;
import fi.kanta.arkistopalvelu.util.configurations.KoostekantaProperties;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.util.InternalServiceError;
import fi.kela.kanta.koostekanta.rajapinnat.dto.KoosteErrorResponse;
import fi.kela.kanta.koostekanta.rajapinnat.dto.KorvaaKoosteetRequest;
import fi.kela.kanta.koostekanta.rajapinnat.dto.KorvaaKoosteetResponse;
import fi.kela.kanta.koostekanta.rajapinnat.dto.PeruKoosteidenKorvausRequest;
import fi.kela.kanta.koostekanta.rajapinnat.dto.PeruKoosteidenKorvausResponse;
import fi.kela.kanta.koostekanta.rajapinnat.dto.PeruKoosteidenPoistoRequest;
import fi.kela.kanta.koostekanta.rajapinnat.dto.PeruKoosteidenPoistoResponse;
import fi.kela.kanta.koostekanta.rajapinnat.dto.PeruKoosteidenTallennusRequest;
import fi.kela.kanta.koostekanta.rajapinnat.dto.PeruKoosteidenTallennusResponse;
import fi.kela.kanta.koostekanta.rajapinnat.dto.PoistaKoosteetRequest;
import fi.kela.kanta.koostekanta.rajapinnat.dto.PoistaKoosteetResponse;
import fi.kela.kanta.koostekanta.rajapinnat.dto.TallennaKoosteetRequest;
import fi.kela.kanta.koostekanta.rajapinnat.dto.TallennaKoosteetResponse;
import fi.kela.kanta.koostekanta.rajapinnat.dto.VahvistaKoosteidenKorvausRequest;
import fi.kela.kanta.koostekanta.rajapinnat.dto.VahvistaKoosteidenKorvausResponse;
import fi.kela.kanta.koostekanta.rajapinnat.dto.VahvistaKoosteidenPoistoRequest;
import fi.kela.kanta.koostekanta.rajapinnat.dto.VahvistaKoosteidenPoistoResponse;
import fi.kela.kanta.koostekanta.rajapinnat.dto.VahvistaKoosteidenTallennusRequest;
import fi.kela.kanta.koostekanta.rajapinnat.dto.VahvistaKoosteidenTallennusResponse;
import java.math.BigInteger;
import javax.ws.rs.core.MediaType;
import org.apache.log4j.Logger;

public class KoostekantaClient {
    private static final String DEBUG_MESSSAGE_TMP_HETU = "hetu on v\u00e4liaikainen hetu, ei l\u00e4hde koosteisiin.";
    private static final Logger LOGGER = Logger.getLogger(KoostekantaClient.class);
    private LogHelper logHelper = new LogHelper();
    private ErrorWrapperArchive errorWrapper = ErrorWrapperArchive.getInstance();
    private KoostekantaProperties koostekantaProperties;
    private BigInteger koostekantaTimeout;
    private MediaType mediaType;

    public KoostekantaClient(String logId) {
        this.koostekantaProperties = ArkistopalveluConfigManager.getInstance().getKoostekantaProperties(logId);
        this.koostekantaTimeout = ArkistopalveluConfigManager.getInstance().getArkistoProperties(logId).getKoostetimeout();
        this.mediaType = MediaType.APPLICATION_JSON_TYPE;
    }

    public String tallennaKoosteet(String logId, TallennaKoosteetRequest request) throws SaveException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        String returnValue = "T";
        if ("061177-993M".equals(request.getTallennettavanAsiakirjanHenkilotunnusRoot())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)this.logHelper.formatMsg(logId, DEBUG_MESSSAGE_TMP_HETU));
            }
            return "F";
        }
        request.setPoiminnanLahde("PTA");
        String path = this.koostekantaProperties.getTallennaKoosteetPath();
        try {
            this.sendRequest(logId, path, request, TallennaKoosteetResponse.class);
        }
        catch (KoostekantaException e) {
            InternalServiceError error = this.getError(e, "1180");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
            throw new SaveException(error, e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return returnValue;
    }

    public void vahvistaKoosteidenTallennus(String logId, VahvistaKoosteidenTallennusRequest request) throws SaveException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        if ("061177-993M".equals(request.getTallennettavanAsiakirjanHenkilotunnusRoot())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)this.logHelper.formatMsg(logId, DEBUG_MESSSAGE_TMP_HETU));
            }
            return;
        }
        String path = this.koostekantaProperties.getVahvistaKoosteidenTallennusPath();
        try {
            this.sendRequest(logId, path, request, VahvistaKoosteidenTallennusResponse.class);
        }
        catch (KoostekantaException e) {
            InternalServiceError error = this.getError(e, "1181");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
            throw new SaveException(error, e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    public void peruKoosteidenTallennus(String logId, PeruKoosteidenTallennusRequest request) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        if ("061177-993M".equals(request.getTallennettavanAsiakirjanHenkilotunnusRoot())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)this.logHelper.formatMsg(logId, DEBUG_MESSSAGE_TMP_HETU));
            }
            return;
        }
        String path = this.koostekantaProperties.getPeruKoosteidenTallennusPath();
        try {
            this.sendRequest(logId, path, request, PeruKoosteidenTallennusResponse.class);
        }
        catch (KoostekantaException e) {
            InternalServiceError error = this.getError(e, "1182");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
        }
        catch (SaveException saveException) {
            // empty catch block
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    public String korvaaKoosteet(String logId, KorvaaKoosteetRequest request) throws SaveException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        String returnValue = "T";
        request.setPoiminnanLahde("PTA");
        String path = this.koostekantaProperties.getKorvaaKoosteetPath();
        try {
            this.sendRequest(logId, path, request, KorvaaKoosteetResponse.class);
        }
        catch (KoostekantaException e) {
            InternalServiceError error = this.getError(e, "1180");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
            throw new SaveException(error, e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return returnValue;
    }

    public void vahvistaKoosteidenKorvaus(String logId, VahvistaKoosteidenKorvausRequest request) throws SaveException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        String path = this.koostekantaProperties.getVahvistaKoosteidenKorvausPath();
        try {
            this.sendRequest(logId, path, request, VahvistaKoosteidenKorvausResponse.class);
        }
        catch (KoostekantaException e) {
            InternalServiceError error = this.getError(e, "1181");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
            throw new SaveException(error, e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    public void peruKoosteidenKorvaus(String logId, PeruKoosteidenKorvausRequest request) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        String path = this.koostekantaProperties.getPeruKoosteidenKorvausPath();
        try {
            this.sendRequest(logId, path, request, PeruKoosteidenKorvausResponse.class);
        }
        catch (KoostekantaException e) {
            InternalServiceError error = this.getError(e, "1182");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
        }
        catch (SaveException saveException) {
            // empty catch block
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    public String poistaKoosteet(String logId, PoistaKoosteetRequest request) throws SaveException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        String path = this.koostekantaProperties.getPoistaKoosteetPath();
        try {
            this.sendRequest(logId, path, request, PoistaKoosteetResponse.class);
        }
        catch (KoostekantaException e) {
            InternalServiceError error = this.getError(e, "1180");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
            throw new SaveException(error, e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return "T";
    }

    public void vahvistaKoosteidenPoisto(String logId, VahvistaKoosteidenPoistoRequest request) throws SaveException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        String path = this.koostekantaProperties.getVahvistaKoosteidenPoistoPath();
        try {
            this.sendRequest(logId, path, request, VahvistaKoosteidenPoistoResponse.class);
        }
        catch (KoostekantaException e) {
            InternalServiceError error = this.getError(e, "1181");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
            throw new SaveException(error, e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    public void peruKoosteidenPoisto(String logId, PeruKoosteidenPoistoRequest request) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        String path = this.koostekantaProperties.getPeruKoosteidenPoistoPath();
        try {
            this.sendRequest(logId, path, request, PeruKoosteidenPoistoResponse.class);
        }
        catch (KoostekantaException e) {
            InternalServiceError error = this.getError(e, "1182");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
        }
        catch (SaveException saveException) {
            // empty catch block
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    protected Object sendRequest(String logId, String path, Object request, Class<?> responseClass) throws KoostekantaException, SaveException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        Object response = null;
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        if (this.mediaType == MediaType.APPLICATION_JSON_TYPE) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
            JacksonJaxbJsonProvider jacksonJsonProvider = new JacksonJaxbJsonProvider();
            jacksonJsonProvider.setMapper(mapper);
            clientConfig.getSingletons().add(jacksonJsonProvider);
        }
        Client client = Client.create((ClientConfig)clientConfig);
        client.setConnectTimeout(Integer.valueOf(this.koostekantaTimeout.intValue()));
        client.setReadTimeout(Integer.valueOf(this.koostekantaTimeout.intValue()));
        String url = this.koostekantaProperties.getKoostekantaUrl();
        WebResource resource = client.resource(url);
        try {
            ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)resource.path(path).type(this.mediaType).accept(new MediaType[]{this.mediaType})).post(ClientResponse.class, request);
            ClientResponse.Status status = clientResponse.getClientResponseStatus();
            if (status.getStatusCode() != ClientResponse.Status.OK.getStatusCode()) {
                KoosteErrorResponse errorResponse = (KoosteErrorResponse)clientResponse.getEntity(KoosteErrorResponse.class);
                throw new KoostekantaException(errorResponse);
            }
            response = clientResponse.getEntity(responseClass);
        }
        catch (ClientHandlerException e) {
            InternalServiceError error = this.errorWrapper.getError("1180");
            error.setErrorMessage("Virhe yhteydess\u00e4 koostekantaan");
            error.setErrorDescription(e.getMessage());
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
            throw new SaveException(error, e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return response;
    }

    private InternalServiceError getError(KoostekantaException exception, String errorCode) {
        KoosteErrorResponse errorResponse = exception.getErrorResponse();
        InternalServiceError error = this.errorWrapper.getError(errorCode);
        if (errorResponse.getResultCode() != null && !errorResponse.getResultCode().isEmpty()) {
            error.setErrorCode(errorResponse.getResultCode());
            error.setErrorMessage(errorResponse.getDescription());
            error.setErrorDescription(errorResponse.getDetailedDescription());
        } else {
            error.setErrorDescription(exception.getMessage());
        }
        return error;
    }
}

