/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.client;

import fi.kanta.arkistopalvelu.luovutusloki.webservices.NewLogMessagePortType;
import fi.kanta.arkistopalvelu.luovutusloki.webservices.NewLogMessageService;
import fi.kanta.arkistopalvelu.luovutusloki.webservices.web.AddInvalidationWebType;
import fi.kanta.arkistopalvelu.luovutusloki.webservices.web.AddWebType;
import fi.kanta.arkistopalvelu.luovutusloki.webservices.web.ResultDetails;
import fi.kanta.arkistopalvelu.luovutusloki.webservices.web.ResultDetailsForInvalidation;
import fi.kanta.arkistopalvelu.luovutusloki.webservices.web.SaveInteractionWeb;
import fi.kanta.arkistopalvelu.luovutusloki.webservices.web.SaveInvalidationInteractionWeb;
import fi.kanta.arkistopalvelu.util.ErrorWrapperArchive;
import fi.kanta.arkistopalvelu.util.ISaveObject;
import fi.kanta.arkistopalvelu.util.SaveObjectLuovutusloki;
import fi.kanta.arkistopalvelu.util.configurations.ArkistopalveluConfigManager;
import fi.kanta.arkistopalvelu.webservices.compensatelog.CompensateLog;
import fi.kanta.arkistopalvelu.webservices.compensatelog.CompensateLog_Service;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.exception.UtilException;
import fi.kanta.common.util.InternalServiceError;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import org.apache.log4j.Logger;

public class LuovutusClient {
    private ErrorWrapperArchive errorWrapper;
    private static final Logger LOGGER = Logger.getLogger(LuovutusClient.class);
    private LogHelper logHelper = new LogHelper();

    public LuovutusClient() {
        this.errorWrapper = ErrorWrapperArchive.getInstance();
    }

    public void saveLog(String logId, ISaveObject saveObject) throws UtilException {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
            }
            URL url = new URL(ArkistopalveluConfigManager.getInstance().getArkistoProperties(logId).getLogmessageserviceurl());
            NewLogMessageService service = new NewLogMessageService(url, new QName("http://webservices.luovutusloki.arkistopalvelu.kanta.fi/", "NewLogMessageService"));
            NewLogMessagePortType port = service.getNewLogMessagePort();
            AddWebType add = new AddWebType();
            add.setLogDetailsWeb(this.setLogDetails(logId, (SaveObjectLuovutusloki)saveObject));
            add.getAcquiredDocumentDetailsWeb().addAll(((SaveObjectLuovutusloki)saveObject).getAquiredDocumentDetails());
            SaveInteractionWeb saveInteraction = port.add(add);
            ResultDetails returnvalue = saveInteraction.getResultDetails();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)this.logHelper.formatMsg(logId, "DETAILS: " + returnvalue.getResultCode()));
            }
            if (!returnvalue.getResultCode().equals("800000")) {
                InternalServiceError error = this.errorWrapper.getError("1045");
                error.setErrorDescription(returnvalue.getDescription());
                LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
                throw new UtilException(error);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
            }
        }
        catch (MalformedURLException me) {
            InternalServiceError error = this.errorWrapper.getError("1045");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)me);
            throw new UtilException(error, (Throwable)me);
        }
    }

    public void saveInvalidationLog(String logId, ISaveObject saveObject) throws UtilException {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
            }
            URL url = new URL(ArkistopalveluConfigManager.getInstance().getArkistoProperties(logId).getLogmessageserviceurl());
            NewLogMessageService service = new NewLogMessageService(url, new QName("http://webservices.luovutusloki.arkistopalvelu.kanta.fi/", "NewLogMessageService"));
            NewLogMessagePortType port = service.getNewLogMessagePort();
            AddInvalidationWebType add = new AddInvalidationWebType();
            add.setInvalidationLogDetailsWeb(this.setInvalidationLogDetails(logId, (SaveObjectLuovutusloki)saveObject));
            SaveInvalidationInteractionWeb saveInteraction = port.addInvalidation(add);
            ResultDetailsForInvalidation returnvalue = saveInteraction.getResultDetailsForInvalidation();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)this.logHelper.formatMsg(logId, "DETAILS: " + returnvalue.getResultCode()));
            }
            if (!returnvalue.getResultCode().equals("800000")) {
                InternalServiceError error = this.errorWrapper.getError("1045");
                error.setErrorDescription(returnvalue.getDescription());
                LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
                throw new UtilException(error);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
            }
        }
        catch (MalformedURLException me) {
            InternalServiceError error = this.errorWrapper.getError("1045");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)me);
            throw new UtilException(error, (Throwable)me);
        }
    }

    private AddWebType.LogDetailsWeb setLogDetails(String logId, SaveObjectLuovutusloki saveObject) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        AddWebType.LogDetailsWeb logDetails = new AddWebType.LogDetailsWeb();
        logDetails.setReceivedMessageId(logId);
        logDetails.setEventType(saveObject.getEventType());
        logDetails.setEventTimeStamp(saveObject.getEventTimeStamp());
        logDetails.setNotificationDocCreationTime(saveObject.getNotificationDocCreationTime());
        logDetails.setResponsibleOrganization(saveObject.getResponsibleOrganization());
        logDetails.setAcquiringOrganization(saveObject.getAcquiringOrganization());
        logDetails.setAcquiringPersonID(saveObject.getAcquiringPersonId());
        logDetails.setRepresentedOrganization(saveObject.getRepresentedOrganization());
        logDetails.setAcquiringPersonAuthenticationType(saveObject.getAcquiringPersonAuthenticationType());
        logDetails.setAcquiringCustodian(saveObject.getAcquiringCustodian());
        logDetails.setAcquiringRegistry(saveObject.getAcquiringRegistry());
        logDetails.setAcquiringRegistrySpecifier(saveObject.getAcquiringRegistrySpecifier());
        logDetails.setPatientId(saveObject.getPatientId());
        logDetails.setPatientBirthtime(saveObject.getPatientBirthtime());
        logDetails.setPatientFamilyname(saveObject.getPatientFamilyName());
        logDetails.setPatientGivennames(saveObject.getPatientGivenNames());
        logDetails.setAlienationType(saveObject.getAlienationType());
        logDetails.setConsentDocumentId(saveObject.getConsentDocumentId());
        logDetails.setNotificationDocId(saveObject.getNotificationDocId());
        if (saveObject.getConfidentialityTime() != null) {
            logDetails.setConfidentialityTime(saveObject.getConfidentialityTime());
        }
        logDetails.setAlienationReason(saveObject.getAlienationReason());
        logDetails.setAlienationReceiverName(saveObject.getAlienationReceiverName());
        String privateOperatorConnType = saveObject.getPrivateOperatorConnectionType();
        if (privateOperatorConnType != null && privateOperatorConnType.equals("2")) {
            logDetails.setResponsibleOrganization2(saveObject.getAcquiringOrganizationPrivate());
            logDetails.setResponsibleOrganizationUnit(saveObject.getAcquiringOrganizationUnit());
            logDetails.setResponsibleOrganizationUnit2(saveObject.getAcquiringOrganizationUnit2());
        }
        logDetails.setAcquiringDeviceId(saveObject.getAcquiringDeviceId());
        logDetails.setHL7InteractionId(saveObject.getHl7InteractionId());
        logDetails.setAutomaticAlienation(saveObject.getAutomaticAlienation());
        logDetails.setSoftwareName(saveObject.getSoftwareName());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return logDetails;
    }

    private AddInvalidationWebType.InvalidationLogDetailsWeb setInvalidationLogDetails(String logId, SaveObjectLuovutusloki saveObject) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        AddInvalidationWebType.InvalidationLogDetailsWeb logDetails = new AddInvalidationWebType.InvalidationLogDetailsWeb();
        logDetails.setReceivedMessageId(logId);
        logDetails.setEventTimeStamp(saveObject.getEventTimeStamp());
        logDetails.setNotificationDocId(saveObject.getNotificationDocId());
        logDetails.setAcquiringDeviceId(saveObject.getAcquiringDeviceId());
        logDetails.setSetId(saveObject.getRplcId());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return logDetails;
    }

    public void compensateLog(String logId, String documentOid) throws UtilException {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
            }
            URL url = new URL(ArkistopalveluConfigManager.getInstance().getArkistoProperties(logId).getLogcompensateurl());
            CompensateLog_Service locator = new CompensateLog_Service(url, new QName("http://compensatelog.webservices.arkistopalvelu.kanta.fi/", "CompensateLog"));
            CompensateLog port = locator.getCompensateLogSOAP();
            Holder resultCode = new Holder();
            Holder detailedDescription = new Holder();
            Holder description = new Holder();
            port.compensate(documentOid, logId, resultCode, detailedDescription, description);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)this.logHelper.formatMsg(logId, "DETAILS: " + (String)resultCode.value));
            }
            if (!((String)resultCode.value).equals("800000")) {
                InternalServiceError error = this.errorWrapper.getError("1045");
                error.setErrorDescription((String)description.value);
                LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
                throw new UtilException(error);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
            }
        }
        catch (MalformedURLException me) {
            InternalServiceError error = this.errorWrapper.getError("1045");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)me);
            throw new UtilException(error, (Throwable)me);
        }
    }

    public void compensateInvalidationLog(String logId, String documentOid) throws UtilException {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
            }
            URL url = new URL(ArkistopalveluConfigManager.getInstance().getArkistoProperties(logId).getLogcompensateurl());
            CompensateLog_Service locator = new CompensateLog_Service(url, new QName("http://compensatelog.webservices.arkistopalvelu.kanta.fi/", "CompensateLog"));
            CompensateLog port = locator.getCompensateLogSOAP();
            Holder resultCode = new Holder();
            Holder detailedDescription = new Holder();
            Holder description = new Holder();
            port.compensateInvalidationLog(documentOid, logId, resultCode, detailedDescription, description);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)this.logHelper.formatMsg(logId, "DETAILS: " + (String)resultCode.value));
            }
            if (!((String)resultCode.value).equals("800000")) {
                InternalServiceError error = this.errorWrapper.getError("1045");
                error.setErrorDescription((String)description.value);
                LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
                throw new UtilException(error);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
            }
        }
        catch (MalformedURLException me) {
            InternalServiceError error = this.errorWrapper.getError("1045");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)me);
            throw new UtilException(error, (Throwable)me);
        }
    }
}

