/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.client;

import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import fi.kanta.arkistopalvelu.exception.QueryException;
import fi.kanta.arkistopalvelu.util.ErrorWrapperArchive;
import fi.kanta.arkistopalvelu.util.MetadataList;
import fi.kanta.arkistopalvelu.util.StringHelper;
import fi.kanta.arkistopalvelu.util.configurations.ArkistopalveluConfigManager;
import fi.kanta.arkistopalvelu.util.configurations.OstopalvelutProperties;
import fi.kanta.arkistopalvelu.util.xpathconfig.DctmAttribute;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.exception.UtilException;
import fi.kanta.common.util.InternalServiceError;
import fi.kanta.ostopalvelut.dto.PotilasOsvat;
import fi.kanta.ostopalvelut.dto.ResultDetails;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import org.apache.log4j.Logger;

public class OstopalvelutClient {
    private static final Logger LOGGER = Logger.getLogger(OstopalvelutClient.class);
    private static final String OSVA_PATH_PARAM_PATIENTID = "patientid";
    private static final String OSVA_QUERY_PARAM_LOGID = "logId";
    private static final String OSVA_QUERY_PARAM_CUSTODIAN = "custodian";
    private static final String OSVA_QUERY_PARAM_REGISTRY = "registry";
    private static final String OSVA_QUERY_PARAM_REGISTRY_SPECIFIER = "registrySpecifier";
    private static final String OSVA_QUERY_PARAM_ACQUIRING_ORGANIZATION = "acquiringOrganization";
    private static final String OSVA_QUERY_PARAM_OSVA_ACTIVE = "osvaActive";
    private LogHelper logHelper = new LogHelper();
    private ErrorWrapperArchive errorWrapper = ErrorWrapperArchive.getInstance();
    private StringHelper stringHelper = new StringHelper();
    private OstopalvelutProperties ostopalvelutProperties;
    private MediaType mediaType;

    public OstopalvelutClient(String logId) {
        this.ostopalvelutProperties = ArkistopalveluConfigManager.getInstance().getOstopalvelutProperties(logId);
        this.mediaType = MediaType.APPLICATION_JSON_TYPE;
    }

    public boolean getVaestoOsva(String logId, MetadataList metadataList, boolean osvaActive) throws UtilException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        boolean vaestoOsva = false;
        try {
            boolean saveOperation = this.isSaveOperation(logId, metadataList);
            String uri = this.getVaestoOsvaUri(logId, this.getAttrMap(logId, metadataList, saveOperation), saveOperation);
            WebResource webResource = this.buildClient(logId, uri);
            ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)webResource.queryParams(this.createQueryParameterMap(logId, metadataList, osvaActive, saveOperation)).type(this.mediaType).accept(new MediaType[]{this.mediaType})).get(ClientResponse.class);
            ClientResponse.Status status = clientResponse.getClientResponseStatus();
            vaestoOsva = status.getStatusCode() == ClientResponse.Status.OK.getStatusCode();
        }
        catch (QueryException e) {
            throw new UtilException(e.getInternalServiceError());
        }
        catch (ClientHandlerException e) {
            InternalServiceError error = this.errorWrapper.getError("1144");
            error.setErrorMessage("Virhe yhteydess\u00e4 ostopalvelut-sovellukseen");
            error.setErrorDescription(e.getMessage());
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
            throw new UtilException(error, (Throwable)e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return vaestoOsva;
    }

    public PotilasOsvat getPotilasOsvat(String logId, MetadataList metadataList, boolean osvaActive) throws UtilException {
        PotilasOsvat potilasOsvat;
        block8: {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
            }
            potilasOsvat = null;
            try {
                boolean saveOperation = this.isSaveOperation(logId, metadataList);
                String uri = this.getPotilasOsvaUri(logId, this.getAttrMap(logId, metadataList, saveOperation), saveOperation);
                WebResource webResource = this.buildClient(logId, uri);
                ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)webResource.queryParams(this.createQueryParameterMap(logId, metadataList, osvaActive, saveOperation)).type(this.mediaType).accept(new MediaType[]{this.mediaType})).get(ClientResponse.class);
                ClientResponse.Status status = clientResponse.getClientResponseStatus();
                if (status.getStatusCode() == ClientResponse.Status.OK.getStatusCode()) {
                    potilasOsvat = (PotilasOsvat)clientResponse.getEntity(PotilasOsvat.class);
                    break block8;
                }
                if (status.getStatusCode() == ClientResponse.Status.NO_CONTENT.getStatusCode()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)"Voimassaolevia osva-dokumentteja ei l\u00f6ytynyt.");
                    }
                    break block8;
                }
                throw new UtilException(this.getError(logId, (ResultDetails)clientResponse.getEntity(ResultDetails.class)));
            }
            catch (QueryException e) {
                throw new UtilException(e.getInternalServiceError());
            }
            catch (ClientHandlerException e) {
                InternalServiceError error = this.errorWrapper.getError("1144");
                error.setErrorMessage("Virhe yhteydess\u00e4 ostopalvelut-sovellukseen");
                error.setErrorDescription(e.getMessage());
                LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
                throw new UtilException(error, (Throwable)e);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return potilasOsvat;
    }

    private Map<String, DctmAttribute> getAttrMap(String logId, MetadataList metadataList, boolean saveOperation) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        Map<String, DctmAttribute> attrMap = null;
        attrMap = saveOperation ? metadataList.getSaveAttrMap() : metadataList.getValidateAttrMap();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return attrMap;
    }

    private WebResource buildClient(String logId, String uri) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        if (this.mediaType == MediaType.APPLICATION_JSON_TYPE) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
            JacksonJaxbJsonProvider jacksonJsonProvider = new JacksonJaxbJsonProvider();
            jacksonJsonProvider.setMapper(mapper);
            clientConfig.getSingletons().add(jacksonJsonProvider);
        }
        Client client = Client.create((ClientConfig)clientConfig);
        client.setConnectTimeout(Integer.valueOf(this.ostopalvelutProperties.getOstopalvelutConnectTimeout().intValue()));
        client.setReadTimeout(Integer.valueOf(this.ostopalvelutProperties.getOstopalvelutReadTimeout().intValue()));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return client.resource(uri);
    }

    private MultivaluedMap<String, String> createQueryParameterMap(String logId, MetadataList metadataList, boolean osvaActive, boolean saveOperation) throws QueryException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        Map<String, DctmAttribute> attrMap = this.getAttrMap(logId, metadataList, saveOperation);
        String registry = attrMap.get("cda_code").getAttributeValue().getOriginalValue().getValue();
        this.stringHelper.nullCheck(logId, "cda_code", registry);
        String registrySpecifier = null;
        if (registry != null && registry.equals("4")) {
            registrySpecifier = attrMap.get("hl7fi_pat_reg_specifier").getAttributeValue().getOriginalValue().getValue();
            this.stringHelper.nullCheck(logId, "hl7fi_pat_reg_specifier", registrySpecifier);
        }
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)OSVA_QUERY_PARAM_LOGID, (Object)logId);
        queryParams.add((Object)OSVA_QUERY_PARAM_CUSTODIAN, (Object)this.getCustodian(logId, metadataList, saveOperation));
        queryParams.add((Object)OSVA_QUERY_PARAM_REGISTRY, (Object)registry);
        queryParams.add((Object)OSVA_QUERY_PARAM_REGISTRY_SPECIFIER, (Object)registrySpecifier);
        queryParams.add((Object)OSVA_QUERY_PARAM_ACQUIRING_ORGANIZATION, (Object)this.getAcquiringOrganization(logId, metadataList, saveOperation));
        queryParams.add((Object)OSVA_QUERY_PARAM_OSVA_ACTIVE, (Object)Boolean.toString(osvaActive));
        return queryParams;
    }

    private InternalServiceError getError(String logId, ResultDetails resultDetails) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        InternalServiceError error = ErrorWrapperArchive.getInstance().getError("1144");
        if (resultDetails != null && resultDetails.getResultCode() != null && !resultDetails.getResultCode().isEmpty()) {
            error.setErrorCode(resultDetails.getResultCode());
            error.setErrorMessage(resultDetails.getDescription());
            error.setErrorDescription(resultDetails.getDetailedDescription());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return error;
    }

    private String getPotilasOsvaUri(String logId, Map<String, DctmAttribute> attrMap, boolean saveOperation) throws QueryException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        String basePath = this.ostopalvelutProperties.getOstopalvelutUrl();
        String pathAnnotation = saveOperation ? this.ostopalvelutProperties.getPotilasOsvaWritePermissionPath() : this.ostopalvelutProperties.getPotilasOsvaReadPermissionPath();
        String patientId = attrMap.get("cda_patient_id").getAttributeValue().getOriginalValue().getValue();
        this.stringHelper.nullCheck(logId, "cda_patient_id", patientId);
        HashMap<String, String> pathParameterValues = new HashMap<String, String>();
        pathParameterValues.put(OSVA_PATH_PARAM_PATIENTID, patientId);
        String returnUri = null;
        UriBuilder builder = UriBuilder.fromUri((String)basePath);
        URI resolvedUri = builder.path(pathAnnotation).buildFromMap(pathParameterValues);
        if (resolvedUri != null) {
            returnUri = resolvedUri.toString();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return returnUri;
    }

    private String getVaestoOsvaUri(String logId, Map<String, DctmAttribute> attrMap, boolean saveOperation) throws QueryException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        String basePath = this.ostopalvelutProperties.getOstopalvelutUrl();
        String pathAnnotation = saveOperation ? this.ostopalvelutProperties.getVaestoOsvaWritePermissionPath() : this.ostopalvelutProperties.getVaestoOsvaReadPermissionPath();
        String patientId = attrMap.get("cda_patient_id").getAttributeValue().getOriginalValue().getValue();
        this.stringHelper.nullCheck(logId, "cda_patient_id", patientId);
        HashMap<String, String> pathParameterValues = new HashMap<String, String>();
        pathParameterValues.put(OSVA_PATH_PARAM_PATIENTID, patientId);
        String returnUri = null;
        UriBuilder builder = UriBuilder.fromUri((String)basePath);
        URI resolvedUri = builder.path(pathAnnotation).buildFromMap(pathParameterValues);
        if (resolvedUri != null) {
            returnUri = resolvedUri.toString();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return returnUri;
    }

    private String getCustodian(String logId, MetadataList metadataList, boolean saveOperation) throws QueryException {
        String custodian;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        Map<String, DctmAttribute> attrMap = this.getAttrMap(logId, metadataList, saveOperation);
        if (saveOperation) {
            custodian = attrMap.get("cda_custodian").getAttributeValue().getOriginalValue().getValue();
            this.stringHelper.nullCheck(logId, "cda_custodian", custodian);
        } else {
            custodian = attrMap.get("hl7fi_active_custodian").getAttributeValue().getOriginalValue().getValue();
            this.stringHelper.nullCheck(logId, "hl7fi_active_custodian", custodian);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return custodian;
    }

    private String getAcquiringOrganization(String logId, MetadataList metadataList, boolean saveOperation) throws QueryException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        String acquiringOrganization = null;
        acquiringOrganization = saveOperation ? this.getAcquiringOrganizationForSave(logId, metadataList) : this.getAcquiringOrganizationForSearch(logId, metadataList);
        this.stringHelper.nullCheck(logId, "cda_osva_serviceprovider", acquiringOrganization);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return acquiringOrganization;
    }

    private String getAcquiringOrganizationForSearch(String logId, MetadataList metadataList) {
        String privateOperatorConnType;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        String acquiringOrganization = (privateOperatorConnType = metadataList.getValidateAttrMap().get("cap_private_operator_connectiontype").getAttributeValue().getOriginalValue().getValue()) != null && privateOperatorConnType.equals("2") ? metadataList.getValidateAttrMap().get("cap_aquiring_organization_private").getAttributeValue().getOriginalValue().getValue() : metadataList.getValidateAttrMap().get("cap_aquiring_organization").getAttributeValue().getOriginalValue().getValue();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return acquiringOrganization;
    }

    private String getAcquiringOrganizationForSave(String logId, MetadataList metadataList) {
        String privateOperatorConnType;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        String acquiringOrganization = (privateOperatorConnType = metadataList.getValidateAttrMap().get("cap_private_operator_connectiontype").getAttributeValue().getOriginalValue().getValue()) != null && privateOperatorConnType.equals("2") ? metadataList.getValidateAttrMap().get("cap_cda_rep_org_sub_id").getAttributeValue().getOriginalValue().getValue() : metadataList.getValidateAttrMap().get("cap_cda_rep_org_id").getAttributeValue().getOriginalValue().getValue();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return acquiringOrganization;
    }

    private boolean isSaveOperation(String logId, MetadataList metadataList) {
        String typeString;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        boolean isSaveOperation = false;
        DctmAttribute requestType = metadataList.getValidateAttrMap().get("cap_service_request_type");
        if (requestType != null && ((typeString = requestType.getAttributeValue().getOriginalValue().getValue()).equals("PP13") || typeString.equals("PP16"))) {
            isSaveOperation = true;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return isSaveOperation;
    }
}

