/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.client;

import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import fi.kanta.arkistopalvelu.exception.QueryException;
import fi.kanta.arkistopalvelu.util.ErrorWrapperArchive;
import fi.kanta.arkistopalvelu.util.MetadataList;
import fi.kanta.arkistopalvelu.util.StringHelper;
import fi.kanta.arkistopalvelu.util.configurations.ArkistopalveluConfigManager;
import fi.kanta.arkistopalvelu.util.configurations.SuostumustenHallintaProperties;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.exception.UtilException;
import fi.kanta.common.util.InternalServiceError;
import fi.kanta.suostumustenhallinta.dto.ArkistoSuostumus;
import fi.kanta.suostumustenhallinta.dto.Arkistokiellot;
import fi.kanta.suostumustenhallinta.dto.Potilas;
import fi.kanta.suostumustenhallinta.dto.ResultDetails;
import java.net.URI;
import java.util.HashMap;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import org.apache.log4j.Logger;

public class SuostumustenhallintaClient {
    private static final String VIRHE_YHTEYDESS\u00c4_SUOSTUMUSTENHALLINTA_SOVELLUKSEEN = "Virhe yhteydess\u00e4 suostumustenhallinta-sovellukseen";
    private static final Logger LOGGER = Logger.getLogger(SuostumustenhallintaClient.class);
    private static final String PATH_PARAM_PATIENTID = "patientId";
    private static final String QUERY_PARAM_LOGID = "logId";
    private static StringHelper stringHelper = new StringHelper();
    private static MediaType mediaType = MediaType.APPLICATION_JSON_TYPE;
    private static LogHelper logHelper = new LogHelper();
    private static ErrorWrapperArchive errorWrapper = ErrorWrapperArchive.getInstance();
    private static SuostumustenHallintaProperties suostumustenHallintaProperties = ArkistopalveluConfigManager.getInstance().getSuostumustenHallintaProperties("");

    private SuostumustenhallintaClient() {
    }

    public static Potilas getPotilas(String logId, MetadataList metadataList) throws UtilException {
        Potilas potilas;
        block8: {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)logHelper.formatMsgBgn(logId));
            }
            potilas = null;
            try {
                String uri = SuostumustenhallintaClient.getPotilasUri(logId, SuostumustenhallintaClient.getPatientId(logId, metadataList));
                WebResource webResource = SuostumustenhallintaClient.buildClient(logId, uri);
                ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)webResource.queryParams(SuostumustenhallintaClient.createQueryParameterMap(logId)).type(mediaType).accept(new MediaType[]{mediaType})).get(ClientResponse.class);
                ClientResponse.Status status = clientResponse.getClientResponseStatus();
                if (status.getStatusCode() == ClientResponse.Status.OK.getStatusCode()) {
                    potilas = (Potilas)clientResponse.getEntity(Potilas.class);
                    break block8;
                }
                if (status.getStatusCode() == ClientResponse.Status.NO_CONTENT.getStatusCode()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)"Potilas-tietoa ei l\u00f6ytynyt.");
                    }
                    break block8;
                }
                throw new UtilException(SuostumustenhallintaClient.getError(logId, (ResultDetails)clientResponse.getEntity(ResultDetails.class)));
            }
            catch (QueryException e) {
                throw new UtilException(e.getInternalServiceError());
            }
            catch (ClientHandlerException e) {
                InternalServiceError error = errorWrapper.getError("1144");
                error.setErrorMessage(VIRHE_YHTEYDESS\u00c4_SUOSTUMUSTENHALLINTA_SOVELLUKSEEN);
                error.setErrorDescription(e.getMessage());
                LOGGER.error((Object)logHelper.formatMsg(logId, error));
                throw new UtilException(error, (Throwable)e);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)logHelper.formatMsgEnd(logId));
        }
        return potilas;
    }

    public static Arkistokiellot getArkistoKiellot(String logId, MetadataList metadataList) throws UtilException {
        Arkistokiellot kiellot;
        block8: {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)logHelper.formatMsgBgn(logId));
            }
            kiellot = null;
            try {
                String uri = SuostumustenhallintaClient.getArkistoKiellotUri(logId, SuostumustenhallintaClient.getPatientId(logId, metadataList));
                WebResource webResource = SuostumustenhallintaClient.buildClient(logId, uri);
                ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)webResource.queryParams(SuostumustenhallintaClient.createQueryParameterMap(logId)).type(mediaType).accept(new MediaType[]{mediaType})).get(ClientResponse.class);
                ClientResponse.Status status = clientResponse.getClientResponseStatus();
                if (status.getStatusCode() == ClientResponse.Status.OK.getStatusCode()) {
                    kiellot = (Arkistokiellot)clientResponse.getEntity(Arkistokiellot.class);
                    break block8;
                }
                if (status.getStatusCode() == ClientResponse.Status.NO_CONTENT.getStatusCode()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)"Arkistokiellot-tietoa ei l\u00f6ytynyt.");
                    }
                    break block8;
                }
                throw new UtilException(SuostumustenhallintaClient.getError(logId, (ResultDetails)clientResponse.getEntity(ResultDetails.class)));
            }
            catch (QueryException e) {
                throw new UtilException(e.getInternalServiceError());
            }
            catch (ClientHandlerException e) {
                InternalServiceError error = errorWrapper.getError("1144");
                error.setErrorMessage(VIRHE_YHTEYDESS\u00c4_SUOSTUMUSTENHALLINTA_SOVELLUKSEEN);
                error.setErrorDescription(e.getMessage());
                LOGGER.error((Object)logHelper.formatMsg(logId, error));
                throw new UtilException(error, (Throwable)e);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)logHelper.formatMsgEnd(logId));
        }
        return kiellot;
    }

    public static ArkistoSuostumus getArkistoSuostumus(String logId, MetadataList metadataList) throws UtilException {
        ArkistoSuostumus suostumus;
        block8: {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)logHelper.formatMsgBgn(logId));
            }
            suostumus = null;
            try {
                String uri = SuostumustenhallintaClient.getArkistoSuostumusUri(logId, SuostumustenhallintaClient.getPatientId(logId, metadataList));
                WebResource webResource = SuostumustenhallintaClient.buildClient(logId, uri);
                ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)webResource.queryParams(SuostumustenhallintaClient.createQueryParameterMap(logId)).type(mediaType).accept(new MediaType[]{mediaType})).get(ClientResponse.class);
                ClientResponse.Status status = clientResponse.getClientResponseStatus();
                if (status.getStatusCode() == ClientResponse.Status.OK.getStatusCode()) {
                    suostumus = (ArkistoSuostumus)clientResponse.getEntity(ArkistoSuostumus.class);
                    break block8;
                }
                if (status.getStatusCode() == ClientResponse.Status.NO_CONTENT.getStatusCode()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)"ArkistoSuostumus-tietoa ei l\u00f6ytynyt.");
                    }
                    break block8;
                }
                throw new UtilException(SuostumustenhallintaClient.getError(logId, (ResultDetails)clientResponse.getEntity(ResultDetails.class)));
            }
            catch (QueryException e) {
                throw new UtilException(e.getInternalServiceError());
            }
            catch (ClientHandlerException e) {
                InternalServiceError error = errorWrapper.getError("1144");
                error.setErrorMessage(VIRHE_YHTEYDESS\u00c4_SUOSTUMUSTENHALLINTA_SOVELLUKSEEN);
                error.setErrorDescription(e.getMessage());
                LOGGER.error((Object)logHelper.formatMsg(logId, error));
                throw new UtilException(error, (Throwable)e);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)logHelper.formatMsgEnd(logId));
        }
        return suostumus;
    }

    private static String getPatientId(String logId, MetadataList metadataList) throws QueryException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)logHelper.formatMsgBgn(logId));
        }
        String patientId = "";
        if (metadataList.getSaveAttrMap() != null && metadataList.getSaveAttrMap().get("cda_patient_id") != null) {
            patientId = metadataList.getSaveAttrMap().get("cda_patient_id").getAttributeValue().getOriginalValue().getValue();
        } else if (metadataList.getValidateAttrMap() != null && metadataList.getValidateAttrMap().get("cda_patient_id") != null) {
            patientId = metadataList.getValidateAttrMap().get("cda_patient_id").getAttributeValue().getOriginalValue().getValue();
        }
        stringHelper.nullCheck(logId, "cda_patient_id", patientId);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)logHelper.formatMsgEnd(logId));
        }
        return patientId;
    }

    private static WebResource buildClient(String logId, String uri) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)logHelper.formatMsgBgn(logId));
        }
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        if (mediaType == MediaType.APPLICATION_JSON_TYPE) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
            JacksonJaxbJsonProvider jacksonJsonProvider = new JacksonJaxbJsonProvider();
            jacksonJsonProvider.setMapper(mapper);
            clientConfig.getSingletons().add(jacksonJsonProvider);
        }
        Client client = Client.create((ClientConfig)clientConfig);
        client.setConnectTimeout(Integer.valueOf(suostumustenHallintaProperties.getConnectTimeout().intValue()));
        client.setReadTimeout(Integer.valueOf(suostumustenHallintaProperties.getReadTimeout().intValue()));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)logHelper.formatMsgEnd(logId));
        }
        return client.resource(uri);
    }

    private static MultivaluedMap<String, String> createQueryParameterMap(String logId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)logHelper.formatMsgBgn(logId));
        }
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)QUERY_PARAM_LOGID, (Object)logId);
        return queryParams;
    }

    private static InternalServiceError getError(String logId, ResultDetails resultDetails) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)logHelper.formatMsgBgn(logId));
        }
        InternalServiceError error = ErrorWrapperArchive.getInstance().getError("1144");
        if (resultDetails != null && resultDetails.getResultCode() != null && !resultDetails.getResultCode().isEmpty()) {
            error.setErrorCode(resultDetails.getResultCode());
            error.setErrorMessage(resultDetails.getDescription());
            error.setErrorDescription(resultDetails.getDetailedDescription());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)logHelper.formatMsgEnd(logId));
        }
        return error;
    }

    private static String getArkistoKiellotUri(String logId, String patientId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)logHelper.formatMsgBgn(logId));
        }
        String basePath = suostumustenHallintaProperties.getKieltotietoUrl();
        String pathAnnotation = suostumustenHallintaProperties.getKieltotietoPath();
        HashMap<String, String> pathParameterValues = new HashMap<String, String>();
        pathParameterValues.put(PATH_PARAM_PATIENTID, patientId);
        String returnUri = null;
        UriBuilder builder = UriBuilder.fromUri((String)basePath);
        URI resolvedUri = builder.path(pathAnnotation).buildFromMap(pathParameterValues);
        if (resolvedUri != null) {
            returnUri = resolvedUri.toString();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)logHelper.formatMsgEnd(logId));
        }
        return returnUri;
    }

    private static String getArkistoSuostumusUri(String logId, String patientId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)logHelper.formatMsgBgn(logId));
        }
        String basePath = suostumustenHallintaProperties.getSuostumusUrl();
        String pathAnnotation = suostumustenHallintaProperties.getSuostumusPath();
        HashMap<String, String> pathParameterValues = new HashMap<String, String>();
        pathParameterValues.put(PATH_PARAM_PATIENTID, patientId);
        String returnUri = null;
        UriBuilder builder = UriBuilder.fromUri((String)basePath);
        URI resolvedUri = builder.path(pathAnnotation).buildFromMap(pathParameterValues);
        if (resolvedUri != null) {
            returnUri = resolvedUri.toString();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)logHelper.formatMsgEnd(logId));
        }
        return returnUri;
    }

    private static String getPotilasUri(String logId, String patientId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)logHelper.formatMsgBgn(logId));
        }
        String basePath = suostumustenHallintaProperties.getPotilasUrl();
        String pathAnnotation = suostumustenHallintaProperties.getPotilasPath();
        HashMap<String, String> pathParameterValues = new HashMap<String, String>();
        pathParameterValues.put(PATH_PARAM_PATIENTID, patientId);
        String returnUri = null;
        UriBuilder builder = UriBuilder.fromUri((String)basePath);
        URI resolvedUri = builder.path(pathAnnotation).buildFromMap(pathParameterValues);
        if (resolvedUri != null) {
            returnUri = resolvedUri.toString();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)logHelper.formatMsgEnd(logId));
        }
        return returnUri;
    }
}

