/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.client;

import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import fi.kanta.arkistopalvelu.util.ErrorWrapperArchive;
import fi.kanta.arkistopalvelu.util.configurations.ArkistopalveluConfigManager;
import fi.kanta.arkistopalvelu.util.configurations.VapakypaValityshistoriaProperties;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.exception.UtilException;
import fi.kanta.common.util.InternalServiceError;
import fi.kela.kanta.valityshistoria.dto.HaeValityshistoriaHetulla;
import fi.kela.kanta.valityshistoria.dto.RequestDetails;
import fi.kela.kanta.valityshistoria.dto.ValityshistoriaHakuResponse;
import javax.ws.rs.core.MediaType;
import org.apache.log4j.Logger;

public class ValityshistoriaClient {
    private ErrorWrapperArchive errorWrapper;
    private static final Logger LOGGER = Logger.getLogger(ValityshistoriaClient.class);
    private LogHelper logHelper = new LogHelper();
    private MediaType mediaType;

    public ValityshistoriaClient(String logId) {
        this.errorWrapper = ErrorWrapperArchive.getInstance();
        this.mediaType = MediaType.APPLICATION_JSON_TYPE;
    }

    private WebResource buildClient(String logId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        if (this.mediaType == MediaType.APPLICATION_JSON_TYPE) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
            JacksonJaxbJsonProvider jacksonJsonProvider = new JacksonJaxbJsonProvider();
            jacksonJsonProvider.setMapper(mapper);
            clientConfig.getSingletons().add(jacksonJsonProvider);
        }
        Client client = Client.create((ClientConfig)clientConfig);
        VapakypaValityshistoriaProperties properties = ArkistopalveluConfigManager.getInstance().getVapakypaValityshistoriaProperties(logId);
        client.setConnectTimeout(Integer.valueOf(properties.getConnectTimeout().intValue()));
        client.setReadTimeout(Integer.valueOf(properties.getReadTimeout().intValue()));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return client.resource(properties.getValityshistoriaHetuUrl());
    }

    public ValityshistoriaHakuResponse haeValitysHistoria(String logId, String hetuExtension) throws UtilException {
        ValityshistoriaHakuResponse historia;
        block10: {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
            }
            historia = null;
            try {
                WebResource webResource = this.buildClient(logId);
                HaeValityshistoriaHetulla requestClass = new HaeValityshistoriaHetulla(logId, hetuExtension);
                ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)webResource.type(this.mediaType).accept(new MediaType[]{this.mediaType})).post(ClientResponse.class, (Object)requestClass);
                ClientResponse.Status status = clientResponse.getClientResponseStatus();
                if (status.getStatusCode() == ClientResponse.Status.OK.getStatusCode()) {
                    historia = (ValityshistoriaHakuResponse)clientResponse.getEntity(ValityshistoriaHakuResponse.class);
                } else if (status.getStatusCode() == ClientResponse.Status.NO_CONTENT.getStatusCode()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)"V\u00e4lityshistoriaa ei l\u00f6ytynyt.");
                    }
                } else {
                    RequestDetails errorResponse = (RequestDetails)clientResponse.getEntity(RequestDetails.class);
                    InternalServiceError error = this.errorWrapper.getError("1144");
                    error.setErrorMessage(errorResponse.getErrorMessage());
                    error.setErrorDescription(errorResponse.getDescription());
                    LOGGER.error((Object)this.logHelper.formatMsg("virhekoodi valityshistoriapalvelusta: " + errorResponse.getErrorCode()));
                    LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
                    if (!ArkistopalveluConfigManager.getInstance().getVapakypaValityshistoriaProperties(logId).isOhitaVirheet()) {
                        throw new UtilException(error);
                    }
                }
            }
            catch (ClientHandlerException e) {
                InternalServiceError error = this.errorWrapper.getError("1144");
                error.setErrorMessage("Virhe yhteydess\u00e4 vapakypa valityshistoria-sovellukseen");
                error.setErrorDescription(e.getMessage());
                LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
                if (ArkistopalveluConfigManager.getInstance().getVapakypaValityshistoriaProperties(logId).isOhitaVirheet()) break block10;
                throw new UtilException(error, (Throwable)e);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return historia;
    }
}

