/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.util;

import com.ximpleware.AutoPilot;
import com.ximpleware.FastLongBuffer;
import com.ximpleware.NavException;
import com.ximpleware.ParseException;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import com.ximpleware.XPathEvalException;
import com.ximpleware.XPathParseException;
import fi.kanta.arkistopalvelu.util.ErrorWrapperArchive;
import fi.kanta.arkistopalvelu.util.IArkistoXPathHelperVTD;
import fi.kanta.arkistopalvelu.util.xpathconfig.AttributeValueType;
import fi.kanta.arkistopalvelu.util.xpathconfig.DctmAttribute;
import fi.kanta.arkistopalvelu.util.xpathconfig.ObjectValueType;
import fi.kanta.arkistopalvelu.util.xpathconfig.ValueMap;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.exception.UtilException;
import fi.kanta.common.util.InternalServiceError;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ArkistoXPathHelperVTD
implements IArkistoXPathHelperVTD {
    private static final Logger LOGGER = Logger.getLogger(ArkistoXPathHelperVTD.class);
    private LogHelper logHelper;
    private AutoPilot ap;
    private VTDGen vg;
    private VTDNav vn;
    private ErrorWrapperArchive errorWrapper;

    public ArkistoXPathHelperVTD(String logId, File file) throws UtilException {
        try {
            this.errorWrapper = ErrorWrapperArchive.getInstance();
            this.logHelper = new LogHelper();
            this.vg = new VTDGen();
            if (this.vg.parseFile(file.getCanonicalPath(), true)) {
                this.ap = new AutoPilot();
                this.ap.declareXPathNameSpace("we", "http://webservices.arkistopalvelu.kanta.fi/");
                this.ap.declareXPathNameSpace("v3", "urn:hl7-org:v3");
                this.ap.declareXPathNameSpace("web", "http://webservices.arkistopalvelu.kanta.fi/");
                this.ap.declareXPathNameSpace("hl7fi", "urn:hl7finland");
                this.vn = this.vg.getNav();
                this.ap.bind(this.vn);
            }
        }
        catch (IOException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
    }

    public ArkistoXPathHelperVTD(String logId, byte[] doc) throws UtilException {
        try {
            this.errorWrapper = ErrorWrapperArchive.getInstance();
            this.logHelper = new LogHelper();
            this.vg = new VTDGen();
            this.vg.setDoc(doc);
            this.vg.parse(true);
            this.ap = new AutoPilot();
            this.ap.declareXPathNameSpace("we", "http://webservices.arkistopalvelu.kanta.fi/");
            this.ap.declareXPathNameSpace("v3", "urn:hl7-org:v3");
            this.ap.declareXPathNameSpace("web", "http://webservices.arkistopalvelu.kanta.fi/");
            this.ap.declareXPathNameSpace("hl7fi", "urn:hl7finland");
            this.vn = this.vg.getNav();
            this.ap.bind(this.vn);
        }
        catch (ParseException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
    }

    @Override
    public String getCode(String logId, String expression) throws UtilException {
        String retStr = "";
        try {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)this.logHelper.formatMsgBgn(logId));
            }
            this.ap.selectXPath(expression);
            retStr = this.ap.evalXPathToString();
            if (retStr != null) {
                retStr = retStr.trim();
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)this.logHelper.formatMsgEnd(logId));
            }
        }
        catch (XPathParseException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        return retStr;
    }

    @Override
    public String getUniqueCodesFromNodeList(String logId, String expression) throws UtilException {
        StringBuilder retStr = new StringBuilder();
        ArrayList<String> nodevalues = new ArrayList<String>();
        boolean exists = false;
        try {
            int i;
            this.ap.selectXPath(expression);
            while ((i = this.ap.evalXPath()) != -1) {
                exists = false;
                String tt = this.vn.toString(i + 1);
                if (tt != null) {
                    tt = tt.trim();
                }
                if (nodevalues.contains(tt)) {
                    exists = true;
                }
                if (exists) continue;
                nodevalues.add(tt);
                if (retStr.length() > 0) {
                    retStr.append(" ");
                }
                retStr.append(tt);
            }
            this.ap.resetXPath();
        }
        catch (NavException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        catch (XPathEvalException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        catch (XPathParseException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        return retStr.toString();
    }

    @Override
    public List<AttributeValueType> getUniqueCVvaluesFromNodeList(String logId, String expression, String separator, boolean allowNoCode) throws UtilException {
        ArrayList<String> tempList = new ArrayList<String>();
        ArrayList<AttributeValueType> retVal = new ArrayList<AttributeValueType>();
        try {
            int index;
            AutoPilot apCode = new AutoPilot();
            AutoPilot apCodeSystem = new AutoPilot();
            this.ap.selectXPath(expression);
            apCode.selectXPath("@code");
            apCodeSystem.selectXPath("@codeSystem");
            apCode.bind(this.vn);
            apCodeSystem.bind(this.vn);
            while ((index = this.ap.evalXPath()) != -1) {
                AttributeValueType attrValueType = new AttributeValueType();
                AttributeValueType.OriginalValue origValue = new AttributeValueType.OriginalValue();
                String code = apCode.evalXPathToString();
                String codeSystem = apCodeSystem.evalXPathToString();
                StringBuilder valueBuff = new StringBuilder();
                if (code != null && code.length() > 0) {
                    if (codeSystem != null && codeSystem.length() > 0) {
                        valueBuff.append(codeSystem).append(separator).append(code);
                    }
                } else if (allowNoCode) {
                    valueBuff.append(codeSystem);
                }
                if (tempList.contains(valueBuff.toString())) continue;
                tempList.add(valueBuff.toString());
                origValue.setValue(valueBuff.toString());
                origValue.setFirstValue(code);
                origValue.setSecondValue(codeSystem);
                attrValueType.setOriginalValue(origValue);
                retVal.add(attrValueType);
            }
            this.ap.resetXPath();
        }
        catch (NavException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        catch (XPathEvalException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        catch (XPathParseException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        return retVal;
    }

    @Override
    public List<AttributeValueType> getCVvaluesFromNodeList(String logId, String expression, String separator, boolean allowNoCode) throws UtilException {
        ArrayList<AttributeValueType> rval = new ArrayList<AttributeValueType>();
        try {
            int index;
            AutoPilot apCode = new AutoPilot();
            AutoPilot apCodeSystem = new AutoPilot();
            this.ap.selectXPath(expression);
            apCode.selectXPath("@code");
            apCodeSystem.selectXPath("@codeSystem");
            apCode.bind(this.vn);
            apCodeSystem.bind(this.vn);
            while ((index = this.ap.evalXPath()) != -1) {
                AttributeValueType attrValueType = new AttributeValueType();
                AttributeValueType.OriginalValue origValue = new AttributeValueType.OriginalValue();
                String code = apCode.evalXPathToString();
                String codeSystem = apCodeSystem.evalXPathToString();
                StringBuilder valueBuff = new StringBuilder();
                if (code != null && code.length() > 0) {
                    if (codeSystem != null && codeSystem.length() > 0) {
                        valueBuff.append(codeSystem).append(separator).append(code);
                    }
                } else if (allowNoCode) {
                    valueBuff.append(codeSystem);
                }
                origValue.setValue(valueBuff.toString());
                origValue.setFirstValue(code);
                origValue.setSecondValue(codeSystem);
                attrValueType.setOriginalValue(origValue);
                rval.add(attrValueType);
            }
            this.ap.resetXPath();
        }
        catch (NavException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        catch (XPathEvalException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        catch (XPathParseException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        return rval;
    }

    @Override
    public List<AttributeValueType> getCVvaluesFromNodeList(String logId, String rootExpression, String expression, String separator, boolean allowNoCode) throws UtilException {
        ArrayList<AttributeValueType> rval = new ArrayList<AttributeValueType>();
        try {
            int index;
            AutoPilot apCode = new AutoPilot();
            AutoPilot apCodeSystem = new AutoPilot();
            AutoPilot apExpression = new AutoPilot();
            this.ap.selectXPath(rootExpression);
            apExpression.selectXPath(expression);
            apCode.selectXPath("@code");
            apCodeSystem.selectXPath("@codeSystem");
            apCode.bind(this.vn);
            apCodeSystem.bind(this.vn);
            apExpression.bind(this.vn);
            while ((index = this.ap.evalXPath()) != -1) {
                int i;
                while ((i = apExpression.evalXPath()) != -1) {
                    AttributeValueType attrValueType = new AttributeValueType();
                    AttributeValueType.OriginalValue origValue = new AttributeValueType.OriginalValue();
                    String code = apCode.evalXPathToString();
                    String codeSystem = apCodeSystem.evalXPathToString();
                    StringBuilder valueBuff = new StringBuilder();
                    if (code != null && code.length() > 0) {
                        if (codeSystem != null && codeSystem.length() > 0) {
                            valueBuff.append(codeSystem).append(separator).append(code);
                        }
                    } else if (allowNoCode) {
                        valueBuff.append(codeSystem);
                    }
                    origValue.setValue(valueBuff.toString());
                    origValue.setFirstValue(code);
                    origValue.setSecondValue(codeSystem);
                    attrValueType.setOriginalValue(origValue);
                    rval.add(attrValueType);
                }
                apExpression.resetXPath();
            }
            this.ap.resetXPath();
        }
        catch (NavException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        catch (XPathEvalException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        catch (XPathParseException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        return rval;
    }

    @Override
    public AttributeValueType getCVvalue(String logId, String expression, String separator) throws UtilException {
        AttributeValueType attrValueType = this.getEmptyAttributeValueType();
        StringBuilder valueBuff = new StringBuilder();
        try {
            AutoPilot apCode = new AutoPilot();
            AutoPilot apCodeSystem = new AutoPilot();
            this.ap.selectXPath(expression);
            apCode.selectXPath("@code");
            apCodeSystem.selectXPath("@codeSystem");
            apCode.bind(this.vn);
            apCodeSystem.bind(this.vn);
            if (this.ap.evalXPath() != -1) {
                String code = apCode.evalXPathToString();
                String codeSystem = apCodeSystem.evalXPathToString();
                if (code != null && code.length() > 0 && codeSystem != null && codeSystem.length() > 0) {
                    valueBuff.append(codeSystem).append(separator).append(code);
                }
                attrValueType.getOriginalValue().setValue(valueBuff.toString());
                attrValueType.getOriginalValue().setFirstValue(code);
                attrValueType.getOriginalValue().setSecondValue(codeSystem);
            }
            this.ap.resetXPath();
        }
        catch (NavException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        catch (XPathEvalException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        catch (XPathParseException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        return attrValueType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<AttributeValueType> getUniqueIIvaluesFromNodeList(String logId, String expression, String separator) throws UtilException {
        ArrayList<AttributeValueType> retVal = new ArrayList<AttributeValueType>();
        ArrayList<String> tempList = new ArrayList<String>();
        try {
            AutoPilot apRoot = new AutoPilot();
            AutoPilot apExtension = new AutoPilot();
            this.ap.selectXPath(expression);
            apRoot.selectXPath("@root");
            apExtension.selectXPath("@extension");
            apRoot.bind(this.vn);
            apExtension.bind(this.vn);
            while (true) {
                StringBuilder valueBuff;
                String extension;
                String root;
                AttributeValueType.OriginalValue origValue;
                AttributeValueType attrValueType;
                block9: {
                    int index;
                    if ((index = this.ap.evalXPath()) == -1) {
                        this.ap.resetXPath();
                        return retVal;
                    }
                    attrValueType = new AttributeValueType();
                    origValue = new AttributeValueType.OriginalValue();
                    root = apRoot.evalXPathToString();
                    extension = apExtension.evalXPathToString();
                    valueBuff = new StringBuilder();
                    if (extension.length() > 0) {
                        if (root != null && root.length() > 0) {
                            valueBuff.append(root).append(separator).append(extension);
                            break block9;
                        } else {
                            InternalServiceError error = this.errorWrapper.getError("1015");
                            error.setErrorDescription("II-elementilt\u00e4 puuttuu root, vaikka on annettu extension: " + expression);
                            LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
                            throw new UtilException(error);
                        }
                    }
                    valueBuff.append(root);
                }
                if (tempList.contains(valueBuff.toString())) continue;
                tempList.add(valueBuff.toString());
                origValue.setValue(valueBuff.toString());
                origValue.setFirstValue(root);
                origValue.setSecondValue(extension);
                attrValueType.setOriginalValue(origValue);
                retVal.add(attrValueType);
            }
        }
        catch (NavException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        catch (XPathEvalException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        catch (XPathParseException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<AttributeValueType> getIIvaluesFromNodeList(String logId, String expression, String separator) throws UtilException {
        ArrayList<AttributeValueType> rval = new ArrayList<AttributeValueType>();
        try {
            String expressionRoot = "@root";
            String expressionExtension = "@extension";
            AutoPilot apRoot = new AutoPilot();
            AutoPilot apExtension = new AutoPilot();
            this.ap.selectXPath(expression);
            apRoot.selectXPath(expressionRoot);
            apExtension.selectXPath(expressionExtension);
            apRoot.bind(this.vn);
            apExtension.bind(this.vn);
            while (true) {
                StringBuilder valueBuff;
                String extension;
                String root;
                AttributeValueType.OriginalValue origValue;
                AttributeValueType attrValueType;
                block9: {
                    int index;
                    if ((index = this.ap.evalXPath()) == -1) {
                        this.ap.resetXPath();
                        return rval;
                    }
                    attrValueType = new AttributeValueType();
                    origValue = new AttributeValueType.OriginalValue();
                    root = apRoot.evalXPathToString();
                    extension = apExtension.evalXPathToString();
                    valueBuff = new StringBuilder();
                    if (extension.length() > 0) {
                        if (root != null && root.length() > 0) {
                            valueBuff.append(root).append(separator).append(extension);
                            break block9;
                        } else {
                            InternalServiceError error = this.errorWrapper.getError("1015");
                            error.setErrorDescription("II-elementilt\u00e4 puuttuu root, vaikka on annettu extension:" + expression);
                            LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
                            throw new UtilException(error);
                        }
                    }
                    valueBuff.append(root);
                }
                origValue.setFirstValue(root);
                origValue.setSecondValue(extension);
                origValue.setValue(valueBuff.toString());
                attrValueType.setOriginalValue(origValue);
                rval.add(attrValueType);
            }
        }
        catch (NavException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        catch (XPathEvalException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        catch (XPathParseException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<AttributeValueType> getIIvaluesFromNodeList(String logId, String rootExpression, String expression, String separator) throws UtilException {
        ArrayList<AttributeValueType> rval = new ArrayList<AttributeValueType>();
        try {
            String expressionRoot = "@root";
            String expressionExtension = "@extension";
            AutoPilot apRoot = new AutoPilot();
            AutoPilot apExtension = new AutoPilot();
            AutoPilot apExpression = new AutoPilot();
            this.ap.selectXPath(rootExpression);
            apRoot.selectXPath(expressionRoot);
            apExtension.selectXPath(expressionExtension);
            apExpression.selectXPath(expression);
            apExpression.bind(this.vn);
            apRoot.bind(this.vn);
            apExtension.bind(this.vn);
            while (true) {
                int i;
                int index;
                if ((index = this.ap.evalXPath()) == -1) {
                    this.ap.resetXPath();
                    return rval;
                }
                while ((i = apExpression.evalXPath()) != -1) {
                    StringBuilder valueBuff;
                    String extension;
                    String root;
                    AttributeValueType.OriginalValue origValue;
                    AttributeValueType attrValueType;
                    block10: {
                        attrValueType = new AttributeValueType();
                        origValue = new AttributeValueType.OriginalValue();
                        root = apRoot.evalXPathToString();
                        extension = apExtension.evalXPathToString();
                        valueBuff = new StringBuilder();
                        if (extension.length() > 0) {
                            if (root != null && root.length() > 0) {
                                valueBuff.append(root).append(separator).append(extension);
                                break block10;
                            } else {
                                InternalServiceError error = this.errorWrapper.getError("1015");
                                error.setErrorDescription("II-elementilt\u00e4 puuttuu root, vaikka on annettu extension, " + rootExpression + " " + expression);
                                LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
                                throw new UtilException(error);
                            }
                        }
                        valueBuff.append(root);
                    }
                    origValue.setFirstValue(root);
                    origValue.setSecondValue(extension);
                    origValue.setValue(valueBuff.toString());
                    attrValueType.setOriginalValue(origValue);
                    rval.add(attrValueType);
                }
                apExpression.resetXPath();
            }
        }
        catch (NavException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        catch (XPathEvalException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        catch (XPathParseException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<AttributeValueType> getIIvaluesFromNodeListInclEmpty(String logId, String rootExpression, String expression, String separator) throws UtilException {
        ArrayList<AttributeValueType> rval = new ArrayList<AttributeValueType>();
        try {
            String expressionRoot = "@root";
            String expressionExtension = "@extension";
            AutoPilot apRoot = new AutoPilot();
            AutoPilot apExtension = new AutoPilot();
            AutoPilot apExpression = new AutoPilot();
            this.ap.selectXPath(rootExpression);
            apRoot.selectXPath(expressionRoot);
            apExtension.selectXPath(expressionExtension);
            apExpression.selectXPath(expression);
            apExpression.bind(this.vn);
            apRoot.bind(this.vn);
            apExtension.bind(this.vn);
            while (true) {
                int index;
                if ((index = this.ap.evalXPath()) == -1) {
                    this.ap.resetXPath();
                    return rval;
                }
                int i = 0;
                int counter = 0;
                do {
                    i = apExpression.evalXPath();
                    AttributeValueType attrValueType = new AttributeValueType();
                    AttributeValueType.OriginalValue origValue = new AttributeValueType.OriginalValue();
                    if (i > -1) {
                        StringBuilder valueBuff;
                        String extension;
                        String root;
                        block11: {
                            root = apRoot.evalXPathToString();
                            extension = apExtension.evalXPathToString();
                            valueBuff = new StringBuilder();
                            if (extension.length() > 0) {
                                if (root != null && root.length() > 0) {
                                    valueBuff.append(root).append(separator).append(extension);
                                    break block11;
                                } else {
                                    InternalServiceError error = this.errorWrapper.getError("1015");
                                    error.setErrorDescription("II-elementilt\u00e4 puuttuu root, vaikka on annettu extension: " + rootExpression + " " + expression);
                                    LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
                                    throw new UtilException(error);
                                }
                            }
                            valueBuff.append(root);
                        }
                        origValue.setFirstValue(root);
                        origValue.setSecondValue(extension);
                        origValue.setValue(valueBuff.toString());
                        attrValueType.setOriginalValue(origValue);
                        rval.add(attrValueType);
                        ++counter;
                        continue;
                    }
                    if (counter != 0) continue;
                    origValue.setValue("");
                    attrValueType.setOriginalValue(origValue);
                    rval.add(attrValueType);
                } while (i != -1);
                apExpression.resetXPath();
            }
        }
        catch (NavException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        catch (XPathEvalException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        catch (XPathParseException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
    }

    @Override
    public String getAsString(String logId, String expression) throws UtilException {
        String retStr = null;
        try {
            int i;
            this.ap.selectXPath(expression);
            FastLongBuffer flb = new FastLongBuffer(4);
            byte[] xml = this.vn.getXML().getBytes();
            while ((i = this.ap.evalXPath()) != -1) {
                flb.append(this.vn.getElementFragment());
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            int size = flb.size();
            for (int k = 0; k < size; ++k) {
                os.write("\n".getBytes());
                os.write(xml, flb.lower32At(k), flb.upper32At(k));
            }
            retStr = new String(os.toByteArray(), "utf-8");
            this.ap.resetXPath();
            flb.clear();
        }
        catch (NavException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        catch (XPathEvalException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        catch (IOException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        catch (XPathParseException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        return retStr;
    }

    public String getNonXMLBody(String logId, String expression) throws UtilException {
        String retStr = null;
        try {
            int i;
            this.ap.selectXPath(expression);
            while ((i = this.ap.evalXPath()) != -1) {
                retStr = this.vn.toRawString(i);
            }
            this.ap.resetXPath();
        }
        catch (NavException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        catch (XPathEvalException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        catch (XPathParseException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        return retStr;
    }

    @Override
    public List<AttributeValueType> getValuesFromNodeList(String logId, String expression) throws UtilException {
        ArrayList<AttributeValueType> rval = new ArrayList<AttributeValueType>();
        try {
            int index;
            this.ap.selectXPath(expression);
            while ((index = this.ap.evalXPath()) != -1) {
                AttributeValueType attrValueType = new AttributeValueType();
                AttributeValueType.OriginalValue origValue = new AttributeValueType.OriginalValue();
                attrValueType.setOriginalValue(origValue);
                int startToken = this.vn.getTokenType(index);
                int endToken = this.vn.getTokenType(index + 1);
                if (!(startToken != 0 && startToken != 2 || endToken != 4 && endToken != 11 && endToken != 5)) {
                    origValue.setValue(this.vn.toString(index + 1));
                    attrValueType.setOriginalValue(origValue);
                    rval.add(attrValueType);
                    continue;
                }
                if (this.vn.getAttrCount() <= 0) continue;
                String value = "";
                if (this.vn.getText() > -1) {
                    value = this.vn.toString(this.vn.getText());
                }
                if (value != null) {
                    value = value.trim();
                }
                origValue.setValue(value);
                attrValueType.setOriginalValue(origValue);
                rval.add(attrValueType);
            }
            this.ap.resetXPath();
        }
        catch (NavException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        catch (XPathEvalException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        catch (XPathParseException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        return rval;
    }

    @Override
    public List<AttributeValueType> getValuesFromNodeList(String logId, String rootPath, String expression) throws UtilException {
        ArrayList<AttributeValueType> rval = new ArrayList<AttributeValueType>();
        try {
            int index;
            this.ap.selectXPath(rootPath);
            AutoPilot apExpression = new AutoPilot();
            this.ap.selectXPath(rootPath);
            apExpression.selectXPath(expression);
            apExpression.bind(this.vn);
            while ((index = this.ap.evalXPath()) != -1) {
                int i = 0;
                while ((i = apExpression.evalXPath()) != -1) {
                    AttributeValueType attrValueType = new AttributeValueType();
                    AttributeValueType.OriginalValue origValue = new AttributeValueType.OriginalValue();
                    attrValueType.setOriginalValue(origValue);
                    int startToken = this.vn.getTokenType(i);
                    int endToken = this.vn.getTokenType(i + 1);
                    if (!(startToken != 0 && startToken != 2 || endToken != 4 && endToken != 11 && endToken != 5)) {
                        if (this.vn.toString(i + 1) == null) continue;
                        origValue.setValue(this.vn.toString(i + 1));
                        attrValueType.setOriginalValue(origValue);
                        rval.add(attrValueType);
                        continue;
                    }
                    if (this.vn.getAttrCount() <= 0 || this.vn.getText() <= -1) continue;
                    origValue.setValue(this.vn.toString(this.vn.getText()));
                    attrValueType.setOriginalValue(origValue);
                    rval.add(attrValueType);
                }
                apExpression.resetXPath();
            }
            this.ap.resetXPath();
        }
        catch (NavException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error);
        }
        catch (XPathEvalException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error);
        }
        catch (XPathParseException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error);
        }
        return rval;
    }

    @Override
    public List<AttributeValueType> getValuesFromNodeListInclEmpty(String logId, String rootPath, String expression) throws UtilException {
        ArrayList<AttributeValueType> rval = new ArrayList<AttributeValueType>();
        try {
            int index;
            this.ap.selectXPath(rootPath);
            AutoPilot apExpression = new AutoPilot();
            this.ap.selectXPath(rootPath);
            apExpression.selectXPath(expression);
            apExpression.bind(this.vn);
            while ((index = this.ap.evalXPath()) != -1) {
                int i = 0;
                int counter = 0;
                do {
                    AttributeValueType attrValueType = new AttributeValueType();
                    AttributeValueType.OriginalValue origValue = new AttributeValueType.OriginalValue();
                    attrValueType.setOriginalValue(origValue);
                    i = apExpression.evalXPath();
                    if (i >= 0) {
                        int startToken = this.vn.getTokenType(i);
                        int endToken = this.vn.getTokenType(i + 1);
                        if (!(startToken != 0 && startToken != 2 || endToken != 4 && endToken != 11 && endToken != 5)) {
                            if (this.vn.toString(i + 1) != null) {
                                origValue.setValue(this.vn.toString(i + 1));
                            } else {
                                origValue.setValue("");
                            }
                            attrValueType.setOriginalValue(origValue);
                            rval.add(attrValueType);
                        } else if (this.vn.getAttrCount() > 0) {
                            if (this.vn.getText() > -1) {
                                origValue.setValue(this.vn.toString(this.vn.getText()));
                            } else {
                                origValue.setValue("");
                            }
                            attrValueType.setOriginalValue(origValue);
                            rval.add(attrValueType);
                        }
                        ++counter;
                        continue;
                    }
                    if (counter != 0) continue;
                    origValue.setValue("");
                    attrValueType.setOriginalValue(origValue);
                    rval.add(attrValueType);
                } while (i != -1);
                apExpression.resetXPath();
            }
            this.ap.resetXPath();
        }
        catch (NavException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error);
        }
        catch (XPathEvalException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error);
        }
        catch (XPathParseException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error);
        }
        return rval;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public List<DctmAttribute.AttributeObjectValue> getValueObjectsFromNodeListInclEmpty(String logId, String rootPath, List<DctmAttribute.ObjectRelativeXpath> expressionList) throws UtilException {
        rval = new ArrayList<DctmAttribute.AttributeObjectValue>();
        try {
            this.ap.selectXPath(rootPath);
            apExpression = new AutoPilot();
            index = -1;
            while ((index = this.ap.evalXPath()) != -1) {
                this.vn.push();
                objectValue = new DctmAttribute.AttributeObjectValue();
                valueMap = new ValueMap<String, ObjectValueType>();
                for (DctmAttribute.ObjectRelativeXpath expression : expressionList) {
                    value = new ObjectValueType();
                    value.setXpath(rootPath + " " + expression.getValue());
                    value.setType(expression.getType());
                    if (expression.getMinLength() != null) {
                        value.setMinLength(expression.getMinLength());
                    }
                    if (expression.getMaxLength() != null) {
                        value.setMaxLength(expression.getMaxLength());
                    }
                    i = 0;
                    counter = 0;
                    apExpression.selectXPath(expression.getValue());
                    apExpression.bind(this.vn);
                    separator = ".";
                    if (expression.getSeparator() != null) {
                        separator = expression.getSeparator();
                    }
                    do {
                        block31: {
                            i = apExpression.evalXPath();
                            attributeValue = new AttributeValueType();
                            origValue = new AttributeValueType.OriginalValue();
                            if (i < 0) break block31;
                            var17_23 = expression.getType();
                            var18_24 = -1;
                            switch (var17_23.hashCode()) {
                                case 83: {
                                    if (!var17_23.equals("S")) break;
                                    var18_24 = 0;
                                    break;
                                }
                                case 84: {
                                    if (!var17_23.equals("T")) break;
                                    var18_24 = 1;
                                    break;
                                }
                                case 2122: {
                                    if (!var17_23.equals("BL")) break;
                                    var18_24 = 2;
                                    break;
                                }
                                case 2336: {
                                    if (!var17_23.equals("II")) break;
                                    var18_24 = 3;
                                    break;
                                }
                                case 2163: {
                                    if (!var17_23.equals("CV")) break;
                                    var18_24 = 4;
                                }
                            }
                            switch (var18_24) {
                                case 0: 
                                case 1: 
                                case 2: {
                                    startToken = this.vn.getTokenType(i);
                                    endToken = this.vn.getTokenType(i + 1);
                                    if (!(startToken != 0 && startToken != 2 || endToken != 4 && endToken != 11 && endToken != 5)) {
                                        origValue.setValue(this.vn.toString(i + 1));
                                        attributeValue.setOriginalValue(origValue);
                                        value.getValueList().add(attributeValue);
                                    } else if (this.vn.getAttrCount() > 0) {
                                        if (this.vn.getText() > -1) {
                                            origValue.setValue(this.vn.toString(this.vn.getText()));
                                        } else {
                                            origValue.setValue("");
                                        }
                                        attributeValue.setOriginalValue(origValue);
                                        value.getValueList().add(attributeValue);
                                    }
                                    ++counter;
                                    break;
                                }
                                case 3: {
                                    apExpressionRoot = new AutoPilot();
                                    apExpressionRoot.selectXPath("@root");
                                    apExpressionExtension = new AutoPilot();
                                    apExpressionExtension.selectXPath("@extension");
                                    apExpressionRoot.bind(this.vn);
                                    apExpressionExtension.bind(this.vn);
                                    root = apExpressionRoot.evalXPathToString();
                                    extension = apExpressionExtension.evalXPathToString();
                                    retValue = new StringBuilder();
                                    if (extension == null || extension.length() <= 0) ** GOTO lbl91
                                    if (root != null && root.length() > 0) {
                                        retValue.append(root).append(separator).append(extension);
                                    } else {
                                        error = this.errorWrapper.getError("1015");
                                        error.setErrorDescription("II-elementilt\u00e4 puuttuu root, vaikka on annettu extension: " + rootPath + " " + expression.getValue());
                                        ArkistoXPathHelperVTD.LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
                                        throw new UtilException(error);
lbl91:
                                        // 1 sources

                                        retValue.append(root);
                                    }
                                    origValue.setValue(retValue.toString());
                                    origValue.setFirstValue(root);
                                    origValue.setSecondValue(extension);
                                    attributeValue.setOriginalValue(origValue);
                                    ++counter;
                                    value.getValueList().add(attributeValue);
                                    break;
                                }
                                case 4: {
                                    separator = "!";
                                    if (expression.getSeparator() != null) {
                                        separator = expression.getSeparator();
                                    }
                                    apCode = new AutoPilot();
                                    apCodeSystem = new AutoPilot();
                                    apCode.selectXPath("@code");
                                    apCodeSystem.selectXPath("@codeSystem");
                                    apCode.bind(this.vn);
                                    apCodeSystem.bind(this.vn);
                                    code = apCode.evalXPathToString();
                                    codeSystem = apCodeSystem.evalXPathToString();
                                    retValue = new StringBuilder();
                                    if (code != null && code.length() > 0 && codeSystem != null && codeSystem.length() > 0) {
                                        retValue.append(codeSystem).append(separator).append(code);
                                    }
                                    ++counter;
                                    origValue.setValue(retValue.toString());
                                    origValue.setFirstValue(code);
                                    origValue.setSecondValue(codeSystem);
                                    attributeValue.setOriginalValue(origValue);
                                    value.getValueList().add(attributeValue);
                                    break;
                                }
                                default: {
                                    error = this.errorWrapper.getError("1017");
                                    error.setErrorDescription("Tuntematon attribuuttityyppi.");
                                    error.setReturnDescription(false);
                                    ArkistoXPathHelperVTD.LOGGER.error((Object)this.logHelper.formatMsg("20", error));
                                    throw new UtilException(error);
                                }
                            }
                            continue;
                        }
                        if (counter != 0) continue;
                        origValue.setValue("");
                        attributeValue.setOriginalValue(origValue);
                        value.getValueList().add(attributeValue);
                    } while (i != -1);
                    valueMap.put(expression.getKey(), value);
                    apExpression.resetXPath();
                }
                this.vn.pop();
                objectValue.setValues(valueMap);
                rval.add(objectValue);
            }
            this.ap.resetXPath();
        }
        catch (NavException e) {
            error = this.errorWrapper.getError("2010");
            ArkistoXPathHelperVTD.LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error);
        }
        catch (XPathEvalException e) {
            error = this.errorWrapper.getError("2010");
            ArkistoXPathHelperVTD.LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error);
        }
        catch (XPathParseException e) {
            error = this.errorWrapper.getError("2010");
            ArkistoXPathHelperVTD.LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error);
        }
        return rval;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public List<DctmAttribute.AttributeObjectValue> getValueObjectsFromNode(String logId, String rootPath, List<DctmAttribute.ObjectRelativeXpath> expressionList) throws UtilException {
        rval = new ArrayList<DctmAttribute.AttributeObjectValue>();
        try {
            block28: {
                this.ap.selectXPath(rootPath);
                apExpression = new AutoPilot();
                index = -1;
                index = this.ap.evalXPath();
                if (index == -1) break block28;
                this.vn.push();
                objectValue = new DctmAttribute.AttributeObjectValue();
                valueMap = new ValueMap<String, ObjectValueType>();
                for (DctmAttribute.ObjectRelativeXpath expression : expressionList) {
                    value = new ObjectValueType();
                    value.setXpath(rootPath + " " + expression.getValue());
                    value.setType(expression.getType());
                    if (expression.getMinLength() != null) {
                        value.setMinLength(expression.getMinLength());
                    }
                    if (expression.getMaxLength() != null) {
                        value.setMaxLength(expression.getMaxLength());
                    }
                    i = 0;
                    counter = 0;
                    apExpression.selectXPath(expression.getValue());
                    apExpression.bind(this.vn);
                    separator = ".";
                    if (expression.getSeparator() != null) {
                        separator = expression.getSeparator();
                    }
                    do {
                        block29: {
                            i = apExpression.evalXPath();
                            attributeValue = new AttributeValueType();
                            origValue = new AttributeValueType.OriginalValue();
                            if (i < 0) break block29;
                            var17_23 = expression.getType();
                            var18_24 = -1;
                            switch (var17_23.hashCode()) {
                                case 83: {
                                    if (!var17_23.equals("S")) break;
                                    var18_24 = 0;
                                    break;
                                }
                                case 84: {
                                    if (!var17_23.equals("T")) break;
                                    var18_24 = 1;
                                    break;
                                }
                                case 2122: {
                                    if (!var17_23.equals("BL")) break;
                                    var18_24 = 2;
                                    break;
                                }
                                case 2336: {
                                    if (!var17_23.equals("II")) break;
                                    var18_24 = 3;
                                    break;
                                }
                                case 2163: {
                                    if (!var17_23.equals("CV")) break;
                                    var18_24 = 4;
                                }
                            }
                            switch (var18_24) {
                                case 0: 
                                case 1: 
                                case 2: {
                                    startToken = this.vn.getTokenType(i);
                                    endToken = this.vn.getTokenType(i + 1);
                                    if (!(startToken != 0 && startToken != 2 || endToken != 4 && endToken != 11 && endToken != 5)) {
                                        origValue.setValue(this.vn.toString(i + 1));
                                        attributeValue.setOriginalValue(origValue);
                                        value.getValueList().add(attributeValue);
                                    } else if (this.vn.getAttrCount() > 0) {
                                        origValue.setValue(this.vn.toString(this.vn.getText()));
                                        attributeValue.setOriginalValue(origValue);
                                        value.getValueList().add(attributeValue);
                                    }
                                    ++counter;
                                    break;
                                }
                                case 3: {
                                    apExpressionRoot = new AutoPilot();
                                    apExpressionRoot.selectXPath("@root");
                                    apExpressionExtension = new AutoPilot();
                                    apExpressionExtension.selectXPath("@extension");
                                    apExpressionRoot.bind(this.vn);
                                    apExpressionExtension.bind(this.vn);
                                    root = apExpressionRoot.evalXPathToString();
                                    extension = apExpressionExtension.evalXPathToString();
                                    retValue = new StringBuilder();
                                    if (extension == null || extension.length() <= 0) ** GOTO lbl89
                                    if (root != null && root.length() > 0) {
                                        retValue.append(root).append(separator).append(extension);
                                    } else {
                                        error = this.errorWrapper.getError("1015");
                                        error.setErrorDescription("II-elementilt\u00e4 puuttuu root, vaikka on annettu extension: " + rootPath + " " + expression.getValue());
                                        ArkistoXPathHelperVTD.LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
                                        throw new UtilException(error);
lbl89:
                                        // 1 sources

                                        retValue.append(root);
                                    }
                                    origValue.setValue(retValue.toString());
                                    origValue.setFirstValue(root);
                                    origValue.setSecondValue(extension);
                                    attributeValue.setOriginalValue(origValue);
                                    ++counter;
                                    value.getValueList().add(attributeValue);
                                    break;
                                }
                                case 4: {
                                    separator = "!";
                                    if (expression.getSeparator() != null) {
                                        separator = expression.getSeparator();
                                    }
                                    apCode = new AutoPilot();
                                    apCodeSystem = new AutoPilot();
                                    apCode.selectXPath("@code");
                                    apCodeSystem.selectXPath("@codeSystem");
                                    apCode.bind(this.vn);
                                    apCodeSystem.bind(this.vn);
                                    code = apCode.evalXPathToString();
                                    codeSystem = apCodeSystem.evalXPathToString();
                                    retValue = new StringBuilder();
                                    if (code != null && code.length() > 0 && codeSystem != null && codeSystem.length() > 0) {
                                        retValue.append(codeSystem).append(separator).append(code);
                                    }
                                    ++counter;
                                    origValue.setValue(retValue.toString());
                                    origValue.setFirstValue(code);
                                    origValue.setSecondValue(codeSystem);
                                    attributeValue.setOriginalValue(origValue);
                                    value.getValueList().add(attributeValue);
                                    break;
                                }
                                default: {
                                    error = this.errorWrapper.getError("1017");
                                    error.setErrorDescription("Tuntematon attribuuttityyppi.");
                                    error.setReturnDescription(false);
                                    ArkistoXPathHelperVTD.LOGGER.error((Object)this.logHelper.formatMsg("20", error));
                                    throw new UtilException(error);
                                }
                            }
                            continue;
                        }
                        if (counter != 0) continue;
                        origValue.setValue("");
                        attributeValue.setOriginalValue(origValue);
                        value.getValueList().add(attributeValue);
                    } while (i != -1);
                    valueMap.put(expression.getKey(), value);
                    apExpression.resetXPath();
                }
                this.vn.pop();
                objectValue.setValues(valueMap);
                rval.add(objectValue);
            }
            this.ap.resetXPath();
        }
        catch (NavException e) {
            error = this.errorWrapper.getError("2010");
            ArkistoXPathHelperVTD.LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error);
        }
        catch (XPathEvalException e) {
            error = this.errorWrapper.getError("2010");
            ArkistoXPathHelperVTD.LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error);
        }
        catch (XPathParseException e) {
            error = this.errorWrapper.getError("2010");
            ArkistoXPathHelperVTD.LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error);
        }
        return rval;
    }

    @Override
    public List<String> getValuesFromNodeListByElementName(String logId, String expression, String elementName) throws UtilException {
        ArrayList<String> rval = new ArrayList<String>();
        try {
            this.ap.selectXPath(expression);
            String elementValue = null;
            while (this.ap.evalXPath() != -1) {
                if (this.vn.toElement(2, elementName)) {
                    do {
                        int val;
                        if ((val = this.vn.getText()) == -1) continue;
                        elementValue = this.vn.toNormalizedString(val);
                        rval.add(elementValue);
                    } while (this.vn.toElement(4, elementName));
                }
                this.vn.toElement(1);
            }
            this.ap.resetXPath();
        }
        catch (NavException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error);
        }
        catch (XPathEvalException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error);
        }
        catch (XPathParseException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error);
        }
        return rval;
    }

    @Override
    public AttributeValueType getIIValue(String logId, String rootExpr, String extensionExpr, String separator) throws UtilException {
        AttributeValueType rval = new AttributeValueType();
        AttributeValueType.OriginalValue origValue = new AttributeValueType.OriginalValue();
        String root = "";
        String rootValue = this.getCode(logId, rootExpr);
        String extensionValue = this.getCode(logId, extensionExpr);
        if (extensionValue != null && extensionValue.length() > 0) {
            origValue.setValue(root + separator + extensionValue);
        } else {
            origValue.setValue(rootValue);
        }
        origValue.setFirstValue(rootValue);
        origValue.setSecondValue(extensionValue);
        rval.setOriginalValue(origValue);
        return rval;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AttributeValueType getIIValue(String logId, String expression, String separator) throws UtilException {
        StringBuilder valueBuff = new StringBuilder();
        AttributeValueType rval = new AttributeValueType();
        AttributeValueType.OriginalValue origValue = new AttributeValueType.OriginalValue();
        rval.setOriginalValue(origValue);
        String expressionRoot = "@root";
        String expressionExtension = "@extension";
        try {
            AutoPilot apRoot = new AutoPilot();
            AutoPilot apExtension = new AutoPilot();
            this.ap.selectXPath(expression);
            apRoot.selectXPath(expressionRoot);
            apExtension.selectXPath(expressionExtension);
            apRoot.bind(this.vn);
            apExtension.bind(this.vn);
            if (this.ap.evalXPath() != -1) {
                String extension;
                String root;
                block8: {
                    root = apRoot.evalXPathToString();
                    extension = apExtension.evalXPathToString();
                    if (extension.length() > 0) {
                        if (root != null && root.length() > 0) {
                            valueBuff.append(root).append(separator).append(extension);
                            break block8;
                        } else {
                            InternalServiceError error = this.errorWrapper.getError("1015");
                            error.setErrorDescription("II-elementilt\u00e4 puuttuu root, vaikka on annettu extension: " + expression);
                            LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
                            throw new UtilException(error);
                        }
                    }
                    valueBuff.append(root);
                }
                origValue.setFirstValue(root);
                origValue.setSecondValue(extension);
                origValue.setValue(valueBuff.toString());
                rval.setOriginalValue(origValue);
            }
            this.ap.resetXPath();
            return rval;
        }
        catch (NavException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        catch (XPathParseException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error);
        }
        catch (XPathEvalException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error);
        }
    }

    @Override
    public AutoPilot getPilot() {
        return this.ap;
    }

    @Override
    public VTDNav getNav() {
        return this.vn;
    }

    private AttributeValueType getEmptyAttributeValueType() {
        AttributeValueType attrValueType = new AttributeValueType();
        attrValueType.setFormattedValue("");
        AttributeValueType.OriginalValue origValue = new AttributeValueType.OriginalValue();
        origValue.setValue("");
        origValue.setFirstValue("");
        origValue.setSecondValue("");
        attrValueType.setOriginalValue(origValue);
        return attrValueType;
    }

    @Override
    public List<String> getPatientIds(String logId) throws UtilException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
            if (this.vn != null) {
                LOGGER.debug((Object)("current vn index: " + this.vn.getCurrentIndex()));
            }
        }
        ArrayList<String> hetuList = new ArrayList<String>();
        try {
            int index;
            int rootIndex = this.vn.getRootIndex();
            this.vn.recoverNode(rootIndex);
            AutoPilot apPalvelutapahtuma = new AutoPilot();
            apPalvelutapahtuma.bind(this.vn);
            apPalvelutapahtuma.selectXPath("descendant-or-self::*[contains(@codeSystem, '1.2.246.21')]/@code");
            while ((index = apPalvelutapahtuma.evalXPath()) != -1) {
                String hetu = this.vn.toString(index + 1);
                if (hetu == null) continue;
                hetuList.add(hetu);
            }
            this.vn.recoverNode(rootIndex);
            apPalvelutapahtuma.resetXPath();
            AutoPilot apHoitoasiakirja = new AutoPilot();
            apHoitoasiakirja.bind(this.vn);
            apHoitoasiakirja.selectXPath("descendant-or-self::*[contains(@root, '1.2.246.21')]/@extension");
            while ((index = apHoitoasiakirja.evalXPath()) != -1) {
                String hetu = this.vn.toString(index + 1);
                if (hetu == null) continue;
                hetuList.add(hetu);
            }
            apHoitoasiakirja.resetXPath();
        }
        catch (NavException | XPathEvalException | XPathParseException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), e);
            throw new UtilException(error, e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return hetuList;
    }
}

