/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.util;

import fi.kanta.arkistopalvelu.client.SuostumustenhallintaClient;
import fi.kanta.arkistopalvelu.util.MetadataList;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.exception.UtilException;
import fi.kanta.common.util.QueryResult;
import fi.kanta.suostumustenhallinta.dto.Arkistokiellot;
import fi.kanta.suostumustenhallinta.dto.Potilas;
import org.apache.log4j.Logger;

public class SuostumustenHallintaUtil {
    private static final Logger LOGGER = Logger.getLogger(SuostumustenHallintaUtil.class);
    private static LogHelper logHelper = new LogHelper();

    private SuostumustenHallintaUtil() {
    }

    public static boolean getKantaEArkistoInformation(String logId, MetadataList metadataList) throws UtilException {
        Potilas potilas = SuostumustenhallintaClient.getPotilas(logId, metadataList);
        if (potilas != null) {
            return potilas.getArkistoinformointi();
        }
        return false;
    }

    public static boolean getKantaEArkistoSuostumus(String logId, MetadataList metadataList) throws UtilException {
        Potilas potilas = SuostumustenhallintaClient.getPotilas(logId, metadataList);
        if (potilas != null) {
            return potilas.getSuostumus();
        }
        return false;
    }

    public static QueryResult getPatient(String logId, MetadataList metadataList) throws UtilException {
        Potilas potilas;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)logHelper.formatMsgBgn(logId));
        }
        if ((potilas = SuostumustenhallintaClient.getPotilas(logId, metadataList)) == null) {
            return null;
        }
        QueryResult queryResult = new QueryResult();
        queryResult.addAttribute("cda_kanta_earkisto_info", (Object)potilas.getArkistoinformointi());
        queryResult.addAttribute("consent", (Object)potilas.getSuostumus());
        queryResult.addAttribute("restriction", (Object)potilas.getKielto());
        queryResult.addAttribute("cda_bypass_restriction", (Object)potilas.getOhitakiellot());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)logHelper.formatMsgEnd(logId));
        }
        return queryResult;
    }

    public static Arkistokiellot getArkistoKiellot(String logId, MetadataList metadataList) throws UtilException {
        return SuostumustenhallintaClient.getArkistoKiellot(logId, metadataList);
    }

    public static Potilas getPotilas(String logId, MetadataList metadataList) throws UtilException {
        return SuostumustenhallintaClient.getPotilas(logId, metadataList);
    }
}

