/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.util.xpathconfig;

import fi.kanta.arkistopalvelu.exception.ConfigException;
import fi.kanta.arkistopalvelu.util.ErrorWrapperArchive;
import fi.kanta.arkistopalvelu.util.xpathconfig.DctmAttribute;
import fi.kanta.arkistopalvelu.util.xpathconfig.DctmAttributesForbidden;
import fi.kanta.arkistopalvelu.util.xpathconfig.DctmAttributesSave;
import fi.kanta.arkistopalvelu.util.xpathconfig.DctmAttributesSpecial;
import fi.kanta.arkistopalvelu.util.xpathconfig.DctmAttributesValidate;
import fi.kanta.arkistopalvelu.util.xpathconfig.XmlXpathConfig;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.util.InternalServiceError;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class XpathConfigManager {
    private static final String XML_FILE_SUFFIX = ".xml";
    private static final Logger LOGGER = Logger.getLogger(XpathConfigManager.class);
    private static XpathConfigManager me = null;
    private LogHelper logHelper;
    private Map<String, XmlXpathConfig> configMap = new HashMap<String, XmlXpathConfig>();
    private ErrorWrapperArchive errorWrapper = ErrorWrapperArchive.getInstance();

    private XpathConfigManager() throws ConfigException {
        this.logHelper = new LogHelper();
        this.getXPathConfigMap();
    }

    private void getXPathConfigMap() throws ConfigException {
        String logId;
        block10: {
            logId = "20";
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
            }
            try {
                String arkistoPath = System.getProperty("arkistopalvelu.path");
                String xmlPath = arkistoPath + System.getProperty("file.separator") + "config" + System.getProperty("file.separator") + "xpathconfig";
                File folder = new File(xmlPath);
                File[] files = folder.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(XpathConfigManager.XML_FILE_SUFFIX);
                    }
                });
                if (files == null) break block10;
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{XmlXpathConfig.class});
                String fileName = xmlPath + System.getProperty("file.separator") + "xmlXpathConfig.xsd";
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)this.logHelper.formatMsg("20", "Reading schema", fileName));
                }
                SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema arkistoConfigSchema = factory.newSchema(new StreamSource(new File(fileName)));
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                jaxbUnmarshaller.setSchema(arkistoConfigSchema);
                XmlXpathConfig config = null;
                for (File file : files) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)this.logHelper.formatMsg("20", "Luetaan tiedosto: ", file.getName()));
                    }
                    if ((config = (XmlXpathConfig)jaxbUnmarshaller.unmarshal(file)).getSpecifications() != null) {
                        List<String> specifications = this.parseSpecifications(logId, config.getSpecifications());
                        for (String specification : specifications) {
                            this.addConfiguration(logId, config, specification);
                        }
                        continue;
                    }
                    this.addConfiguration(logId, config);
                }
            }
            catch (JAXBException e) {
                InternalServiceError error = this.errorWrapper.getError("1046");
                LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
                throw new ConfigException(error);
            }
            catch (SAXException e) {
                InternalServiceError error = this.errorWrapper.getError("1046");
                LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
                throw new ConfigException(error);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    public static XpathConfigManager getInstance() {
        return me;
    }

    public XmlXpathConfig getXPathConfig(String logId, String doctype, int level) throws ConfigException {
        return this.getXPathConfig(logId, doctype, level, null);
    }

    public XmlXpathConfig getXPathConfig(String logId, String doctype, int level, String specificationIdentifier) throws ConfigException {
        XmlXpathConfig origConfig;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        XmlXpathConfig retConfig = null;
        String identifier = null;
        if (specificationIdentifier != null) {
            String tempIdentifier = doctype + "*|*" + specificationIdentifier + "*|*" + level;
            if (identifier == null && this.configMap.containsKey(tempIdentifier)) {
                identifier = tempIdentifier;
            }
        }
        if (identifier == null) {
            identifier = doctype + "*|*" + level;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsg(logId, "Haetaan xpathconfig-konfiguraatio: [" + identifier + "]"));
        }
        if ((origConfig = this.configMap.get(identifier)) != null) {
            retConfig = this.copy(logId, origConfig);
        }
        if (retConfig == null) {
            InternalServiceError error = this.errorWrapper.getError("1046");
            error.setErrorDescription("Puuttuva xpathconfig-konfiguraatio: [" + identifier + "]");
            error.setReturnDescription(false);
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
            throw new ConfigException(error);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return retConfig;
    }

    private XmlXpathConfig copy(String logId, XmlXpathConfig origConfig) {
        XmlXpathConfig copy = new XmlXpathConfig();
        copy.setDocType(new String(origConfig.getDocType()));
        copy.setName(new String(origConfig.getName()));
        copy.setInspectionLevel(origConfig.inspectionLevel);
        if (origConfig.getSpecifications() != null) {
            copy.setSpecifications(new String(origConfig.getSpecifications()));
        }
        ArrayList<DctmAttribute> validateAttrs = new ArrayList<DctmAttribute>();
        for (DctmAttribute dctmAttribute : origConfig.getDctmAttributesValidate().getDctmAttribute()) {
            validateAttrs.add(this.copyDctmAttribute(dctmAttribute));
        }
        copy.setDctmAttributesValidate(new DctmAttributesValidate());
        copy.getDctmAttributesValidate().getDctmAttribute().addAll(validateAttrs);
        ArrayList<DctmAttribute> saveAttrs = new ArrayList<DctmAttribute>();
        for (DctmAttribute attr : origConfig.getDctmAttributesSave().getDctmAttribute()) {
            saveAttrs.add(this.copyDctmAttribute(attr));
        }
        copy.setDctmAttributesSave(new DctmAttributesSave());
        copy.getDctmAttributesSave().getDctmAttribute().addAll(saveAttrs);
        if (origConfig.getDctmAttributesSpecial() != null) {
            ArrayList<DctmAttribute> arrayList = new ArrayList<DctmAttribute>();
            for (DctmAttribute attr : origConfig.getDctmAttributesSpecial().getDctmAttribute()) {
                arrayList.add(this.copyDctmAttribute(attr));
            }
            copy.setDctmAttributesSpecial(new DctmAttributesSpecial());
            copy.getDctmAttributesSpecial().getDctmAttribute().addAll(arrayList);
        }
        copy.setDctmAttributesForbidden(new DctmAttributesForbidden());
        copy.getDctmAttributesForbidden().getDctmAttributeForbidden().addAll(origConfig.getDctmAttributesForbidden().getDctmAttributeForbidden());
        return copy;
    }

    private DctmAttribute copyDctmAttribute(DctmAttribute attr) {
        DctmAttribute attrCopy = new DctmAttribute();
        attrCopy.setAttributeMaxLength(attr.attributeMaxLength);
        attrCopy.setAttributeMinLength(attr.attributeMinLength);
        attrCopy.setAttributeMaxLengthTotal(attr.attributeMaxLengthTotal);
        if (attr.getRequiredAttributeValues() != null) {
            attrCopy.getRequiredAttributeValues().addAll(attr.getRequiredAttributeValues());
        }
        if (attr.getDctmAttributeRelativeXpath() != null) {
            attrCopy.setDctmAttributeRelativeXpath(new String(attr.getDctmAttributeRelativeXpath()));
        }
        if (attr.getObjectRelativeXpath() != null) {
            List<DctmAttribute.ObjectRelativeXpath> relativeList = attr.getObjectRelativeXpath();
            for (DctmAttribute.ObjectRelativeXpath relative : relativeList) {
                DctmAttribute.ObjectRelativeXpath relativeNew = new DctmAttribute.ObjectRelativeXpath();
                if (relative.getKey() != null) {
                    relativeNew.setKey(new String(relative.getKey()));
                }
                if (relative.getType() != null) {
                    relativeNew.setType(new String(relative.getType()));
                }
                if (relative.getChecktype() != null) {
                    relativeNew.setChecktype(relative.getChecktype());
                }
                relativeNew.setValue(new String(relative.getValue()));
                if (relative.getSeparator() != null) {
                    relativeNew.setSeparator(new String(relative.getSeparator()));
                }
                if (relative.getMinLength() != null) {
                    relativeNew.setMinLength(relative.minLength);
                }
                if (relative.getMaxLength() != null) {
                    relativeNew.setMaxLength(relative.maxLength);
                }
                attrCopy.getObjectRelativeXpath().add(relativeNew);
            }
        }
        attrCopy.setDctmAttributeXpath(new String(attr.getDctmAttributeXpath()));
        attrCopy.setDctmAttributeType(attr.getDctmAttributeType());
        if (attr.getDctmAttributeType().getSeparator() != null) {
            attrCopy.getDctmAttributeType().setSeparator(new String(attr.getDctmAttributeType().getSeparator()));
        }
        attrCopy.setDefaultNamespace(new Boolean(attr.isDefaultNamespace()));
        attrCopy.setIsNodelist(new DctmAttribute.IsNodelist());
        attrCopy.getIsNodelist().setValue(attr.getIsNodelist().isValue());
        if (attr.getIsNodelist().getSeparator() != null) {
            attrCopy.getIsNodelist().setSeparator(new String(attr.getIsNodelist().getSeparator()));
        }
        if (attr.getIsNodelist().isIncEmtpy() != null) {
            attrCopy.getIsNodelist().setIncEmtpy(new Boolean(attr.getIsNodelist().isIncEmtpy()));
        }
        if (attr.getIsNodelist().isRemoveDuplicates() != null) {
            attrCopy.getIsNodelist().setRemoveDuplicates(new Boolean(attr.getIsNodelist().isRemoveDuplicates()));
        }
        attrCopy.setIsRepeating(attr.isIsRepeating());
        attrCopy.setName(new String(attr.getName()));
        if (attr.getCodesystemCheck() != null) {
            attrCopy.getCodesystemCheck().addAll(attr.getCodesystemCheck());
        }
        return attrCopy;
    }

    private List<String> parseSpecifications(String logId, String specificationsString) {
        String[] specificationsArray;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        ArrayList<String> specifications = new ArrayList<String>();
        for (String specification : specificationsArray = specificationsString.split(",")) {
            if ((specification = specification.trim()).length() <= 0) continue;
            specifications.add(specification);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return specifications;
    }

    private void addConfiguration(String logId, XmlXpathConfig config) throws ConfigException {
        this.addConfiguration(logId, config, null);
    }

    private void addConfiguration(String logId, XmlXpathConfig config, String specification) throws ConfigException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        StringBuilder identifierBuilder = new StringBuilder();
        identifierBuilder.append(config.getDocType());
        if (specification != null) {
            identifierBuilder.append("*|*");
            identifierBuilder.append(specification);
        }
        identifierBuilder.append("*|*");
        identifierBuilder.append(config.getInspectionLevel().toString());
        String identifier = identifierBuilder.toString();
        if (this.configMap.containsKey(identifier)) {
            InternalServiceError error = this.errorWrapper.getError("1046");
            error.setErrorDescription("Kaksi p\u00e4\u00e4llek\u00e4ist\u00e4 xpathconfig-konfiguraatiota samalla avaimella: [" + identifier + "]");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
            throw new ConfigException(error);
        }
        this.configMap.put(identifier, config);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    static {
        try {
            me = new XpathConfigManager();
        }
        catch (ConfigException e) {
            throw new ExceptionInInitializerError((Throwable)((Object)e));
        }
    }
}

