/*
 * Decompiled with CFR 0.152.
 */
package fi.kela.kanta.components;

import com.ximpleware.AutoPilot;
import com.ximpleware.FastLongBuffer;
import com.ximpleware.ModifyException;
import com.ximpleware.NavException;
import com.ximpleware.ParseException;
import com.ximpleware.TranscodeException;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import com.ximpleware.XMLModifier;
import com.ximpleware.XPathEvalException;
import com.ximpleware.XPathParseException;
import fi.kela.kanta.components.IXPathHelperVTD;
import fi.kela.kanta.exceptions.XPathHelperVTDException;
import fi.kela.kanta.utils.AttributeObjectValue;
import fi.kela.kanta.utils.AttributeValueType;
import fi.kela.kanta.utils.InsertProcessingInstruction;
import fi.kela.kanta.utils.ObjectRelativeXpath;
import fi.kela.kanta.utils.ObjectValueType;
import fi.kela.kanta.utils.RemoveProcessingInstruction;
import fi.kela.kanta.utils.UpdateProcessingInstruction;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class XPathHelperVTD
implements IXPathHelperVTD {
    private static final String II_NO_ROOT_ERRORMESSAGE = "II-elementilt\u00e4 puuttuu root, vaikka on annettu extension: ";
    private static final String UNKNOWN_ATTRIBUTETYPE = "Tuntematon attribuuttityyppi.";
    private AutoPilot ap;
    private VTDGen vg;
    private VTDNav vn;

    public XPathHelperVTD(byte[] doc) throws XPathHelperVTDException {
        try {
            this.ap = new AutoPilot();
            this.ap.declareXPathNameSpace("we", "http://webservices.arkistopalvelu.kanta.fi/");
            this.ap.declareXPathNameSpace("v3", "urn:hl7-org:v3");
            this.ap.declareXPathNameSpace("web", "http://webservices.arkistopalvelu.kanta.fi/");
            this.ap.declareXPathNameSpace("hl7fi", "urn:hl7finland");
            this.vg = new VTDGen();
            this.vg.setDoc(doc);
            this.vg.parse(true);
            this.vn = this.vg.getNav();
            this.ap.bind(this.vn);
        }
        catch (ParseException e) {
            throw new XPathHelperVTDException(e);
        }
    }

    @Override
    public String getCode(String expression) throws XPathHelperVTDException {
        String retStr = "";
        try {
            this.ap.selectXPath(expression);
            retStr = this.ap.evalXPathToString();
            if (retStr != null) {
                retStr = retStr.trim();
            }
        }
        catch (XPathParseException e) {
            throw new XPathHelperVTDException(e);
        }
        this.ap.resetXPath();
        return retStr;
    }

    @Override
    public String getContent(String expression) throws XPathHelperVTDException {
        String retStr = null;
        try {
            int index;
            this.ap.selectXPath(expression);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] xml = this.vn.getXML().getBytes();
            while ((index = this.ap.evalXPath()) != -1) {
                if (this.vn.getTokenType(index) != 0) continue;
                long l = this.vn.getContentFragment();
                int offset = (int)l;
                int len = (int)(l >> 32);
                os.write(xml, offset, len);
            }
            retStr = new String(os.toByteArray(), "UTF-8");
            this.ap.resetXPath();
        }
        catch (NavException | XPathEvalException | XPathParseException | IOException e) {
            throw new XPathHelperVTDException(e);
        }
        return retStr;
    }

    @Override
    public String getUniqueCodesFromNodeList(String expression) throws XPathHelperVTDException {
        StringBuilder retStr = new StringBuilder();
        ArrayList<String> nodevalues = new ArrayList<String>();
        boolean exists = false;
        try {
            int i;
            this.ap.selectXPath(expression);
            while ((i = this.ap.evalXPath()) != -1) {
                exists = false;
                String tt = this.vn.toString(i + 1);
                if (tt != null) {
                    tt = tt.trim();
                }
                if (nodevalues.contains(tt)) {
                    exists = true;
                }
                if (exists) continue;
                nodevalues.add(tt);
                if (retStr.length() > 0) {
                    retStr.append(" ");
                }
                retStr.append(tt);
            }
            this.ap.resetXPath();
        }
        catch (NavException | XPathEvalException | XPathParseException e) {
            throw new XPathHelperVTDException(e);
        }
        return retStr.toString();
    }

    @Override
    public String getAsString(String expression) throws XPathHelperVTDException {
        String retStr = null;
        try {
            this.ap.selectXPath(expression);
            FastLongBuffer flb = new FastLongBuffer(4);
            byte[] xml = this.vn.getXML().getBytes();
            while (this.ap.evalXPath() != -1) {
                flb.append(this.vn.getElementFragment());
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            int size = flb.size();
            for (int k = 0; k < size; ++k) {
                os.write("\n".getBytes());
                os.write(xml, flb.lower32At(k), flb.upper32At(k));
            }
            retStr = new String(os.toByteArray(), "UTF-8");
            this.ap.resetXPath();
            flb.clear();
        }
        catch (NavException | XPathEvalException | XPathParseException | IOException e) {
            throw new XPathHelperVTDException(e);
        }
        return retStr;
    }

    @Override
    public List<AttributeValueType> getUniqueCVvaluesFromNodeList(String expression, String separator, boolean allowNoCode) throws XPathHelperVTDException {
        ArrayList<String> tempList = new ArrayList<String>();
        ArrayList<AttributeValueType> retVal = new ArrayList<AttributeValueType>();
        try {
            AutoPilot apCode = new AutoPilot();
            AutoPilot apCodeSystem = new AutoPilot();
            this.ap.selectXPath(expression);
            apCode.selectXPath("@code");
            apCodeSystem.selectXPath("@codeSystem");
            apCode.bind(this.vn);
            apCodeSystem.bind(this.vn);
            AttributeValueType attrValueType = null;
            String code = null;
            String codeSystem = null;
            StringBuilder valueBuff = null;
            while (this.ap.evalXPath() != -1) {
                attrValueType = new AttributeValueType();
                code = apCode.evalXPathToString();
                codeSystem = apCodeSystem.evalXPathToString();
                valueBuff = new StringBuilder();
                if (code != null && code.length() > 0) {
                    if (codeSystem != null && codeSystem.length() > 0) {
                        valueBuff.append(codeSystem).append(separator).append(code);
                    }
                } else if (allowNoCode) {
                    valueBuff.append(codeSystem);
                }
                if (tempList.contains(valueBuff.toString())) continue;
                tempList.add(valueBuff.toString());
                attrValueType.setOriginalValue(valueBuff.toString());
                attrValueType.setOriginalFirstValue(code);
                attrValueType.setOriginalSecondValue(codeSystem);
                retVal.add(attrValueType);
            }
            this.ap.resetXPath();
        }
        catch (NavException | XPathEvalException | XPathParseException e) {
            throw new XPathHelperVTDException(e);
        }
        return retVal;
    }

    @Override
    public AttributeValueType getCVvalue(String expression, String separator) throws XPathHelperVTDException {
        AttributeValueType attrValueType = new AttributeValueType();
        StringBuilder valueBuff = new StringBuilder();
        try {
            AutoPilot apCode = new AutoPilot();
            AutoPilot apCodeSystem = new AutoPilot();
            this.ap.selectXPath(expression);
            apCode.selectXPath("@code");
            apCodeSystem.selectXPath("@codeSystem");
            apCode.bind(this.vn);
            apCodeSystem.bind(this.vn);
            if (this.ap.evalXPath() != -1) {
                String code = apCode.evalXPathToString();
                String codeSystem = apCodeSystem.evalXPathToString();
                if (code != null && code.length() > 0 && codeSystem != null && codeSystem.length() > 0) {
                    valueBuff.append(codeSystem).append(separator).append(code);
                }
                attrValueType.setOriginalValue(valueBuff.toString());
                attrValueType.setOriginalFirstValue(code);
                attrValueType.setOriginalSecondValue(codeSystem);
            }
            this.ap.resetXPath();
        }
        catch (NavException | XPathEvalException | XPathParseException e) {
            throw new XPathHelperVTDException(e);
        }
        return attrValueType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<AttributeValueType> getUniqueIIvaluesFromNodeList(String expression, String separator) throws XPathHelperVTDException {
        ArrayList<AttributeValueType> retVal = new ArrayList<AttributeValueType>();
        ArrayList<String> tempList = new ArrayList<String>();
        try {
            AutoPilot apRoot = new AutoPilot();
            AutoPilot apExtension = new AutoPilot();
            this.ap.selectXPath(expression);
            apRoot.selectXPath("@root");
            apExtension.selectXPath("@extension");
            apRoot.bind(this.vn);
            apExtension.bind(this.vn);
            AttributeValueType attrValueType = null;
            String root = null;
            String extension = null;
            StringBuilder valueBuff = null;
            while (this.ap.evalXPath() != -1) {
                attrValueType = new AttributeValueType();
                root = apRoot.evalXPathToString();
                extension = apExtension.evalXPathToString();
                valueBuff = new StringBuilder();
                if (extension.length() > 0) {
                    if (root == null || root.length() <= 0) throw new XPathHelperVTDException(II_NO_ROOT_ERRORMESSAGE + expression);
                    valueBuff.append(root).append(separator).append(extension);
                } else {
                    valueBuff.append(root);
                }
                if (tempList.contains(valueBuff.toString())) continue;
                tempList.add(valueBuff.toString());
                attrValueType.setOriginalValue(valueBuff.toString());
                attrValueType.setOriginalFirstValue(root);
                attrValueType.setOriginalSecondValue(extension);
                retVal.add(attrValueType);
            }
            this.ap.resetXPath();
            return retVal;
        }
        catch (NavException | XPathEvalException | XPathParseException e) {
            throw new XPathHelperVTDException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<AttributeValueType> getIIvaluesFromNodeList(String expression, String separator) throws XPathHelperVTDException {
        ArrayList<AttributeValueType> rval = new ArrayList<AttributeValueType>();
        try {
            String expressionRoot = "@root";
            String expressionExtension = "@extension";
            AutoPilot apRoot = new AutoPilot();
            AutoPilot apExtension = new AutoPilot();
            this.ap.selectXPath(expression);
            apRoot.selectXPath(expressionRoot);
            apExtension.selectXPath(expressionExtension);
            apRoot.bind(this.vn);
            apExtension.bind(this.vn);
            AttributeValueType attrValueType = null;
            String root = null;
            String extension = null;
            StringBuilder valueBuff = null;
            while (this.ap.evalXPath() != -1) {
                attrValueType = new AttributeValueType();
                root = apRoot.evalXPathToString();
                extension = apExtension.evalXPathToString();
                valueBuff = new StringBuilder();
                if (extension.length() > 0) {
                    if (root == null || root.length() <= 0) throw new XPathHelperVTDException(II_NO_ROOT_ERRORMESSAGE + expression);
                    valueBuff.append(root).append(separator).append(extension);
                } else {
                    valueBuff.append(root);
                }
                attrValueType.setOriginalValue(valueBuff.toString());
                attrValueType.setOriginalFirstValue(root);
                attrValueType.setOriginalSecondValue(extension);
                rval.add(attrValueType);
            }
            this.ap.resetXPath();
            return rval;
        }
        catch (NavException | XPathEvalException | XPathParseException e) {
            throw new XPathHelperVTDException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<AttributeValueType> getIIvaluesFromNodeList(String rootExpression, String expression, String separator) throws XPathHelperVTDException {
        ArrayList<AttributeValueType> rval = new ArrayList<AttributeValueType>();
        try {
            String expressionRoot = "@root";
            String expressionExtension = "@extension";
            AutoPilot apRoot = new AutoPilot();
            AutoPilot apExtension = new AutoPilot();
            AutoPilot apExpression = new AutoPilot();
            this.ap.selectXPath(rootExpression);
            apRoot.selectXPath(expressionRoot);
            apExtension.selectXPath(expressionExtension);
            apExpression.selectXPath(expression);
            apExpression.bind(this.vn);
            apRoot.bind(this.vn);
            apExtension.bind(this.vn);
            AttributeValueType attrValueType = null;
            String root = null;
            String extension = null;
            StringBuilder valueBuff = null;
            while (this.ap.evalXPath() != -1) {
                while (apExpression.evalXPath() != -1) {
                    attrValueType = new AttributeValueType();
                    root = apRoot.evalXPathToString();
                    extension = apExtension.evalXPathToString();
                    valueBuff = new StringBuilder();
                    if (extension.length() > 0) {
                        if (root == null || root.length() <= 0) throw new XPathHelperVTDException(II_NO_ROOT_ERRORMESSAGE + expression);
                        valueBuff.append(root).append(separator).append(extension);
                    } else {
                        valueBuff.append(root);
                    }
                    attrValueType.setOriginalValue(valueBuff.toString());
                    attrValueType.setOriginalFirstValue(root);
                    attrValueType.setOriginalSecondValue(extension);
                    rval.add(attrValueType);
                }
                apExpression.resetXPath();
            }
            this.ap.resetXPath();
            return rval;
        }
        catch (NavException | XPathEvalException | XPathParseException e) {
            throw new XPathHelperVTDException(e);
        }
    }

    @Override
    public List<AttributeValueType> getValuesFromNodeList(String expression) throws XPathHelperVTDException {
        ArrayList<AttributeValueType> rval = new ArrayList<AttributeValueType>();
        try {
            int index;
            this.ap.selectXPath(expression);
            AttributeValueType attrValueType = null;
            String value = null;
            while ((index = this.ap.evalXPath()) != -1) {
                attrValueType = new AttributeValueType();
                int startToken = this.vn.getTokenType(index);
                int endToken = this.vn.getTokenType(index + 1);
                if (!(startToken != 0 && startToken != 2 || endToken != 4 && endToken != 11 && endToken != 5)) {
                    attrValueType.setOriginalValue(this.vn.toString(index + 1));
                    rval.add(attrValueType);
                    continue;
                }
                if (this.vn.getAttrCount() <= 0) continue;
                value = this.vn.toString(this.vn.getText());
                if (value != null) {
                    value = value.trim();
                }
                attrValueType.setOriginalValue(this.vn.toString(index + 1));
                rval.add(attrValueType);
            }
            this.ap.resetXPath();
        }
        catch (NavException | XPathEvalException | XPathParseException e) {
            throw new XPathHelperVTDException(e);
        }
        return rval;
    }

    @Override
    public List<AttributeValueType> getValuesFromNodeList(String rootPath, String expression) throws XPathHelperVTDException {
        ArrayList<AttributeValueType> rval = new ArrayList<AttributeValueType>();
        try {
            this.ap.selectXPath(rootPath);
            AutoPilot apExpression = new AutoPilot();
            this.ap.selectXPath(rootPath);
            apExpression.selectXPath(expression);
            apExpression.bind(this.vn);
            AttributeValueType attrValueType = null;
            while (this.ap.evalXPath() != -1) {
                int i = 0;
                while ((i = apExpression.evalXPath()) != -1) {
                    attrValueType = new AttributeValueType();
                    int startToken = this.vn.getTokenType(i);
                    int endToken = this.vn.getTokenType(i + 1);
                    if (!(startToken != 0 && startToken != 2 || endToken != 4 && endToken != 11 && endToken != 5)) {
                        if (this.vn.toString(i + 1) == null) continue;
                        attrValueType.setOriginalValue(this.vn.toString(i + 1));
                        rval.add(attrValueType);
                        continue;
                    }
                    if (this.vn.getAttrCount() <= 0 || this.vn.getText() <= -1) continue;
                    attrValueType.setOriginalValue(this.vn.toString(i + 1));
                    rval.add(attrValueType);
                }
                apExpression.resetXPath();
            }
            this.ap.resetXPath();
        }
        catch (NavException | XPathEvalException | XPathParseException e) {
            throw new XPathHelperVTDException(e);
        }
        return rval;
    }

    @Override
    public List<AttributeValueType> getValuesFromNodeListInclEmpty(String rootPath, String expression) throws XPathHelperVTDException {
        ArrayList<AttributeValueType> rval = new ArrayList<AttributeValueType>();
        try {
            this.ap.selectXPath(rootPath);
            AutoPilot apExpression = new AutoPilot();
            this.ap.selectXPath(rootPath);
            apExpression.selectXPath(expression);
            apExpression.bind(this.vn);
            AttributeValueType attrValueType = null;
            while (this.ap.evalXPath() != -1) {
                int i = 0;
                int counter = 0;
                do {
                    attrValueType = new AttributeValueType();
                    i = apExpression.evalXPath();
                    if (i >= 0) {
                        int startToken = this.vn.getTokenType(i);
                        int endToken = this.vn.getTokenType(i + 1);
                        if (!(startToken != 0 && startToken != 2 || endToken != 4 && endToken != 11 && endToken != 5)) {
                            if (this.vn.toString(i + 1) != null) {
                                attrValueType.setOriginalValue(this.vn.toString(i + 1));
                            } else {
                                attrValueType.setOriginalValue("");
                            }
                            rval.add(attrValueType);
                        } else if (this.vn.getAttrCount() > 0) {
                            if (this.vn.getText() > -1) {
                                attrValueType.setOriginalValue(this.vn.toString(this.vn.getText()));
                            } else {
                                attrValueType.setOriginalValue("");
                            }
                            rval.add(attrValueType);
                        }
                        ++counter;
                        continue;
                    }
                    if (counter != 0) continue;
                    attrValueType.setOriginalValue("");
                    rval.add(attrValueType);
                } while (i != -1);
                apExpression.resetXPath();
            }
            this.ap.resetXPath();
        }
        catch (NavException | XPathEvalException | XPathParseException e) {
            throw new XPathHelperVTDException(e);
        }
        return rval;
    }

    @Override
    public AttributeValueType getIIValue(String rootExpr, String extensionExpr, String separator) throws XPathHelperVTDException {
        AttributeValueType attrValueType = new AttributeValueType();
        String root = "";
        String rootValue = this.getCode(rootExpr);
        String extensionValue = this.getCode(extensionExpr);
        if (extensionValue != null && extensionValue.length() > 0) {
            attrValueType.setOriginalValue(root + separator + extensionValue);
        } else {
            attrValueType.setOriginalValue(rootValue);
        }
        attrValueType.setOriginalFirstValue(rootValue);
        attrValueType.setOriginalSecondValue(extensionValue);
        return attrValueType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public AttributeValueType getIIValue(String expression, String separator) throws XPathHelperVTDException {
        StringBuilder valueBuff = new StringBuilder();
        AttributeValueType attrValueType = new AttributeValueType();
        String expressionRoot = "@root";
        String expressionExtension = "@extension";
        try {
            AutoPilot apRoot = new AutoPilot();
            AutoPilot apExtension = new AutoPilot();
            this.ap.selectXPath(expression);
            apRoot.selectXPath(expressionRoot);
            apExtension.selectXPath(expressionExtension);
            apRoot.bind(this.vn);
            apExtension.bind(this.vn);
            if (this.ap.evalXPath() != -1) {
                String root = apRoot.evalXPathToString();
                String extension = apExtension.evalXPathToString();
                if (extension.length() > 0) {
                    if (root == null || root.length() <= 0) throw new XPathHelperVTDException(II_NO_ROOT_ERRORMESSAGE + expression);
                    valueBuff.append(root).append(separator).append(extension);
                } else {
                    valueBuff.append(root);
                }
                attrValueType.setOriginalFirstValue(root);
                attrValueType.setOriginalSecondValue(extension);
                attrValueType.setOriginalValue(valueBuff.toString());
            }
            this.ap.resetXPath();
            return attrValueType;
        }
        catch (NavException | XPathEvalException | XPathParseException e) {
            throw new XPathHelperVTDException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<AttributeObjectValue> getValueObjectsFromNodeListInclEmpty(String rootPath, List<ObjectRelativeXpath> expressionList) throws XPathHelperVTDException {
        ArrayList<AttributeObjectValue> rval = new ArrayList<AttributeObjectValue>();
        try {
            this.ap.selectXPath(rootPath);
            AutoPilot apExpression = new AutoPilot();
            HashMap<String, ObjectValueType> valueMap = null;
            AttributeObjectValue objectValue = null;
            AttributeValueType attributeValue = null;
            ObjectValueType value = null;
            String separator = null;
            String code = null;
            String codeSystem = null;
            String root = null;
            String extension = null;
            StringBuilder retValue = null;
            AutoPilot apExpressionRoot = null;
            AutoPilot apExpressionExtension = null;
            AutoPilot apCode = null;
            AutoPilot apCodeSystem = null;
            while (this.ap.evalXPath() != -1) {
                this.vn.push();
                objectValue = new AttributeObjectValue();
                valueMap = new HashMap<String, ObjectValueType>();
                for (ObjectRelativeXpath expression : expressionList) {
                    value = new ObjectValueType();
                    value.setXpath(rootPath + " " + expression.getValue());
                    value.setType(expression.getType());
                    if (expression.getMinLength() != null) {
                        value.setMinLength(expression.getMinLength());
                    }
                    if (expression.getMaxLength() != null) {
                        value.setMaxLength(expression.getMaxLength());
                    }
                    int i = 0;
                    int counter = 0;
                    apExpression.selectXPath(expression.getValue());
                    apExpression.bind(this.vn);
                    separator = ".";
                    if (expression.getSeparator() != null) {
                        separator = expression.getSeparator();
                    }
                    do {
                        i = apExpression.evalXPath();
                        attributeValue = new AttributeValueType();
                        if (i >= 0) {
                            switch (expression.getType()) {
                                case "S": 
                                case "T": 
                                case "BL": {
                                    int startToken = this.vn.getTokenType(i);
                                    int endToken = this.vn.getTokenType(i + 1);
                                    if (!(startToken != 0 && startToken != 2 || endToken != 4 && endToken != 11 && endToken != 5)) {
                                        attributeValue.setOriginalValue(this.vn.toString(i + 1));
                                        value.getValueList().add(attributeValue);
                                    } else if (this.vn.getAttrCount() > 0) {
                                        if (this.vn.getText() > -1) {
                                            attributeValue.setOriginalValue(this.vn.toString(this.vn.getText()));
                                        } else {
                                            attributeValue.setOriginalValue("");
                                        }
                                        value.getValueList().add(attributeValue);
                                    }
                                    ++counter;
                                    break;
                                }
                                case "II": {
                                    apExpressionRoot = new AutoPilot();
                                    apExpressionRoot.selectXPath("@root");
                                    apExpressionExtension = new AutoPilot();
                                    apExpressionExtension.selectXPath("@extension");
                                    apExpressionRoot.bind(this.vn);
                                    apExpressionExtension.bind(this.vn);
                                    root = apExpressionRoot.evalXPathToString();
                                    extension = apExpressionExtension.evalXPathToString();
                                    retValue = new StringBuilder();
                                    if (extension != null && extension.length() > 0) {
                                        if (root == null || root.length() <= 0) throw new XPathHelperVTDException(II_NO_ROOT_ERRORMESSAGE + rootPath + " " + expression.getValue());
                                        retValue.append(root).append(separator).append(extension);
                                    } else {
                                        retValue.append(root);
                                    }
                                    attributeValue.setOriginalValue(retValue.toString());
                                    attributeValue.setOriginalFirstValue(root);
                                    attributeValue.setOriginalSecondValue(extension);
                                    ++counter;
                                    value.getValueList().add(attributeValue);
                                    break;
                                }
                                case "CV": {
                                    separator = "!";
                                    if (expression.getSeparator() != null) {
                                        separator = expression.getSeparator();
                                    }
                                    apCode = new AutoPilot();
                                    apCodeSystem = new AutoPilot();
                                    apCode.selectXPath("@code");
                                    apCodeSystem.selectXPath("@codeSystem");
                                    apCode.bind(this.vn);
                                    apCodeSystem.bind(this.vn);
                                    code = apCode.evalXPathToString();
                                    codeSystem = apCodeSystem.evalXPathToString();
                                    retValue = new StringBuilder();
                                    if (code != null && code.length() > 0 && codeSystem != null && codeSystem.length() > 0) {
                                        retValue.append(codeSystem).append(separator).append(code);
                                    }
                                    ++counter;
                                    attributeValue.setOriginalValue(retValue.toString());
                                    attributeValue.setOriginalFirstValue(code);
                                    attributeValue.setOriginalSecondValue(codeSystem);
                                    value.getValueList().add(attributeValue);
                                    break;
                                }
                                default: {
                                    throw new XPathHelperVTDException(UNKNOWN_ATTRIBUTETYPE);
                                }
                            }
                            continue;
                        }
                        if (counter != 0) continue;
                        attributeValue.setOriginalValue("");
                        value.getValueList().add(attributeValue);
                    } while (i != -1);
                    valueMap.put(expression.getKey(), value);
                    apExpression.resetXPath();
                }
                this.vn.pop();
                objectValue.setValues(valueMap);
                rval.add(objectValue);
            }
            this.ap.resetXPath();
            return rval;
        }
        catch (NavException | XPathEvalException | XPathParseException e) {
            throw new XPathHelperVTDException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<AttributeObjectValue> getValueObjectsFromNode(String rootPath, List<ObjectRelativeXpath> expressionList) throws XPathHelperVTDException {
        ArrayList<AttributeObjectValue> rval = new ArrayList<AttributeObjectValue>();
        try {
            this.ap.selectXPath(rootPath);
            AutoPilot apExpression = new AutoPilot();
            HashMap<String, ObjectValueType> valueMap = null;
            AttributeObjectValue objectValue = null;
            AttributeValueType attributeValue = null;
            ObjectValueType value = null;
            String separator = null;
            String code = null;
            String codeSystem = null;
            String root = null;
            String extension = null;
            StringBuilder retValue = null;
            AutoPilot apExpressionRoot = null;
            AutoPilot apExpressionExtension = null;
            AutoPilot apCode = null;
            AutoPilot apCodeSystem = null;
            if (this.ap.evalXPath() != -1) {
                this.vn.push();
                objectValue = new AttributeObjectValue();
                valueMap = new HashMap<String, ObjectValueType>();
                for (ObjectRelativeXpath expression : expressionList) {
                    value = new ObjectValueType();
                    value.setXpath(rootPath + " " + expression.getValue());
                    value.setType(expression.getType());
                    if (expression.getMinLength() != null) {
                        value.setMinLength(expression.getMinLength());
                    }
                    if (expression.getMaxLength() != null) {
                        value.setMaxLength(expression.getMaxLength());
                    }
                    int i = 0;
                    int counter = 0;
                    apExpression.selectXPath(expression.getValue());
                    apExpression.bind(this.vn);
                    separator = ".";
                    if (expression.getSeparator() != null) {
                        separator = expression.getSeparator();
                    }
                    do {
                        i = apExpression.evalXPath();
                        attributeValue = new AttributeValueType();
                        if (i >= 0) {
                            switch (expression.getType()) {
                                case "S": 
                                case "T": 
                                case "BL": {
                                    int startToken = this.vn.getTokenType(i);
                                    int endToken = this.vn.getTokenType(i + 1);
                                    if (!(startToken != 0 && startToken != 2 || endToken != 4 && endToken != 11 && endToken != 5)) {
                                        attributeValue.setOriginalValue(this.vn.toString(i + 1));
                                        value.getValueList().add(attributeValue);
                                    } else if (this.vn.getAttrCount() > 0) {
                                        attributeValue.setOriginalValue(this.vn.toString(this.vn.getText()));
                                        value.getValueList().add(attributeValue);
                                    }
                                    ++counter;
                                    break;
                                }
                                case "II": {
                                    apExpressionRoot = new AutoPilot();
                                    apExpressionRoot.selectXPath("@root");
                                    apExpressionExtension = new AutoPilot();
                                    apExpressionExtension.selectXPath("@extension");
                                    apExpressionRoot.bind(this.vn);
                                    apExpressionExtension.bind(this.vn);
                                    root = apExpressionRoot.evalXPathToString();
                                    extension = apExpressionExtension.evalXPathToString();
                                    retValue = new StringBuilder();
                                    if (extension != null && extension.length() > 0) {
                                        if (root == null || root.length() <= 0) throw new XPathHelperVTDException(II_NO_ROOT_ERRORMESSAGE + rootPath + " " + expression.getValue());
                                        retValue.append(root).append(separator).append(extension);
                                    } else {
                                        retValue.append(root);
                                    }
                                    attributeValue.setOriginalValue(retValue.toString());
                                    attributeValue.setOriginalFirstValue(root);
                                    attributeValue.setOriginalSecondValue(extension);
                                    ++counter;
                                    value.getValueList().add(attributeValue);
                                    break;
                                }
                                case "CV": {
                                    separator = "!";
                                    if (expression.getSeparator() != null) {
                                        separator = expression.getSeparator();
                                    }
                                    apCode = new AutoPilot();
                                    apCodeSystem = new AutoPilot();
                                    apCode.selectXPath("@code");
                                    apCodeSystem.selectXPath("@codeSystem");
                                    apCode.bind(this.vn);
                                    apCodeSystem.bind(this.vn);
                                    code = apCode.evalXPathToString();
                                    codeSystem = apCodeSystem.evalXPathToString();
                                    retValue = new StringBuilder();
                                    if (code != null && code.length() > 0 && codeSystem != null && codeSystem.length() > 0) {
                                        retValue.append(codeSystem).append(separator).append(code);
                                    }
                                    ++counter;
                                    attributeValue.setOriginalValue(retValue.toString());
                                    attributeValue.setOriginalFirstValue(code);
                                    attributeValue.setOriginalSecondValue(codeSystem);
                                    value.getValueList().add(attributeValue);
                                    break;
                                }
                                default: {
                                    throw new XPathHelperVTDException(UNKNOWN_ATTRIBUTETYPE);
                                }
                            }
                            continue;
                        }
                        if (counter != 0) continue;
                        attributeValue.setOriginalValue("");
                        value.getValueList().add(attributeValue);
                    } while (i != -1);
                    valueMap.put(expression.getKey(), value);
                    apExpression.resetXPath();
                }
                this.vn.pop();
                objectValue.setValues(valueMap);
                rval.add(objectValue);
            }
            this.ap.resetXPath();
            return rval;
        }
        catch (NavException | XPathEvalException | XPathParseException e) {
            throw new XPathHelperVTDException(e);
        }
    }

    @Override
    public String getPartOfStructure(String expression, String elementName) throws XPathHelperVTDException {
        String retVal = null;
        try {
            this.ap.selectXPath(expression);
            if (this.ap.evalXPath() != -1) {
                XMLModifier xm = new XMLModifier(this.vn);
                this.vn.toElement(2, elementName);
                long l = this.vn.getContentFragment();
                xm.remove(l);
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                xm.output((OutputStream)os);
                retVal = new String(os.toByteArray());
            }
            this.ap.resetXPath();
        }
        catch (ModifyException | NavException | TranscodeException | XPathEvalException | XPathParseException | IOException e) {
            throw new XPathHelperVTDException(e);
        }
        return retVal;
    }

    @Override
    public String getPartOfStructure(List<RemoveProcessingInstruction> removeProcessingInstructionList) throws XPathHelperVTDException {
        String retVal = null;
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            XMLModifier xm = null;
            boolean elementRemoved = false;
            for (RemoveProcessingInstruction procIns : removeProcessingInstructionList) {
                this.ap.selectXPath(procIns.getExpression());
                if (this.ap.evalXPath() == -1) continue;
                xm = new XMLModifier(this.vn);
                this.vn.toElement(2, procIns.getElementName());
                if (procIns.isRemoveElement()) {
                    xm.remove();
                } else {
                    xm.remove(this.vn.getContentFragment());
                }
                this.vn = xm.outputAndReparse();
                this.ap.bind(this.vn);
                elementRemoved = true;
            }
            if (elementRemoved) {
                xm.output((OutputStream)os);
            } else {
                this.vn.dumpXML((OutputStream)os);
            }
            retVal = new String(os.toByteArray());
            this.ap.resetXPath();
        }
        catch (ModifyException | NavException | ParseException | TranscodeException | XPathEvalException | XPathParseException | IOException e) {
            throw new XPathHelperVTDException(e);
        }
        return retVal;
    }

    @Override
    public String updateAttribute(List<UpdateProcessingInstruction> updateProcessingInstructionList) throws XPathHelperVTDException {
        String retVal = null;
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            XMLModifier xm = null;
            boolean elementUpdated = false;
            for (UpdateProcessingInstruction procIns : updateProcessingInstructionList) {
                this.ap.selectXPath(procIns.getExpression());
                if (this.ap.evalXPath() == -1) continue;
                xm = new XMLModifier(this.vn);
                int i = this.vn.getAttrVal(procIns.getAttributeName());
                if (i == -1) continue;
                xm.updateToken(i, procIns.getValueToSet());
                elementUpdated = true;
                this.vn = xm.outputAndReparse();
                this.ap.bind(this.vn);
            }
            if (elementUpdated) {
                xm.output((OutputStream)os);
            } else {
                this.vn.dumpXML((OutputStream)os);
            }
            retVal = new String(os.toByteArray());
            this.ap.resetXPath();
        }
        catch (ModifyException | NavException | ParseException | TranscodeException | XPathEvalException | XPathParseException | IOException e) {
            throw new XPathHelperVTDException(e);
        }
        return retVal;
    }

    @Override
    public String insertElement(List<InsertProcessingInstruction> insertProcessingInstructionList) throws XPathHelperVTDException {
        String retVal = null;
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            XMLModifier xm = null;
            boolean elementInserted = false;
            for (InsertProcessingInstruction procIns : insertProcessingInstructionList) {
                this.ap.selectXPath(procIns.getExpression());
                if (this.ap.evalXPath() == -1) continue;
                xm = new XMLModifier(this.vn);
                if (procIns.isInsertBefore()) {
                    xm.insertBeforeElement(procIns.getElementValue());
                } else {
                    xm.insertAfterElement(procIns.getElementValue());
                }
                elementInserted = true;
                this.vn = xm.outputAndReparse();
                this.ap.bind(this.vn);
            }
            if (elementInserted) {
                xm.output((OutputStream)os);
            } else {
                this.vn.dumpXML((OutputStream)os);
            }
            retVal = new String(os.toByteArray());
            this.ap.resetXPath();
        }
        catch (ModifyException | NavException | ParseException | TranscodeException | XPathEvalException | XPathParseException | IOException e) {
            throw new XPathHelperVTDException(e);
        }
        return retVal;
    }
}

