/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware;

import java.io.IOException;
import java.io.OutputStream;

public class XMLByteOutputStream
extends OutputStream {
    private byte[] XMLDoc;
    private int offset = 0;

    public final byte[] getXML() {
        return this.XMLDoc;
    }

    @Override
    public void write(int b) throws IOException {
        this.XMLDoc[this.offset] = (byte)b;
        ++this.offset;
    }

    @Override
    public void write(byte[] ba) throws IOException {
        if (ba.length + this.offset > this.XMLDoc.length) {
            throw new IOException("XMLDoc size exceeds maximum size");
        }
        System.arraycopy(ba, 0, this.XMLDoc, this.offset, ba.length);
        this.offset += ba.length;
    }

    @Override
    public void write(byte[] ba, int os, int len) throws IOException {
        if (len + this.offset > this.XMLDoc.length) {
            throw new IOException("XMLDoc size exceeds maximum size");
        }
        System.arraycopy(ba, os, this.XMLDoc, this.offset, len);
        this.offset += len;
    }

    @Override
    public void close() {
        this.offset = 0;
    }

    public XMLByteOutputStream(int size) {
        this.XMLDoc = new byte[size];
        this.offset = 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.XMLDoc.length);
        for (int i = 0; i < this.XMLDoc.length; ++i) {
            sb.append((char)this.XMLDoc[i]);
        }
        return sb.toString();
    }
}

