/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.extended;

import com.ximpleware.extended.NavExceptionHuge;
import com.ximpleware.extended.PilotExceptionHuge;
import com.ximpleware.extended.VTDNavHuge;
import com.ximpleware.extended.XPathEvalExceptionHuge;
import com.ximpleware.extended.XPathParseExceptionHuge;
import com.ximpleware.extended.xpath.Expr;
import com.ximpleware.extended.xpath.parser;
import java.io.StringReader;
import java.util.Hashtable;

public class AutoPilotHuge {
    private int depth;
    private int iter_type;
    private VTDNavHuge vn;
    private int index;
    private boolean ft;
    private boolean special;
    private String name;
    private String localName;
    private String URL;
    private int size;
    private Expr xpe;
    private int[] contextCopy;
    private int stackSize;
    private static Hashtable nsHash;
    public static final int UNDEFINED = 0;
    public static final int SIMPLE = 1;
    public static final int SIMPLE_NS = 2;
    public static final int DESCENDANT = 3;
    public static final int DESCENDANT_NS = 4;
    public static final int FOLLOWING = 5;
    public static final int FOLLOWING_NS = 6;
    public static final int PRECEDING = 7;
    public static final int PRECEDING_NS = 8;
    public static final int ATTR = 9;
    public static final int ATTR_NS = 10;
    private static Hashtable symbolHash;

    protected String getName() {
        return this.name;
    }

    public AutoPilotHuge(VTDNavHuge v) {
        if (v == null) {
            throw new IllegalArgumentException(" instance of VTDNav can't be null ");
        }
        this.name = null;
        this.vn = v;
        this.iter_type = 0;
        this.ft = true;
        this.size = 0;
        this.special = false;
        this.xpe = null;
        symbolHash = new Hashtable();
    }

    public AutoPilotHuge() {
        this.name = null;
        this.iter_type = 0;
        this.ft = true;
        this.size = 0;
        this.special = false;
        this.xpe = null;
        symbolHash = new Hashtable();
    }

    public void declareXPathNameSpace(String prefix, String URL2) {
        if (nsHash == null) {
            nsHash = new Hashtable();
        }
        nsHash.put(prefix, URL2);
    }

    public void bind(VTDNavHuge vnv) {
        this.name = null;
        if (vnv == null) {
            throw new IllegalArgumentException(" instance of VTDNav can't be null ");
        }
        this.vn = vnv;
        this.iter_type = 0;
        this.ft = true;
        this.size = 0;
        this.special = false;
    }

    public void declareVariableExpr(String varName, String varExpr) throws XPathParseExceptionHuge {
        try {
            parser p = new parser(new StringReader(varExpr));
            p.nsHash = nsHash;
            p.symbolHash = symbolHash;
            this.xpe = (Expr)p.parse().value;
            symbolHash.put(varName, this.xpe);
            this.ft = true;
        }
        catch (XPathParseExceptionHuge e) {
            System.out.println("Syntax error after  ==>" + varExpr.substring(0, e.getOffset()));
            throw e;
        }
        catch (Exception e) {
            throw new XPathParseExceptionHuge("Error occurred");
        }
    }

    public boolean iterate() throws PilotExceptionHuge, NavExceptionHuge {
        switch (this.iter_type) {
            case 1: {
                if (this.vn.atTerminal) {
                    return false;
                }
                if (!this.ft) {
                    return this.vn.iterate(this.depth, this.name, this.special);
                }
                this.ft = false;
                if (this.special || this.vn.matchElement(this.name)) {
                    return true;
                }
                return this.vn.iterate(this.depth, this.name, this.special);
            }
            case 2: {
                if (this.vn.atTerminal) {
                    return false;
                }
                if (!this.ft) {
                    return this.vn.iterateNS(this.depth, this.URL, this.localName);
                }
                this.ft = false;
                if (this.vn.matchElementNS(this.URL, this.localName)) {
                    return true;
                }
                return this.vn.iterateNS(this.depth, this.URL, this.localName);
            }
            case 3: {
                if (this.vn.atTerminal) {
                    return false;
                }
                return this.vn.iterate(this.depth, this.name, this.special);
            }
            case 4: {
                if (this.vn.atTerminal) {
                    return false;
                }
                return this.vn.iterateNS(this.depth, this.URL, this.localName);
            }
            case 5: {
                if (this.vn.atTerminal) {
                    return false;
                }
                if (!this.ft) {
                    return this.vn.iterate_following(this.name, this.special);
                }
                this.ft = false;
                do {
                    if (!this.vn.toElement(4)) continue;
                    if (this.special || this.vn.matchElement(this.name)) {
                        return true;
                    }
                    return this.vn.iterate_following(this.name, this.special);
                } while (this.vn.toElement(1));
                return false;
            }
            case 6: {
                if (this.vn.atTerminal) {
                    return false;
                }
                if (!this.ft) {
                    return this.vn.iterate_followingNS(this.URL, this.localName);
                }
                this.ft = false;
                do {
                    if (!this.vn.toElement(4)) continue;
                    if (this.vn.matchElementNS(this.URL, this.localName)) {
                        return true;
                    }
                    return this.vn.iterate_followingNS(this.URL, this.localName);
                } while (this.vn.toElement(1));
                return false;
            }
            case 7: {
                if (this.vn.atTerminal) {
                    return false;
                }
                return this.vn.iterate_preceding(this.name, this.contextCopy, this.special);
            }
            case 8: {
                if (this.vn.atTerminal) {
                    return false;
                }
                return this.vn.iterate_precedingNS(this.URL, this.localName, this.contextCopy);
            }
        }
        throw new PilotExceptionHuge(" iteration action type undefined");
    }

    protected int iterateAttr() throws PilotExceptionHuge, NavExceptionHuge {
        switch (this.iter_type) {
            case 9: {
                if (this.name.compareTo("*") == 0) {
                    if (this.ft) {
                        this.ft = false;
                        this.index = this.vn.getCurrentIndex2() + 1;
                    } else {
                        this.index += 2;
                    }
                    if (!this.vn.ns) {
                        if (this.index < this.size) {
                            int type = this.vn.getTokenType(this.index);
                            if (type == 2 || type == 3) {
                                this.vn.LN = this.index;
                                return this.index;
                            }
                            return -1;
                        }
                        return -1;
                    }
                    while (this.index < this.size) {
                        int type = this.vn.getTokenType(this.index);
                        if (type == 2 || type == 3) {
                            if (type == 2) {
                                this.vn.LN = this.index;
                                return this.index;
                            }
                            this.index += 2;
                            continue;
                        }
                        return -1;
                    }
                    return -1;
                }
                if (!this.ft) {
                    return -1;
                }
                this.ft = false;
                int i = this.vn.getAttrVal(this.name);
                if (i != -1) {
                    this.vn.LN = i - 1;
                    return i - 1;
                }
                return -1;
            }
            case 10: {
                if (!this.ft) {
                    return -1;
                }
                this.ft = false;
                int i = this.vn.getAttrValNS(this.URL, this.localName);
                if (i != -1) {
                    this.vn.LN = i - 1;
                    return i - 1;
                }
                return -1;
            }
        }
        throw new PilotExceptionHuge("invalid iteration type");
    }

    public void selectElement(String en) {
        if (en == null) {
            throw new IllegalArgumentException("element name can't be null");
        }
        this.iter_type = 1;
        this.depth = this.vn.getCurrentDepth();
        this.name = en;
        this.ft = true;
    }

    public void selectElementNS(String ns_URL, String ln) {
        if (ln == null) {
            throw new IllegalArgumentException("local name can't be null");
        }
        this.iter_type = 2;
        this.depth = this.vn.getCurrentDepth();
        this.localName = ln;
        this.URL = ns_URL;
        this.ft = true;
    }

    protected void selectElement_D(String en) {
        if (en == null) {
            throw new IllegalArgumentException("element name can't be null");
        }
        this.iter_type = 3;
        this.depth = this.vn.getCurrentDepth();
        this.name = en;
        this.ft = true;
    }

    protected void selectElementNS_D(String ns_URL, String ln) {
        if (ln == null) {
            throw new IllegalArgumentException("local name can't be null");
        }
        this.iter_type = 4;
        this.depth = this.vn.getCurrentDepth();
        this.localName = ln;
        this.URL = ns_URL;
        this.ft = true;
    }

    protected void selectElement_F(String en) {
        if (en == null) {
            throw new IllegalArgumentException("element name can't be null");
        }
        this.iter_type = 5;
        this.ft = true;
        this.name = en;
    }

    protected void selectElementNS_F(String ns_URL, String ln) {
        if (ln == null) {
            throw new IllegalArgumentException("local name can't be null");
        }
        this.iter_type = 6;
        this.ft = true;
        this.localName = ln;
        this.URL = ns_URL;
    }

    protected void selectElement_P(String en) {
        if (en == null) {
            throw new IllegalArgumentException("element name can't be null");
        }
        this.depth = this.vn.getCurrentDepth();
        this.iter_type = 7;
        this.ft = true;
        this.name = en;
        this.contextCopy = (int[])this.vn.context.clone();
        for (int i = this.vn.context[0] + 1; i < this.vn.context.length; ++i) {
            this.contextCopy[i] = -1;
        }
        this.contextCopy[0] = this.vn.rootIndex;
    }

    protected void selectElementNS_P(String ns_URL, String ln) {
        if (ln == null) {
            throw new IllegalArgumentException("local name can't be null");
        }
        this.depth = this.vn.getCurrentDepth();
        this.iter_type = 8;
        this.ft = true;
        this.localName = ln;
        this.URL = ns_URL;
        this.contextCopy = (int[])this.vn.context.clone();
        for (int i = this.vn.context[0] + 1; i < this.vn.context.length; ++i) {
            this.vn.context[i] = -1;
        }
        this.contextCopy[0] = this.vn.rootIndex;
    }

    protected void selectAttr(String en) {
        if (en == null) {
            throw new IllegalArgumentException("attribute name can't be null");
        }
        this.iter_type = 9;
        this.ft = true;
        this.size = this.vn.getTokenCount();
        this.name = en;
    }

    protected void selectAttrNS(String ns_URL, String ln) {
        if (ln == null) {
            throw new IllegalArgumentException("local name of an attribute can't be null");
        }
        this.iter_type = 10;
        this.ft = true;
        this.localName = ln;
        this.URL = ns_URL;
    }

    public void selectXPath(String s) throws XPathParseExceptionHuge {
        try {
            parser p = new parser(new StringReader(s));
            p.nsHash = nsHash;
            p.symbolHash = symbolHash;
            this.xpe = (Expr)p.parse().value;
            this.ft = true;
        }
        catch (XPathParseExceptionHuge e) {
            System.out.println("Syntax error after  ==>" + s.substring(0, e.getOffset()));
            throw e;
        }
        catch (Exception e) {
            throw new XPathParseExceptionHuge("Error occurred");
        }
    }

    public void resetXPath() {
        if (this.xpe != null && this.vn != null) {
            this.xpe.reset(this.vn);
            this.ft = true;
            this.vn.contextStack2.size = this.stackSize;
        }
    }

    public double evalXPathToNumber() {
        return this.xpe.evalNumber(this.vn);
    }

    public String evalXPathToString() {
        return this.xpe.evalString(this.vn);
    }

    public boolean evalXPathToBoolean() {
        return this.xpe.evalBoolean(this.vn);
    }

    public int evalXPath() throws XPathEvalExceptionHuge, NavExceptionHuge {
        if (this.xpe != null) {
            if (this.ft) {
                if (this.vn != null) {
                    this.stackSize = this.vn.contextStack2.size;
                }
                this.ft = false;
                this.xpe.adjust(this.vn.getTokenCount());
            }
            return this.xpe.evalNodeSet(this.vn);
        }
        throw new PilotExceptionHuge(" Null XPath expression ");
    }

    protected void setSpecial(boolean b) {
        this.special = b;
    }

    public String getExprString() {
        return this.xpe.toString();
    }

    public void clearVariableExprs() {
        symbolHash.clear();
    }

    public void clearXPathNameSpaces() {
        nsHash.clear();
    }
}

