/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.olddocuments;

import fi.kanta.arkistopalvelu.olddocuments.logging.DbLogger;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DbTestErrorChecker {
    public static void main(String[] args) {
        String expectedErrorsFilePath = "";
        expectedErrorsFilePath = "../olddocumentsloader-resources/resources/expected_test_error_results.txt";
        DbLogger logger = new DbLogger();
        boolean createdTables = false;
        if (!logger.tarkistaTaulut()) {
            System.out.println("Tietokanta tauluja ei l\u00f6ydy, ei ole tarkistettavaa...");
            System.exit(-1);
        }
        ArrayList<String> virheetTiedostosta = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new FileReader(expectedErrorsFilePath));){
            String line;
            while ((line = br.readLine()) != null) {
                String[] fields = line.split("\\t");
                if (fields.length != 4) {
                    throw new IllegalArgumentException("invalid row: " + line);
                }
                String oid = fields[0];
                virheetTiedostosta.add(oid);
                String code = fields[2];
                List<Object> codeList = new ArrayList();
                if (code.contains(",")) {
                    codeList = Arrays.asList(code.split(","));
                } else {
                    codeList = new ArrayList();
                    codeList.add(code);
                }
                String explanation = fields[3];
                if (code.equals("-") && logger.onkoVirheArkistoitu(oid, codeList)) {
                    System.out.println("Odottamaton virhe:");
                    logger.tulostaVirheet(oid);
                }
                System.out.println(codeList);
                if (codeList.isEmpty() || codeList.contains("-") || logger.onkoVirheArkistoitu(oid, codeList)) continue;
                System.out.println("Error with oid = " + oid + " and code = " + code + " not found... Expected the following: '" + explanation + "'");
                logger.tulostaVirheet(oid);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
        }
        List<String> virheet = logger.haeVirheellisetOidit();
        for (String virheoid : virheet) {
            if (virheetTiedostosta.contains(virheoid)) continue;
            System.out.println("Ylim\u00e4\u00e4r\u00e4inen virhe oid:issa :" + virheoid);
        }
        if (createdTables && logger.tarkistaTaulut()) {
            System.out.println("Poistetaan testausta varten luodut taulut...");
            logger.dropTables();
        }
    }
}

