/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.olddocuments.logging;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import fi.kanta.arkistopalvelu.olddocuments.logging.SQLLogger;
import fi.kanta.arkistopalvelu.olddocuments.utils.ConsoleWriter;
import fi.kanta.arkistopalvelu.olddocuments.utils.PropertyHandler;
import fi.kanta.common.exception.PropertyException;
import fi.kanta.common.util.InternalServiceError;
import java.beans.PropertyVetoException;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class DbLogger {
    private static Logger log4j = Logger.getLogger(DbLogger.class);
    private static ComboPooledDataSource cpds;

    private void closeConnection(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e) {
                log4j.error((Object)"Virhe yhteyden sulkemisessa", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sammuta() {
        Statement st = null;
        Connection con = null;
        try {
            con = cpds.getConnection();
            st = con.createStatement();
            st.executeUpdate("shutdown");
            this.close(st);
            this.closeConnection(con);
        }
        catch (SQLException e) {
            try {
                this.handleError(e);
                this.close(st);
                this.closeConnection(con);
            }
            catch (Throwable throwable) {
                this.close(st);
                this.closeConnection(con);
                throw throwable;
            }
        }
    }

    public void kirjaaVirhe(String cdaId, String errorcode, String errorMessage, File cdafilepath) {
        InternalServiceError ise = new InternalServiceError();
        ise.setErrorCode(errorcode);
        ise.setErrorMessage(errorMessage);
        ArrayList<InternalServiceError> errorlist = new ArrayList<InternalServiceError>();
        errorlist.add(ise);
        this.kirjaaVirhe(cdaId, errorlist, cdafilepath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kirjaaVirhe(String cdaId, List<InternalServiceError> combinedlist, File cdafilepath) {
        String absolutePath = cdafilepath.getAbsolutePath();
        String sql = "insert into asiakirja (cda_id, tila, tiedostopolku) values (?, ?, ?)";
        PreparedStatement st = null;
        PreparedStatement sterror = null;
        Connection con = null;
        this.poistaVirheet(cdaId);
        try {
            con = cpds.getConnection();
            if (!this.onkoCdaIdLogissa(cdaId)) {
                st = con.prepareStatement(sql);
                st.setString(1, cdaId);
                st.setString(2, "ERROR");
                st.setString(3, absolutePath);
                st.executeUpdate();
                con.commit();
                SQLLogger logger = SQLLogger.getInstance();
                logger.logEntry(sql, cdaId, "ERROR", absolutePath);
            }
            for (InternalServiceError ise : combinedlist) {
                String kuvaus = ise.getErrorMessage() != null ? ise.getErrorMessage() : "NA";
                String tarkkakuvaus = ise.getErrorDescription() != null ? ise.getErrorDescription() : "NA";
                String koodi = ise.getErrorCode() != null ? ise.getErrorCode() : "NA";
                String sqlerror = "insert into virhetaulu (cda_id, kuvaus, tarkkakuvaus, koodi, korjattu) values (?, ?, ?, ?, ?);";
                sterror = con.prepareStatement(sqlerror);
                sterror.setString(1, cdaId);
                sterror.setString(2, kuvaus);
                sterror.setString(3, tarkkakuvaus);
                sterror.setString(4, koodi);
                sterror.setString(5, "false");
                sterror.executeUpdate();
                con.commit();
                SQLLogger logger = SQLLogger.getInstance();
                logger.logEntry(sqlerror, cdaId, kuvaus, tarkkakuvaus, koodi, "true");
                sterror.close();
            }
            this.close(st);
            this.closeConnection(con);
        }
        catch (SQLException e) {
            this.handleError(e);
        }
        finally {
            this.close(st);
            this.closeConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearErrors(String logId) {
        PreparedStatement st = null;
        Connection con = null;
        String sql = "update virhetaulu set korjattu = ? where cda_id = ?";
        try {
            con = cpds.getConnection();
            st = con.prepareStatement(sql);
            st.setString(1, "true");
            st.setString(2, logId);
            st.executeUpdate();
            con.commit();
            SQLLogger logger = SQLLogger.getInstance();
            logger.logEntry(sql, "true", logId);
            this.close(st);
            this.closeConnection(con);
        }
        catch (SQLException e) {
            try {
                this.handleError(e);
                this.close(st);
                this.closeConnection(con);
            }
            catch (Throwable throwable) {
                this.close(st);
                this.closeConnection(con);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void poistaVirheet(String logId) {
        PreparedStatement st = null;
        Connection con = null;
        try {
            con = cpds.getConnection();
            String sql = "delete from virhetaulu where cda_id = ?";
            st = con.prepareStatement(sql);
            st.setString(1, logId);
            st.executeUpdate();
            con.commit();
            SQLLogger logger = SQLLogger.getInstance();
            logger.logEntry(sql, logId);
            this.close(st);
            this.closeConnection(con);
        }
        catch (SQLException e) {
            try {
                this.handleError(e);
                this.close(st);
                this.closeConnection(con);
            }
            catch (Throwable throwable) {
                this.close(st);
                this.closeConnection(con);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean onkoCdaIdLogissa(String cdaId) {
        String sql = "select cda_id from asiakirja where cda_id = ?";
        PreparedStatement stmt = null;
        Connection con = null;
        ResultSet rs = null;
        int counter = 0;
        try {
            con = cpds.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, cdaId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                rs.getString(1);
                ++counter;
            }
            this.close(stmt);
            this.close(rs);
            this.closeConnection(con);
        }
        catch (SQLException e) {
            try {
                this.handleError(e);
                this.close(stmt);
                this.close(rs);
                this.closeConnection(con);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.close(rs);
                this.closeConnection(con);
                throw throwable;
            }
        }
        return counter > 0;
    }

    private void close(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                log4j.error((Object)"sql virhe", (Throwable)e);
            }
        }
    }

    private void close(Statement st) {
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e) {
                log4j.error((Object)"sql virhe", (Throwable)e);
            }
        }
    }

    public void logOK(String cdaid, File file) {
        this.clearErrors(cdaid);
        boolean vanharivionolemassa = this.tarkistaOnkoAsiakirjaTaulussaRivi(cdaid);
        if (vanharivionolemassa) {
            this.paivitaStatusTietoAsiakirjaTauluun(cdaid);
        } else {
            this.lisaaAsiakirjaRiviOK(cdaid, file);
        }
        log4j.info((Object)("cda arkistoitu ja ok: " + cdaid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lisaaAsiakirjaRiviOK(String cdaid, File file) {
        String absolutePath = file.getAbsolutePath();
        String sql = "insert into asiakirja (cda_id, tila, tiedostopolku) values (?, ?, ?)";
        PreparedStatement st = null;
        Connection con = null;
        try {
            con = cpds.getConnection();
            st = con.prepareStatement(sql);
            st.setString(1, cdaid);
            st.setString(2, "OK");
            st.setString(3, absolutePath);
            st.executeUpdate();
            con.commit();
            SQLLogger logger = SQLLogger.getInstance();
            logger.logEntry(sql, cdaid, "OK", absolutePath);
            this.close(st);
            this.closeConnection(con);
        }
        catch (SQLException e) {
            try {
                this.handleError(e);
                this.close(st);
                this.closeConnection(con);
            }
            catch (Throwable throwable) {
                this.close(st);
                this.closeConnection(con);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paivitaStatusTietoAsiakirjaTauluun(String cdaid) {
        String sql = "update asiakirja set tila = ? where cda_id = ?";
        PreparedStatement st = null;
        Connection con = null;
        try {
            con = cpds.getConnection();
            st = con.prepareStatement(sql);
            st.setString(1, "OK");
            st.setString(2, cdaid);
            st.executeUpdate();
            con.commit();
            SQLLogger logger = SQLLogger.getInstance();
            logger.logEntry(sql, "OK", cdaid);
            this.close(st);
            this.closeConnection(con);
        }
        catch (SQLException e) {
            try {
                this.handleError(e);
                this.close(st);
                this.closeConnection(con);
            }
            catch (Throwable throwable) {
                this.close(st);
                this.closeConnection(con);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tarkistaOnkoAsiakirjaTaulussaRivi(String cdaid) {
        PreparedStatement selectStatement = null;
        String sql = "select cda_id from asiakirja where cda_id = ?";
        Connection con = null;
        ResultSet rs = null;
        int counter = 0;
        try {
            con = cpds.getConnection();
            selectStatement = con.prepareStatement(sql);
            selectStatement.setString(1, cdaid);
            rs = selectStatement.executeQuery();
            while (rs.next()) {
                rs.getString(1);
                ++counter;
            }
            this.close(selectStatement);
            this.closeConnection(con);
            this.close(rs);
        }
        catch (SQLException e) {
            try {
                this.handleError(e);
                this.close(selectStatement);
                this.closeConnection(con);
                this.close(rs);
            }
            catch (Throwable throwable) {
                this.close(selectStatement);
                this.closeConnection(con);
                this.close(rs);
                throw throwable;
            }
        }
        return counter == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tarkistaTaulut() {
        String sql = "select table_name from information_schema.tables where table_type = 'BASE TABLE' and table_name in ('ASIAKIRJA', 'PALVELUTAPAHTUMA', 'VIRHETAULU', 'MANIFESTVIRHETAULU', 'HAKEMISTOTAULU', 'VIRHEHAKEMISTOTAULU');";
        PreparedStatement stmt = null;
        Connection con = null;
        ResultSet rs = null;
        int counter = 0;
        try {
            con = cpds.getConnection();
            stmt = con.prepareStatement(sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                ++counter;
            }
            this.close(stmt);
            this.closeConnection(con);
            this.close(rs);
        }
        catch (SQLException e) {
            try {
                this.handleError(e);
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
                throw throwable;
            }
        }
        return counter == 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tarkistaonkokantatyhja() {
        String sql = "select count(*) as cnt from asiakirja;";
        PreparedStatement stmt = null;
        Connection con = null;
        ResultSet rs = null;
        int count = 0;
        try {
            con = cpds.getConnection();
            stmt = con.prepareStatement(sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                count = rs.getInt(1);
            }
            this.close(stmt);
            this.closeConnection(con);
            this.close(rs);
        }
        catch (SQLException e) {
            try {
                this.handleError(e);
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
                throw throwable;
            }
        }
        return count == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void luoTaulut() {
        Statement stmt = null;
        Connection con = null;
        try {
            con = cpds.getConnection();
            stmt = con.createStatement();
            stmt.executeUpdate("create cached table ASIAKIRJA (cda_id varchar(128) not null, tila varchar(20) not null, tiedostopolku varchar(500), primary key (cda_id));");
            stmt.executeUpdate("create cached table PALVELUTAPAHTUMA (cda_id varchar(128) not null, asiakirjatarkistoitu varchar(5), primary key (cda_id));");
            stmt.executeUpdate("create cached table VIRHETAULU (cda_id varchar(128) not null, kuvaus varchar(500) not null, tarkkakuvaus varchar(500),koodi varchar(10) not null, korjattu varchar(5) default 'false');");
            stmt.executeUpdate("create cached table MANIFESTVIRHETAULU (tiedosto varchar(500) not null);");
            stmt.executeUpdate("create cached table HAKEMISTOTAULU (hakemisto varchar(500) not null, primary key (hakemisto));");
            stmt.executeUpdate("create cached table VIRHEHAKEMISTOTAULU (hakemisto varchar(500) not null, primary key (hakemisto));");
            this.close(stmt);
            this.closeConnection(con);
        }
        catch (SQLException e) {
            try {
                this.handleError(e);
                this.close(stmt);
                this.closeConnection(con);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asetaHakemistoSuoritetuksi(String dirPath) {
        this.poistaHakemistoVirhe(dirPath);
        String sql = "insert into hakemistotaulu (hakemisto) values (?);";
        PreparedStatement st = null;
        Connection con = null;
        try {
            con = cpds.getConnection();
            st = con.prepareStatement(sql);
            st.setString(1, dirPath);
            st.executeUpdate();
            con.commit();
            SQLLogger logger = SQLLogger.getInstance();
            logger.logEntry(sql, dirPath);
            this.close(st);
            this.closeConnection(con);
        }
        catch (SQLException e) {
            try {
                this.handleError(e);
                this.close(st);
                this.closeConnection(con);
            }
            catch (Throwable throwable) {
                this.close(st);
                this.closeConnection(con);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onkoPalvelutapahtumaArkistoitu(String id) {
        String sql = "select cda_id from palvelutapahtuma where cda_id = ? and asiakirjatarkistoitu = ?";
        PreparedStatement stmt = null;
        Connection con = null;
        ResultSet rs = null;
        int counter = 0;
        try {
            con = cpds.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, id);
            stmt.setBoolean(2, true);
            rs = stmt.executeQuery();
            while (rs.next()) {
                rs.getString(1);
                ++counter;
            }
            this.close(stmt);
            this.closeConnection(con);
            this.close(rs);
        }
        catch (SQLException e) {
            try {
                this.handleError(e);
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
                throw throwable;
            }
        }
        return counter == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onkoHoitoasiakirjaArkistoitu(String id) {
        String sql = "select * from asiakirja where cda_id = ? and tila = ?";
        PreparedStatement stmt = null;
        Connection con = null;
        ResultSet rs = null;
        int counter = 0;
        try {
            con = cpds.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, id);
            stmt.setString(2, "OK");
            rs = stmt.executeQuery();
            while (rs.next()) {
                rs.getString(1);
                ++counter;
            }
            this.close(stmt);
            this.closeConnection(con);
            this.close(rs);
        }
        catch (SQLException e) {
            try {
                this.handleError(e);
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
                throw throwable;
            }
        }
        return counter == 1;
    }

    public void logPalvelutapahtuma(String id, boolean asiakirjojentallennusonnistui) {
        boolean tallennettu = this.tarkistaOnkoPalvelutapahtumaTallennettu(id);
        this.tarkistaOnkoPTOsittainTallennettu(id);
        if (!tallennettu) {
            this.luoPalveluTapahtumaRivi(id, asiakirjojentallennusonnistui);
        }
        if (tallennettu) {
            this.paivitaPalvelutapahtuma(id, asiakirjojentallennusonnistui);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paivitaPalvelutapahtuma(String id, boolean asiakirjojentallennusonnistui) {
        String sql = "update palvelutapahtuma set asiakirjatarkistoitu = ? where cda_id = ?";
        PreparedStatement st = null;
        Connection con = null;
        try {
            con = cpds.getConnection();
            st = con.prepareStatement(sql);
            st.setString(1, Boolean.toString(asiakirjojentallennusonnistui));
            st.setString(2, id);
            st.executeUpdate();
            con.commit();
            SQLLogger logger = SQLLogger.getInstance();
            logger.logEntry(sql, Boolean.toString(asiakirjojentallennusonnistui), id);
            this.close(st);
            this.closeConnection(con);
        }
        catch (SQLException e) {
            try {
                this.handleError(e);
                this.close(st);
                this.closeConnection(con);
            }
            catch (Throwable throwable) {
                this.close(st);
                this.closeConnection(con);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void luoPalveluTapahtumaRivi(String id, boolean asiakirjojentallennusonnistui) {
        String sql = "insert into palvelutapahtuma (CDA_ID, ASIAKIRJATARKISTOITU) values (?, ?)";
        PreparedStatement st = null;
        Connection con = null;
        try {
            con = cpds.getConnection();
            st = con.prepareStatement(sql);
            st.setString(1, id);
            st.setString(2, String.valueOf(asiakirjojentallennusonnistui));
            st.executeUpdate();
            con.commit();
            SQLLogger logger = SQLLogger.getInstance();
            logger.logEntry(sql, id, String.valueOf(asiakirjojentallennusonnistui));
            this.close(st);
            this.closeConnection(con);
        }
        catch (SQLException e) {
            try {
                this.handleError(e);
                this.close(st);
                this.closeConnection(con);
            }
            catch (Throwable throwable) {
                this.close(st);
                this.closeConnection(con);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tarkistaOnkoPalvelutapahtumaTallennettu(String id) {
        String sql = "select cda_id from palvelutapahtuma where cda_id = ?";
        PreparedStatement stmt = null;
        Connection con = null;
        ResultSet rs = null;
        int counter = 0;
        try {
            con = cpds.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, id);
            rs = stmt.executeQuery();
            while (rs.next()) {
                rs.getString(1);
                ++counter;
            }
            this.close(stmt);
            this.closeConnection(con);
            this.close(rs);
        }
        catch (SQLException e) {
            try {
                this.handleError(e);
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
                throw throwable;
            }
        }
        return counter == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tarkistaOnkoPTOsittainTallennettu(String id) {
        String sql = "select cda_id from palvelutapahtuma where cda_id = ? and asiakirjatarkistoitu = ?";
        PreparedStatement stmt = null;
        Connection con = null;
        ResultSet rs = null;
        int counter = 0;
        try {
            con = cpds.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, id);
            stmt.setBoolean(2, false);
            rs = stmt.executeQuery();
            while (rs.next()) {
                rs.getString(1);
                ++counter;
            }
            this.close(stmt);
            this.closeConnection(con);
            this.close(rs);
        }
        catch (SQLException e) {
            try {
                this.handleError(e);
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
                throw throwable;
            }
        }
        return counter == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tarkastaOnkoHakemistoArkistoitu(String directory) {
        String sql = "select hakemisto from hakemistotaulu where hakemisto = ?";
        PreparedStatement stmt = null;
        Connection con = null;
        ResultSet rs = null;
        int counter = 0;
        try {
            con = cpds.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, directory);
            rs = stmt.executeQuery();
            while (rs.next()) {
                rs.getString(1);
                ++counter;
            }
            this.close(stmt);
            this.closeConnection(con);
            this.close(rs);
        }
        catch (SQLException e) {
            try {
                this.handleError(e);
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
                throw throwable;
            }
        }
        return counter == 1;
    }

    private void handleError(SQLException e) {
        log4j.error((Object)"sql virhe: ", (Throwable)e);
        e.printStackTrace();
        this.sammuta();
        System.err.println("Fataali tietokanta virhe, suoritus ei voi jatkua");
        System.exit(1);
    }

    public void tulostaYhteenveto() {
        this.tulostaAsiakirjaYhteenveto();
        this.tulostaManifestVirheYhteenveto();
        this.tulostaPalvelutapahtumaYhteenveto();
        this.tulostaHakemistoYhteenveto();
        this.tulostaVirheHakemistoYhteenveto();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tulostaHakemistoYhteenveto() {
        String sql = "select count(*) as cnt from hakemistotaulu";
        PreparedStatement stmt = null;
        Connection con = null;
        ResultSet rs = null;
        ConsoleWriter.writeLine("Hakemistoja k\u00e4sitelty onnistuneesti");
        try {
            con = cpds.getConnection();
            stmt = con.prepareStatement(sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                ConsoleWriter.writeLine(rs.getString(1));
            }
            this.close(stmt);
            this.closeConnection(con);
            this.close(rs);
        }
        catch (SQLException e) {
            try {
                this.handleError(e);
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tulostaPalvelutapahtumaYhteenveto() {
        String sql = "select count(*) as cnt, asiakirjatarkistoitu from palvelutapahtuma group by asiakirjatarkistoitu";
        PreparedStatement stmt = null;
        Connection con = null;
        ResultSet rs = null;
        ConsoleWriter.writeLine("Palvelutapahtumat (lukum\u00e4\u00e4r\u00e4, onko kaikki asiakirjat arkistoitu/validoitu)");
        try {
            con = cpds.getConnection();
            stmt = con.prepareStatement(sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                ConsoleWriter.write(rs.getString(1));
                ConsoleWriter.writeLine(" " + rs.getString(2));
            }
            this.close(stmt);
            this.closeConnection(con);
            this.close(rs);
        }
        catch (SQLException e) {
            try {
                this.handleError(e);
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tulostaManifestVirheYhteenveto() {
        String sql = "select count(*) as cnt from manifestvirhetaulu";
        PreparedStatement stmt = null;
        Connection con = null;
        ResultSet rs = null;
        ConsoleWriter.writeLine("Virheellisi\u00e4 manifest tiedostoja");
        try {
            con = cpds.getConnection();
            stmt = con.prepareStatement(sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                ConsoleWriter.writeLine(rs.getString(1));
            }
            this.close(stmt);
            this.closeConnection(con);
            this.close(rs);
        }
        catch (SQLException e) {
            try {
                this.handleError(e);
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tulostaVirheHakemistoYhteenveto() {
        String sql = "select count(*) as cnt from virhehakemistotaulu";
        PreparedStatement stmt = null;
        Connection con = null;
        ResultSet rs = null;
        ConsoleWriter.writeLine("Virheellisi\u00e4 hakemistoja joita ei huomioitu ");
        try {
            con = cpds.getConnection();
            stmt = con.prepareStatement(sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                ConsoleWriter.writeLine(rs.getString(1));
            }
            this.close(stmt);
            this.closeConnection(con);
            this.close(rs);
        }
        catch (SQLException e) {
            try {
                this.handleError(e);
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
                throw throwable;
            }
        }
        this.tulostaVirheellisetHakemistot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tulostaVirheellisetHakemistot() {
        String sql = "select hakemisto from virhehakemistotaulu";
        PreparedStatement stmt = null;
        Connection con = null;
        ResultSet rs = null;
        ConsoleWriter.writeLine("Virheelliset hakemistot:");
        try {
            con = cpds.getConnection();
            stmt = con.prepareStatement(sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                ConsoleWriter.writeLine(rs.getString(1));
            }
            this.close(stmt);
            this.closeConnection(con);
            this.close(rs);
        }
        catch (SQLException e) {
            try {
                this.handleError(e);
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tulostaAsiakirjaYhteenveto() {
        String sql = "select count(*) as cnt, tila from asiakirja group by tila";
        PreparedStatement stmt = null;
        Connection con = null;
        ResultSet rs = null;
        ConsoleWriter.writeLine("\n");
        ConsoleWriter.writeLine("Asiakirjoja arkistoitu / validoitu");
        try {
            con = cpds.getConnection();
            stmt = con.prepareStatement(sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                ConsoleWriter.write(rs.getString(1));
                String tila = rs.getString(2);
                if (tila.equals("OK")) {
                    ConsoleWriter.writeLine(" " + rs.getString(2));
                    continue;
                }
                ConsoleWriter.writeLine(" " + rs.getString(2));
            }
            this.close(stmt);
            this.closeConnection(con);
            this.close(rs);
        }
        catch (SQLException e) {
            try {
                this.handleError(e);
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kirjaaKoontitiedostovirhe(String dirPath) {
        if (this.koontitiedostolokitettu(dirPath)) {
            return;
        }
        String sql = "insert into manifestvirhetaulu (tiedosto) values (?);";
        PreparedStatement st = null;
        Connection con = null;
        try {
            con = cpds.getConnection();
            st = con.prepareStatement(sql);
            st.setString(1, dirPath);
            st.executeUpdate();
            con.commit();
            SQLLogger logger = SQLLogger.getInstance();
            logger.logEntry(sql, dirPath);
            this.close(st);
            this.closeConnection(con);
        }
        catch (SQLException e) {
            try {
                this.handleError(e);
                this.close(st);
                this.closeConnection(con);
            }
            catch (Throwable throwable) {
                this.close(st);
                this.closeConnection(con);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean koontitiedostolokitettu(String dirPath) {
        String sql = "select tiedosto from manifestvirhetaulu where tiedosto = ?";
        PreparedStatement stmt = null;
        Connection con = null;
        ResultSet rs = null;
        boolean onlokitettu = false;
        try {
            con = cpds.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, dirPath);
            rs = stmt.executeQuery();
            while (rs.next()) {
                onlokitettu = true;
            }
            this.close(stmt);
            this.closeConnection(con);
            this.close(rs);
        }
        catch (SQLException e) {
            try {
                this.handleError(e);
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
                throw throwable;
            }
        }
        return onlokitettu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poistaVirheManifest(String absolutePath) {
        if (this.koontitiedostolokitettu(absolutePath)) {
            String sql = "delete from manifestvirhetaulu where tiedosto = ?";
            PreparedStatement stmt = null;
            Connection con = null;
            try {
                con = cpds.getConnection();
                stmt = con.prepareStatement(sql);
                stmt.setString(1, absolutePath);
                stmt.executeUpdate();
                con.commit();
                SQLLogger logger = SQLLogger.getInstance();
                logger.logEntry(sql, absolutePath);
                this.close(stmt);
                this.closeConnection(con);
            }
            catch (SQLException e) {
                try {
                    this.handleError(e);
                    this.close(stmt);
                    this.closeConnection(con);
                }
                catch (Throwable throwable) {
                    this.close(stmt);
                    this.closeConnection(con);
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kompensoiasiakirja(String cdaId) {
        if (this.onkoHoitoasiakirjaArkistoitu(cdaId)) {
            String sql = "delete from asiakirja where cda_id = ?";
            PreparedStatement stmt = null;
            Connection con = null;
            try {
                con = cpds.getConnection();
                stmt = con.prepareStatement(sql);
                stmt.setString(1, cdaId);
                stmt.executeUpdate();
                con.commit();
                SQLLogger logger = SQLLogger.getInstance();
                logger.logEntry(sql, cdaId);
                this.close(stmt);
                this.closeConnection(con);
            }
            catch (SQLException e) {
                try {
                    this.handleError(e);
                    this.close(stmt);
                    this.closeConnection(con);
                }
                catch (Throwable throwable) {
                    this.close(stmt);
                    this.closeConnection(con);
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tulostaViallisetManifestit() {
        String sql = "select tiedosto from manifestvirhetaulu";
        PreparedStatement stmt = null;
        Connection con = null;
        ResultSet rs = null;
        boolean onlokitettu = false;
        ConsoleWriter.writeLine("Virheelliset manifest-tiedostot:");
        try {
            con = cpds.getConnection();
            stmt = con.prepareStatement(sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                ConsoleWriter.writeLine(rs.getString(1));
            }
            this.close(stmt);
            this.closeConnection(con);
            this.close(rs);
        }
        catch (SQLException e) {
            try {
                this.handleError(e);
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
                throw throwable;
            }
        }
    }

    public void tulostaKeskenEraisetPalvelutapahtumat() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tulostaViallisetTiedostot() {
        String sql = "SELECT v.cda_id, v.kuvaus, v.tarkkakuvaus, a.tiedostopolku from virhetaulu v, asiakirja a where a.cda_id = v.cda_id and v.korjattu = 'false';";
        PreparedStatement stmt = null;
        Connection con = null;
        ResultSet rs = null;
        ConsoleWriter.writeLine("Virheelliset asiakirjat:");
        try {
            con = cpds.getConnection();
            stmt = con.prepareStatement(sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                ConsoleWriter.writeLine(rs.getString(1));
                ConsoleWriter.writeLine(rs.getString(2));
                ConsoleWriter.writeLine(rs.getString(3));
                ConsoleWriter.writeLine(rs.getString(4));
                ConsoleWriter.writeLine("---");
            }
            this.close(stmt);
            this.closeConnection(con);
            this.close(rs);
        }
        catch (SQLException e) {
            try {
                this.handleError(e);
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTables() {
        Statement stmt = null;
        Connection con = null;
        try {
            con = cpds.getConnection();
            stmt = con.createStatement();
            stmt.executeUpdate("drop table ASIAKIRJA;");
            stmt.executeUpdate("drop table PALVELUTAPAHTUMA;");
            stmt.executeUpdate("drop table VIRHETAULU;");
            stmt.executeUpdate("drop table MANIFESTVIRHETAULU;");
            stmt.executeUpdate("drop table HAKEMISTOTAULU;");
            stmt.executeUpdate("drop table VIRHEHAKEMISTOTAULU;");
            this.close(stmt);
            this.closeConnection(con);
        }
        catch (SQLException e) {
            try {
                this.handleError(e);
                this.close(stmt);
                this.closeConnection(con);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeRedoLine(String sql) {
        PreparedStatement stmt = null;
        Connection con = null;
        try {
            con = cpds.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.executeUpdate();
            con.commit();
            this.close(stmt);
            this.closeConnection(con);
        }
        catch (SQLException e) {
            try {
                this.handleError(e);
                this.close(stmt);
                this.closeConnection(con);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poistaHakemistoVirhe(String dirPath) {
        if (!this.onkoHakemistoJoAsetettuVirheelliseksi(dirPath)) {
            return;
        }
        String sql = "delete from virhehakemistotaulu where hakemisto = ?";
        PreparedStatement st = null;
        Connection con = null;
        try {
            con = cpds.getConnection();
            st = con.prepareStatement(sql);
            st.setString(1, dirPath);
            st.executeUpdate();
            con.commit();
            SQLLogger logger = SQLLogger.getInstance();
            logger.logEntry(sql, dirPath);
            this.close(st);
            this.closeConnection(con);
        }
        catch (SQLException e) {
            try {
                this.handleError(e);
                this.close(st);
                this.closeConnection(con);
            }
            catch (Throwable throwable) {
                this.close(st);
                this.closeConnection(con);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asetaHakemistoVirheelliseksi(String dirPath) {
        if (this.onkoHakemistoJoAsetettuVirheelliseksi(dirPath)) {
            return;
        }
        String sql = "insert into virhehakemistotaulu (hakemisto) values (?)";
        log4j.debug((Object)sql);
        PreparedStatement st = null;
        Connection con = null;
        try {
            con = cpds.getConnection();
            st = con.prepareStatement(sql);
            st.setString(1, dirPath);
            st.executeUpdate();
            con.commit();
            SQLLogger logger = SQLLogger.getInstance();
            logger.logEntry(sql, dirPath);
            this.close(st);
            this.closeConnection(con);
        }
        catch (SQLException e) {
            try {
                this.handleError(e);
                this.close(st);
                this.closeConnection(con);
            }
            catch (Throwable throwable) {
                this.close(st);
                this.closeConnection(con);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean onkoHakemistoJoAsetettuVirheelliseksi(String dirPath) {
        String sql = "select hakemisto from virhehakemistotaulu where hakemisto = ?";
        PreparedStatement stmt = null;
        Connection con = null;
        ResultSet rs = null;
        int counter = 0;
        try {
            con = cpds.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, dirPath);
            rs = stmt.executeQuery();
            while (rs.next()) {
                rs.getString(1);
                ++counter;
            }
            this.close(stmt);
            this.closeConnection(con);
            this.close(rs);
        }
        catch (SQLException e) {
            try {
                this.handleError(e);
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
                throw throwable;
            }
        }
        return counter == 1;
    }

    public boolean onkoVirheArkistoitu(String id, List<String> codeList) {
        return this.tarkistaVirheKoodit(id, codeList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tarkistaVirheKoodit(String id, List<String> codeList) {
        String sql = "select * from virhetaulu where cda_id = ?";
        PreparedStatement stmt = null;
        Connection con = null;
        ResultSet rs = null;
        ArrayList<String> resultList = new ArrayList<String>();
        try {
            con = cpds.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, id);
            rs = stmt.executeQuery();
            while (rs.next()) {
                resultList.add(rs.getString("koodi"));
            }
            this.close(stmt);
            this.closeConnection(con);
            this.close(rs);
        }
        catch (SQLException e) {
            try {
                this.handleError(e);
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
                throw throwable;
            }
        }
        if (codeList.size() != resultList.size()) {
            return false;
        }
        for (String code : codeList) {
            if (resultList.contains(code)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tulostaVirheet(String oid) {
        String sql = "select * from virhetaulu where cda_id = ?";
        PreparedStatement stmt = null;
        Connection con = null;
        ResultSet rs = null;
        try {
            con = cpds.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, oid);
            rs = stmt.executeQuery();
            while (rs.next()) {
                ConsoleWriter.write(" " + rs.getString("koodi"));
                ConsoleWriter.write(" " + rs.getString("kuvaus"));
                ConsoleWriter.write(" " + rs.getString("tarkkakuvaus"));
                ConsoleWriter.writeLine("");
            }
            this.close(stmt);
            this.closeConnection(con);
            this.close(rs);
        }
        catch (SQLException e) {
            try {
                this.handleError(e);
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> haeVirheellisetOidit() {
        String sql = "select * from virhetaulu";
        PreparedStatement stmt = null;
        Connection con = null;
        ResultSet rs = null;
        ArrayList<String> virheet = new ArrayList<String>();
        try {
            con = cpds.getConnection();
            stmt = con.prepareStatement(sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                virheet.add(rs.getString("cda_id"));
            }
            this.close(stmt);
            this.closeConnection(con);
            this.close(rs);
        }
        catch (SQLException e) {
            try {
                this.handleError(e);
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.closeConnection(con);
                this.close(rs);
                throw throwable;
            }
        }
        return virheet;
    }

    static {
        try {
            String jdbcurl = PropertyHandler.getInstance().getProperty("", "jdbcurl");
            String jdbcdriver = PropertyHandler.getInstance().getProperty("", "jdbcdriver");
            cpds = new ComboPooledDataSource();
            cpds.setDriverClass(jdbcdriver);
            cpds.setJdbcUrl(jdbcurl);
            cpds.setUser("sa");
            cpds.setPassword("");
        }
        catch (PropertyException | PropertyVetoException e) {
            log4j.error((Object)"Virhe kannan initialisoinnissa", e);
            System.err.print("Could not create connection pool, exiting");
            System.exit(-1);
        }
    }
}

