/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.olddocuments.logging;

import fi.kanta.arkistopalvelu.olddocuments.exception.ConfigException;
import fi.kanta.arkistopalvelu.olddocuments.exception.ErrorWrapperLoader;
import fi.kanta.arkistopalvelu.olddocuments.logging.IProcessLogger;
import fi.kanta.arkistopalvelu.olddocuments.metadata.DocumentData;
import fi.kanta.arkistopalvelu.olddocuments.utils.PropertyHandler;
import fi.kanta.arkistopalvelu.webservices.RequestResponseInteraction;
import fi.kanta.arkistopalvelu.webservices.olddocumentwithcontent.request.AsiakirjaHAReq;
import fi.kanta.arkistopalvelu.webservices.olddocumentwithcontent.request.AsiakirjaPTReq;
import fi.kanta.arkistopalvelu.webservices.olddocumentwithcontent.response.OlddocumentwithcontentHAResp;
import fi.kanta.arkistopalvelu.webservices.olddocumentwithcontent.response.OlddocumentwithcontentPTResp;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.exception.PropertyException;
import fi.kanta.common.util.InternalServiceError;
import fi.kanta.lokipalvelu.webservices.kayttoloki.arkisto.ArkistoKayttolokiSOAPType;
import fi.kanta.lokipalvelu.webservices.kayttoloki.arkisto.web.ArkistoKayttoLokiResponseDetailWeb;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;

public class ProcessLogger
implements IProcessLogger {
    private boolean palveluTapahtumaOpen = false;
    private boolean docOpen = false;
    private boolean logAll = true;
    private boolean bruteForceMode = false;
    private boolean rerunOpen = false;
    private boolean rerunPalvelutapahtuma = false;
    private String logPath = null;
    private String organizationid = null;
    private String logId = null;
    private File logFile = null;
    private File rerunFile = null;
    private File compareFile = null;
    private FileWriter fw = null;
    private FileWriter rerunW = null;
    private FileWriter compareW = null;
    private DocumentData currentPalvelutapahtuma = null;
    private Logger log4j;
    private URL serviceURL;
    private QName serviceName;
    private LogHelper logHelper = null;
    private ArkistoKayttolokiSOAPType proxy;
    private Long starttime = 0L;
    private int ptSuccessCount = 0;
    private int ptFailCount = 0;
    private int ptDocFoundCount = 0;
    private int docSuccessCount = 0;
    private int docFailCount = 0;
    private int docFoundCount = 0;
    private int missingDocCount = 0;
    private ErrorWrapperLoader errorWrapper;

    public ProcessLogger(String logId) throws PropertyException, MalformedURLException {
        this.logId = logId;
        this.serviceName = new QName(PropertyHandler.getInstance().getProperty(logId, "kayttolokipalvelu"), PropertyHandler.getInstance().getProperty(logId, "kayttolokiservice"));
        this.serviceURL = new URL(PropertyHandler.getInstance().getProperty(logId, "kayttolokiurl"));
        this.logHelper = new LogHelper();
        this.proxy = null;
        this.log4j = Logger.getLogger(ProcessLogger.class);
        this.logAll = Boolean.parseBoolean(PropertyHandler.getInstance().getProperty(logId, "logAll"));
        this.bruteForceMode = Boolean.parseBoolean(PropertyHandler.getInstance().getProperty(logId, "bruteforcemode"));
        this.errorWrapper = ErrorWrapperLoader.getInstance();
    }

    @Override
    public void startLog(String directory, String logName) throws IOException, ConfigException {
        this.logPath = directory;
        this.starttime = System.currentTimeMillis();
        Object fileName = logName;
        if (logName == null) {
            fileName = this.logId + this.hashCode() + "_olddocuments_log.txt";
        }
        this.logFile = new File(this.logPath + (String)fileName);
        if (!this.logFile.createNewFile()) {
            this.log4j.error((Object)("Ei saatu luotua lokitiedostoa:" + this.logFile));
            InternalServiceError error = this.errorWrapper.getError("0018");
            throw new ConfigException(error);
        }
        this.fw = new FileWriter(this.logFile);
        this.fw.write("Ajon aloitus: ");
        this.fw.write(new Date(this.starttime).toString());
        this.fw.write("\n");
        this.fw.flush();
    }

    @Override
    public void startCompareLog(String logName) throws IOException, ConfigException {
        this.compareFile = new File(this.logPath + "compare_" + logName);
        if (!this.compareFile.createNewFile()) {
            this.log4j.error((Object)("Ei saatu luotua lokitiedostoa:" + this.compareFile));
            InternalServiceError error = this.errorWrapper.getError("0018");
            this.log4j.error((Object)this.logHelper.formatMsg(this.logId, error));
            throw new ConfigException(error);
        }
        this.compareW = new FileWriter(this.compareFile);
    }

    @Override
    public void startRerunLog() throws IOException {
        this.rerunFile = new File(this.logPath + this.logId + "_rerun_log.xml");
        if (this.rerunFile.createNewFile()) {
            this.rerunW = new FileWriter(this.rerunFile);
            this.rerunW.write(this.openRerunFile());
            this.rerunW.flush();
        } else {
            this.log4j.error((Object)("Ei saatu luotua lokitiedostoa:" + this.rerunFile));
        }
    }

    private String openRerunFile() {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?><palvelutapahtumat palvelujenantaja=\"");
        sb.append(this.organizationid);
        sb.append("\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"Koontitiedosto.xsd\">");
        return sb.toString();
    }

    private String closeRerunFile() {
        return "</palvelutapahtumat>";
    }

    @Override
    public void closeLog() throws IOException {
        this.fw.flush();
        try {
            if (this.palveluTapahtumaOpen) {
                if (this.docOpen) {
                    this.closeAsiakirja(null, null, "Asiakirjan k\u00e4sittely auki lokia suljettaessa", false);
                }
                this.closePalveluTapahtuma(null, null, "Palvelutapahtuman k\u00e4sittely auki lokia suljettaessa", false);
            }
        }
        catch (Exception e) {
            this.log4j.error((Object)"virhe login sulkemisessa", (Throwable)e);
        }
        finally {
            this.fw.write("\n\nAjon lopetus: ");
            this.fw.write(new Date().toString());
            this.fw.write("\n");
            this.fw.flush();
            this.fw.write("\nOnnistuneita palvelutapahtumia: " + this.ptSuccessCount);
            this.fw.write("\nEp\u00e4onnistuneita palvelutapahtumia: " + this.ptFailCount);
            if (this.bruteForceMode) {
                this.fw.write("\nKannassa valmiiksi palvelutapahtumia: " + this.ptDocFoundCount);
            }
            this.fw.write("\nYhteens\u00e4: " + (this.ptSuccessCount + this.ptFailCount + this.ptDocFoundCount));
            this.fw.write("\nOnnistuneita asiakirjoja: " + this.docSuccessCount);
            this.fw.write("\nEp\u00e4onnistuneita asiakirjoja: " + this.docFailCount);
            if (this.bruteForceMode) {
                this.fw.write("\nKannassa valmiiksi asiakirjoja: " + this.docFoundCount);
            }
            this.fw.write("\nYhteens\u00e4: " + (this.docSuccessCount + this.docFailCount + this.docFoundCount));
            this.fw.write("\n");
            this.fw.flush();
            this.fw.write("\nPuuttuvia asiakirjoja: " + this.missingDocCount);
            this.fw.write("\nAjo kesti: " + (System.currentTimeMillis() - this.starttime) + " millisekuntia");
            this.fw.flush();
            this.fw.close();
        }
        if (this.rerunOpen) {
            if (!this.rerunPalvelutapahtuma) {
                this.closeRerunPalveluTapahtuma(false);
            }
            this.closeRerunLog();
        }
    }

    @Override
    public void closeRerunLog() throws IOException {
        this.rerunW.write(this.closeRerunFile());
        this.rerunW.flush();
        this.rerunW.close();
    }

    @Override
    public void closeCompareLog() throws IOException {
        this.compareW.flush();
        this.compareW.close();
    }

    @Override
    public void writeCompareLog(String string) throws IOException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)("Compare: " + string));
        }
        this.compareW.write(string + "\n");
        this.compareW.flush();
    }

    @Override
    public void flushLog() throws IOException {
        this.fw.flush();
    }

    @Override
    public void openPalveluTapahtuma(DocumentData dd) throws IOException {
        this.log4j.info((Object)("Tallennetaan palvelutapahtuma: " + dd.getOid()));
        this.palveluTapahtumaOpen = true;
        this.currentPalvelutapahtuma = dd;
        if (this.logAll) {
            this.fw.write("\n\nAloitetaan palvelutapahtuma: ");
            this.fw.write(dd.getOid());
        }
    }

    @Override
    public void openPalveluTapahtuma(AsiakirjaPTReq req) throws IOException {
        String oid = ((AsiakirjaPTReq.Asiakirja)req.getAsiakirja().get(0)).getAsiakirjanTunnisteTiedot().getCdaId().getValue();
        this.log4j.info((Object)("Tallennetaan palvelutapahtuma: " + oid));
        this.palveluTapahtumaOpen = true;
        if (this.logAll) {
            this.fw.write("\n\nAloitetaan palvelutapahtuma: ");
            this.fw.write(oid);
        }
    }

    @Override
    public void openRerunPalveluTapahtuma(String oid) throws IOException {
        if (!this.rerunOpen) {
            this.startRerunLog();
            this.rerunOpen = true;
        }
        if (!this.rerunPalvelutapahtuma) {
            this.rerunW.write("<palvelutapahtuma id=\"" + oid + "\">");
            this.rerunPalvelutapahtuma = true;
        }
    }

    @Override
    public void closePalveluTapahtuma(String oid, String statusCode, String message, boolean success) throws IOException {
        this.palveluTapahtumaOpen = false;
        if (success) {
            ++this.ptSuccessCount;
            if (this.logAll) {
                this.fw.write("\nPalvelutapahtuma k\u00e4sitelty onnistuneesti: ");
                this.fw.write(oid);
                this.fw.flush();
            }
        } else {
            if (this.bruteForceMode && statusCode.equals("201159")) {
                ++this.ptDocFoundCount;
                this.fw.write("\nPalvelutapahtuman k\u00e4sittely onnistui: ");
            } else {
                ++this.ptFailCount;
                this.fw.write("\nPalvelutapahtuman k\u00e4sittely ep\u00e4onnistui: ");
            }
            this.fw.write(oid);
            this.fw.write(" Paluuarvo: ");
            this.fw.write(statusCode);
            this.fw.flush();
            this.fw.write(" Viesti: ");
            this.fw.write(message);
            this.fw.flush();
        }
    }

    @Override
    public void closeRerunPalveluTapahtuma(boolean success) throws IOException {
        if (this.rerunPalvelutapahtuma) {
            if (success) {
                this.rerunW.write("<success/>");
            } else {
                this.rerunW.write("<fail/>");
            }
            this.rerunW.write("</palvelutapahtuma>");
            this.rerunW.flush();
        }
        this.rerunPalvelutapahtuma = false;
    }

    @Override
    public void openAsiakirja(String oid) throws IOException {
        this.log4j.info((Object)("Tallennetaan asiakirja: " + oid));
        this.docOpen = true;
    }

    @Override
    public void closeAsiakirja(String oid, String statusCode, String message, boolean success) throws IOException {
        this.docOpen = false;
        if (success) {
            ++this.docSuccessCount;
            if (this.logAll) {
                this.fw.write("\nAsiakirja: ");
                this.fw.write(oid + ": OK");
                this.fw.flush();
            }
        } else {
            if (this.bruteForceMode && statusCode.equals("201159")) {
                ++this.docFoundCount;
                this.fw.write("\nAsiakirjan k\u00e4sittely onnistui: ");
                this.fw.write(oid);
            } else {
                ++this.docFailCount;
                this.fw.write("\nAsiakirjan k\u00e4sittely ep\u00e4onnistui: ");
                this.fw.write(oid);
                this.fw.write(": ERROR ");
            }
            this.fw.write(" Paluuarvo: ");
            this.fw.write(statusCode);
            this.fw.write(" Viesti:");
            this.fw.write(message);
            this.fw.write(" Asiakirjan palvelutapahtuma: ");
            if (this.currentPalvelutapahtuma != null) {
                this.fw.write(this.currentPalvelutapahtuma.getOid());
            }
            this.fw.flush();
        }
    }

    @Override
    public void rerunAsiakirja(String oid) throws IOException {
        if (!this.rerunPalvelutapahtuma) {
            if (this.currentPalvelutapahtuma != null) {
                this.openRerunPalveluTapahtuma(this.currentPalvelutapahtuma.getOid());
            } else {
                this.openRerunPalveluTapahtuma("Oid ei tiedossa");
            }
        }
        this.rerunW.write("<asiakirja id=\"" + oid + "\" status=\"fail\" />");
        this.rerunW.flush();
    }

    @Override
    public ArkistoKayttoLokiResponseDetailWeb writeUsageLog(String subsystem, DocumentData dd, RequestResponseInteraction ptresult, String logExtension) {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(this.logId));
            this.log4j.info((Object)("Kirjoitetaan k\u00e4ytt\u00f6lokia null loggerilla: " + dd.getOid()));
        }
        ArkistoKayttoLokiResponseDetailWeb usageLogResponse = new ArkistoKayttoLokiResponseDetailWeb();
        usageLogResponse.setResultCode("600000");
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(this.logId));
        }
        return usageLogResponse;
    }

    @Override
    public ArkistoKayttoLokiResponseDetailWeb writeUsageLog(String subsystem, AsiakirjaHAReq ptreq, OlddocumentwithcontentHAResp ptResp, String logExtension) {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(this.logId));
        }
        ArkistoKayttoLokiResponseDetailWeb usageLogResponse = new ArkistoKayttoLokiResponseDetailWeb();
        usageLogResponse.setResultCode("600000");
        this.log4j.debug((Object)"k\u00e4ytt\u00f6loki null logger");
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(this.logId));
        }
        return usageLogResponse;
    }

    @Override
    public ArkistoKayttoLokiResponseDetailWeb writeUsageLog(String subsystem, AsiakirjaPTReq ptreq, OlddocumentwithcontentPTResp ptResp, String logExtension) {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(this.logId));
        }
        ArkistoKayttoLokiResponseDetailWeb usageLogResponse = new ArkistoKayttoLokiResponseDetailWeb();
        usageLogResponse.setResultCode("600000");
        this.log4j.debug((Object)"k\u00e4ytt\u00f6loki null logger");
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(this.logId));
        }
        return usageLogResponse;
    }

    @Override
    public void error(String string) throws IOException {
        this.log4j.error((Object)string);
        this.fw.write("\n" + string);
        this.fw.flush();
    }

    @Override
    public void log(String string) throws IOException {
        this.log4j.info((Object)string);
        this.fw.write("\n" + string);
        this.fw.flush();
    }

    @Override
    public void missingDoc(String docOid, String docPath) throws IOException {
        ++this.missingDocCount;
        this.fw.write("\n Puuttuva asiakirja: " + docOid + " polusta: " + docPath);
        this.fw.flush();
    }

    @Override
    public void palvelunantaja(String oid) throws IOException {
        this.organizationid = oid;
        this.fw.write("\n Ajon palvelunantaja = : " + oid);
        this.fw.flush();
    }

    @Override
    public String getLogId() {
        return this.logId;
    }
}

