/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.olddocuments.metadata;

import fi.kanta.arkistopalvelu.olddocuments.client.MaakuntaRekisterinpitajaTiedot;
import fi.kanta.arkistopalvelu.olddocuments.client.RekisterinPitajapalveluClient;
import fi.kanta.arkistopalvelu.olddocuments.exception.ConfigException;
import fi.kanta.arkistopalvelu.olddocuments.exception.ErrorWrapperLoader;
import fi.kanta.arkistopalvelu.olddocuments.exception.MessagingException;
import fi.kanta.arkistopalvelu.olddocuments.exception.ValidatorException;
import fi.kanta.arkistopalvelu.olddocuments.logging.DbLogger;
import fi.kanta.arkistopalvelu.olddocuments.logging.RunMode;
import fi.kanta.arkistopalvelu.olddocuments.metadata.DocumentData;
import fi.kanta.arkistopalvelu.olddocuments.utils.PropertyHandler;
import fi.kanta.arkistopalvelu.olddocuments.utils.xpathconfig.DctmAttribute;
import fi.kanta.arkistopalvelu.olddocuments.utils.xpathconfig.DctmAttributesSave;
import fi.kanta.arkistopalvelu.olddocuments.utils.xpathconfig.DctmAttributesValidate;
import fi.kanta.arkistopalvelu.olddocuments.utils.xpathconfig.XMLXPathConfigManager;
import fi.kanta.arkistopalvelu.olddocuments.utils.xpathconfig.XmlXpathConfig;
import fi.kanta.arkistopalvelu.olddocuments.validation.AttributeValidator;
import fi.kanta.arkistopalvelu.olddocuments.validation.OldDocumentValidator;
import fi.kanta.arkistopalvelu.webservices.MetadataAttrType;
import fi.kanta.arkistopalvelu.webservices.MetadataObjectType;
import fi.kanta.arkistopalvelu.webservices.olddocumentwithcontent.request.AsiakirjaHAReq;
import fi.kanta.arkistopalvelu.webservices.olddocumentwithcontent.request.AsiakirjaPTReq;
import fi.kanta.common.components.DateHelper;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.components.XPathHelper;
import fi.kanta.common.exception.PropertyException;
import fi.kanta.common.exception.UtilException;
import fi.kanta.common.util.InternalServiceError;
import fi.kela.kanta.components.XPathHelperVTD;
import fi.kela.kanta.exceptions.XPathHelperVTDException;
import fi.kela.kanta.utils.AttributeObjectValue;
import fi.kela.kanta.utils.AttributeValueType;
import fi.kela.kanta.utils.ObjectRelativeXpath;
import fi.kela.kanta.utils.ObjectValueType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.w3c.dom.Document;

public class OldDocumentMetadataReader {
    private static final String CDA_COUNTY_CUSTODIAN_NAME = "cda_county_custodian_name";
    private static final String CDA_COUNTY_CUSTODIAN = "cda_county_custodian";
    private static final String FILEFORMAT_XHTML = "6";
    private static final String FILEFORMAT_TEXT = "4";
    private String logId;
    Logger log4j = Logger.getLogger(OldDocumentMetadataReader.class);
    private XPathHelper xpathhelper;
    private LogHelper logHelper;
    private XMLXPathConfigManager xpathConfigmanager;
    private AttributeValidator attrValidator;
    private OldDocumentValidator oldDocValidator;
    private ErrorWrapperLoader errorWrapper;
    private boolean validatePdf;
    private boolean checkPdf;
    private boolean validateXhtml;
    private boolean checkCodes;
    private boolean checkTextPlain;
    private List<InternalServiceError> errorList = new ArrayList<InternalServiceError>();
    private boolean set2020custodian;
    private static Cache<String, MaakuntaRekisterinpitajaTiedot> rekisterinpitajaCache;
    private static CacheManager cacheManager;
    private static RunMode executionMode;

    public OldDocumentMetadataReader(String logId) throws PropertyException {
        this.logId = logId;
        this.xpathhelper = new XPathHelper();
        this.logHelper = new LogHelper();
        this.xpathConfigmanager = XMLXPathConfigManager.getInstance();
        this.attrValidator = new AttributeValidator();
        this.oldDocValidator = new OldDocumentValidator(logId);
        this.errorWrapper = ErrorWrapperLoader.getInstance();
        this.log4j.debug((Object)("MODE ON!!!: " + executionMode.getMode()));
        if (executionMode.getMode().equals("ARKISTOINTI")) {
            this.set2020custodian = Boolean.parseBoolean(PropertyHandler.getInstance().getProperty(this.logId, "aseta2020rekisterinpitaja"));
            this.validatePdf = Boolean.parseBoolean(PropertyHandler.getInstance().getProperty(this.logId, "validatepdf"));
            this.checkPdf = Boolean.parseBoolean(PropertyHandler.getInstance().getProperty(this.logId, "checkpdf"));
            this.checkCodes = Boolean.parseBoolean(PropertyHandler.getInstance().getProperty(this.logId, "checkcodes"));
            this.validateXhtml = Boolean.parseBoolean(PropertyHandler.getInstance().getProperty(this.logId, "checkxhtml"));
            this.checkTextPlain = Boolean.parseBoolean(PropertyHandler.getInstance().getProperty(this.logId, "checktextplain"));
        } else {
            this.validatePdf = true;
            this.checkPdf = true;
            this.checkCodes = true;
            this.validateXhtml = true;
            this.checkTextPlain = true;
        }
    }

    public DocumentData parseDocumentData(Document document) throws UtilException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(this.logId));
        }
        DocumentData ptd = new DocumentData();
        DateHelper dateHelper = new DateHelper();
        ptd.setTempPatientId(this.xpathhelper.getCode(this.logId, document, "/ClinicalDocument/recordTarget/patientRole/id[@root!='1.2.246.21']/@extension"));
        ptd.setTempPatientRoot(this.xpathhelper.getCode(this.logId, document, "/ClinicalDocument/recordTarget/patientRole/id[@root!='1.2.246.21']/@root"));
        ptd.setSetId(this.xpathhelper.getCode(this.logId, document, "/ClinicalDocument/setId/@root"));
        ptd.setOid(this.xpathhelper.getCode(this.logId, document, "/ClinicalDocument/id/@root"));
        ptd.setAuthorTime(this.xpathhelper.getCode(this.logId, document, "/ClinicalDocument/author/time/@value"));
        ptd.setEffectiveTime(this.xpathhelper.getCode(this.logId, document, "/ClinicalDocument/componentOf/encompassingEncounter/effectiveTime/@value"));
        ptd.setEffectiveTimeLow(this.xpathhelper.getCode(this.logId, document, "/ClinicalDocument/componentOf/encompassingEncounter/effectiveTime/low"));
        ptd.setEffectiveTimeHigh(this.xpathhelper.getCode(this.logId, document, "/ClinicalDocument/componentOf/encompassingEncounter/effectiveTime/high"));
        ptd.setPatientId(this.xpathhelper.getCode(this.logId, document, "/ClinicalDocument/recordTarget/patientRole/id[@root='1.2.246.21']/@extension"));
        ptd.setPatientIdroot(this.xpathhelper.getCode(this.logId, document, "/ClinicalDocument/recordTarget/patientRole/id[@root='1.2.246.21']/@root"));
        ptd.setPatientFamilyName(this.xpathhelper.getCode(this.logId, document, "/ClinicalDocument/recordTarget/patientRole/patient/name/family"));
        ptd.setPatientGivenNames(this.xpathhelper.getUniqueCodesFromNodeList(this.logId, document, "/ClinicalDocument/recordTarget/patientRole/patient/name/given[not(@qualifier)]"));
        ptd.setPatientBirthTime(dateHelper.toDate(this.logId, this.xpathhelper.getCode(this.logId, document, "/ClinicalDocument/recordTarget/patientRole/patient/birthTime/@value")));
        ptd.setRegistry(this.xpathhelper.getCode(this.logId, document, "/ClinicalDocument/code/@code"));
        ptd.setRepresentedOrganization(this.xpathhelper.getCode(this.logId, document, "/ClinicalDocument/componentOf/encompassingEncounter/encounterParticipant/assignedEntity/representedOrganization/id/@root"));
        ptd.setCustodian(this.getCustodian(document));
        ptd.setRepresentedOrganizationExt(this.xpathhelper.getCode(this.logId, document, "/ClinicalDocument/componentOf/encompassingEncounter/encounterParticipant/assignedEntity/representedOrganization"));
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(this.logId));
        }
        return ptd;
    }

    public AsiakirjaPTReq getPalvelutapahtumaReq(String logId, File palvelutapahtuma, String signatureTimeStamp, String rekisterinpitaja) throws XPathHelperVTDException, ValidatorException, ConfigException, MessagingException, InterruptedException, IOException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        AsiakirjaPTReq asiakirjaPTReq = new AsiakirjaPTReq();
        try {
            XPathHelperVTD xpathHelperVTD = new XPathHelperVTD(OldDocumentMetadataReader.readFileContent(palvelutapahtuma).getBytes());
            XmlXpathConfig xpathConfig = this.xpathConfigmanager.getXPathConfig(logId, FILEFORMAT_TEXT, 1);
            AsiakirjaPTReq.Asiakirja asiakirjaPT = new AsiakirjaPTReq.Asiakirja();
            this.attrValidator.checkForbiddenMetadata(logId, xpathHelperVTD, xpathConfig.getDctmAttributesForbidden());
            DctmAttributesSave dctmAttrSave = xpathConfig.getDctmAttributesSave();
            HashMap<String, DctmAttribute> saveAttrMap = new HashMap<String, DctmAttribute>();
            for (DctmAttribute dctmAttr : dctmAttrSave.getDctmAttribute()) {
                saveAttrMap.put(dctmAttr.getName(), dctmAttr);
            }
            DctmAttributesValidate dctmAttrValidate = xpathConfig.getDctmAttributesValidate();
            HashMap<String, DctmAttribute> validateAttrMap = new HashMap<String, DctmAttribute>();
            for (DctmAttribute dctmAttr : dctmAttrValidate.getDctmAttribute()) {
                validateAttrMap.put(dctmAttr.getName(), dctmAttr);
            }
            this.setPTAsiakirjanTunnisteTiedot(logId, asiakirjaPT, xpathHelperVTD, saveAttrMap);
            this.setPTPotilaanTiedot(logId, asiakirjaPT, xpathHelperVTD, saveAttrMap);
            this.setPTAsiakirjanLaatijanTiedot(logId, asiakirjaPT, xpathHelperVTD, saveAttrMap);
            this.setPTAsiakirjanElinkaariTiedot(logId, asiakirjaPT, rekisterinpitaja, xpathHelperVTD, saveAttrMap, validateAttrMap);
            this.setPTAsiakirjanSisaltoTiedot(logId, asiakirjaPT, xpathHelperVTD, saveAttrMap);
            this.setPTAsiakirjanPalvelutapahtumaTiedot(logId, asiakirjaPT, xpathHelperVTD, saveAttrMap);
            this.setPTOhjelmistonTiedot(logId, asiakirjaPT, xpathHelperVTD, saveAttrMap);
            this.setPTAllekirjoitusTiedot(logId, asiakirjaPT, signatureTimeStamp);
            this.attrValidator.validateCodesystems(logId, this.checkCodes);
            this.validatePTAsiakirjanPalvelutapahtumaTiedot(logId, asiakirjaPT);
            asiakirjaPTReq.getAsiakirja().add(asiakirjaPT);
            List<InternalServiceError> attributeErrorList = this.attrValidator.getErrorList();
            List<InternalServiceError> validatorErrorList = this.oldDocValidator.getErrorList();
            if (!(attributeErrorList.isEmpty() && validatorErrorList.isEmpty() && this.errorList.isEmpty())) {
                DbLogger errorLogger = new DbLogger();
                ArrayList<InternalServiceError> combinedlist = new ArrayList<InternalServiceError>();
                combinedlist.addAll(attributeErrorList);
                combinedlist.addAll(validatorErrorList);
                combinedlist.addAll(this.errorList);
                errorLogger.kirjaaVirhe(logId, combinedlist, palvelutapahtuma);
                throw new ValidatorException((InternalServiceError)combinedlist.get(0));
            }
            if (this.log4j.isDebugEnabled()) {
                this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
            }
        }
        catch (UtilException e) {
            this.log4j.error((Object)this.logHelper.formatMsg(logId), (Throwable)e);
            DbLogger dblogger = new DbLogger();
            dblogger.kirjaaVirhe(logId, e.getInternalServiceError().getErrorCode(), e.getInternalServiceError().getErrorMessage(), palvelutapahtuma);
            throw new ValidatorException(e.getInternalServiceError());
        }
        return asiakirjaPTReq;
    }

    public AsiakirjaHAReq getHoitoasiakirjaReq(String logId, File hoitoasiakirja, AsiakirjaPTReq.Asiakirja asiakirjaPT, String signatureTimeStamp, String rekisterinpitaja) throws XPathHelperVTDException, ValidatorException, ConfigException, MessagingException, InterruptedException, IOException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        AsiakirjaHAReq asiakirjaHAReq = new AsiakirjaHAReq();
        try {
            XPathHelperVTD xpathHelperVTD = new XPathHelperVTD(OldDocumentMetadataReader.readFileContent(hoitoasiakirja).getBytes());
            XmlXpathConfig xpathConfig = this.xpathConfigmanager.getXPathConfig(logId, "5", 1);
            this.attrValidator.checkForbiddenMetadata(logId, xpathHelperVTD, xpathConfig.getDctmAttributesForbidden());
            String fileFormat = xpathHelperVTD.getCode("/*[local-name()='ClinicalDocument']/*[local-name()='localHeader']/*[local-name()='fileFormat']/@code");
            if (this.log4j.isDebugEnabled()) {
                this.log4j.debug((Object)this.logHelper.formatMsg("fileFormat(pdf3,text4,xhtml6): " + fileFormat));
            }
            if (this.checkPdf && fileFormat.equals("3")) {
                this.oldDocValidator.validatePdfA(logId, xpathHelperVTD.getCode("/ClinicalDocument/component/nonXMLBody/text/text()"), this.validatePdf, hoitoasiakirja);
            }
            if (this.validateXhtml && fileFormat.equals(FILEFORMAT_XHTML)) {
                this.oldDocValidator.validateXhtml(logId, xpathHelperVTD.getCode("/ClinicalDocument/component/nonXMLBody/text/text()"), hoitoasiakirja);
            }
            if (this.checkTextPlain && fileFormat.equals(FILEFORMAT_TEXT)) {
                this.oldDocValidator.validateTextPlainBase64(logId, xpathHelperVTD.getCode("/ClinicalDocument/component/nonXMLBody/text/text()"), hoitoasiakirja);
            }
            DctmAttributesSave dctmAttrSave = xpathConfig.getDctmAttributesSave();
            HashMap<String, DctmAttribute> saveAttrMap = new HashMap<String, DctmAttribute>();
            for (DctmAttribute dctmAttr : dctmAttrSave.getDctmAttribute()) {
                saveAttrMap.put(dctmAttr.getName(), dctmAttr);
            }
            DctmAttributesValidate dctmAttrValidate = xpathConfig.getDctmAttributesValidate();
            HashMap<String, DctmAttribute> validateAttrMap = new HashMap<String, DctmAttribute>();
            for (DctmAttribute dctmAttr : dctmAttrValidate.getDctmAttribute()) {
                validateAttrMap.put(dctmAttr.getName(), dctmAttr);
            }
            AsiakirjaHAReq.Asiakirja asiakirjaHA = new AsiakirjaHAReq.Asiakirja();
            this.setHAAsiakirjanTunnisteTiedot(logId, asiakirjaHA, xpathHelperVTD, saveAttrMap);
            this.setHAPotilaanTiedot(logId, asiakirjaHA, xpathHelperVTD, saveAttrMap);
            this.setHAAsiakirjanLaatijanTiedot(logId, asiakirjaHA, xpathHelperVTD, saveAttrMap);
            this.setHAAsiakirjanElinkaariTiedot(logId, asiakirjaHA, rekisterinpitaja, xpathHelperVTD, saveAttrMap, validateAttrMap);
            this.setHAAsiakirjanSisaltoTiedot(logId, asiakirjaHA, xpathHelperVTD, saveAttrMap);
            this.setHAAsiakirjanPalvelutapahtumaTiedot(logId, asiakirjaHA, asiakirjaPT, xpathHelperVTD, saveAttrMap);
            this.setHAOhjelmistonTiedot(logId, asiakirjaHA, xpathHelperVTD, saveAttrMap);
            this.setHAAllekirjoitusTiedot(logId, asiakirjaHA, xpathHelperVTD, signatureTimeStamp);
            this.attrValidator.validateCodesystems(logId, this.checkCodes);
            this.validatePTAndHAAsiakirjaTiedot(logId, asiakirjaHA, asiakirjaPT);
            asiakirjaHAReq.getAsiakirja().add(asiakirjaHA);
            List<InternalServiceError> attributeErrorList = this.attrValidator.getErrorList();
            List<InternalServiceError> validatorErrorList = this.oldDocValidator.getErrorList();
            if (!(attributeErrorList.isEmpty() && validatorErrorList.isEmpty() && this.errorList.isEmpty())) {
                new InternalServiceError();
                DbLogger errorLogger = new DbLogger();
                ArrayList<InternalServiceError> combinedlist = new ArrayList<InternalServiceError>();
                combinedlist.addAll(attributeErrorList);
                combinedlist.addAll(validatorErrorList);
                combinedlist.addAll(this.errorList);
                errorLogger.kirjaaVirhe(logId, combinedlist, hoitoasiakirja);
                throw new ValidatorException((InternalServiceError)combinedlist.get(0));
            }
            if (this.log4j.isDebugEnabled()) {
                this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
            }
        }
        catch (UtilException e) {
            this.log4j.error((Object)this.logHelper.formatMsg(logId), (Throwable)e);
            DbLogger dblogger = new DbLogger();
            dblogger.kirjaaVirhe(logId, e.getInternalServiceError().getErrorCode(), e.getInternalServiceError().getErrorMessage(), hoitoasiakirja);
            throw new ValidatorException(e.getInternalServiceError());
        }
        return asiakirjaHAReq;
    }

    private void setPTAsiakirjanTunnisteTiedot(String logId, AsiakirjaPTReq.Asiakirja asiakirjaPT, XPathHelperVTD xpathHelperVTD, Map<String, DctmAttribute> saveAttrMap) throws XPathHelperVTDException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        AsiakirjaPTReq.Asiakirja.AsiakirjanTunnisteTiedot asiakirjanTunnisteTiedot = new AsiakirjaPTReq.Asiakirja.AsiakirjanTunnisteTiedot();
        DctmAttribute attr = null;
        AttributeValueType attrValue = null;
        String value = null;
        attr = saveAttrMap.get("cda_id");
        attrValue = xpathHelperVTD.getIIValue(attr.getDctmAttributeXpath(), ".");
        value = attrValue.getOriginalValue();
        asiakirjanTunnisteTiedot.setCdaId(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("cda_set_id");
        attrValue = xpathHelperVTD.getIIValue(attr.getDctmAttributeXpath(), ".");
        value = attrValue.getOriginalValue();
        asiakirjanTunnisteTiedot.setCdaSetId(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        asiakirjaPT.setAsiakirjanTunnisteTiedot(asiakirjanTunnisteTiedot);
        attr = saveAttrMap.get("cda_versionnumber");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        asiakirjanTunnisteTiedot.setCdaVersionnumber(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        String version = this.getMetadataValue(logId, asiakirjanTunnisteTiedot.getCdaVersionnumber());
        if (version == null || !"1".equals(version)) {
            InternalServiceError error = this.errorWrapper.getError("0006");
            this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
            this.errorList.add(error);
        }
        asiakirjaPT.setAsiakirjanTunnisteTiedot(asiakirjanTunnisteTiedot);
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void setPTPotilaanTiedot(String logId, AsiakirjaPTReq.Asiakirja asiakirjaPT, XPathHelperVTD xpathHelperVTD, Map<String, DctmAttribute> saveAttrMap) throws XPathHelperVTDException, UtilException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        AsiakirjaPTReq.Asiakirja.PotilaanTiedot potilaanTiedot = new AsiakirjaPTReq.Asiakirja.PotilaanTiedot();
        DctmAttribute attr = null;
        AttributeValueType attrValue = null;
        String value = null;
        List attrValues = null;
        List<Object> values = new ArrayList();
        attr = saveAttrMap.get("cda_patient_id");
        attrValue = xpathHelperVTD.getIIValue(attr.getDctmAttributeXpath(), ".");
        String potilaanHetu = attrValue.getOriginalValue();
        potilaanTiedot.setCdaPatientId(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, potilaanHetu, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("cda_temp_patient_id");
        attrValue = xpathHelperVTD.getIIValue(attr.getDctmAttributeXpath(), ".");
        String potilaanTempHetu = attrValue.getOriginalValue();
        potilaanTiedot.setCdaTempPatientId(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, potilaanTempHetu, attr), attr.getDctmAttributeType()));
        this.validatePakollinenHetu(potilaanHetu, potilaanTempHetu);
        attr = saveAttrMap.get("cda_patient_birthtime");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        potilaanTiedot.setCdaPatientBirthtime(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("cda_patient_familyname");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        potilaanTiedot.setCdaPatientFamilyname(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("cda_patient_givennames");
        attrValues = xpathHelperVTD.getValuesFromNodeList(attr.getDctmAttributeXpath());
        values = OldDocumentMetadataReader.getValues(attrValues);
        if (values != null && values.size() == 1) {
            potilaanTiedot.setCdaPatientGivennames(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, values, attr, ""), attr.getDctmAttributeType()));
        } else {
            potilaanTiedot.setCdaPatientGivennames(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, values, attr, " "), attr.getDctmAttributeType()));
        }
        attr = saveAttrMap.get("cda_patient_gender");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        potilaanTiedot.setCdaPatientGender(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("cda_patient_firstname");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        potilaanTiedot.setCdaPatientFirstname(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("cda_patient_prefix");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        potilaanTiedot.setCdaPatientPrefix(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("cda_p_homemunicipality");
        attrValue = xpathHelperVTD.getCVvalue(attr.getDctmAttributeXpath(), "!");
        value = attrValue.getOriginalValue();
        if (value != null && value.length() > 0) {
            potilaanTiedot.setCdaPHomemunicipality(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        }
        this.validatePTPotilaanTiedot(logId, potilaanTiedot, xpathHelperVTD);
        asiakirjaPT.setPotilaanTiedot(potilaanTiedot);
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void validatePakollinenHetu(String potilaanHetu, String potilaanTempHetu) throws UtilException {
        if ((potilaanHetu == null || "".equals(potilaanHetu.trim())) && (potilaanTempHetu == null || "".equals(potilaanTempHetu.trim()))) {
            InternalServiceError error = this.errorWrapper.getError("0024");
            this.log4j.error((Object)this.logHelper.formatMsg(this.logId, error));
            throw new UtilException(error);
        }
    }

    private void setPTAsiakirjanLaatijanTiedot(String logId, AsiakirjaPTReq.Asiakirja asiakirjaPT, XPathHelperVTD xpathHelperVTD, Map<String, DctmAttribute> saveAttrMap) throws XPathHelperVTDException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        AsiakirjaPTReq.Asiakirja.AsiakirjanLaatijanTiedot asiakirjanLaatijanTiedot = new AsiakirjaPTReq.Asiakirja.AsiakirjanLaatijanTiedot();
        DctmAttribute attr = null;
        attr = saveAttrMap.get("cda_author_id");
        List<ObjectRelativeXpath> expressionList = this.createAuthorExpressionList(logId);
        List objectValues = xpathHelperVTD.getValueObjectsFromNodeListInclEmpty(attr.getDctmAttributeXpath(), expressionList);
        String separator = " ";
        if (objectValues != null && objectValues.size() > 1) {
            separator = " @";
        }
        List<String> values = this.getAuthorIds(logId, objectValues);
        String hetu = this.attrValidator.validate(logId, values, attr, separator);
        asiakirjanLaatijanTiedot.setCdaAuthorId(this.getMetadataObject(logId, attr.getName(), hetu, MetadataAttrType.S.value()));
        this.validoiLaatijanTiedot(logId, xpathHelperVTD, hetu, separator);
        asiakirjaPT.setAsiakirjanLaatijanTiedot(asiakirjanLaatijanTiedot);
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void setPTAsiakirjanElinkaariTiedot(String logId, AsiakirjaPTReq.Asiakirja asiakirjaPT, String rekisterinpitaja, XPathHelperVTD xpathHelperVTD, Map<String, DctmAttribute> saveAttrMap, Map<String, DctmAttribute> validateAttrMap) throws XPathHelperVTDException, UtilException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        AsiakirjaPTReq.Asiakirja.AsiakirjanElinkaariTiedot asiakirjanElinkaariTiedot = new AsiakirjaPTReq.Asiakirja.AsiakirjanElinkaariTiedot();
        DctmAttribute attr = null;
        AttributeValueType attrValue = null;
        String value = null;
        attr = saveAttrMap.get("cda_effectivetime");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        this.oldDocValidator.checkEffectiveTime(logId, value);
        asiakirjanElinkaariTiedot.setCdaEffectivetime(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("cda_custodian");
        attrValue = xpathHelperVTD.getIIValue(attr.getDctmAttributeXpath(), ".");
        value = attrValue.getOriginalValue();
        if (value == null || !value.equals(rekisterinpitaja)) {
            InternalServiceError error = this.errorWrapper.getError("0027");
            if (value != null) {
                error.setErrorMessage(error.getErrorMessage() + " " + value);
            }
            this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
            this.errorList.add(error);
        } else {
            asiakirjanElinkaariTiedot.setCdaCustodian(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
            this.aseta2020rekisterinpitajaPT(logId, value, asiakirjanElinkaariTiedot);
        }
        attr = saveAttrMap.get("cda_code");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        asiakirjanElinkaariTiedot.setCdaCode(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("hl7fi_pat_reg_specifier");
        StringBuffer sbExpression = new StringBuffer(attr.getDctmAttributeXpath());
        String rootValue = xpathHelperVTD.getCode(sbExpression.append("/@root").toString());
        sbExpression = new StringBuffer(attr.getDctmAttributeXpath());
        String extensionValue = xpathHelperVTD.getCode(sbExpression.append("/@extension").toString());
        value = rootValue != null && rootValue.equals("1.2.246.21") ? this.oldDocValidator.parseHetuString(logId, rootValue, extensionValue) : this.oldDocValidator.parseYTunnusString(logId, rootValue, extensionValue);
        asiakirjanElinkaariTiedot.setHl7FiPatRegSpecifier(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("hl7fi_pat_reg_spec_name");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        asiakirjanElinkaariTiedot.setHl7FiPatRegSpecName(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("hl7fi_functioncode");
        attrValue = xpathHelperVTD.getCVvalue(attr.getDctmAttributeXpath(), "!");
        value = attrValue.getOriginalValue();
        asiakirjanElinkaariTiedot.setHl7FiFunctioncode(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("hl7fi_retentionperiodclass");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        asiakirjanElinkaariTiedot.setHl7FiRetentionperiodclass(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("cda_title");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        asiakirjanElinkaariTiedot.setCdaTitle(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("ar_record_type");
        attrValue = xpathHelperVTD.getCVvalue(attr.getDctmAttributeXpath(), "!");
        value = attrValue.getOriginalValue();
        asiakirjanElinkaariTiedot.setArRecordType(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("hl7fi_typecode");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        asiakirjanElinkaariTiedot.setHl7FiTypecode(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("cda_confidentialitycode");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        asiakirjanElinkaariTiedot.setCdaConfidentialitycode(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        this.validatePTAsiakirjanElinkaariTiedot(logId, asiakirjanElinkaariTiedot, xpathHelperVTD, validateAttrMap);
        asiakirjaPT.setAsiakirjanElinkaariTiedot(asiakirjanElinkaariTiedot);
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void aseta2020rekisterinpitajaPT(String logId, String custodian, AsiakirjaPTReq.Asiakirja.AsiakirjanElinkaariTiedot asiakirjanElinkaariTiedot) throws UtilException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
            this.log4j.debug((Object)executionMode.getMode());
            this.log4j.debug((Object)this.set2020custodian);
        }
        if (executionMode.getMode().equals("ARKISTOINTI") && this.set2020custodian) {
            MaakuntaRekisterinpitajaTiedot maakuntarekisterinpitaja = null;
            if (rekisterinpitajaCache.containsKey((Object)custodian)) {
                maakuntarekisterinpitaja = (MaakuntaRekisterinpitajaTiedot)rekisterinpitajaCache.get((Object)custodian);
            } else {
                RekisterinPitajapalveluClient client = new RekisterinPitajapalveluClient();
                maakuntarekisterinpitaja = client.getMaakuntaRekisterinpitaja(logId, custodian, "");
                if (maakuntarekisterinpitaja == null || maakuntarekisterinpitaja.getRekisterinpitajat() == null || maakuntarekisterinpitaja.getRekisterinpitajat().isEmpty()) {
                    rekisterinpitajaCache.put((Object)custodian, (Object)new MaakuntaRekisterinpitajaTiedot());
                } else {
                    rekisterinpitajaCache.put((Object)custodian, (Object)maakuntarekisterinpitaja);
                }
            }
            if (maakuntarekisterinpitaja != null && maakuntarekisterinpitaja.getRekisterinpitajat() != null && !maakuntarekisterinpitaja.getRekisterinpitajat().isEmpty()) {
                MetadataObjectType countyCustodian = this.getMetadataObject(logId, CDA_COUNTY_CUSTODIAN, maakuntarekisterinpitaja.getRekisterinpitajat().get(0).getMaakuntaRekisterinpitaja(), "S");
                asiakirjanElinkaariTiedot.setCdaCountyCustodian(countyCustodian);
                MetadataObjectType countyCustodianName = this.getMetadataObject(logId, CDA_COUNTY_CUSTODIAN_NAME, maakuntarekisterinpitaja.getRekisterinpitajat().get(0).getMaakuntaRekisterinpitajaNimi(), "S");
                asiakirjanElinkaariTiedot.setCdaCountyCustodianName(countyCustodianName);
            }
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void setPTAsiakirjanSisaltoTiedot(String logId, AsiakirjaPTReq.Asiakirja asiakirjaPT, XPathHelperVTD xpathHelperVTD, Map<String, DctmAttribute> saveAttrMap) throws XPathHelperVTDException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        AsiakirjaPTReq.Asiakirja.AsiakirjanSisaltoTiedot asiakirjanSisaltoTiedot = new AsiakirjaPTReq.Asiakirja.AsiakirjanSisaltoTiedot();
        DctmAttribute attr = null;
        String value = null;
        attr = saveAttrMap.get("hl7fi_fileformat");
        AttributeValueType attrValue = xpathHelperVTD.getCVvalue(attr.getDctmAttributeXpath(), "!");
        value = attrValue.getOriginalValue();
        asiakirjanSisaltoTiedot.setHl7FiFileformat(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("cda_languagecode");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        asiakirjanSisaltoTiedot.setCdaLanguagecode(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        asiakirjaPT.setAsiakirjanSisaltoTiedot(asiakirjanSisaltoTiedot);
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void setPTAsiakirjanPalvelutapahtumaTiedot(String logId, AsiakirjaPTReq.Asiakirja asiakirjaPT, XPathHelperVTD xpathHelperVTD, Map<String, DctmAttribute> saveAttrMap) throws XPathHelperVTDException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        AsiakirjaPTReq.Asiakirja.PalvelutapahtumanTiedot palvelutapahtumanTiedot = new AsiakirjaPTReq.Asiakirja.PalvelutapahtumanTiedot();
        DctmAttribute attr = null;
        AttributeValueType attrValue = null;
        String value = null;
        List attrValues = null;
        List<String> values = null;
        attr = saveAttrMap.get("encompassing_encounter_id");
        attrValue = xpathHelperVTD.getIIValue(attr.getDctmAttributeXpath(), ".");
        value = attrValue.getOriginalValue();
        palvelutapahtumanTiedot.setEncompassingEncounterId(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("cda_rep_org_id");
        attrValue = xpathHelperVTD.getIIValue(attr.getDctmAttributeXpath(), ".");
        value = attrValue.getOriginalValue();
        palvelutapahtumanTiedot.setCdaRepOrgId(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("cda_rep_org_host_id");
        attrValue = xpathHelperVTD.getIIValue(attr.getDctmAttributeXpath(), ".");
        value = attrValue.getOriginalValue();
        palvelutapahtumanTiedot.setCdaRepOrgHostId(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("cda_rep_org_name");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        palvelutapahtumanTiedot.setCdaRepOrgName(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("encomp_enc_participants");
        attrValues = xpathHelperVTD.getIIvaluesFromNodeList(attr.getDctmAttributeXpath(), ".");
        values = OldDocumentMetadataReader.getValues(attrValues);
        palvelutapahtumanTiedot.setEncompEncParticipants(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, values, attr, " "), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("encomp_enc_part_name");
        attrValues = xpathHelperVTD.getValuesFromNodeList(attr.getDctmAttributeXpath(), "assignedEntity/representedOrganization/name");
        values = OldDocumentMetadataReader.getValues(attrValues);
        palvelutapahtumanTiedot.setEncompEncPartName(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, values, attr, "*|*"), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("enc_part_host_id");
        attrValues = xpathHelperVTD.getIIvaluesFromNodeList(attr.getDctmAttributeXpath(), "assignedEntity/representedOrganization/asOrganizationPartOf/id");
        values = OldDocumentMetadataReader.getValues(attrValues);
        palvelutapahtumanTiedot.setEncPartHostId(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, values, attr, "*|*"), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("encomp_enc_time_low");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        palvelutapahtumanTiedot.setEncompEncTimeLow(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("encomp_enc_time_high");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        palvelutapahtumanTiedot.setEncompEncTimeHigh(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("encomp_enc_code");
        attrValue = xpathHelperVTD.getCVvalue(attr.getDctmAttributeXpath(), "!");
        value = attrValue.getOriginalValue();
        palvelutapahtumanTiedot.setEncompEncCode(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("hl7fi_custodiantypecode");
        attrValue = xpathHelperVTD.getCVvalue(attr.getDctmAttributeXpath(), "!");
        value = attrValue.getOriginalValue();
        palvelutapahtumanTiedot.setHl7FiCustodiantypecode(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("hl7fi_outsourcing_customer");
        attrValue = xpathHelperVTD.getIIValue(attr.getDctmAttributeXpath(), ".");
        value = attrValue.getOriginalValue();
        palvelutapahtumanTiedot.setHl7FiOutsourcingCustomer(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("hl7fi_outs_cust_name");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        palvelutapahtumanTiedot.setHl7FiOutsCustName(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("cda_serviceeventcodes");
        attrValues = xpathHelperVTD.getUniqueCVvaluesFromNodeList(attr.getDctmAttributeXpath(), "!", false);
        values = OldDocumentMetadataReader.getValues(attrValues);
        palvelutapahtumanTiedot.setCdaServiceeventcodes(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, values, attr, "."), attr.getDctmAttributeType()));
        attr = new DctmAttribute();
        attr.setName("hl7fi_serv_chainlinks");
        attr.setIsNodelist(true);
        attr.setAttributeMinLength(BigInteger.valueOf(0L));
        attr.setAttributeMaxLength(BigInteger.valueOf(128L));
        attr.setAttributeMaxLengthTotal(BigInteger.valueOf(2000L));
        attr.setDctmAttributeType(MetadataAttrType.II.value());
        attr.setDefaultNamespace(false);
        attr.setDctmAttributeXpath("/*[local-name()='ClinicalDocument']/*[local-name()='localHeader']/*[local-name()='serviceChainLink']");
        attrValues = xpathHelperVTD.getIIvaluesFromNodeList(attr.getDctmAttributeXpath(), "*[local-name()='serviceChainLinkId']", ".");
        values = OldDocumentMetadataReader.getValues(attrValues);
        palvelutapahtumanTiedot.setHl7FiServChainlinks(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, values, attr, "*|*"), attr.getDctmAttributeType()));
        attr = new DctmAttribute();
        attr.setName("hl7fi_serv_chain_names");
        attr.setIsNodelist(true);
        attr.setAttributeMinLength(BigInteger.valueOf(0L));
        attr.setAttributeMaxLength(BigInteger.valueOf(128L));
        attr.setAttributeMaxLengthTotal(BigInteger.valueOf(2000L));
        attr.setDctmAttributeType(MetadataAttrType.S.value());
        attr.setDefaultNamespace(false);
        attr.setDctmAttributeXpath("/*[local-name()='ClinicalDocument']/*[local-name()='localHeader']/*[local-name()='serviceChainLink']");
        attrValues = xpathHelperVTD.getValuesFromNodeList(attr.getDctmAttributeXpath(), "*[local-name()='serviceChainLinkName']");
        values = OldDocumentMetadataReader.getValues(attrValues);
        palvelutapahtumanTiedot.setHl7FiServChainNames(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, values, attr, "*|*"), attr.getDctmAttributeType()));
        attr = new DctmAttribute();
        attr.setName("hl7fi_serv_chain_codes");
        attr.setIsNodelist(true);
        attr.setAttributeMinLength(BigInteger.valueOf(0L));
        attr.setAttributeMaxLength(BigInteger.valueOf(128L));
        attr.setAttributeMaxLengthTotal(BigInteger.valueOf(2000L));
        attr.setDctmAttributeType(MetadataAttrType.CV.value());
        attr.setDefaultNamespace(false);
        attr.setDctmAttributeXpath("/*[local-name()='ClinicalDocument']/*[local-name()='localHeader']/*[local-name()='serviceChainLink']/*[local-name()='serviceChainLinkCode']");
        attrValues = xpathHelperVTD.getUniqueCVvaluesFromNodeList(attr.getDctmAttributeXpath(), "!", false);
        values = OldDocumentMetadataReader.getValues(attrValues);
        palvelutapahtumanTiedot.setHl7FiServChainCodes(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, values, attr, "*|*"), attr.getDctmAttributeType()));
        asiakirjaPT.setPalvelutapahtumanTiedot(palvelutapahtumanTiedot);
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void setPTOhjelmistonTiedot(String logId, AsiakirjaPTReq.Asiakirja asiakirjaPT, XPathHelperVTD xpathHelperVTD, Map<String, DctmAttribute> saveAttrMap) throws XPathHelperVTDException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        AsiakirjaPTReq.Asiakirja.OhjelmistonTiedot ohjelmistonTiedot = new AsiakirjaPTReq.Asiakirja.OhjelmistonTiedot();
        DctmAttribute attr = null;
        String value = null;
        attr = saveAttrMap.get("hl7fi_softwaresupport");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        ohjelmistonTiedot.setHl7FiSoftwaresupport(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("hl7fi_softwareversion");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        ohjelmistonTiedot.setHl7FiSoftwareversion(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        asiakirjaPT.setOhjelmistonTiedot(ohjelmistonTiedot);
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void setPTAllekirjoitusTiedot(String logId, AsiakirjaPTReq.Asiakirja asiakirjaPT, String signatureExpirationDate) {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        AsiakirjaPTReq.Asiakirja.AsiakirjanAllekirjoitusTiedot allekirjoitusTiedot = new AsiakirjaPTReq.Asiakirja.AsiakirjanAllekirjoitusTiedot();
        DctmAttribute attr = null;
        attr = new DctmAttribute();
        attr.setName("cda_sigexpirationdate");
        attr.setIsNodelist(false);
        attr.setAttributeMinLength(BigInteger.valueOf(0L));
        attr.setAttributeMaxLength(BigInteger.valueOf(32L));
        attr.setDctmAttributeType(MetadataAttrType.T.value());
        attr.setDefaultNamespace(false);
        attr.setDctmAttributeXpath("/*[local-name()='ClinicalDocument']/*[local-name()='localHeader']/*[local-name()='signatureCollection']/*[local-name()='signature']/*[local-name()='signatureTimestamp']");
        allekirjoitusTiedot.setCdaSigexpirationdate(this.getMetadataObject(logId, attr.getName(), signatureExpirationDate, attr.getDctmAttributeType()));
        asiakirjaPT.setAsiakirjanAllekirjoitusTiedot(allekirjoitusTiedot);
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void setHAAsiakirjanTunnisteTiedot(String logId, AsiakirjaHAReq.Asiakirja asiakirjaHA, XPathHelperVTD xpathHelperVTD, Map<String, DctmAttribute> saveAttrMap) throws XPathHelperVTDException, UtilException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        AsiakirjaHAReq.Asiakirja.AsiakirjanTunnisteTiedot asiakirjanTunnisteTiedot = new AsiakirjaHAReq.Asiakirja.AsiakirjanTunnisteTiedot();
        DctmAttribute attr = null;
        AttributeValueType attrValue = null;
        String value = null;
        attr = saveAttrMap.get("cda_id");
        attrValue = xpathHelperVTD.getIIValue(attr.getDctmAttributeXpath(), ".");
        value = attrValue.getOriginalValue();
        asiakirjanTunnisteTiedot.setCdaId(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("cda_set_id");
        attrValue = xpathHelperVTD.getIIValue(attr.getDctmAttributeXpath(), ".");
        value = attrValue.getOriginalValue();
        asiakirjanTunnisteTiedot.setCdaSetId(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        asiakirjaHA.setAsiakirjanTunnisteTiedot(asiakirjanTunnisteTiedot);
        attr = saveAttrMap.get("cda_versionnumber");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        asiakirjanTunnisteTiedot.setCdaVersionnumber(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        String version = this.getMetadataValue(logId, asiakirjanTunnisteTiedot.getCdaVersionnumber());
        if (version == null || !"1".equals(version)) {
            InternalServiceError error = this.errorWrapper.getError("0006");
            this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
            throw new UtilException(error);
        }
        asiakirjaHA.setAsiakirjanTunnisteTiedot(asiakirjanTunnisteTiedot);
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void setHAPotilaanTiedot(String logId, AsiakirjaHAReq.Asiakirja asiakirjaHA, XPathHelperVTD xpathHelperVTD, Map<String, DctmAttribute> saveAttrMap) throws XPathHelperVTDException, UtilException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        AsiakirjaHAReq.Asiakirja.PotilaanTiedot potilaanTiedot = new AsiakirjaHAReq.Asiakirja.PotilaanTiedot();
        DctmAttribute attr = null;
        AttributeValueType attrValue = null;
        String value = null;
        List attrValues = null;
        List<String> values = null;
        attr = saveAttrMap.get("cda_patient_id");
        attrValue = xpathHelperVTD.getIIValue(attr.getDctmAttributeXpath(), ".");
        String potilaanHetu = attrValue.getOriginalValue();
        potilaanTiedot.setCdaPatientId(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, potilaanHetu, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("cda_temp_patient_id");
        attrValue = xpathHelperVTD.getIIValue(attr.getDctmAttributeXpath(), ".");
        String potilaanTempHetu = attrValue.getOriginalValue();
        potilaanTiedot.setCdaTempPatientId(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, potilaanTempHetu, attr), attr.getDctmAttributeType()));
        this.validatePakollinenHetu(potilaanHetu, potilaanTempHetu);
        attr = saveAttrMap.get("cda_patient_birthtime");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        potilaanTiedot.setCdaPatientBirthtime(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("cda_patient_familyname");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        potilaanTiedot.setCdaPatientFamilyname(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("cda_patient_givennames");
        attrValues = xpathHelperVTD.getValuesFromNodeList(attr.getDctmAttributeXpath());
        values = OldDocumentMetadataReader.getValues(attrValues);
        if (values != null && values.size() == 1) {
            potilaanTiedot.setCdaPatientGivennames(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, values, attr, ""), attr.getDctmAttributeType()));
        } else {
            potilaanTiedot.setCdaPatientGivennames(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, values, attr, " "), attr.getDctmAttributeType()));
        }
        attr = saveAttrMap.get("cda_patient_gender");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        potilaanTiedot.setCdaPatientGender(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("cda_patient_firstname");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        potilaanTiedot.setCdaPatientFirstname(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("cda_patient_prefix");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        potilaanTiedot.setCdaPatientPrefix(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        this.validateHAPotilaanTiedot(logId, potilaanTiedot, xpathHelperVTD);
        asiakirjaHA.setPotilaanTiedot(potilaanTiedot);
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void setHAAsiakirjanLaatijanTiedot(String logId, AsiakirjaHAReq.Asiakirja asiakirjaHA, XPathHelperVTD xpathHelperVTD, Map<String, DctmAttribute> saveAttrMap) throws XPathHelperVTDException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        AsiakirjaHAReq.Asiakirja.AsiakirjanLaatijanTiedot asiakirjanLaatijanTiedot = new AsiakirjaHAReq.Asiakirja.AsiakirjanLaatijanTiedot();
        DctmAttribute attr = null;
        attr = saveAttrMap.get("cda_author_id");
        List<ObjectRelativeXpath> expressionList = this.createAuthorExpressionList(logId);
        List objectValues = xpathHelperVTD.getValueObjectsFromNodeListInclEmpty(attr.getDctmAttributeXpath(), expressionList);
        String separator = " ";
        if (objectValues != null && objectValues.size() > 1) {
            separator = " @";
        }
        List<String> values = this.getAuthorIds(logId, objectValues);
        String hetu = this.attrValidator.validate(logId, values, attr, separator);
        asiakirjanLaatijanTiedot.setCdaAuthorId(this.getMetadataObject(logId, attr.getName(), hetu, MetadataAttrType.S.value()));
        asiakirjaHA.setAsiakirjanLaatijanTiedot(asiakirjanLaatijanTiedot);
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void setHAAsiakirjanElinkaariTiedot(String logId, AsiakirjaHAReq.Asiakirja asiakirjaHA, String rekisterinpitaja, XPathHelperVTD xpathHelperVTD, Map<String, DctmAttribute> saveAttrMap, Map<String, DctmAttribute> validateAttrMap) throws XPathHelperVTDException, UtilException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        AsiakirjaHAReq.Asiakirja.AsiakirjanElinkaariTiedot asiakirjanElinkaariTiedot = new AsiakirjaHAReq.Asiakirja.AsiakirjanElinkaariTiedot();
        DctmAttribute attr = null;
        AttributeValueType attrValue = null;
        String value = null;
        attr = saveAttrMap.get("cda_effectivetime");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        this.oldDocValidator.checkEffectiveTime(logId, value);
        asiakirjanElinkaariTiedot.setCdaEffectivetime(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("cda_custodian");
        attrValue = xpathHelperVTD.getIIValue(attr.getDctmAttributeXpath(), ".");
        value = attrValue.getOriginalValue();
        if (value == null || !value.equals(rekisterinpitaja)) {
            InternalServiceError error = this.errorWrapper.getError("0027");
            if (value != null) {
                error.setErrorMessage(error.getErrorMessage() + " " + value);
            }
            this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
            throw new UtilException(error);
        }
        asiakirjanElinkaariTiedot.setCdaCustodian(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        this.aseta2020rekisterinpitajaHA(logId, value, asiakirjanElinkaariTiedot);
        attr = saveAttrMap.get("cda_code");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        asiakirjanElinkaariTiedot.setCdaCode(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("hl7fi_pat_reg_specifier");
        StringBuffer sbExpression = new StringBuffer(attr.getDctmAttributeXpath());
        String rootValue = xpathHelperVTD.getCode(sbExpression.append("/@root").toString());
        sbExpression = new StringBuffer(attr.getDctmAttributeXpath());
        String extensionValue = xpathHelperVTD.getCode(sbExpression.append("/@extension").toString());
        value = rootValue != null && rootValue.equals("1.2.246.21") ? this.oldDocValidator.parseHetuString(logId, rootValue, extensionValue) : this.oldDocValidator.parseYTunnusString(logId, rootValue, extensionValue);
        asiakirjanElinkaariTiedot.setHl7FiPatRegSpecifier(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("hl7fi_pat_reg_spec_name");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        asiakirjanElinkaariTiedot.setHl7FiPatRegSpecName(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("hl7fi_functioncode");
        attrValue = xpathHelperVTD.getCVvalue(attr.getDctmAttributeXpath(), "!");
        value = attrValue.getOriginalValue();
        asiakirjanElinkaariTiedot.setHl7FiFunctioncode(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("hl7fi_retentionperiodclass");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        asiakirjanElinkaariTiedot.setHl7FiRetentionperiodclass(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("cda_title");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        asiakirjanElinkaariTiedot.setCdaTitle(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("ar_record_type");
        attrValue = xpathHelperVTD.getCVvalue(attr.getDctmAttributeXpath(), "!");
        value = attrValue.getOriginalValue();
        asiakirjanElinkaariTiedot.setArRecordType(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("hl7fi_typecode");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        asiakirjanElinkaariTiedot.setHl7FiTypecode(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("cda_confidentialitycode");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        asiakirjanElinkaariTiedot.setCdaConfidentialitycode(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        this.validateHAAsiakirjanElinkaariTiedot(logId, asiakirjanElinkaariTiedot, xpathHelperVTD, validateAttrMap);
        asiakirjaHA.setAsiakirjanElinkaariTiedot(asiakirjanElinkaariTiedot);
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void aseta2020rekisterinpitajaHA(String logId, String custodian, AsiakirjaHAReq.Asiakirja.AsiakirjanElinkaariTiedot asiakirjanElinkaariTiedot) throws UtilException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
            this.log4j.debug((Object)executionMode.getMode());
            this.log4j.debug((Object)this.set2020custodian);
        }
        if (executionMode.getMode().equals("ARKISTOINTI") && this.set2020custodian) {
            MaakuntaRekisterinpitajaTiedot maakuntarekisterinpitaja = null;
            if (rekisterinpitajaCache.containsKey((Object)custodian)) {
                maakuntarekisterinpitaja = (MaakuntaRekisterinpitajaTiedot)rekisterinpitajaCache.get((Object)custodian);
            } else {
                RekisterinPitajapalveluClient client = new RekisterinPitajapalveluClient();
                maakuntarekisterinpitaja = client.getMaakuntaRekisterinpitaja(logId, custodian, "");
                if (maakuntarekisterinpitaja == null || maakuntarekisterinpitaja.getRekisterinpitajat() == null || maakuntarekisterinpitaja.getRekisterinpitajat().isEmpty()) {
                    rekisterinpitajaCache.put((Object)custodian, (Object)new MaakuntaRekisterinpitajaTiedot());
                } else {
                    rekisterinpitajaCache.put((Object)custodian, (Object)maakuntarekisterinpitaja);
                }
            }
            if (maakuntarekisterinpitaja != null && maakuntarekisterinpitaja.getRekisterinpitajat() != null && !maakuntarekisterinpitaja.getRekisterinpitajat().isEmpty()) {
                MetadataObjectType countyCustodian = this.getMetadataObject(logId, CDA_COUNTY_CUSTODIAN, maakuntarekisterinpitaja.getRekisterinpitajat().get(0).getMaakuntaRekisterinpitaja(), "S");
                asiakirjanElinkaariTiedot.setCdaCountyCustodian(countyCustodian);
                MetadataObjectType countyCustodianName = this.getMetadataObject(logId, CDA_COUNTY_CUSTODIAN_NAME, maakuntarekisterinpitaja.getRekisterinpitajat().get(0).getMaakuntaRekisterinpitajaNimi(), "S");
                asiakirjanElinkaariTiedot.setCdaCountyCustodianName(countyCustodianName);
            }
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void setHAAsiakirjanSisaltoTiedot(String logId, AsiakirjaHAReq.Asiakirja asiakirjaHA, XPathHelperVTD xpathHelperVTD, Map<String, DctmAttribute> saveAttrMap) throws XPathHelperVTDException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        AsiakirjaHAReq.Asiakirja.AsiakirjanSisaltoTiedot asiakirjanSisaltoTiedot = new AsiakirjaHAReq.Asiakirja.AsiakirjanSisaltoTiedot();
        DctmAttribute attr = null;
        AttributeValueType attrValue = null;
        String value = null;
        List attrValues = null;
        List<String> values = null;
        attr = saveAttrMap.get("hl7fi_toc_contents_codes");
        attrValues = xpathHelperVTD.getUniqueCVvaluesFromNodeList(attr.getDctmAttributeXpath(), "!", false);
        values = OldDocumentMetadataReader.getValues(attrValues);
        this.attrValidator.validate(logId, values, attr, " ");
        attr = new DctmAttribute();
        attr.setName("hl7fi_toc_contents_codes");
        attr.setIsNodelist(true);
        attr.setAttributeMinLength(BigInteger.valueOf(0L));
        attr.setAttributeMaxLength(BigInteger.valueOf(128L));
        attr.setAttributeMaxLengthTotal(BigInteger.valueOf(2000L));
        attr.setDctmAttributeType(MetadataAttrType.CV.value());
        attr.setDefaultNamespace(false);
        attr.setDctmAttributeXpath("/*[local-name()='ClinicalDocument']/*[local-name()='localHeader']/*[local-name()='tableOfContents']/*[local-name()='contentsCode'][not(@codeSystem='1.2.246.537.6.12.2002')]");
        List attrLocalTocValues = xpathHelperVTD.getUniqueCVvaluesFromNodeList(attr.getDctmAttributeXpath(), "!", false);
        attrLocalTocValues.addAll(attrValues);
        values = OldDocumentMetadataReader.getValues(attrLocalTocValues);
        asiakirjanSisaltoTiedot.setHl7FiTocContentsCodes(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, values, attr, " "), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("hl7fi_fileformat");
        attrValue = xpathHelperVTD.getCVvalue(attr.getDctmAttributeXpath(), "!");
        value = attrValue.getOriginalValue();
        asiakirjanSisaltoTiedot.setHl7FiFileformat(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("cda_languagecode");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        asiakirjanSisaltoTiedot.setCdaLanguagecode(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("hl7fi_sensitivedocument");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        asiakirjanSisaltoTiedot.setHl7FiSensitivedocument(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("cda_add_patientid");
        attrValue = xpathHelperVTD.getIIValue(attr.getDctmAttributeXpath(), ".");
        value = attrValue.getOriginalValue();
        asiakirjanSisaltoTiedot.setCdaAddPatientid(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("hl7fi_view_releasedate");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        asiakirjanSisaltoTiedot.setHl7FiViewReleasedate(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        asiakirjaHA.setAsiakirjanSisaltoTiedot(asiakirjanSisaltoTiedot);
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void setHAAsiakirjanPalvelutapahtumaTiedot(String logId, AsiakirjaHAReq.Asiakirja asiakirjaHA, AsiakirjaPTReq.Asiakirja asiakirjaPT, XPathHelperVTD xpathHelperVTD, Map<String, DctmAttribute> saveAttrMap) throws XPathHelperVTDException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        AsiakirjaHAReq.Asiakirja.PalvelutapahtumanTiedot palvelutapahtumanTiedot = new AsiakirjaHAReq.Asiakirja.PalvelutapahtumanTiedot();
        DctmAttribute attr = null;
        AttributeValueType attrValue = null;
        List attrValues = null;
        List<String> values = null;
        attr = saveAttrMap.get("encompassing_encounter_id");
        attrValue = xpathHelperVTD.getIIValue(attr.getDctmAttributeXpath(), ".");
        String value = attrValue.getOriginalValue();
        palvelutapahtumanTiedot.setEncompassingEncounterId(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("cda_rep_org_id");
        attrValue = xpathHelperVTD.getIIValue(attr.getDctmAttributeXpath(), ".");
        value = attrValue.getOriginalValue();
        palvelutapahtumanTiedot.setCdaRepOrgId(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("cda_rep_org_name");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        palvelutapahtumanTiedot.setCdaRepOrgName(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("encomp_enc_participants");
        attrValues = xpathHelperVTD.getIIvaluesFromNodeList(attr.getDctmAttributeXpath(), ".");
        values = OldDocumentMetadataReader.getValues(attrValues);
        palvelutapahtumanTiedot.setEncompEncParticipants(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, values, attr, " "), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("encomp_enc_part_name");
        attrValues = xpathHelperVTD.getValuesFromNodeList(attr.getDctmAttributeXpath(), "assignedEntity/representedOrganization/name");
        values = OldDocumentMetadataReader.getValues(attrValues);
        palvelutapahtumanTiedot.setEncompEncPartName(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, values, attr, "*|*"), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("enc_part_host_id");
        attrValues = xpathHelperVTD.getIIvaluesFromNodeList(attr.getDctmAttributeXpath() + "/assignedEntity/representedOrganization/asOrganizationPartOf/id", ".");
        values = OldDocumentMetadataReader.getValues(attrValues);
        palvelutapahtumanTiedot.setEncPartHostId(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, values, attr, "*|*"), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("hl7fi_custodiantypecode");
        attrValue = xpathHelperVTD.getCVvalue(attr.getDctmAttributeXpath(), "!");
        value = attrValue.getOriginalValue();
        palvelutapahtumanTiedot.setHl7FiCustodiantypecode(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        palvelutapahtumanTiedot.setHl7FiOutsourcingCustomer(asiakirjaPT.getPalvelutapahtumanTiedot().getHl7FiOutsourcingCustomer());
        palvelutapahtumanTiedot.setHl7FiOutsCustName(asiakirjaPT.getPalvelutapahtumanTiedot().getHl7FiOutsCustName());
        palvelutapahtumanTiedot.setHl7FiServChainlinks(asiakirjaPT.getPalvelutapahtumanTiedot().getHl7FiServChainlinks());
        palvelutapahtumanTiedot.setHl7FiServChainNames(asiakirjaPT.getPalvelutapahtumanTiedot().getHl7FiServChainNames());
        palvelutapahtumanTiedot.setHl7FiServChainCodes(asiakirjaPT.getPalvelutapahtumanTiedot().getHl7FiServChainCodes());
        palvelutapahtumanTiedot.setEncompEncTimeLow(this.getMetadataObject(logId, "encomp_enc_time_low", asiakirjaPT.getPalvelutapahtumanTiedot().getEncompEncTimeLow().getValue(), asiakirjaPT.getPalvelutapahtumanTiedot().getEncompEncTimeLow().getValueType().value()));
        if (asiakirjaPT.getPalvelutapahtumanTiedot().getEncompEncTimeHigh() != null) {
            palvelutapahtumanTiedot.setEncompEncTimeHigh(this.getMetadataObject(logId, "encomp_enc_time_high", asiakirjaPT.getPalvelutapahtumanTiedot().getEncompEncTimeHigh().getValue(), asiakirjaPT.getPalvelutapahtumanTiedot().getEncompEncTimeHigh().getValueType().value()));
        }
        if ((value = (attrValue = xpathHelperVTD.getIIValue((attr = saveAttrMap.get("cda_rep_org_id")).getDctmAttributeXpath(), ".")).getOriginalValue()) != null && value.length() > 0) {
            palvelutapahtumanTiedot.setCdaRepOrgId(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
            attr = saveAttrMap.get("cda_rep_org_name");
            value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
            palvelutapahtumanTiedot.setCdaRepOrgName(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        } else {
            palvelutapahtumanTiedot.setCdaRepOrgId(asiakirjaPT.getPalvelutapahtumanTiedot().getCdaRepOrgId());
            palvelutapahtumanTiedot.setCdaRepOrgName(asiakirjaPT.getPalvelutapahtumanTiedot().getCdaRepOrgName());
        }
        attr = saveAttrMap.get("cda_rep_org_host_id");
        attrValue = xpathHelperVTD.getIIValue(attr.getDctmAttributeXpath(), ".");
        value = attrValue.getOriginalValue();
        this.attrValidator.validate(logId, value, attr);
        if (value != null && value.length() > 0) {
            palvelutapahtumanTiedot.setCdaRepOrgHostId(this.getMetadataObject(logId, attr.getName(), value, attr.getDctmAttributeType()));
        } else {
            palvelutapahtumanTiedot.setCdaRepOrgHostId(asiakirjaPT.getPalvelutapahtumanTiedot().getCdaRepOrgHostId());
        }
        asiakirjaHA.setPalvelutapahtumanTiedot(palvelutapahtumanTiedot);
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void setHAOhjelmistonTiedot(String logId, AsiakirjaHAReq.Asiakirja asiakirjaHA, XPathHelperVTD xpathHelperVTD, Map<String, DctmAttribute> saveAttrMap) throws XPathHelperVTDException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        AsiakirjaHAReq.Asiakirja.OhjelmistonTiedot ohjelmistonTiedot = new AsiakirjaHAReq.Asiakirja.OhjelmistonTiedot();
        DctmAttribute attr = null;
        String value = null;
        attr = saveAttrMap.get("hl7fi_softwaresupport");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        ohjelmistonTiedot.setHl7FiSoftwaresupport(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        attr = saveAttrMap.get("hl7fi_softwareversion");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        ohjelmistonTiedot.setHl7FiSoftwareversion(this.getMetadataObject(logId, attr.getName(), this.attrValidator.validate(logId, value, attr), attr.getDctmAttributeType()));
        asiakirjaHA.setOhjelmistonTiedot(ohjelmistonTiedot);
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void setHAAllekirjoitusTiedot(String logId, AsiakirjaHAReq.Asiakirja asiakirjaHA, XPathHelperVTD xpathHelperVTD, String signatureExpirationDate) {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        AsiakirjaHAReq.Asiakirja.AsiakirjanAllekirjoitusTiedot allekirjoitusTiedot = new AsiakirjaHAReq.Asiakirja.AsiakirjanAllekirjoitusTiedot();
        DctmAttribute attr = null;
        attr = new DctmAttribute();
        attr.setName("cda_sigexpirationdate");
        attr.setIsNodelist(false);
        attr.setAttributeMinLength(BigInteger.valueOf(0L));
        attr.setAttributeMaxLength(BigInteger.valueOf(32L));
        attr.setDctmAttributeType(MetadataAttrType.T.value());
        attr.setDefaultNamespace(false);
        attr.setDctmAttributeXpath("/*[local-name()='ClinicalDocument']/*[local-name()='localHeader']/*[local-name()='signatureCollection']/*[local-name()='signature']/*[local-name()='signatureTimestamp']");
        allekirjoitusTiedot.setCdaSigexpirationdate(this.getMetadataObject(logId, attr.getName(), signatureExpirationDate, attr.getDctmAttributeType()));
        asiakirjaHA.setAsiakirjanAllekirjoitusTiedot(allekirjoitusTiedot);
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void validatePTAsiakirjanElinkaariTiedot(String logId, AsiakirjaPTReq.Asiakirja.AsiakirjanElinkaariTiedot asiakirjanElinkaariTiedot, XPathHelperVTD xpathHelperVTD, Map<String, DctmAttribute> validateAttrMap) throws UtilException, XPathHelperVTDException {
        DctmAttribute attr;
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        InternalServiceError error = null;
        String value = null;
        String cdaCode = this.getMetadataValue(logId, asiakirjanElinkaariTiedot.getCdaCode());
        if (cdaCode != null && !cdaCode.equals(FILEFORMAT_TEXT)) {
            value = this.getMetadataValue(logId, asiakirjanElinkaariTiedot.getHl7FiPatRegSpecifier());
            if (value != null && value.length() > 0) {
                error = this.errorWrapper.getError("0004");
                error.setErrorDescription("[hl7fi:patientRegistrySpecifier]");
                this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
                throw new UtilException(error);
            }
            value = this.getMetadataValue(logId, asiakirjanElinkaariTiedot.getHl7FiPatRegSpecName());
            if (value != null && value.length() > 0) {
                error = this.errorWrapper.getError("0004");
                error.setErrorDescription("[hl7fi:patientRegistrySpecifierName]");
                this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
                throw new UtilException(error);
            }
        } else {
            if (this.getMetadataValue(logId, asiakirjanElinkaariTiedot.getHl7FiPatRegSpecifier()) == null || this.getMetadataValue(logId, asiakirjanElinkaariTiedot.getHl7FiPatRegSpecifier()).length() < 1) {
                error = this.errorWrapper.getError("0005");
                error.setErrorDescription("[hl7fi:patientRegistrySpecifier]");
                this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
                throw new UtilException(error);
            }
            if (this.getMetadataValue(logId, asiakirjanElinkaariTiedot.getHl7FiPatRegSpecName()) == null || this.getMetadataValue(logId, asiakirjanElinkaariTiedot.getHl7FiPatRegSpecName()).length() < 1) {
                error = this.errorWrapper.getError("0005");
                error.setErrorDescription("[hl7fi:patientRegistrySpecifierName]");
                this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
                throw new UtilException(error);
            }
        }
        if (!"3".equals(this.attrValidator.validate(logId, value = xpathHelperVTD.getCode((attr = validateAttrMap.get("ar_record_status")).getDctmAttributeXpath()), attr))) {
            error = this.errorWrapper.getError("0009");
            error.setErrorDescription("[recordStatus]");
            this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
            throw new UtilException(error);
        }
        attr = validateAttrMap.get("validate_templateId");
        AttributeValueType attrValue = xpathHelperVTD.getIIValue(attr.getDctmAttributeXpath(), ".");
        value = attrValue.getOriginalValue();
        this.attrValidator.validate(logId, value, attr);
        attr = validateAttrMap.get("validate_assignedCustodian_name");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        this.attrValidator.validate(logId, value, attr);
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void validateHAAsiakirjanElinkaariTiedot(String logId, AsiakirjaHAReq.Asiakirja.AsiakirjanElinkaariTiedot asiakirjanElinkaariTiedot, XPathHelperVTD xpathHelperVTD, Map<String, DctmAttribute> validateAttrMap) throws UtilException, XPathHelperVTDException {
        DctmAttribute attr;
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        InternalServiceError error = null;
        String value = null;
        String cdaCode = this.getMetadataValue(logId, asiakirjanElinkaariTiedot.getCdaCode());
        if (cdaCode != null && !cdaCode.equals(FILEFORMAT_TEXT)) {
            value = this.getMetadataValue(logId, asiakirjanElinkaariTiedot.getHl7FiPatRegSpecifier());
            if (value != null && value.length() > 0) {
                error = this.errorWrapper.getError("0004");
                error.setErrorDescription("[hl7fi:patientRegistrySpecifier]");
                this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
                throw new UtilException(error);
            }
            value = this.getMetadataValue(logId, asiakirjanElinkaariTiedot.getHl7FiPatRegSpecName());
            if (value != null && value.length() > 0) {
                error = this.errorWrapper.getError("0004");
                error.setErrorDescription("[hl7fi:patientRegistrySpecifierName]");
                this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
                throw new UtilException(error);
            }
        } else {
            if (this.getMetadataValue(logId, asiakirjanElinkaariTiedot.getHl7FiPatRegSpecifier()) == null || this.getMetadataValue(logId, asiakirjanElinkaariTiedot.getHl7FiPatRegSpecifier()).length() < 1) {
                error = this.errorWrapper.getError("0005");
                error.setErrorDescription("[hl7fi:patientRegistrySpecifier]");
                this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
                throw new UtilException(error);
            }
            if (this.getMetadataValue(logId, asiakirjanElinkaariTiedot.getHl7FiPatRegSpecName()) == null || this.getMetadataValue(logId, asiakirjanElinkaariTiedot.getHl7FiPatRegSpecName()).length() < 1) {
                error = this.errorWrapper.getError("0005");
                error.setErrorDescription("[hl7fi:patientRegistrySpecifierName]");
                this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
                throw new UtilException(error);
            }
        }
        if (!"3".equals(this.attrValidator.validate(logId, value = xpathHelperVTD.getCode((attr = validateAttrMap.get("ar_record_status")).getDctmAttributeXpath()), attr))) {
            error = this.errorWrapper.getError("0009");
            error.setErrorDescription("[recordStatus]");
            this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
            throw new UtilException(error);
        }
        attr = validateAttrMap.get("validate_templateId");
        AttributeValueType attrValue = xpathHelperVTD.getIIValue(attr.getDctmAttributeXpath(), ".");
        value = attrValue.getOriginalValue();
        this.attrValidator.validate(logId, value, attr);
        attr = validateAttrMap.get("validate_assignedCustodian_name");
        value = xpathHelperVTD.getCode(attr.getDctmAttributeXpath());
        this.attrValidator.validate(logId, value, attr);
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void validatePTPotilaanTiedot(String logId, AsiakirjaPTReq.Asiakirja.PotilaanTiedot potilaanTiedot, XPathHelperVTD xpathHelperVTD) throws UtilException, XPathHelperVTDException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        String officialPatientId = this.getMetadataValue(logId, potilaanTiedot.getCdaPatientId());
        String tempPatientId = this.getMetadataValue(logId, potilaanTiedot.getCdaTempPatientId());
        String givenName = this.getMetadataValue(logId, potilaanTiedot.getCdaPatientGivennames());
        String familyName = this.getMetadataValue(logId, potilaanTiedot.getCdaPatientFamilyname());
        String birthTime = this.formatBirthTime(logId, this.getMetadataValue(logId, potilaanTiedot.getCdaPatientBirthtime()));
        InternalServiceError error = null;
        String patientIdFromBody = xpathHelperVTD.getCode("/ClinicalDocument/component/structuredBody/component[1]/section/subject/relatedSubject/code/@code");
        String patientIdCSFromBody = xpathHelperVTD.getCode("/ClinicalDocument/component/structuredBody/component[1]/section/subject/relatedSubject/code/@codeSystem");
        String patientIdExtension = null;
        String patientIdRoot = null;
        if (officialPatientId != null && officialPatientId.length() > 0) {
            patientIdExtension = xpathHelperVTD.getCode("/ClinicalDocument/recordTarget/patientRole/id[@root='1.2.246.21']/@extension");
            patientIdRoot = xpathHelperVTD.getCode("/ClinicalDocument/recordTarget/patientRole/id[@root='1.2.246.21']/@root");
            this.oldDocValidator.checkPatientId(logId, patientIdExtension, false);
            if (birthTime != null && birthTime.length() > 0) {
                this.oldDocValidator.validatePatientIdAndBirthDate(logId, patientIdExtension, birthTime);
            }
        } else {
            patientIdExtension = xpathHelperVTD.getCode("/ClinicalDocument/recordTarget/patientRole/id[@root!='1.2.246.21']/@extension");
            patientIdRoot = xpathHelperVTD.getCode("/ClinicalDocument/recordTarget/patientRole/id[@root!='1.2.246.21']/@root");
            if (tempPatientId == null || tempPatientId.length() < 1 || !this.oldDocValidator.checkNameAndBirthTime(logId, givenName, familyName, birthTime)) {
                error = this.errorWrapper.getError("0021");
                this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
                this.errorList.add(error);
            }
        }
        if (!patientIdExtension.equals(patientIdFromBody) || !patientIdRoot.equals(patientIdCSFromBody)) {
            error = this.errorWrapper.getError("0012");
            this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
            this.errorList.add(error);
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void validateHAPotilaanTiedot(String logId, AsiakirjaHAReq.Asiakirja.PotilaanTiedot potilaanTiedot, XPathHelperVTD xpathHelperVTD) throws UtilException, XPathHelperVTDException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        String officialPatientId = this.getMetadataValue(logId, potilaanTiedot.getCdaPatientId());
        String tempPatientId = this.getMetadataValue(logId, potilaanTiedot.getCdaTempPatientId());
        String givenName = this.getMetadataValue(logId, potilaanTiedot.getCdaPatientGivennames());
        String familyName = this.getMetadataValue(logId, potilaanTiedot.getCdaPatientFamilyname());
        String birthTime = this.formatBirthTime(logId, this.getMetadataValue(logId, potilaanTiedot.getCdaPatientBirthtime()));
        String patientIdExtension = null;
        InternalServiceError error = null;
        if (officialPatientId == null || officialPatientId.length() < 1) {
            if (tempPatientId == null || tempPatientId.length() < 1 || !this.oldDocValidator.checkNameAndBirthTime(logId, givenName, familyName, birthTime)) {
                error = this.errorWrapper.getError("0021");
                this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
                this.errorList.add(error);
            }
        } else {
            patientIdExtension = xpathHelperVTD.getCode("/ClinicalDocument/recordTarget/patientRole/id[@root='1.2.246.21']/@extension");
            this.oldDocValidator.checkPatientId(logId, patientIdExtension, false);
            if (birthTime != null && birthTime.length() > 0) {
                this.oldDocValidator.validatePatientIdAndBirthDate(logId, patientIdExtension, birthTime);
            }
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void validoiLaatijanTiedot(String logId, XPathHelperVTD xpathHelperVTD, String hetu, String separator) throws XPathHelperVTDException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        String givenExpression = null;
        String familyExpression = null;
        String givenVal = null;
        String familyVal = null;
        InternalServiceError error = null;
        List<String> hetuList = null;
        if (hetu != null && hetu.trim().length() > 0) {
            hetuList = Arrays.asList(hetu.split(separator));
        }
        if (hetuList == null || hetuList.isEmpty()) {
            this.log4j.debug((Object)(this.logHelper.formatMsgEnd(logId) + " Laatijan hetu puuttuu"));
            return;
        }
        for (int i = 0; i < hetuList.size(); ++i) {
            givenExpression = "/ClinicalDocument/author[" + (i + 1) + "]/assignedAuthor/assignedPerson/name/given";
            familyExpression = "/ClinicalDocument/author[" + (i + 1) + "]/assignedAuthor/assignedPerson/name/family";
            givenVal = xpathHelperVTD.getCode(givenExpression);
            familyVal = xpathHelperVTD.getCode(familyExpression);
            if (givenVal == null || givenVal != null && givenVal.trim().length() < 1) {
                error = this.errorWrapper.getError("0023");
                error.setErrorDescription("Asiakirjasta puuttuu tieto [/assignedPerson/name/given]");
                this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
                this.errorList.add(error);
            }
            if (familyVal != null && (familyVal == null || familyVal.trim().length() >= 1)) continue;
            error = this.errorWrapper.getError("0023");
            error.setErrorDescription("Asiakirjasta puuttuu tieto [/assignedPerson/name/family]");
            this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
            this.errorList.add(error);
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void validatePTAndHAAsiakirjaTiedot(String logId, AsiakirjaHAReq.Asiakirja asiakirjaHA, AsiakirjaPTReq.Asiakirja asiakirjaPT) {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        InternalServiceError error = null;
        String custodianHA = this.getMetadataValue(logId, asiakirjaHA.getAsiakirjanElinkaariTiedot().getCdaCustodian());
        String custodianPT = this.getMetadataValue(logId, asiakirjaPT.getAsiakirjanElinkaariTiedot().getCdaCustodian());
        String registryHA = this.getMetadataValue(logId, asiakirjaHA.getAsiakirjanElinkaariTiedot().getCdaCode());
        String registryPT = this.getMetadataValue(logId, asiakirjaPT.getAsiakirjanElinkaariTiedot().getCdaCode());
        String registrySpecifierHA = this.getMetadataValue(logId, asiakirjaHA.getAsiakirjanElinkaariTiedot().getHl7FiPatRegSpecifier());
        String registrySpecifierPT = this.getMetadataValue(logId, asiakirjaPT.getAsiakirjanElinkaariTiedot().getHl7FiPatRegSpecifier());
        String typeCodeHA = this.getMetadataValue(logId, asiakirjaHA.getAsiakirjanElinkaariTiedot().getHl7FiTypecode());
        String typeCodePT = this.getMetadataValue(logId, asiakirjaPT.getAsiakirjanElinkaariTiedot().getHl7FiTypecode());
        String patientIDHA = this.getMetadataValue(logId, asiakirjaHA.getPotilaanTiedot().getCdaPatientId());
        String patientIDPT = this.getMetadataValue(logId, asiakirjaPT.getPotilaanTiedot().getCdaPatientId());
        String tempPatientIDHA = this.getMetadataValue(logId, asiakirjaHA.getPotilaanTiedot().getCdaTempPatientId());
        String tempPatientIDPT = this.getMetadataValue(logId, asiakirjaPT.getPotilaanTiedot().getCdaTempPatientId());
        String encompassingEncounterIdHA = this.getMetadataValue(logId, asiakirjaHA.getPalvelutapahtumanTiedot().getEncompassingEncounterId());
        String encompassingEncounterIdPT = this.getMetadataValue(logId, asiakirjaPT.getPalvelutapahtumanTiedot().getEncompassingEncounterId());
        if (custodianHA == null || custodianPT == null || !custodianHA.equals(custodianPT)) {
            error = this.errorWrapper.getError("0026");
            if (encompassingEncounterIdPT != null) {
                error.setErrorMessage(error.getErrorMessage() + " Pt: " + encompassingEncounterIdPT + " (custodian)");
            }
            this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
            this.errorList.add(error);
        } else if (registryHA == null || registryPT == null || !registryHA.equals(registryPT)) {
            error = this.errorWrapper.getError("0026");
            if (encompassingEncounterIdPT != null) {
                error.setErrorMessage(error.getErrorMessage() + " Pt: " + encompassingEncounterIdPT + " (registry)");
            }
            this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
            this.errorList.add(error);
        } else if (typeCodeHA == null || typeCodePT == null || !typeCodeHA.equals(typeCodePT)) {
            error = this.errorWrapper.getError("0026");
            if (encompassingEncounterIdPT != null) {
                error.setErrorMessage(error.getErrorMessage() + " Pt: " + encompassingEncounterIdPT + " (typeCode)");
            }
            this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
            this.errorList.add(error);
        } else if (encompassingEncounterIdHA == null || encompassingEncounterIdPT == null || !encompassingEncounterIdHA.equals(encompassingEncounterIdPT)) {
            error = this.errorWrapper.getError("0026");
            if (encompassingEncounterIdPT != null) {
                error.setErrorMessage(error.getErrorMessage() + " Pt: " + encompassingEncounterIdPT + " (encompassingEncounterId)");
            }
            this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
            this.errorList.add(error);
        } else if (registrySpecifierHA != null && registrySpecifierPT == null || registrySpecifierHA == null && registrySpecifierPT != null || registrySpecifierHA != null && registrySpecifierPT != null && !registrySpecifierHA.equals(registrySpecifierPT)) {
            error = this.errorWrapper.getError("0026");
            if (encompassingEncounterIdPT != null) {
                error.setErrorMessage(error.getErrorMessage() + " Pt: " + encompassingEncounterIdPT + " (registrySpecifier)");
            }
            this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
            this.errorList.add(error);
        } else if (patientIDHA != null && patientIDPT == null || patientIDHA == null && patientIDPT != null || patientIDHA != null && patientIDPT != null && !patientIDHA.equals(patientIDPT)) {
            error = this.errorWrapper.getError("0026");
            if (encompassingEncounterIdPT != null) {
                error.setErrorMessage(error.getErrorMessage() + " Pt: " + encompassingEncounterIdPT + " (patientId)");
            }
            this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
            this.errorList.add(error);
        } else if (tempPatientIDHA != null && tempPatientIDPT == null || tempPatientIDHA == null && tempPatientIDPT != null || tempPatientIDHA != null && tempPatientIDPT != null && !tempPatientIDHA.equals(tempPatientIDPT)) {
            error = this.errorWrapper.getError("0026");
            if (encompassingEncounterIdPT != null) {
                error.setErrorMessage(error.getErrorMessage() + " Pt: " + encompassingEncounterIdPT + " (tempPatientId)");
            }
            this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
            this.errorList.add(error);
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void validatePTAsiakirjanPalvelutapahtumaTiedot(String logId, AsiakirjaPTReq.Asiakirja asiakirjaPT) {
        String publicCustodianType;
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        if (asiakirjaPT.getPalvelutapahtumanTiedot().getHl7FiCustodiantypecode() == null || asiakirjaPT.getPalvelutapahtumanTiedot().getHl7FiCustodiantypecode().getValue() == null) {
            InternalServiceError error = this.errorWrapper.getError("0010");
            error.setErrorMessage("Virhe asiakirjan validoinnissa");
            error.setErrorDescription("custodianTypeCode puuttuu");
            this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
            this.errorList.add(error);
            return;
        }
        String custodianType = asiakirjaPT.getPalvelutapahtumanTiedot().getHl7FiCustodiantypecode().getValue();
        if (custodianType.equals(publicCustodianType = "1.2.246.537.5.40172.2008!1") && (asiakirjaPT.getPotilaanTiedot().getCdaPHomemunicipality() == null || asiakirjaPT.getPotilaanTiedot().getCdaPHomemunicipality().getValue().length() < 1)) {
            InternalServiceError error = this.errorWrapper.getError("0029");
            this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
            this.errorList.add(error);
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private String getMetadataValue(String logId, MetadataObjectType metadataObject) {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        String retVal = null;
        if (metadataObject != null) {
            retVal = metadataObject.getValue();
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return retVal;
    }

    private MetadataObjectType getMetadataObject(String logId, String attrName, String attrValue, String attrType) {
        MetadataObjectType metadataObject = null;
        if (attrValue != null && attrValue.length() > 0) {
            metadataObject = new MetadataObjectType();
            metadataObject.setValueType(MetadataAttrType.fromValue((String)attrType));
            metadataObject.setValue(attrValue);
            metadataObject.setRepeating(false);
            metadataObject.setAttribute(attrName);
            metadataObject.setAttributeHigh(null);
            metadataObject.setValueHigh(null);
        }
        return metadataObject;
    }

    private String getCustodian(Document cdadoc) throws UtilException {
        Object returnvalue = "";
        String root = this.xpathhelper.getCode(this.logId, cdadoc, "/ClinicalDocument/custodian/assignedCustodian/representedCustodianOrganization/id/@root");
        String extension = this.xpathhelper.getCode(this.logId, cdadoc, "/ClinicalDocument/custodian/assignedCustodian/representedCustodianOrganization/id/@extension");
        returnvalue = extension.length() > 0 ? root + "." + extension : root;
        return returnvalue;
    }

    private String formatBirthTime(String logId, String birthTime) {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        String retbirthTime = null;
        if (birthTime != null) {
            try {
                SimpleDateFormat sdfSource = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                Date date = sdfSource.parse(birthTime);
                SimpleDateFormat sdfDestination = new SimpleDateFormat("yyyyMMdd");
                retbirthTime = sdfDestination.format(date);
                if (this.log4j.isDebugEnabled()) {
                    this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
                }
            }
            catch (ParseException e) {
                InternalServiceError error = this.errorWrapper.getError("0008");
                this.log4j.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
                this.errorList.add(error);
            }
        }
        return retbirthTime;
    }

    private static List<String> getValues(List<AttributeValueType> attrValues) {
        ArrayList<String> values = new ArrayList<String>();
        for (AttributeValueType v : attrValues) {
            values.add(v.getOriginalValue());
        }
        return values;
    }

    private static String readFileContent(File file) throws IOException {
        try (FileInputStream stream = new FileInputStream(file);){
            byte[] fileContent = new byte[(int)file.length()];
            stream.read(fileContent);
            String string = new String(fileContent);
            return string;
        }
    }

    private List<String> getAuthorIds(String logId, List<AttributeObjectValue> objectValues) {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        List<String> values = new ArrayList<String>();
        if (objectValues != null && !objectValues.isEmpty()) {
            ArrayList<AttributeValueType> valueTypeList = new ArrayList<AttributeValueType>();
            for (AttributeObjectValue vals : objectValues) {
                valueTypeList.addAll(((ObjectValueType)vals.getValues().get("authorId")).getValueList());
            }
            values = OldDocumentMetadataReader.getValues(valueTypeList);
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return values;
    }

    private List<ObjectRelativeXpath> createAuthorExpressionList(String logId) {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        ArrayList<ObjectRelativeXpath> expressionList = new ArrayList<ObjectRelativeXpath>();
        ObjectRelativeXpath expr = new ObjectRelativeXpath();
        expr.setKey("authorId");
        expr.setValue("assignedAuthor/id");
        expr.setType("II");
        expr.setSeparator("!");
        expressionList.add(expr);
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return expressionList;
    }

    static {
        cacheManager = CacheManagerBuilder.newCacheManagerBuilder().withCache("codecache", (Builder)CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, MaakuntaRekisterinpitajaTiedot.class, (Builder)ResourcePoolsBuilder.heap((long)100L))).build();
        cacheManager.init();
        rekisterinpitajaCache = cacheManager.getCache("codecache", String.class, MaakuntaRekisterinpitajaTiedot.class);
        executionMode = new RunMode();
    }
}

