/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.olddocuments.utils;

import fi.kanta.common.components.LogHelper;
import fi.kanta.common.exception.ApplicationException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Properties;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.log4j.Logger;

public class MimeHelper {
    Logger log4j = Logger.getLogger(MimeHelper.class);
    private LogHelper logHelper = new LogHelper();

    public String encodeToMIME(String logId, String sourceText) throws ApplicationException, MessagingException, IOException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        Properties props = new Properties();
        Session session = Session.getInstance((Properties)props, null);
        MimeMessage message = new MimeMessage(session);
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        String msgWithHeader = "";
        messageBodyPart.setText(sourceText, "UTF-8");
        messageBodyPart.addHeader("Content-transfer-encoding", "base64");
        messageBodyPart.addHeader("Content-type", "text/xml; charset=\"UTF-8\"");
        MimeMultipart multipart = new MimeMultipart("related");
        multipart.addBodyPart((BodyPart)messageBodyPart);
        message.setContent((Multipart)multipart);
        message.setSentDate(new Date());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        message.writeTo((OutputStream)bos);
        msgWithHeader = bos.toString();
        msgWithHeader = msgWithHeader.replaceFirst("<", "&lt;");
        msgWithHeader = msgWithHeader.replaceFirst(">", "&gt;");
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return msgWithHeader;
    }
}

