/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.olddocuments.utils;

import fi.kanta.common.components.IPropertyManager;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.components.PropertyManager;
import fi.kanta.common.exception.PropertyException;
import fi.kanta.common.util.InternalServiceError;
import java.io.File;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class PropertyHandler {
    Logger log4j = Logger.getLogger(PropertyHandler.class);
    private LogHelper logHelper;
    private static PropertyHandler me = new PropertyHandler();
    private IPropertyManager properties = null;
    private Schema cdaSchema;
    private Schema xhtmlSchema;
    private Schema koontitiedostoSchema;

    public PropertyHandler() {
        try {
            this.logHelper = new LogHelper();
            System.out.println("using file: " + PropertyHandler.class.getClassLoader().getResource("olddocuments.properties").getFile());
            this.properties = new PropertyManager("23", PropertyHandler.class.getClassLoader().getResource("olddocuments.properties").getFile());
            String fileName = this.getProperty("23", "schemapath");
            this.log4j.debug((Object)this.logHelper.formatMsg("23", "Luetaan skeema: ", fileName));
            StreamSource cdaSource = new StreamSource(new File(fileName));
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            this.cdaSchema = factory.newSchema(cdaSource);
            String schemaPath = this.properties.getValue("23", "xhtmlschemapath");
            this.log4j.debug((Object)this.logHelper.formatMsg("23", "Luetaan xhtml skeema: ", schemaPath));
            File localSchemaFile = new File(schemaPath);
            this.xhtmlSchema = factory.newSchema(localSchemaFile);
            String koontischemaPath = this.properties.getValue("23", "koontitiedostoschemapath");
            this.log4j.debug((Object)this.logHelper.formatMsg("23", "Luetaan koontitiedoston skeema: ", koontischemaPath));
            this.koontitiedostoSchema = factory.newSchema(new File(koontischemaPath));
        }
        catch (PropertyException ex) {
            InternalServiceError error = ex.getInternalServiceError();
            if (error.isCommonError()) {
                this.log4j.error((Object)this.logHelper.formatMsg("23", error), error.getErrorCause());
            } else {
                this.log4j.error((Object)this.logHelper.formatMsg("23", error), (Throwable)ex);
            }
            System.err.println("propertyjen initialisointi ep\u00e4onnistui.");
        }
        catch (SAXException e) {
            this.log4j.error((Object)this.logHelper.formatMsg("23"), (Throwable)e);
            System.err.println("scheman initialisointi ep\u00e4onnistui.");
            System.exit(1);
        }
    }

    public static PropertyHandler getInstance() {
        return me;
    }

    public String getProperty(String logId, String key) throws PropertyException {
        return this.properties.getValue(logId, key);
    }

    public Schema getCDASchema() {
        return this.cdaSchema;
    }

    public Schema getXHTMLSchema() {
        return this.xhtmlSchema;
    }

    public Schema getKoontiedostoSchema() {
        return this.koontitiedostoSchema;
    }
}

