/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.olddocuments.utils.xpathconfig;

import fi.kanta.arkistopalvelu.olddocuments.exception.ConfigException;
import fi.kanta.arkistopalvelu.olddocuments.exception.ErrorWrapperLoader;
import fi.kanta.arkistopalvelu.olddocuments.utils.PropertyHandler;
import fi.kanta.arkistopalvelu.olddocuments.utils.xpathconfig.XmlXpathConfig;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.exception.PropertyException;
import fi.kanta.common.util.InternalServiceError;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;

public class XMLXPathConfigManager {
    Logger log = Logger.getLogger(XMLXPathConfigManager.class);
    private static XMLXPathConfigManager me = null;
    private LogHelper logHelper;
    private Map<String, XmlXpathConfig> configMap = new HashMap<String, XmlXpathConfig>();
    private ErrorWrapperLoader errorWrapper = ErrorWrapperLoader.getInstance();

    private XMLXPathConfigManager() throws ConfigException {
        this.logHelper = new LogHelper();
        this.getXPathConfigMap();
    }

    private void getXPathConfigMap() throws ConfigException {
        String logId = "20";
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        String identifier = null;
        try {
            String path = PropertyHandler.getInstance().getProperty("23", "xpathconfigpath");
            File folder = new File(path);
            File[] files = folder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".xml");
                }
            });
            if (files != null) {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{XmlXpathConfig.class});
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                XmlXpathConfig config = null;
                for (File file : files) {
                    config = (XmlXpathConfig)jaxbUnmarshaller.unmarshal(file);
                    identifier = String.valueOf(config.getDocType());
                    this.configMap.put(identifier, config);
                }
            }
        }
        catch (PropertyException | JAXBException e) {
            InternalServiceError error = this.errorWrapper.getError("0011");
            this.log.error((Object)this.logHelper.formatMsg(logId, error), e);
            throw new ConfigException(error);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    public static XMLXPathConfigManager getInstance() {
        return me;
    }

    public XmlXpathConfig getXPathConfig(String logId, String doctype, int level) throws ConfigException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        XmlXpathConfig retConfig = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.logHelper.formatMsg(logId, "haetaan xpathconfig doctype:" + doctype + " level:" + level));
        }
        for (Map.Entry<String, XmlXpathConfig> entry : this.configMap.entrySet()) {
            if (!entry.getKey().equals(doctype)) continue;
            retConfig = entry.getValue();
            break;
        }
        if (retConfig == null) {
            InternalServiceError error = this.errorWrapper.getError("0011");
            this.log.error((Object)this.logHelper.formatMsg(logId, error));
            throw new ConfigException(error);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return retConfig;
    }

    static {
        try {
            me = new XMLXPathConfigManager();
        }
        catch (ConfigException e) {
            e.printStackTrace();
            throw new ExceptionInInitializerError(e);
        }
    }
}

