/*
 * Decompiled with CFR 0.152.
 */
package fi.kela.kanta.koostekanta.rajapinnat.dto;

import fi.kela.kanta.koostekanta.rajapinnat.dto.InvalidKoosteDtoException;
import java.util.Arrays;
import java.util.List;

public final class KoosteDtoDataValidator {
    private KoosteDtoDataValidator() {
    }

    public static void ensureThatListIsNotNullAndStringsAreNotNullOrEmptyOrBlank(List<String> stringsList, boolean emptyListIsAllowed, String identifier) throws InvalidKoosteDtoException {
        KoosteDtoDataValidator.ensureThatListIsNotNull(stringsList, identifier);
        if (!emptyListIsAllowed) {
            KoosteDtoDataValidator.ensureThatListIsNotEmpty(stringsList, identifier);
        }
        for (String string : stringsList) {
            KoosteDtoDataValidator.ensureThatStringIsNotNullOrEmptyOrBlank(string, identifier);
        }
    }

    public static <T> void ensureThatListIsNotNull(List<T> list, String identifier) throws InvalidKoosteDtoException {
        if (list != null) {
            return;
        }
        String errorMessage = "Lista on null kent\u00e4ss\u00e4 [" + identifier + "]";
        throw new InvalidKoosteDtoException(errorMessage);
    }

    public static <T> void ensureThatListIsNotEmpty(List<T> list, String identifier) throws InvalidKoosteDtoException {
        if (!list.isEmpty()) {
            return;
        }
        String errorMessage = "Lista on nollan pituinen kent\u00e4ss\u00e4 [" + identifier + "]";
        throw new InvalidKoosteDtoException(errorMessage);
    }

    public static void ensureThatStringIsNotNullOrEmptyOrBlank(String string, String identifier) throws InvalidKoosteDtoException {
        if (string != null && !string.trim().isEmpty()) {
            return;
        }
        String errorMessage = "Merkkijono on null, nollan pituinen tai sis\u00e4lt\u00e4\u00e4 ainoastaan ei-tulostuvia merkkej\u00e4 kent\u00e4ss\u00e4 [" + identifier + "]";
        throw new InvalidKoosteDtoException(errorMessage);
    }

    public static void ensureThatStringIsNotEmptyOrBlankIfNotNull(String string, String identifier) throws InvalidKoosteDtoException {
        if (string == null) {
            return;
        }
        if (!string.trim().isEmpty()) {
            return;
        }
        String errorMessage = "Merkkijono on nollan pituinen tai sis\u00e4lt\u00e4\u00e4 ainoastaan ei-tulostuvia merkkej\u00e4 kent\u00e4ss\u00e4 [" + identifier + "]";
        throw new InvalidKoosteDtoException(errorMessage);
    }

    public static void ensureThatValueIs(String expectedValue, String actualValue, String identifier) throws InvalidKoosteDtoException {
        if (expectedValue.equals(actualValue)) {
            return;
        }
        String errorMessage = "Varsinainen merkkijonon arvo [" + actualValue + "] ei ole sama kuin odotettu merkkijonon arvo [" + expectedValue + "] kent\u00e4ss\u00e4 [" + identifier + "]";
        throw new InvalidKoosteDtoException(errorMessage);
    }

    public static void ensureThatValueIsOneOf(String[] expectedValues, String actualValue, String identifier) throws InvalidKoosteDtoException {
        for (String expectedValue : expectedValues) {
            if (!expectedValue.equals(actualValue)) continue;
            return;
        }
        String errorMessage = "Varsinainen merkkijonon arvo [" + actualValue + "] ei ole sama kuin yksi odotetuista merkkijonon arvoista [" + Arrays.toString(expectedValues) + "] kent\u00e4ss\u00e4 [" + identifier + "]";
        throw new InvalidKoosteDtoException(errorMessage);
    }

    public static void ensureThatBooleanIsNotNull(Boolean bool, String identifier) throws InvalidKoosteDtoException {
        if (bool != null) {
            return;
        }
        String errorMessage = "Boolean-arvo on null kent\u00e4ss\u00e4 [" + identifier + "]";
        throw new InvalidKoosteDtoException(errorMessage);
    }

    public static void ensureThatBooleanIsNotNullAndTrue(Boolean bool, String identifier) throws InvalidKoosteDtoException {
        if (bool != null && Boolean.TRUE.equals(bool)) {
            return;
        }
        String errorMessage = "Boolean-arvo on null tai false kent\u00e4ss\u00e4 [" + identifier + "]";
        throw new InvalidKoosteDtoException(errorMessage);
    }
}

