/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.client;

import fi.kanta.arkistopalvelu.exception.AttributeFetcherException;
import fi.kanta.arkistopalvelu.util.ErrorWrapperArchive;
import fi.kanta.arkistopalvelu.util.configurations.ArkistopalveluConfigManager;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.util.InternalServiceError;
import fi.kanta.koodistopalvelu.webservices.peruskoodisto.CodeAttributeIn;
import fi.kanta.koodistopalvelu.webservices.peruskoodisto.CodeAttributeResponse;
import fi.kanta.koodistopalvelu.webservices.peruskoodisto.Peruskoodisto;
import fi.kanta.koodistopalvelu.webservices.peruskoodisto.Peruskoodisto_Service;
import java.util.List;
import java.util.concurrent.Callable;
import javax.xml.ws.BindingProvider;
import org.apache.log4j.Logger;

public class FetchCodeAttributeClient
implements Callable<List<CodeAttributeResponse>> {
    private static final Logger LOGGER = Logger.getLogger(FetchCodeAttributeClient.class);
    private ArkistopalveluConfigManager configManager;
    private LogHelper logHelper;
    private ErrorWrapperArchive errorWrapper = ErrorWrapperArchive.getInstance();
    private String logId;
    private List<CodeAttributeIn> codes;

    public FetchCodeAttributeClient(String logId, List<CodeAttributeIn> codesIn) {
        this.configManager = ArkistopalveluConfigManager.getInstance();
        this.logId = logId;
        this.codes = codesIn;
        this.logHelper = new LogHelper();
    }

    @Override
    public List<CodeAttributeResponse> call() throws AttributeFetcherException {
        List retValues = null;
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)this.logHelper.formatMsgBgn(this.logId));
            }
            String urlStr = this.configManager.getArkistoProperties("20").getPeruskoodistourl();
            Peruskoodisto_Service service = new Peruskoodisto_Service();
            Peruskoodisto koodisto = service.getPeruskoodisto();
            BindingProvider bp = (BindingProvider)koodisto;
            bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", urlStr);
            retValues = koodisto.getCodeAttribute(this.codes, "20");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)this.logHelper.formatMsgEnd(this.logId));
            }
        }
        catch (ClassCastException ex) {
            InternalServiceError error = this.errorWrapper.getError("1016");
            LOGGER.error((Object)this.logHelper.formatMsg(this.logId, error), (Throwable)ex);
            throw new AttributeFetcherException(error, ex);
        }
        return retValues;
    }
}

