/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.util;

import fi.kanta.arkistopalvelu.util.ErrorWrapperArchive;
import fi.kanta.arkistopalvelu.util.configurations.ArkistopalveluConfigManager;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.exception.UtilException;
import fi.kanta.common.util.InternalServiceError;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataSource;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.apache.pdfbox.preflight.Format;
import org.apache.pdfbox.preflight.PreflightDocument;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.SyntaxValidationException;
import org.apache.pdfbox.preflight.parser.PreflightParser;
import org.apache.pdfbox.preflight.utils.ByteArrayDataSource;

public class PdfChecker {
    Logger log = Logger.getLogger(PdfChecker.class);
    private LogHelper logHelper = new LogHelper();
    private ErrorWrapperArchive errorWrapper = ErrorWrapperArchive.getInstance();

    public void check(String logId, String b64Pdf) throws UtilException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        ValidationResult valResult = null;
        InputStream is = null;
        ByteArrayDataSource ds = null;
        PreflightParser parser = null;
        PreflightDocument document = null;
        try {
            if (b64Pdf != null) {
                is = new ByteArrayInputStream(Base64.decodeBase64((byte[])b64Pdf.getBytes()));
                ds = new ByteArrayDataSource(is);
                parser = new PreflightParser((DataSource)ds);
                parser.parse();
                document = parser.getPreflightDocument();
                if (!document.getSpecification().equals((Object)Format.PDF_A1B) && !document.getSpecification().equals((Object)Format.PDF_A1A)) {
                    InternalServiceError error = this.errorWrapper.getError("1001");
                    error.setErrorDescription("Virheellinen pdf-asiakirja.");
                    this.log.error((Object)this.logHelper.formatMsg(logId, error));
                    throw new UtilException(error);
                }
                boolean validatePdf = ArkistopalveluConfigManager.getInstance().getArkistoProperties(logId).isValidatePdf();
                ValidationResult result = null;
                if (validatePdf) {
                    document.validate();
                    result = document.getResult();
                    if (!result.isValid()) {
                        if (this.log.isDebugEnabled()) {
                            for (ValidationResult.ValidationError error : result.getErrorsList()) {
                                this.log.debug((Object)(error.getErrorCode() + " : " + error.getDetails()));
                            }
                        }
                        InternalServiceError error = this.errorWrapper.getError("1001");
                        error.setErrorDescription("Virheellinen pdf-asiakirja.");
                        this.log.error((Object)this.logHelper.formatMsg(logId, error));
                        throw new UtilException(error);
                    }
                }
            }
        }
        catch (SyntaxValidationException e) {
            valResult = e.getResult();
            if (this.log.isDebugEnabled() && !valResult.isValid()) {
                for (ValidationResult.ValidationError error : valResult.getErrorsList()) {
                    this.log.debug((Object)(error.getErrorCode() + " : " + error.getDetails()));
                }
            }
            InternalServiceError error = this.errorWrapper.getError("1001");
            error.setErrorDescription("Virheellinen pdf-asiakirja.");
            this.log.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error);
        }
        catch (IOException e) {
            InternalServiceError error = this.errorWrapper.getError("1001");
            error.setErrorDescription("Virheellinen pdf-asiakirja.");
            this.log.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error);
        }
        finally {
            InternalServiceError error;
            if (document != null) {
                try {
                    document.close();
                }
                catch (IOException e) {
                    error = this.errorWrapper.getError("2002");
                    this.log.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
                }
            }
            try {
                is.close();
            }
            catch (IOException e) {
                error = this.errorWrapper.getError("2002");
                this.log.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }
}

