/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.util;

import fi.kanta.arkistopalvelu.exception.QueryException;
import fi.kanta.arkistopalvelu.util.ErrorWrapperArchive;
import fi.kanta.arkistopalvelu.util.MetadataList;
import fi.kanta.arkistopalvelu.util.xpathconfig.AttributeValueType;
import fi.kanta.arkistopalvelu.util.xpathconfig.DctmAttribute;
import fi.kanta.common.components.DateHelper;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.exception.UtilException;
import fi.kanta.common.util.InternalServiceError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class StringHelper {
    private final Logger LOGGER = Logger.getLogger(StringHelper.class);
    private ErrorWrapperArchive errorWrapper;
    private LogHelper logHelper = new LogHelper();

    public StringHelper() {
        this.errorWrapper = ErrorWrapperArchive.getInstance();
    }

    public void nullCheck(String logId, String parameter, String value) throws QueryException {
        if (value == null || value.trim().length() == 0) {
            InternalServiceError error = this.errorWrapper.getError("1015");
            error.setErrorDescription("Asetettu parametri oli null tai tyhj\u00e4: " + parameter);
            error.setReturnDescription(false);
            this.LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
            throw new QueryException(error);
        }
    }

    public boolean hasOnlyEmptyValues(String logId, List<String> values) {
        boolean retVal = true;
        if (values != null) {
            values.removeAll(Collections.singleton(""));
            if (!values.isEmpty()) {
                retVal = false;
            }
        }
        return retVal;
    }

    public List<String> parseMultiValue(String logId, String multiVal, String separator) {
        List<String> valList = new ArrayList<String>();
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        if (multiVal != null && !multiVal.isEmpty()) {
            Pattern p = Pattern.compile(Pattern.quote(separator));
            String[] values = p.split(multiVal);
            valList = Arrays.asList(values);
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return valList;
    }

    public String[] parseCodedValue(String logId, String cvField, String codeSystem) {
        String[] retArr = new String[2];
        String[] codedvalue = cvField.split("!");
        if (codedvalue.length == 2) {
            retArr[0] = codedvalue[1].trim();
            retArr[1] = codedvalue[0];
        } else {
            retArr[0] = cvField;
            retArr[1] = codeSystem;
        }
        return retArr;
    }

    public boolean isAttributeValueTypeValueNotNull(String logId, List<AttributeValueType> attrList) {
        boolean retValue = false;
        if (this.LOGGER.isTraceEnabled()) {
            this.LOGGER.trace((Object)this.logHelper.formatMsgBgn(logId));
        }
        if (attrList != null) {
            for (AttributeValueType attrType : attrList) {
                if (attrType == null || attrType.getOriginalValue() == null || attrType.getOriginalValue().getValue() == null || attrType.getOriginalValue().getValue().length() <= 0) continue;
                retValue = true;
                break;
            }
        }
        if (this.LOGGER.isTraceEnabled()) {
            this.LOGGER.trace((Object)this.logHelper.formatMsgBgn(logId));
        }
        return retValue;
    }

    public boolean isAttributeValuesNullOrEmpty(String logId, DctmAttribute dctmAttr) {
        return dctmAttr == null || dctmAttr.getAttributeValues() == null || !this.isAttributeValueTypeValueNotNull(logId, dctmAttr.getAttributeValues());
    }

    public boolean isAttributeValueNull(String logId, DctmAttribute dctmAttr) {
        return dctmAttr == null || dctmAttr.getAttributeValue() == null || dctmAttr.getAttributeValue().getOriginalValue() == null || dctmAttr.getAttributeValue().getOriginalValue().getValue() == null || dctmAttr.getAttributeValue().getOriginalValue().getValue().length() < 1;
    }

    public boolean attributeValueTypeListContains(String logId, List<AttributeValueType> attrList, String value) {
        boolean retValue = false;
        if (this.LOGGER.isTraceEnabled()) {
            this.LOGGER.trace((Object)this.logHelper.formatMsgBgn(logId));
        }
        if (attrList != null && value != null) {
            for (AttributeValueType attrType : attrList) {
                if (attrType == null || attrType.getOriginalValue() == null || attrType.getOriginalValue().getValue() == null || !attrType.getOriginalValue().getValue().equals(value)) continue;
                retValue = true;
                break;
            }
        }
        if (this.LOGGER.isTraceEnabled()) {
            this.LOGGER.trace((Object)this.logHelper.formatMsgBgn(logId));
        }
        return retValue;
    }

    public boolean compareLists(String logId, List<String> firstList, List<String> secondList) {
        boolean retVal = true;
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        if (firstList == null && secondList == null) {
            return true;
        }
        if (firstList != null && secondList == null || firstList == null) {
            return false;
        }
        if (firstList.size() != secondList.size()) {
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug((Object)"Vertailtavat listat ovat eri kokoisia.");
                this.LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
            }
            return false;
        }
        if (!firstList.containsAll(secondList)) {
            this.LOGGER.debug((Object)"Vertailtava listat ovat erilaisia.");
            retVal = false;
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return retVal;
    }

    public boolean isNotEmpty(MetadataList metadataList, String value, String logId) {
        DctmAttribute dctmAttr;
        Map<String, DctmAttribute> validateAttributesMap;
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        if ((validateAttributesMap = metadataList.getValidateAttrMap()) != null && !validateAttributesMap.isEmpty() && (dctmAttr = validateAttributesMap.get(value)) != null) {
            return true;
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("arvoa " + value + " ei l\u00f6ytynyt metadatalistalta"));
            this.LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return false;
    }

    public String listToMultivalueSeparatedString(String logId, List<String> values, String separator) {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        if (values == null || values.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int counter = 1;
        for (String value : values) {
            sb.append(value);
            if (values.size() != counter) {
                sb.append(separator);
            }
            ++counter;
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return sb.toString();
    }

    public boolean isOfficialHetu(String patientId) {
        boolean isOfficial = false;
        if (patientId == null) {
            return false;
        }
        if (patientId.length() == 22 && patientId.startsWith("1.2.246.21.")) {
            isOfficial = true;
        }
        return isOfficial;
    }

    public String parseOfficialHetuExtension(String patientId) {
        if (patientId != null && this.isOfficialHetu(patientId)) {
            return patientId.substring("1.2.246.21".length() + 1);
        }
        return null;
    }

    public boolean isAdult(String logId, String birthTime) throws UtilException {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        boolean retVal = false;
        Date dateBirthTime = new DateHelper().parseDate(logId, birthTime, "yyyyMMdd");
        Calendar calBirthTime = this.getDatePartCalendar(dateBirthTime);
        calBirthTime.add(1, 18);
        Calendar calNow = this.getDatePartCalendar(new Date());
        boolean bl = retVal = calBirthTime.compareTo(calNow) <= 0;
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)this.logHelper.formatMsg(logId, "isAdult: " + retVal));
            this.LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return retVal;
    }

    public boolean isNotEmpty(String value) {
        return value != null && !value.isEmpty();
    }

    public Calendar getDatePartCalendar(Date date) {
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public boolean isPatientIdAdult(String logId, String patientId) throws UtilException {
        String erotinMerkki = "";
        if (patientId == null) {
            return true;
        }
        if (!this.isOfficialHetu(patientId)) {
            return true;
        }
        if (patientId.length() >= 22) {
            erotinMerkki = patientId.substring("1.2.246.21".length() + 1).substring(6, 7);
            if ("-".equals(erotinMerkki)) {
                return true;
            }
            if ("+".equals(erotinMerkki)) {
                return true;
            }
        }
        if (patientId.contains(".") && erotinMerkki.equals("A")) {
            String day = patientId.substring("1.2.246.21".length() + 1).substring(0, 2);
            String month = patientId.substring("1.2.246.21".length() + 1).substring(2, 4);
            String year = patientId.substring("1.2.246.21".length() + 1).substring(4, 6);
            Calendar cal = GregorianCalendar.getInstance();
            cal.set(10, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(2000 + Integer.parseInt(year), Integer.parseInt(month) - 1, Integer.parseInt(day));
            cal.add(1, 18);
            Date now = new Date();
            return cal.getTime().before(now);
        }
        InternalServiceError error = this.errorWrapper.getError("1019");
        error.setErrorDescription("Virheellinen henkil\u00f6n tunniste");
        error.setReturnDescription(false);
        this.LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
        throw new UtilException(error);
    }

    public String combineHetu(String logId, String syntAika, String loppuOsa) throws UtilException {
        StringBuilder sb = new StringBuilder("1.2.246.21.");
        String vuosiSadanTunnus = "";
        sb = sb.append(syntAika.substring(6, 8)).append(syntAika.substring(4, 6)).append(syntAika.substring(2, 4));
        switch (syntAika.substring(0, 2)) {
            case "18": {
                vuosiSadanTunnus = "+";
                break;
            }
            case "19": {
                vuosiSadanTunnus = "-";
                break;
            }
            case "20": {
                vuosiSadanTunnus = "A";
                break;
            }
            default: {
                InternalServiceError error = this.errorWrapper.getError("1019");
                error.setErrorDescription("Virheellinen syntym\u00e4vuosi");
                error.setReturnDescription(false);
                this.LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
                throw new UtilException(error);
            }
        }
        sb.append(vuosiSadanTunnus);
        sb.append(loppuOsa);
        return sb.toString();
    }
}

