/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.util.configurations;

import fi.kanta.arkistopalvelu.exception.ConfigException;
import fi.kanta.arkistopalvelu.util.ErrorWrapperArchive;
import fi.kanta.arkistopalvelu.util.configurations.ArkistoProperties;
import fi.kanta.arkistopalvelu.util.configurations.ArkistopalveluConfig;
import fi.kanta.arkistopalvelu.util.configurations.ArkistopalveluConfigMiddleManager;
import fi.kanta.arkistopalvelu.util.configurations.KoostekantaProperties;
import fi.kanta.arkistopalvelu.util.configurations.OstopalvelutProperties;
import fi.kanta.arkistopalvelu.util.configurations.Registry;
import fi.kanta.arkistopalvelu.util.configurations.RekisterinpitajaPalveluProperties;
import fi.kanta.arkistopalvelu.util.configurations.Repositories;
import fi.kanta.arkistopalvelu.util.configurations.Repository;
import fi.kanta.arkistopalvelu.util.configurations.RepositoryIdentifier;
import fi.kanta.arkistopalvelu.util.configurations.SuostumustenHallintaProperties;
import fi.kanta.arkistopalvelu.util.configurations.VapakypaValityshistoriaProperties;
import fi.kanta.arkistopalvelu.util.xpathconfig.DctmAttribute;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.util.InternalServiceError;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class ArkistopalveluConfigManager {
    private static final Logger LOGGER = Logger.getLogger(ArkistopalveluConfigManager.class);
    private LogHelper logHelper;
    private SchemaFactory factory;
    private Schema cdaSchema;
    private static ArkistopalveluConfigManager me = null;
    private ArkistoProperties arkistoProperties;
    private KoostekantaProperties koostekantaProperties;
    private VapakypaValityshistoriaProperties vapakypaValityshistoriaProperties;
    private OstopalvelutProperties ostopalvelutProperties;
    private SuostumustenHallintaProperties suostumustenHallintaproperties;
    private RekisterinpitajaPalveluProperties rekisterinpitajaPalveluProperties;
    private ArkistopalveluConfig arkistoPalveluConfig;
    private Repositories repositories;
    private Map<String, Registry> shpTTRegistryMap;
    private Map<RepositoryIdentifier, Repository> arkistoRepositoryMap;
    private Map<RepositoryIdentifier, Repository> arkistoTHPRepositoryMap;
    private Map<RepositoryIdentifier, Repository> arkistoOldDocumentRepositoryMap;
    private Map<RepositoryIdentifier, Repository> arkistoArchiveDocumentRepositoryMap;
    private Map<RepositoryIdentifier, Repository> arkistoTemporaryPatientIDRepositoryMap;
    private Map<RepositoryIdentifier, Repository> arkistoOldTemporaryPatientIDRepositoryMap;

    public static ArkistopalveluConfigManager getInstance() {
        return me;
    }

    private ArkistopalveluConfigManager() throws ConfigException {
        try {
            this.logHelper = new LogHelper();
            this.factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            this.arkistoPalveluConfig = new ArkistopalveluConfigMiddleManager().readArkistopalveluConfig("20", this.factory);
            this.initConfigurations("20");
            String arkistoPath = System.getProperty("arkistopalvelu.path");
            String fileName = arkistoPath + System.getProperty("file.separator") + "xml" + System.getProperty("file.separator") + "xsd" + System.getProperty("file.separator") + "CDA_Fi.xsd";
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)this.logHelper.formatMsg("20", "Reading schema", fileName));
            }
            this.cdaSchema = this.factory.newSchema(new StreamSource(new File(fileName)));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)this.logHelper.formatMsgEnd("20"));
            }
        }
        catch (JAXBException e) {
            e.printStackTrace();
            InternalServiceError retError = new InternalServiceError();
            retError.setErrorCode("1017");
            retError.setErrorMessage("Vakava sis\u00e4inen virhe.");
            retError.setErrorLevel("1");
            retError.setErrorDescription(new StringBuffer("arkistopalvelu.xml").append(" lukeminen ep\u00e4onnistui."));
            LOGGER.error((Object)this.logHelper.formatMsg("20", retError), (Throwable)e);
            throw new ConfigException(retError);
        }
        catch (SAXException ex) {
            InternalServiceError retError = new InternalServiceError();
            retError.setErrorCode("1017");
            retError.setErrorMessage("Vakava sis\u00e4inen virhe.");
            retError.setErrorLevel("1");
            retError.setErrorDescription(new StringBuffer("arkistopalvelu.xml").append(" lukeminen ep\u00e4onnistui."));
            LOGGER.error((Object)this.logHelper.formatMsg("20", retError), (Throwable)ex);
            throw new ConfigException(retError);
        }
    }

    private void initConfigurations(String logId) throws ConfigException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        InternalServiceError error = null;
        if (this.arkistoPalveluConfig != null) {
            this.initShpTTRegistryMap(logId);
            this.arkistoProperties = this.arkistoPalveluConfig.getArkistoProperties();
            this.koostekantaProperties = this.arkistoPalveluConfig.getKoostekantaProperties();
            this.vapakypaValityshistoriaProperties = this.arkistoPalveluConfig.getVapakypaValityshistoriaProperties();
            this.ostopalvelutProperties = this.arkistoPalveluConfig.getOstopalvelutProperties();
            this.suostumustenHallintaproperties = this.arkistoPalveluConfig.getSuostumustenHallintaProperties();
            this.rekisterinpitajaPalveluProperties = this.arkistoPalveluConfig.getRekisterinpitajaPalveluProperties();
            this.repositories = this.arkistoPalveluConfig.getRepositories();
            String errMsg = " month-elementti pakollinen.";
            String errMsg2 = " duplikaatti-tieto konfiguraatiossa.";
            String errMsg3 = "Virheellinen type-elementin arvo.";
            if (this.repositories != null) {
                this.arkistoRepositoryMap = new HashMap<RepositoryIdentifier, Repository>();
                this.arkistoTHPRepositoryMap = new HashMap<RepositoryIdentifier, Repository>();
                this.arkistoOldDocumentRepositoryMap = new HashMap<RepositoryIdentifier, Repository>();
                this.arkistoArchiveDocumentRepositoryMap = new HashMap<RepositoryIdentifier, Repository>();
                this.arkistoTemporaryPatientIDRepositoryMap = new HashMap<RepositoryIdentifier, Repository>();
                this.arkistoOldTemporaryPatientIDRepositoryMap = new HashMap<RepositoryIdentifier, Repository>();
                RepositoryIdentifier repoIdentifier = null;
                block16: for (Repository repository : this.repositories.getRepository()) {
                    repoIdentifier = new RepositoryIdentifier(repository.getType(), repository.getMonth());
                    switch (repository.getType()) {
                        case "ptarkisto": {
                            if (repository.getMonth() == null) {
                                error = ErrorWrapperArchive.getInstance().getError("1017");
                                error.setErrorDescription(new StringBuffer("ptarkisto").append(errMsg));
                                LOGGER.error((Object)this.logHelper.formatMsg("20", error));
                                throw new ConfigException(error);
                            }
                            if (this.ifRepositoryExists(logId, this.arkistoRepositoryMap, repoIdentifier)) {
                                error = ErrorWrapperArchive.getInstance().getError("1017");
                                error.setErrorDescription(new StringBuffer("ptarkisto").append(errMsg2));
                                LOGGER.error((Object)this.logHelper.formatMsg("20", error));
                                throw new ConfigException(error);
                            }
                            this.arkistoRepositoryMap.put(repoIdentifier, repository);
                            continue block16;
                        }
                        case "ptsuostumus": {
                            if (this.ifRepositoryExists(logId, this.arkistoTHPRepositoryMap, repoIdentifier)) {
                                error = ErrorWrapperArchive.getInstance().getError("1017");
                                error.setErrorDescription(new StringBuffer("ptsuostumus").append(errMsg2));
                                LOGGER.error((Object)this.logHelper.formatMsg("20", error));
                                throw new ConfigException(error);
                            }
                            this.arkistoTHPRepositoryMap.put(repoIdentifier, repository);
                            continue block16;
                        }
                        case "ptarkistoAsiakirjat": {
                            if (this.ifRepositoryExists(logId, this.arkistoArchiveDocumentRepositoryMap, repoIdentifier)) {
                                error = ErrorWrapperArchive.getInstance().getError("1017");
                                error.setErrorDescription(new StringBuffer("ptarkistoAsiakirjat").append(errMsg2));
                                LOGGER.error((Object)this.logHelper.formatMsg("20", error));
                                throw new ConfigException(error);
                            }
                            this.arkistoArchiveDocumentRepositoryMap.put(repoIdentifier, repository);
                            continue block16;
                        }
                        case "ptTempHetu": {
                            if (this.ifRepositoryExists(logId, this.arkistoTemporaryPatientIDRepositoryMap, repoIdentifier)) {
                                error = ErrorWrapperArchive.getInstance().getError("1017");
                                error.setErrorDescription(new StringBuffer("ptTempHetu").append(errMsg2));
                                LOGGER.error((Object)this.logHelper.formatMsg("20", error));
                                throw new ConfigException(error);
                            }
                            this.arkistoTemporaryPatientIDRepositoryMap.put(repoIdentifier, repository);
                            continue block16;
                        }
                        case "ptarkistoOld": {
                            if (repository.getMonth() == null) {
                                error = ErrorWrapperArchive.getInstance().getError("1017");
                                error.setErrorDescription(new StringBuffer("ptarkistoOld").append(errMsg));
                                LOGGER.error((Object)this.logHelper.formatMsg("20", error));
                                throw new ConfigException(error);
                            }
                            if (this.ifRepositoryExists(logId, this.arkistoOldDocumentRepositoryMap, repoIdentifier)) {
                                error = ErrorWrapperArchive.getInstance().getError("1017");
                                error.setErrorDescription(new StringBuffer("ptarkistoOld").append(errMsg2));
                                LOGGER.error((Object)this.logHelper.formatMsg("20", error));
                                throw new ConfigException(error);
                            }
                            this.arkistoOldDocumentRepositoryMap.put(repoIdentifier, repository);
                            continue block16;
                        }
                        case "ptTempHetuOld": {
                            if (this.ifRepositoryExists(logId, this.arkistoOldTemporaryPatientIDRepositoryMap, repoIdentifier)) {
                                error = ErrorWrapperArchive.getInstance().getError("1017");
                                error.setErrorDescription(new StringBuffer("ptTempHetuOld").append(errMsg2));
                                LOGGER.error((Object)this.logHelper.formatMsg("20", error));
                                throw new ConfigException(error);
                            }
                            this.arkistoOldTemporaryPatientIDRepositoryMap.put(repoIdentifier, repository);
                            continue block16;
                        }
                    }
                    error = ErrorWrapperArchive.getInstance().getError("1017");
                    error.setErrorDescription(new StringBuffer(errMsg3));
                    LOGGER.error((Object)this.logHelper.formatMsg("20", error));
                    throw new ConfigException(error);
                }
            }
        }
        this.checkRepositories(logId);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void initShpTTRegistryMap(String logId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        if (this.arkistoPalveluConfig != null && this.arkistoPalveluConfig.getShpTTRegistries() != null) {
            this.shpTTRegistryMap = new HashMap<String, Registry>();
            for (Registry registry : this.arkistoPalveluConfig.getShpTTRegistries().getRegistry()) {
                this.shpTTRegistryMap.put(registry.getId(), registry);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void checkRepositories(String logId) throws ConfigException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        InternalServiceError error = null;
        String errMsg = "Virheellinen repositorioiden lukum\u00e4\u00e4r\u00e4 ";
        if (this.arkistoRepositoryMap == null || this.arkistoRepositoryMap.size() != 12) {
            error = ErrorWrapperArchive.getInstance().getError("1017");
            error.setErrorDescription(new StringBuffer(errMsg).append("ptarkisto"));
            LOGGER.error((Object)this.logHelper.formatMsg("20", error));
            throw new ConfigException(error);
        }
        if (this.arkistoTHPRepositoryMap == null || this.arkistoTHPRepositoryMap.size() != 1) {
            error = ErrorWrapperArchive.getInstance().getError("1017");
            error.setErrorDescription(new StringBuffer(errMsg).append("ptsuostumus"));
            LOGGER.error((Object)this.logHelper.formatMsg("20", error));
            throw new ConfigException(error);
        }
        if (this.arkistoOldDocumentRepositoryMap == null || this.arkistoOldDocumentRepositoryMap.size() != 12) {
            error = ErrorWrapperArchive.getInstance().getError("1017");
            error.setErrorDescription(new StringBuffer(errMsg).append("ptarkistoOld"));
            LOGGER.error((Object)this.logHelper.formatMsg("20", error));
            throw new ConfigException(error);
        }
        if (this.arkistoArchiveDocumentRepositoryMap == null || this.arkistoArchiveDocumentRepositoryMap.size() != 1) {
            error = ErrorWrapperArchive.getInstance().getError("1017");
            error.setErrorDescription(new StringBuffer(errMsg).append("ptarkistoAsiakirjat"));
            LOGGER.error((Object)this.logHelper.formatMsg("20", error));
            throw new ConfigException(error);
        }
        if (this.arkistoTemporaryPatientIDRepositoryMap == null || this.arkistoTemporaryPatientIDRepositoryMap.size() != 1) {
            error = ErrorWrapperArchive.getInstance().getError("1017");
            error.setErrorDescription(new StringBuffer(errMsg).append("ptTempHetu"));
            LOGGER.error((Object)this.logHelper.formatMsg("20", error));
            throw new ConfigException(error);
        }
        if (this.arkistoOldTemporaryPatientIDRepositoryMap == null || this.arkistoOldTemporaryPatientIDRepositoryMap.size() != 1) {
            error = ErrorWrapperArchive.getInstance().getError("1017");
            error.setErrorDescription(new StringBuffer(errMsg).append("ptTempHetuOld"));
            LOGGER.error((Object)this.logHelper.formatMsg("20", error));
            throw new ConfigException(error);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    public ArkistoProperties getArkistoProperties(String logId) {
        return this.arkistoProperties;
    }

    public KoostekantaProperties getKoostekantaProperties(String logId) {
        return this.koostekantaProperties;
    }

    public VapakypaValityshistoriaProperties getVapakypaValityshistoriaProperties(String logId) {
        return this.vapakypaValityshistoriaProperties;
    }

    public OstopalvelutProperties getOstopalvelutProperties(String logId) {
        return this.ostopalvelutProperties;
    }

    public SuostumustenHallintaProperties getSuostumustenHallintaProperties(String logId) {
        return this.suostumustenHallintaproperties;
    }

    public RekisterinpitajaPalveluProperties getRekisterinpitajaPalveluProperties() {
        return this.rekisterinpitajaPalveluProperties;
    }

    public Repositories getRepositories(String logId) {
        return this.repositories;
    }

    public String getTargetDocbase(String logId, Map<String, DctmAttribute> attributeMap) throws ConfigException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        if (attributeMap == null) {
            InternalServiceError error = ErrorWrapperArchive.getInstance().getError("1017");
            error.setErrorDescription("AttributeMap oli null");
            error.setReturnDescription(false);
            LOGGER.error((Object)this.logHelper.formatMsg("20", error));
            throw new ConfigException(error);
        }
        String officialPatientId = null;
        String tempPatientId = null;
        String targetDocbase = null;
        if (attributeMap.get("cda_patient_id") != null) {
            officialPatientId = attributeMap.get("cda_patient_id").getAttributeValue().getOriginalValue().getValue();
        }
        if (attributeMap.get("cda_temp_patient_id") != null) {
            tempPatientId = attributeMap.get("cda_temp_patient_id").getAttributeValue().getOriginalValue().getValue();
        }
        if (officialPatientId != null && officialPatientId.length() > 0) {
            targetDocbase = this.getRepository(logId, officialPatientId, "ptarkisto").getName();
        } else if (tempPatientId != null && tempPatientId.length() > 0) {
            targetDocbase = this.getRepository(logId, tempPatientId, "ptTempHetu").getName();
        } else {
            InternalServiceError error = ErrorWrapperArchive.getInstance().getError("1017");
            error.setErrorDescription("Potilaan virallinen hetu sek\u00e4 v\u00e4liaikainen hetu puuttuivat");
            error.setReturnDescription(false);
            LOGGER.error((Object)this.logHelper.formatMsg("20", error));
            throw new ConfigException(error);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return targetDocbase;
    }

    public String getOldDocumentTargetDocbase(String logId, Map<String, DctmAttribute> attributeMap) throws ConfigException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        if (attributeMap == null) {
            InternalServiceError error = ErrorWrapperArchive.getInstance().getError("1017");
            error.setErrorDescription("AttributeMap oli null");
            error.setReturnDescription(false);
            LOGGER.error((Object)this.logHelper.formatMsg("20", error));
            throw new ConfigException(error);
        }
        String officialPatientId = null;
        String tempPatientId = null;
        String targetDocbase = null;
        if (attributeMap.get("cda_patient_id") != null) {
            officialPatientId = attributeMap.get("cda_patient_id").getAttributeValue().getOriginalValue().getValue();
        }
        if (attributeMap.get("cda_temp_patient_id") != null) {
            tempPatientId = attributeMap.get("cda_temp_patient_id").getAttributeValue().getOriginalValue().getValue();
        }
        if (officialPatientId != null && officialPatientId.length() > 0) {
            targetDocbase = this.getRepository(logId, officialPatientId, "ptarkistoOld").getName();
        } else if (tempPatientId != null && tempPatientId.length() > 0) {
            targetDocbase = this.getRepository(logId, tempPatientId, "ptTempHetuOld").getName();
        } else {
            InternalServiceError error = ErrorWrapperArchive.getInstance().getError("1017");
            error.setErrorDescription("Potilaan virallinen hetu sek\u00e4 v\u00e4liaikainen hetu puuttuivat");
            error.setReturnDescription(false);
            LOGGER.error((Object)this.logHelper.formatMsg("20", error));
            throw new ConfigException(error);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return targetDocbase;
    }

    public Repository getRepository(String logId, String patientId, String type) throws ConfigException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        Repository repository = null;
        InternalServiceError error = null;
        String errMsg = "Virheellinen repositorion tyyppitieto: ";
        switch (type) {
            case "ptarkisto": {
                repository = this.getRepositoryByPatientId(logId, patientId, type, this.arkistoRepositoryMap);
                break;
            }
            case "ptarkistoOld": {
                repository = this.getRepositoryByPatientId(logId, patientId, type, this.arkistoOldDocumentRepositoryMap);
                break;
            }
            case "ptsuostumus": {
                repository = this.getRepositoryByIdentifier(logId, this.arkistoTHPRepositoryMap, new RepositoryIdentifier(type, null));
                break;
            }
            case "ptarkistoAsiakirjat": {
                repository = this.getRepositoryByIdentifier(logId, this.arkistoArchiveDocumentRepositoryMap, new RepositoryIdentifier(type, null));
                break;
            }
            case "ptTempHetu": {
                repository = this.getRepositoryByIdentifier(logId, this.arkistoTemporaryPatientIDRepositoryMap, new RepositoryIdentifier(type, null));
                break;
            }
            case "ptTempHetuOld": {
                repository = this.getRepositoryByIdentifier(logId, this.arkistoOldTemporaryPatientIDRepositoryMap, new RepositoryIdentifier(type, null));
                break;
            }
            default: {
                error = ErrorWrapperArchive.getInstance().getError("1017");
                error.setErrorDescription(new StringBuffer(errMsg).append(type));
                LOGGER.error((Object)this.logHelper.formatMsg("20", error));
                throw new ConfigException(error);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return repository;
    }

    public String getShpTTRegistryByCustodian(String logId, String custodian) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        String ttRegistryValue = null;
        if (!this.shpTTRegistryMap.isEmpty() && this.shpTTRegistryMap.get(custodian) != null) {
            ttRegistryValue = this.shpTTRegistryMap.get(custodian).getValue();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return ttRegistryValue;
    }

    private Repository getRepositoryByPatientId(String logId, String patientId, String type, Map<RepositoryIdentifier, Repository> map) throws ConfigException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        Repository repository = null;
        String month = null;
        InternalServiceError error = null;
        if (patientId == null || patientId.length() != 22) {
            error = ErrorWrapperArchive.getInstance().getError("1017");
            error.setErrorDescription(new StringBuffer("Virheellinen patientId pituus"));
            LOGGER.error((Object)this.logHelper.formatMsg("20", error));
            throw new ConfigException(error);
        }
        month = patientId.substring("1.2.246.21".length() + 1).substring(2, 4);
        for (Map.Entry<RepositoryIdentifier, Repository> entry : map.entrySet()) {
            if (!entry.getKey().getType().equals(type) || !entry.getKey().getMonth().equals(month)) continue;
            repository = entry.getValue();
            break;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return repository;
    }

    private Repository getRepositoryByIdentifier(String logId, Map<RepositoryIdentifier, Repository> map, RepositoryIdentifier repoIdentifier) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        Repository repository = null;
        for (Map.Entry<RepositoryIdentifier, Repository> entry : map.entrySet()) {
            if (!entry.getKey().getType().equals(repoIdentifier.getType())) continue;
            if (entry.getKey().getMonth() != null) {
                if (!entry.getKey().getMonth().equals(repoIdentifier.getMonth())) continue;
                repository = entry.getValue();
                break;
            }
            repository = entry.getValue();
            break;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return repository;
    }

    private boolean ifRepositoryExists(String logId, Map<RepositoryIdentifier, Repository> map, RepositoryIdentifier repoIdentifier) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgBgn(logId));
        }
        boolean retVal = false;
        for (Map.Entry<RepositoryIdentifier, Repository> entry : map.entrySet()) {
            if (!entry.getKey().getType().equals(repoIdentifier.getType()) || !entry.getKey().getMonth().equals(repoIdentifier.getMonth())) continue;
            retVal = true;
            break;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgEnd(logId));
        }
        return retVal;
    }

    public Schema getCdaSchema() {
        return this.cdaSchema;
    }

    static {
        try {
            me = new ArkistopalveluConfigManager();
        }
        catch (ConfigException e) {
            e.printStackTrace();
            throw new ExceptionInInitializerError((Throwable)((Object)e));
        }
    }
}

