/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.olddocuments.tasks;

import fi.kanta.arkistopalvelu.olddocuments.exception.MessagingException;
import fi.kanta.arkistopalvelu.olddocuments.interfaces.ICompensateDocumentClient;
import fi.kanta.arkistopalvelu.olddocuments.interfaces.IDocSigner;
import fi.kanta.arkistopalvelu.olddocuments.interfaces.IFetchCodesClient;
import fi.kanta.arkistopalvelu.olddocuments.interfaces.IOldDocumentArchiver;
import fi.kanta.arkistopalvelu.olddocuments.interfaces.IOsoitehakemistoClient;
import fi.kanta.arkistopalvelu.olddocuments.tasks.ArkistoClientCreationTask;
import fi.kanta.arkistopalvelu.olddocuments.tasks.ArkistoClientPool;
import fi.kanta.arkistopalvelu.olddocuments.tasks.CompensateDocumentClientCreationTask;
import fi.kanta.arkistopalvelu.olddocuments.tasks.KompensointiClientPool;
import fi.kanta.arkistopalvelu.olddocuments.tasks.KoodistoClientCreationTask;
import fi.kanta.arkistopalvelu.olddocuments.tasks.KoodistoClientPool;
import fi.kanta.arkistopalvelu.olddocuments.tasks.OsoiteClientCreationTask;
import fi.kanta.arkistopalvelu.olddocuments.tasks.OsoiteClientPool;
import fi.kanta.arkistopalvelu.olddocuments.tasks.SignerClientCreationTask;
import fi.kanta.arkistopalvelu.olddocuments.tasks.SignerClientPool;
import fi.kanta.common.exception.PropertyException;
import java.net.MalformedURLException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class LoaderClientProxies {
    private static ArkistoClientPool arkistoClient;
    private static KoodistoClientPool koodistoClient;
    private static OsoiteClientPool osoiteClient;
    private static SignerClientPool allekirjoitusClient;
    private static KompensointiClientPool kompensointiClient;

    public static void initialize(String logId, int dirThreads, int docThreads) throws InterruptedException, ExecutionException, MalformedURLException, PropertyException, MessagingException {
        ExecutorService execService = Executors.newFixedThreadPool(4);
        Future<List<IOldDocumentArchiver>> future = execService.submit(new ArkistoClientCreationTask(logId, docThreads));
        Future<List<IFetchCodesClient>> koodistoFuture = execService.submit(new KoodistoClientCreationTask(docThreads));
        Future<List<IOsoitehakemistoClient>> osoiteFuture = execService.submit(new OsoiteClientCreationTask(logId, dirThreads));
        Future<List<IDocSigner>> allekirjoitusFuture = execService.submit(new SignerClientCreationTask(logId, docThreads));
        Future<List<ICompensateDocumentClient>> kompensointiFuture = execService.submit(new CompensateDocumentClientCreationTask(1));
        execService.shutdown();
        arkistoClient = new ArkistoClientPool(future.get());
        koodistoClient = new KoodistoClientPool(koodistoFuture.get());
        osoiteClient = new OsoiteClientPool(osoiteFuture.get());
        allekirjoitusClient = new SignerClientPool(allekirjoitusFuture.get());
        kompensointiClient = new KompensointiClientPool(kompensointiFuture.get());
    }

    private LoaderClientProxies() {
    }

    public static ArkistoClientPool getArkistoClient() {
        return arkistoClient;
    }

    public static KoodistoClientPool getKoodistoClient() {
        return koodistoClient;
    }

    public static OsoiteClientPool getOsoiteClient() {
        return osoiteClient;
    }

    public static SignerClientPool getAllekirjoitusClient() {
        return allekirjoitusClient;
    }

    public static KompensointiClientPool getKompensointiClient() {
        return kompensointiClient;
    }
}

