/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.util;

import fi.kanta.arkistopalvelu.client.FetchCodesClient;
import fi.kanta.arkistopalvelu.exception.CodeFetcherException;
import fi.kanta.arkistopalvelu.util.ArkistoConstants;
import fi.kanta.arkistopalvelu.util.ErrorWrapperArchive;
import fi.kanta.arkistopalvelu.util.configurations.ArkistopalveluConfigManager;
import fi.kanta.arkistopalvelu.util.xpathconfig.AttributeValueType;
import fi.kanta.arkistopalvelu.util.xpathconfig.DctmAttribute;
import fi.kanta.arkistopalvelu.util.xpathconfig.ObjectValueType;
import fi.kanta.common.components.DateHelper;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.exception.UtilException;
import fi.kanta.common.util.InternalServiceError;
import fi.kanta.koodistopalvelu.webservices.peruskoodisto.BasicCode;
import fi.kanta.koodistopalvelu.webservices.peruskoodisto.BasicCodeIn;
import fi.kanta.koodistopalvelu.webservices.peruskoodisto.BasicCodeResponse;
import fi.kanta.koodistopalvelu.webservices.peruskoodisto.Code;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class AttributeValidator {
    private static final Logger LOGGER = Logger.getLogger(AttributeValidator.class);
    private List<BasicCodeIn> codeSystemValidations = new ArrayList<BasicCodeIn>();
    private DateHelper dh = new DateHelper(true);
    private ArkistopalveluConfigManager configManager = ArkistopalveluConfigManager.getInstance();
    private LogHelper logHelper;
    private ErrorWrapperArchive errorWrapper = ErrorWrapperArchive.getInstance();
    private Date dateLimit;

    public AttributeValidator() {
        this.logHelper = new LogHelper();
        this.dateLimit = this.getDate(4000, 11, 31);
    }

    private Date getDate(int year, int month, int date) {
        Calendar working = GregorianCalendar.getInstance();
        working.set(year, month, date, 0, 0, 0);
        return working.getTime();
    }

    public void validate(String logId, AttributeValueType attrValueType, DctmAttribute attr) throws UtilException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgBgn(logId));
        }
        if (attr.getIsNodelist() != null && attr.getIsNodelist().isValue()) {
            InternalServiceError error = this.errorWrapper.getError("1017");
            error.setErrorDescription("Attribuutti on nodelist, mutta annettiin yksiarvoiseen validointiin");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
            throw new UtilException(error);
        }
        this.validateAttr(logId, attrValueType, attr, this.getAttributeXpath(logId, attr));
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private String getAttributeXpath(String logId, DctmAttribute attr) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgBgn(logId));
        }
        StringBuilder xpath = new StringBuilder();
        if (attr.getDctmAttributeXpath() == null) {
            xpath.append(attr.getName());
        } else {
            xpath = new StringBuilder(attr.getDctmAttributeXpath());
            if (attr.getDctmAttributeRelativeXpath() != null) {
                xpath.append(" ").append(attr.getDctmAttributeRelativeXpath());
            }
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgEnd(logId));
        }
        return xpath.toString();
    }

    private void validateAttr(String logId, AttributeValueType attrValueType, DctmAttribute attr, String xpath) throws UtilException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgBgn(logId));
        }
        String attrValue = null;
        InternalServiceError error = null;
        if (attrValueType != null && attrValueType.getOriginalValue() != null) {
            attrValue = attrValueType.getOriginalValue().getValue();
        }
        this.validateMinLength(logId, attrValue, attr, xpath);
        this.validateMaxLength(logId, attrValue, attr, xpath);
        if (attrValueType != null && (attr.getIsNodelist() == null || attr.getIsNodelist() != null && !attr.getIsNodelist().isValue() || attr.isIsRepeating() != null && attr.isIsRepeating().booleanValue())) {
            attrValueType.setFormattedValue(attrValue);
        }
        switch (attr.getDctmAttributeType().getValue()) {
            case "S": {
                this.addSCodesystemValidation(logId, attrValue, attr);
                break;
            }
            case "T": {
                this.validateT(logId, attrValue, attr, xpath);
                break;
            }
            case "I": {
                break;
            }
            case "II": {
                if (attr.getDctmAttributeType().getChecktype() != null) {
                    switch (attr.getDctmAttributeType().getChecktype()) {
                        case BOTH: {
                            this.validateII(logId, attrValue, attr, xpath);
                            break;
                        }
                        case ROOT: {
                            if (attrValueType == null || attrValueType.getOriginalValue() == null) break;
                            this.validateII(logId, attrValueType.getOriginalValue().getFirstValue(), attr, xpath);
                            break;
                        }
                        case EXTENSION: {
                            if (attrValueType == null || attrValueType.getOriginalValue() == null) break;
                            this.validateII(logId, attrValueType.getOriginalValue().getSecondValue(), attr, xpath);
                            break;
                        }
                    }
                    break;
                }
                this.validateII(logId, attrValue, attr, xpath);
                break;
            }
            case "IVL": {
                break;
            }
            case "CV": {
                this.validateCV(logId, attrValue, attr);
                this.addCVCodesystemValidation(logId, attrValue, attr, xpath);
                break;
            }
            case "BL": {
                this.validateBL(logId, attrValue, attr, xpath);
                break;
            }
            case "PAT": {
                this.validatePatientId(logId, attrValue, attr, false);
                break;
            }
            case "PAT_Y": {
                this.validatePatientId(logId, attrValue, attr, true);
                break;
            }
            case "EL": {
                break;
            }
            case "LIST": {
                break;
            }
            default: {
                error = this.errorWrapper.getError("1017");
                error.setErrorDescription(new StringBuffer("Tuntematon attribuuttityyppi."));
                LOGGER.error((Object)this.logHelper.formatMsg("20", error));
                throw new UtilException(error);
            }
        }
        if (attr.getDctmAttributeType().getValue().equals("T")) {
            this.validateRequiredTimeValues(logId, attrValue, attr);
        } else if (attr.getRequiredAttributeValues() != null && !attr.getRequiredAttributeValues().isEmpty()) {
            this.validateRequiredValues(logId, attrValue, attr);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void validateRequiredValues(String logId, String attrValue, DctmAttribute attr) throws UtilException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgBgn(logId));
        }
        if (attr.getRequiredAttributeValues() != null && !attr.getRequiredAttributeValues().isEmpty() && !attr.getRequiredAttributeValues().contains(attrValue)) {
            if (attr.getDctmAttributeType().getValue().equals("BL")) {
                InternalServiceError error = this.errorWrapper.getError("1029");
                error.setErrorDescription(this.getAttributeXpath(logId, attr));
                LOGGER.error((Object)this.logHelper.formatMsg("20", error));
                throw new UtilException(error);
            }
            InternalServiceError error = this.errorWrapper.getError("1114");
            error.setErrorDescription(this.getAttributeXpath(logId, attr));
            LOGGER.error((Object)this.logHelper.formatMsg("20", error));
            throw new UtilException(error);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void validateRequiredTimeValues(String logId, String attrValue, DctmAttribute attr) throws UtilException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgBgn(logId));
        }
        Date compareDate = null;
        boolean isError = false;
        try {
            compareDate = this.dh.toDate(logId, attrValue);
        }
        catch (UtilException e) {
            LOGGER.error((Object)this.logHelper.formatMsg(logId, e.getInternalServiceError()));
            throw new UtilException(e.getInternalServiceError());
        }
        if (compareDate != null && compareDate.after(this.dateLimit)) {
            if (attr.getRequiredAttributeValues() != null && !attr.getRequiredAttributeValues().isEmpty()) {
                if (attr.getRequiredAttributeValues().contains("RETURN_DATELIMIT")) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Attribuutti: " + attr.getName() + " yli maksimiarvon, asetetaan arvoksi " + "4000/12/31 00:00:00"));
                    }
                    if (attr.getAttributeValue() != null && (attr.getIsNodelist() == null || attr.getIsNodelist() != null && !attr.getIsNodelist().isValue())) {
                        attr.getAttributeValue().setFormattedValue("4000/12/31 00:00:00");
                    }
                } else {
                    isError = true;
                }
            } else {
                isError = true;
            }
        }
        if (isError) {
            InternalServiceError error = this.errorWrapper.getError("1029");
            error.setErrorDescription(this.getAttributeXpath(logId, attr));
            LOGGER.error((Object)this.logHelper.formatMsg("20", error));
            throw new UtilException(error);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    public void validate(String logId, List<AttributeValueType> attrValueList, DctmAttribute attr) throws UtilException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgBgn(logId));
        }
        if (!attr.getIsNodelist().isValue()) {
            InternalServiceError error = this.errorWrapper.getError("1017");
            error.setErrorDescription("Listan validointia kutsuttiin attribuutille, joka ei ole nodelist");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
            throw new UtilException(error);
        }
        String xpath = this.getAttributeXpath(logId, attr);
        if ((attrValueList == null || attrValueList.isEmpty()) && attr.getAttributeMinLength().intValue() > 0) {
            InternalServiceError error = this.errorWrapper.getError("1015");
            error.setErrorDescription("Attribuutin arvo liian lyhyt. " + xpath);
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
            throw new UtilException(error);
        }
        StringBuilder finalString = new StringBuilder();
        if (attrValueList != null) {
            for (AttributeValueType attrValue : attrValueList) {
                this.validateAttr(logId, attrValue, attr, xpath);
                if (attrValue.getOriginalValue() != null) {
                    finalString.append(attrValue.getOriginalValue().getValue());
                }
                if (attr.getIsNodelist().getSeparator() == null) continue;
                finalString.append(attr.getIsNodelist().getSeparator());
            }
        }
        String val = finalString.toString();
        if (attr.getDctmAttributeType().equals("S")) {
            val = val.trim();
        }
        if (attr.getAttributeMaxLengthTotal() != null && val.length() > attr.getAttributeMaxLengthTotal().intValue()) {
            InternalServiceError error = this.errorWrapper.getError("1139");
            error.setErrorDescription("Listan kokonaisuuspituus ylitti suurimman sallitun. " + xpath);
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
            throw new UtilException(error);
        }
        if (attr.getAttributeValue() == null) {
            AttributeValueType attrType = new AttributeValueType();
            attrType.setFormattedValue(val);
            attr.setAttributeValue(attrType);
        } else {
            attr.getAttributeValue().setFormattedValue(val);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    public void validateObjectValues(String logId, List<DctmAttribute.AttributeObjectValue> attrValue, DctmAttribute attr) throws UtilException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgBgn(logId));
        }
        if (attr.getObjectRelativeXpath() != null && attr.getObjectRelativeXpath().size() > 0) {
            for (DctmAttribute.ObjectRelativeXpath path : attr.getObjectRelativeXpath()) {
                StringBuilder totalValue = new StringBuilder();
                for (DctmAttribute.AttributeObjectValue objectValue : attrValue) {
                    ObjectValueType value = (ObjectValueType)objectValue.getValues().get(path.getKey());
                    String separator = "*|*";
                    if (path.getSeparator() != null) {
                        separator = path.getSeparator();
                    }
                    DctmAttribute tempAttr = new DctmAttribute();
                    if (value.getMinLength() != null) {
                        tempAttr.setAttributeMinLength(value.getMinLength());
                    } else {
                        tempAttr.setAttributeMinLength(new BigInteger("0"));
                    }
                    if (value.getMaxLength() != null) {
                        tempAttr.setAttributeMaxLength(value.getMaxLength());
                    }
                    DctmAttribute.DctmAttributeType type = new DctmAttribute.DctmAttributeType();
                    type.setValue(value.getType());
                    tempAttr.setDctmAttributeType(type);
                    if (path.getChecktype() != null) {
                        type.setChecktype(path.getChecktype());
                    }
                    tempAttr.setName(path.getKey());
                    for (AttributeValueType attrObject : value.getValueList()) {
                        this.validateAttr(logId, attrObject, tempAttr, value.getXpath());
                        totalValue.append(attrObject.getOriginalValue().getValue()).append(separator);
                    }
                }
                if (attr.getAttributeMaxLengthTotal() == null || totalValue.length() <= attr.getAttributeMaxLengthTotal().intValue()) continue;
                InternalServiceError error = this.errorWrapper.getError("1139");
                error.setErrorDescription("Nodelistin kokonaisuuspituus ylitti suurimman sallitun: " + path.getKey() + " length: " + totalValue.length() + " max: " + attr.getAttributeMaxLengthTotal().intValue());
                error.setReturnDescription(false);
                LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
                throw new UtilException(error);
            }
        }
        if ("LIST".equals(attr.getDctmAttributeType().getValue())) {
            this.validateListOfLists(logId, attrValue, attr);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    public void validateRepeatingValues(String logId, List<AttributeValueType> attrValue, DctmAttribute attr) throws UtilException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgBgn(logId));
        }
        if (!attr.getIsNodelist().isValue()) {
            InternalServiceError error = this.errorWrapper.getError("1017");
            error.setErrorDescription("Listan validointia kutsuttiin attribuutille, joka ei ole nodelist");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
            throw new UtilException(error);
        }
        for (AttributeValueType singleAttr : attrValue) {
            this.validateAttr(logId, singleAttr, attr, this.getAttributeXpath(logId, attr));
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void validateT(String logId, String attrValue, DctmAttribute attr, String xpath) throws UtilException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgBgn(logId));
        }
        String date = "";
        try {
            date = this.dh.toOracleLongDate(logId, attrValue);
            if (attr.getAttributeValue() != null && (attr.getIsNodelist() == null || attr.getIsNodelist() != null && !attr.getIsNodelist().isValue())) {
                attr.getAttributeValue().setFormattedValue(date);
            }
        }
        catch (UtilException e) {
            LOGGER.error((Object)this.logHelper.formatMsg(logId, e.getInternalServiceError()));
            e.getInternalServiceError().setErrorDescription(xpath);
            throw new UtilException(e.getInternalServiceError());
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void validateBL(String logId, String attrValue, DctmAttribute attr, String xpath) throws UtilException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgBgn(logId));
        }
        StringBuilder desc = null;
        if ((attr.getAttributeMinLength() != null && !attr.getAttributeMinLength().equals(BigInteger.ZERO) || attrValue != null && attrValue.length() > 0) && !"true".equals(attrValue) && !"false".equals(attrValue)) {
            desc = new StringBuilder("BL tyyppinen attribuutti virheellinen ").append(xpath);
            InternalServiceError error = this.errorWrapper.getError("1029");
            error.setErrorDescription(desc.toString());
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
            throw new UtilException(error);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void validateCV(String logId, String attrValue, DctmAttribute attr) {
    }

    private void validateII(String logId, String attrValue, DctmAttribute attr, String xpath) throws UtilException {
        if (attrValue != null && attrValue.length() > 0) {
            if (!Pattern.matches("[0-2](\\.(0|[1-9][0-9]*))*", attrValue)) {
                InternalServiceError error = this.errorWrapper.getError("1029");
                error.setErrorDescription(xpath + ": " + attrValue);
                LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
                throw new UtilException(error);
            }
            if (attr.getAttributeValue() != null && (attr.getIsNodelist() == null || attr.getIsNodelist() != null && !attr.getIsNodelist().isValue())) {
                attr.getAttributeValue().setFormattedValue(attr.getAttributeValue().getOriginalValue().getValue());
            }
        }
    }

    public void addCVCodesystemValidation(String logId, String attrValue, DctmAttribute attr, String xpath) throws UtilException {
        List<String> allowedCodeSystemList;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgBgn(logId));
        }
        if ((allowedCodeSystemList = attr.getCodesystemCheck()) != null && allowedCodeSystemList.size() > 0 && attrValue != null && attrValue.length() > 0) {
            String[] split = attrValue.split("!");
            if (split.length == 2 && allowedCodeSystemList.contains(split[0])) {
                BasicCodeIn codeIn = new BasicCodeIn();
                codeIn.setLanguage("fi");
                codeIn.setVersionoid(split[0]);
                codeIn.setCodeid(split[1]);
                this.codeSystemValidations.add(codeIn);
            } else {
                InternalServiceError error = this.errorWrapper.getError("1016");
                error.setErrorDescription("Tunnistamaton koodisto asiakirjalla " + xpath);
                LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
                throw new UtilException(error);
            }
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void addSCodesystemValidation(String logId, String attrValue, DctmAttribute attr) throws UtilException {
        List<String> allowedCodeSystemList;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgBgn(logId));
        }
        if ((allowedCodeSystemList = attr.getCodesystemCheck()).size() > 0 && attrValue != null && attrValue.length() > 0) {
            BasicCodeIn codeIn = new BasicCodeIn();
            codeIn.setLanguage("fi");
            codeIn.setVersionoid(allowedCodeSystemList.get(0));
            codeIn.setCodeid(attrValue);
            this.codeSystemValidations.add(codeIn);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    public void validateCodesystems(String logId) throws UtilException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgBgn(logId));
        }
        try {
            if (this.codeSystemValidations != null && this.codeSystemValidations.size() > 0) {
                List<BasicCodeResponse> responses = this.getCodes(logId, this.codeSystemValidations);
                this.checkBasicCodeResponse(logId, this.codeSystemValidations, responses);
            }
        }
        catch (CodeFetcherException ex) {
            throw new UtilException(ex.getInternalServiceError());
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void validateMinLength(String logId, String attrValue, DctmAttribute attr, String xpath) throws UtilException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgBgn(logId));
        }
        StringBuilder desc = null;
        if (!(attr.getAttributeMinLength() == null || attr.getAttributeMinLength().equals(BigInteger.ZERO) || attrValue != null && attr.getAttributeMinLength().intValue() <= attrValue.length())) {
            if (attr.getDctmAttributeType().getValue().equals("T")) {
                desc = new StringBuilder("P\u00e4iv\u00e4m\u00e4\u00e4r\u00e4 puuttuu tai on virheellinen ").append(xpath);
                InternalServiceError error = this.errorWrapper.getError("1015");
                error.setErrorDescription(desc.toString());
                LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
                throw new UtilException(error);
            }
            desc = new StringBuilder("Attribuutin arvo liian lyhyt ").append(xpath);
            InternalServiceError error = this.errorWrapper.getError("1015");
            error.setErrorDescription(desc.toString());
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
            throw new UtilException(error);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void validateMaxLength(String logId, String attrValue, DctmAttribute attr, String xpath) throws UtilException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgBgn(logId));
        }
        StringBuilder desc = null;
        if (attr.getAttributeMaxLength() != null && attrValue != null && attr.getAttributeMaxLength().intValue() < attrValue.length()) {
            desc = new StringBuilder("Attribuutin arvo liian pitk\u00e4 ").append(xpath);
            InternalServiceError error = this.errorWrapper.getError("1139");
            error.setErrorDescription(desc.toString());
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
            throw new UtilException(error);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void validatePatientId(String logId, String attrValue, DctmAttribute attr, boolean commonCheck) throws UtilException {
        InternalServiceError error = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        if (commonCheck) {
            error = this.errorWrapper.getError("1029");
            error.setErrorDescription("Ty\u00f6terveyshuollon rekisterin tarkenne: " + attrValue);
        } else {
            error = this.errorWrapper.getError("1019");
        }
        try {
            if (attrValue != null && attrValue.length() > 0) {
                if (attrValue.length() != 11) {
                    LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
                    throw new UtilException(error);
                }
                if (!Pattern.matches("^[0-3][0-9][0-1][0-9][0-9][0-9][+-A][0-9][0-9][0-9][0-9A-Y]", attrValue)) {
                    LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
                    throw new UtilException(error);
                }
                int number = 0;
                try {
                    number = Integer.parseInt(attrValue.substring(0, 6) + attrValue.substring(7, 10));
                }
                catch (NumberFormatException ex) {
                    LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
                    throw new UtilException(error);
                }
                int leftOver = number % 31;
                String check = ArkistoConstants.CHECKTABLE[leftOver];
                if (!check.equalsIgnoreCase(attrValue.substring(10, 11))) {
                    LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
                    throw new UtilException(error);
                }
            } else if (attr.getAttributeMinLength().intValue() > 0) {
                LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
                throw new UtilException(error);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
            }
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
    }

    private void validateListOfLists(String logId, List<DctmAttribute.AttributeObjectValue> attrValue, DctmAttribute attr) throws UtilException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgBgn(logId));
        }
        String innerSeparator = attr.getDctmAttributeType().getSeparator();
        String outerSeparator = attr.getIsNodelist().getSeparator();
        StringBuilder allListsString = new StringBuilder();
        if (attr.getObjectRelativeXpath() != null && attr.getObjectRelativeXpath().size() > 0) {
            for (DctmAttribute.ObjectRelativeXpath path : attr.getObjectRelativeXpath()) {
                for (DctmAttribute.AttributeObjectValue objectValue : attr.getAttributeObjectValue()) {
                    StringBuilder innerListString = new StringBuilder();
                    ObjectValueType value = (ObjectValueType)objectValue.getValues().get(path.getKey());
                    for (AttributeValueType attrObject : value.getValueList()) {
                        innerListString.append(attrObject.getOriginalValue().getValue()).append(innerSeparator);
                    }
                    allListsString.append((CharSequence)innerListString).append(outerSeparator);
                }
            }
        }
        if (attr.getAttributeMaxLengthTotal() != null && allListsString.length() > attr.getAttributeMaxLengthTotal().intValue()) {
            InternalServiceError error = this.errorWrapper.getError("1139");
            error.setErrorDescription("Listan kokonaisuuspituus ylitti suurimman sallitun. " + attr.getDctmAttributeXpath());
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
            throw new UtilException(error);
        }
        if (attr.getAttributeValue() == null) {
            attr.setAttributeValue(new AttributeValueType());
        }
        attr.getAttributeValue().setFormattedValue(allListsString.toString());
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void checkBasicCodeResponse(String logId, List<BasicCodeIn> codeInList, List<BasicCodeResponse> responses) throws UtilException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgBgn(logId));
        }
        if (responses != null) {
            for (int i = 0; i < responses.size(); ++i) {
                InternalServiceError error;
                BasicCodeResponse response = responses.get(i);
                BasicCode basicCode = response.getResponse();
                if (basicCode == null) {
                    InternalServiceError error2 = this.errorWrapper.getError("1016");
                    error2.setErrorDescription("Koodia (" + codeInList.get(i).getCodeid() + ") ei l\u00f6ytynyt koodistosta (" + codeInList.get(i).getVersionoid() + ")");
                    LOGGER.error((Object)this.logHelper.formatMsg(logId, error2));
                    throw new UtilException(error2);
                }
                String codeId = "";
                if (basicCode.getCode() != null && basicCode.getCode().size() > 0) {
                    List code = basicCode.getCode();
                    codeId = ((Code)code.get(0)).getCodeId();
                }
                if (codeId == null || codeId.length() == 0) {
                    error = this.errorWrapper.getError("1016");
                    error.setErrorDescription("Koodia ei saatu koodistosta ");
                    LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
                    throw new UtilException(error);
                }
                if (response.getBasicCodeResponseDetails().getResultCode().equals("400000")) continue;
                error = this.errorWrapper.getError("1016");
                error.setErrorDescription("Koodia ei saatu koodistosta ");
                LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
                throw new UtilException(error);
            }
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private List<BasicCodeResponse> getCodes(String logId, List<BasicCodeIn> codeInList) throws CodeFetcherException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgBgn(logId));
        }
        List<BasicCodeResponse> resp = null;
        FetchCodesClient client = new FetchCodesClient(logId, codeInList);
        resp = client.call();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgEnd(logId));
        }
        return resp;
    }
}

