/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.util;

import fi.kanta.arkistopalvelu.util.ErrorWrapperArchive;
import fi.kanta.arkistopalvelu.util.IArkistoXPathHelperVTD;
import fi.kanta.arkistopalvelu.util.IMetadataReader;
import fi.kanta.arkistopalvelu.util.xpathconfig.AttributeValueType;
import fi.kanta.arkistopalvelu.util.xpathconfig.DctmAttribute;
import fi.kanta.arkistopalvelu.util.xpathconfig.DctmAttributeForbidden;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.exception.UtilException;
import fi.kanta.common.util.InternalServiceError;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MetadataReader
implements IMetadataReader {
    private static final Logger LOGGER = Logger.getLogger(MetadataReader.class);
    private LogHelper logHelper;
    private ErrorWrapperArchive errorWrapper = ErrorWrapperArchive.getInstance();

    public MetadataReader() {
        this.logHelper = new LogHelper();
    }

    @Override
    public Map<String, DctmAttribute> readMetadata(String logId, IArkistoXPathHelperVTD xpathHelper, List<DctmAttribute> attrList, Map<String, DctmAttribute> attrMap) throws UtilException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        InternalServiceError error = null;
        AttributeValueType attrValue = null;
        List<DctmAttribute.AttributeObjectValue> objectValues = null;
        List<AttributeValueType> attributeValues = null;
        String separator = null;
        if (attrList != null && !attrList.isEmpty()) {
            for (DctmAttribute dctmAttr : attrList) {
                attrValue = null;
                attributeValues = null;
                objectValues = null;
                switch (dctmAttr.getDctmAttributeType().getValue()) {
                    case "S": 
                    case "BL": 
                    case "PAT": 
                    case "T": 
                    case "LIST": {
                        if (dctmAttr.getIsNodelist().isValue()) {
                            if (dctmAttr.getDctmAttributeRelativeXpath() != null) {
                                if (dctmAttr.getIsNodelist().isIncEmtpy() != null && dctmAttr.getIsNodelist().isIncEmtpy().booleanValue()) {
                                    attributeValues = xpathHelper.getValuesFromNodeListInclEmpty(logId, dctmAttr.getDctmAttributeXpath(), dctmAttr.getDctmAttributeRelativeXpath());
                                    break;
                                }
                                attributeValues = xpathHelper.getValuesFromNodeList(logId, dctmAttr.getDctmAttributeXpath(), dctmAttr.getDctmAttributeRelativeXpath());
                                break;
                            }
                            if (dctmAttr.getObjectRelativeXpath() != null && dctmAttr.getObjectRelativeXpath().size() > 0) {
                                objectValues = xpathHelper.getValueObjectsFromNodeListInclEmpty(logId, dctmAttr.getDctmAttributeXpath(), dctmAttr.getObjectRelativeXpath());
                                break;
                            }
                            attributeValues = xpathHelper.getValuesFromNodeList(logId, dctmAttr.getDctmAttributeXpath());
                            break;
                        }
                        attrValue = new AttributeValueType();
                        AttributeValueType.OriginalValue origValue = new AttributeValueType.OriginalValue();
                        origValue.setValue(xpathHelper.getCode(logId, dctmAttr.getDctmAttributeXpath()));
                        attrValue.setOriginalValue(origValue);
                        if (dctmAttr.getObjectRelativeXpath() == null || dctmAttr.getObjectRelativeXpath().size() <= 0) break;
                        objectValues = xpathHelper.getValueObjectsFromNode(logId, dctmAttr.getDctmAttributeXpath(), dctmAttr.getObjectRelativeXpath());
                        break;
                    }
                    case "I": {
                        attrValue = new AttributeValueType();
                        AttributeValueType.OriginalValue origValue = new AttributeValueType.OriginalValue();
                        origValue.setValue(xpathHelper.getCode(logId, dctmAttr.getDctmAttributeXpath()));
                        attrValue.setOriginalValue(origValue);
                        break;
                    }
                    case "II": {
                        separator = ".";
                        if (dctmAttr.getDctmAttributeType().getSeparator() != null) {
                            separator = dctmAttr.getDctmAttributeType().getSeparator();
                        }
                        if (dctmAttr.getIsNodelist().isValue()) {
                            if (dctmAttr.getDctmAttributeRelativeXpath() != null) {
                                if (dctmAttr.getIsNodelist().isIncEmtpy() != null && dctmAttr.getIsNodelist().isIncEmtpy().booleanValue()) {
                                    attributeValues = xpathHelper.getIIvaluesFromNodeListInclEmpty(logId, dctmAttr.getDctmAttributeXpath(), dctmAttr.getDctmAttributeRelativeXpath(), separator);
                                    break;
                                }
                                attributeValues = xpathHelper.getIIvaluesFromNodeList(logId, dctmAttr.getDctmAttributeXpath(), dctmAttr.getDctmAttributeRelativeXpath(), separator);
                                break;
                            }
                            if (dctmAttr.getObjectRelativeXpath() != null && dctmAttr.getObjectRelativeXpath().size() > 0) {
                                objectValues = xpathHelper.getValueObjectsFromNodeListInclEmpty(logId, dctmAttr.getDctmAttributeXpath(), dctmAttr.getObjectRelativeXpath());
                                break;
                            }
                            attributeValues = xpathHelper.getIIvaluesFromNodeList(logId, dctmAttr.getDctmAttributeXpath(), separator);
                            break;
                        }
                        attrValue = xpathHelper.getIIValue(logId, dctmAttr.getDctmAttributeXpath(), separator);
                        if (dctmAttr.getObjectRelativeXpath() == null || dctmAttr.getObjectRelativeXpath().size() <= 0) break;
                        objectValues = xpathHelper.getValueObjectsFromNode(logId, dctmAttr.getDctmAttributeXpath(), dctmAttr.getObjectRelativeXpath());
                        break;
                    }
                    case "IVL": {
                        attrValue = xpathHelper.getIIValue(logId, dctmAttr.getDctmAttributeXpath(), ".");
                        break;
                    }
                    case "CV": {
                        separator = "!";
                        if (dctmAttr.getDctmAttributeType().getSeparator() != null) {
                            separator = dctmAttr.getDctmAttributeType().getSeparator();
                        }
                        if (dctmAttr.getIsNodelist().isValue()) {
                            attributeValues = xpathHelper.getUniqueCVvaluesFromNodeList(logId, dctmAttr.getDctmAttributeXpath(), separator, false);
                            break;
                        }
                        attrValue = xpathHelper.getCVvalue(logId, dctmAttr.getDctmAttributeXpath(), separator);
                        break;
                    }
                    case "EL": {
                        attrValue = new AttributeValueType();
                        String attrString = xpathHelper.getAsString(logId, dctmAttr.getDctmAttributeXpath());
                        AttributeValueType.OriginalValue origValue = new AttributeValueType.OriginalValue();
                        origValue.setValue(attrString);
                        attrValue.setOriginalValue(origValue);
                        break;
                    }
                    default: {
                        error = this.errorWrapper.getError("1017");
                        error.setErrorDescription(new StringBuffer("Tuntematon attribuuttityyppi."));
                        LOGGER.error((Object)this.logHelper.formatMsg("20", error));
                        throw new UtilException(error);
                    }
                }
                if (dctmAttr.getIsNodelist().isValue() && attributeValues != null) {
                    if (dctmAttr.getIsNodelist().isRemoveDuplicates() != null && dctmAttr.getIsNodelist().isRemoveDuplicates().booleanValue()) {
                        attributeValues = this.removeDuplicates(logId, attributeValues);
                    }
                    dctmAttr.getAttributeValues().addAll(attributeValues);
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace((Object)("Poimittu xpath: " + dctmAttr.getDctmAttributeXpath()));
                    }
                } else if (dctmAttr.getIsNodelist().isValue() && objectValues != null) {
                    dctmAttr.getAttributeObjectValue().addAll(objectValues);
                } else {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace((Object)("Poimittu xpath: " + dctmAttr.getDctmAttributeXpath()));
                    }
                    dctmAttr.setAttributeValue(attrValue);
                    if (objectValues != null) {
                        dctmAttr.getAttributeObjectValue().addAll(objectValues);
                    }
                }
                attrMap.put(dctmAttr.getName(), dctmAttr);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return attrMap;
    }

    @Override
    public void checkForbiddenElements(String logId, IArkistoXPathHelperVTD xpathHelper, List<DctmAttributeForbidden> forbiddenAttributes) throws UtilException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        InternalServiceError error = null;
        String val = null;
        if (forbiddenAttributes != null && !forbiddenAttributes.isEmpty()) {
            for (DctmAttributeForbidden dctmAttr : forbiddenAttributes) {
                boolean isAttribute = false;
                String xpath = dctmAttr.getDctmAttributeXpath();
                int index = xpath.lastIndexOf(47);
                if (index > 0 && xpath.length() > index + 1 && xpath.charAt(index + 1) == '@') {
                    isAttribute = true;
                }
                if ((val = isAttribute ? xpathHelper.getCode(logId, dctmAttr.getDctmAttributeXpath()) : xpathHelper.getAsString(logId, dctmAttr.getDctmAttributeXpath())) == null || val.trim().length() <= 0) continue;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)("Kielletty elementti: " + dctmAttr.getDctmAttributeXpath()));
                }
                error = this.errorWrapper.getError("1115");
                error.setErrorDescription("Kielletty elementti: " + dctmAttr.getDctmAttributeXpath());
                LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
                throw new UtilException(error);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private List<AttributeValueType> removeDuplicates(String logId, List<AttributeValueType> attributeValues) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        ArrayList<AttributeValueType> filteredAttributeValues = new ArrayList<AttributeValueType>();
        HashMap<String, AttributeValueType> valueMap = new HashMap<String, AttributeValueType>();
        for (AttributeValueType attributeValue : attributeValues) {
            String key = attributeValue.getOriginalValue().getValue();
            if (valueMap.containsKey(key)) continue;
            valueMap.put(key, attributeValue);
        }
        filteredAttributeValues.addAll(valueMap.values());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return filteredAttributeValues;
    }
}

