/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.util.configurations;

import fi.kanta.arkistopalvelu.util.configurations.ArkistopalveluConfig;
import fi.kanta.common.components.LogHelper;
import java.io.File;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class ArkistopalveluConfigMiddleManager {
    private static final Logger LOGGER = Logger.getLogger(ArkistopalveluConfigMiddleManager.class);
    private LogHelper logHelper = new LogHelper();
    private Schema arkistoConfigSchema;

    public ArkistopalveluConfig readArkistopalveluConfig(String logId, SchemaFactory factory) throws JAXBException, SAXException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn("20"));
        }
        String arkistoPath = System.getProperty("arkistopalvelu.path");
        String propPath = arkistoPath + System.getProperty("file.separator") + "config" + System.getProperty("file.separator") + "arkistopalvelu.xml";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsg("20", "reading arkistopalvelu.xml", propPath));
        }
        File propFile = new File(propPath);
        if (factory == null) {
            factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        }
        String fileName = arkistoPath + System.getProperty("file.separator") + "config" + System.getProperty("file.separator") + "arkistopalvelu.xsd";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsg("20", "Reading schema", fileName));
        }
        this.arkistoConfigSchema = factory.newSchema(new StreamSource(new File(fileName)));
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ArkistopalveluConfig.class});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        jaxbUnmarshaller.setSchema(this.arkistoConfigSchema);
        return (ArkistopalveluConfig)jaxbUnmarshaller.unmarshal(propFile);
    }
}

