/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.olddocuments;

import fi.kanta.arkistopalvelu.olddocuments.exception.ConfigException;
import fi.kanta.arkistopalvelu.olddocuments.exception.ErrorWrapperLoader;
import fi.kanta.arkistopalvelu.olddocuments.exception.MessagingException;
import fi.kanta.arkistopalvelu.olddocuments.filesystem.ListSubDirectories;
import fi.kanta.arkistopalvelu.olddocuments.logging.DbLogger;
import fi.kanta.arkistopalvelu.olddocuments.logging.RunMode;
import fi.kanta.arkistopalvelu.olddocuments.messaging.FetchCodesClient;
import fi.kanta.arkistopalvelu.olddocuments.metadata.ExecutionMode;
import fi.kanta.arkistopalvelu.olddocuments.tasks.DirectoryData;
import fi.kanta.arkistopalvelu.olddocuments.tasks.DirectoryTask;
import fi.kanta.arkistopalvelu.olddocuments.tasks.LoaderClientProxies;
import fi.kanta.arkistopalvelu.olddocuments.tasks.TaskResult;
import fi.kanta.arkistopalvelu.olddocuments.utils.ConsoleWriter;
import fi.kanta.arkistopalvelu.olddocuments.utils.PropertyHandler;
import fi.kanta.common.exception.PropertyException;
import fi.kanta.common.util.InternalServiceError;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class Scheduler {
    private static final Logger log4j = Logger.getLogger(Scheduler.class);
    private static String useinternacodesclient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block18: {
            DbLogger logger;
            ExecutorService dirExecutorService = null;
            ExecutorService palvelutapahtumaPool = null;
            ExecutorService hoitoasiakirjaPool = null;
            long start = System.currentTimeMillis();
            try {
                ExecutionMode mode;
                log4j.info((Object)"Er\u00e4ajo alkoi");
                ConsoleWriter.writeLine("Er\u00e4ajo alkoi: " + new Date());
                RunMode executionMode = new RunMode();
                ConsoleWriter.writeLine("Ajotila on: " + executionMode.getMode());
                for (int i = 0; i < 10; ++i) {
                    Thread.sleep(100L);
                }
                boolean firstrun = false;
                for (int i = 0; i < args.length; ++i) {
                    if (!args[i].equals("-firstrun")) continue;
                    firstrun = true;
                }
                DbLogger logger2 = new DbLogger();
                boolean tablesExist = logger2.tarkistaTaulut();
                if (firstrun) {
                    if (tablesExist) {
                        ConsoleWriter.writeLine("Ensimm\u00e4inen ajokerta mutta tietokanta l\u00f6ytyi. poistutaan ohjelmasta.");
                        System.exit(1);
                    }
                    String redolog = PropertyHandler.getInstance().getProperty("", "sqllog");
                    useinternacodesclient = PropertyHandler.getInstance().getProperty("", "sisainenkoodisto");
                    new File(redolog).delete();
                    logger2.luoTaulut();
                    mode = ExecutionMode.INITIAL;
                    ConsoleWriter.writeLine("Ensimm\u00e4inen ajokerta");
                } else {
                    if (!tablesExist) {
                        ConsoleWriter.writeLine("Uudelleenajo mutta tietokantatauluja ei l\u00f6ytynyt, poistutaan ohjelmasta");
                        System.exit(1);
                    }
                    ConsoleWriter.writeLine("Uudelleen ajo");
                    mode = ExecutionMode.RERUN;
                }
                boolean testMode = Boolean.parseBoolean(PropertyHandler.getInstance().getProperty(null, "testmode"));
                boolean bruteForceMode = Boolean.parseBoolean(PropertyHandler.getInstance().getProperty(null, "bruteforcemode"));
                final String logId = PropertyHandler.getInstance().getProperty(null, "logId");
                String palvelunantaja = PropertyHandler.getInstance().getProperty(logId, "organizationid");
                String rekisterinpitaja = PropertyHandler.getInstance().getProperty(logId, "custodianid");
                String dataPath = PropertyHandler.getInstance().getProperty(logId, "filepath");
                Object manifestFile = PropertyHandler.getInstance().getProperty(logId, "manifestfile");
                String lap = PropertyHandler.getInstance().getProperty(logId, "ajokierros");
                String rerunManifestFilePrefix = PropertyHandler.getInstance().getProperty(logId, "rerunmanifestfileprefix");
                String rerunManifestFile = rerunManifestFilePrefix + lap + ".xml";
                final int dirThreadCount = Integer.parseInt(PropertyHandler.getInstance().getProperty(logId, "threadcount_directory"));
                final int threadCount = Integer.parseInt(PropertyHandler.getInstance().getProperty(logId, "threadcount"));
                int threadTimeout = Integer.parseInt(PropertyHandler.getInstance().getProperty(logId, "threadtimeout"));
                log4j.info((Object)"Init proxies");
                Thread proxyThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            LoaderClientProxies.initialize(logId, dirThreadCount, threadCount * 2);
                        }
                        catch (MessagingException | PropertyException | InterruptedException | MalformedURLException | ExecutionException e) {
                            log4j.error((Object)"Proxy client initialisointi ep\u00e4onnistui, poistutaan ohjelmasta...", e);
                            System.err.println("Proxy client initialisointi ep\u00e4onnistui, poistutaan ohjelmasta...");
                            e.printStackTrace();
                            return;
                        }
                    }
                });
                proxyThread.start();
                int lapInt = Integer.parseInt(lap);
                if (lapInt > 1) {
                    manifestFile = rerunManifestFile;
                }
                String logPath = PropertyHandler.getInstance().getProperty(logId, "logpath");
                boolean createRerunLog = Boolean.parseBoolean(PropertyHandler.getInstance().getProperty(logId, "rerunlog"));
                if (createRerunLog) {
                    logPath = Scheduler.makeLapLogDir(logPath, lap);
                }
                ListSubDirectories lister = new ListSubDirectories(logId);
                List<String> directories = lister.listDirs(dataPath, (String)manifestFile);
                log4j.info((Object)("hakemiston koko: " + directories.size()));
                dirExecutorService = Executors.newFixedThreadPool(dirThreadCount);
                palvelutapahtumaPool = Executors.newFixedThreadPool(threadCount);
                hoitoasiakirjaPool = Executors.newFixedThreadPool(threadCount);
                ArrayList<Future<TaskResult>> futures = new ArrayList<Future<TaskResult>>();
                proxyThread.join();
                log4j.info((Object)"Init proxies complete");
                Iterator<String> iterator = directories.iterator();
                while (iterator.hasNext()) {
                    DbLogger dblogger = new DbLogger();
                    String string = iterator.next();
                    if (!dblogger.tarkastaOnkoHakemistoArkistoitu(string)) {
                        DirectoryData dirData = new DirectoryData(string, (String)manifestFile, logPath, dataPath, lap, threadTimeout, rekisterinpitaja, palvelunantaja, testMode, bruteForceMode);
                        DirectoryTask dirTask = new DirectoryTask(dirData, palvelutapahtumaPool, hoitoasiakirjaPool, mode);
                        futures.add(dirExecutorService.submit(dirTask));
                        continue;
                    }
                    log4j.info((Object)("hakemisto: " + string + " oli jo arkistoitu."));
                }
                for (Future future : futures) {
                    future.get();
                }
                logger = new DbLogger();
            }
            catch (Exception e) {
                log4j.error((Object)"Er\u00e4ajossa virhe", (Throwable)e);
                System.err.println("Er\u00e4ajossa tapahtui virhe");
                break block18;
            }
            finally {
                DbLogger logger3 = new DbLogger();
                Scheduler.shutdownPools(hoitoasiakirjaPool, palvelutapahtumaPool, dirExecutorService);
                if (new RunMode().getMode().equals("VALIDOINTI") && useinternacodesclient == null) {
                    FetchCodesClient.stop("");
                }
                logger3.tulostaYhteenveto();
                logger3.sammuta();
                log4j.info((Object)"Er\u00e4ajo p\u00e4\u00e4ttyi");
                ConsoleWriter.writeLine("Er\u00e4ajo p\u00e4\u00e4ttyi: " + new Date() + ", kesto " + (System.currentTimeMillis() - start) + " ms");
            }
            Scheduler.shutdownPools(hoitoasiakirjaPool, palvelutapahtumaPool, dirExecutorService);
            if (new RunMode().getMode().equals("VALIDOINTI") && useinternacodesclient == null) {
                FetchCodesClient.stop("");
            }
            logger.tulostaYhteenveto();
            logger.sammuta();
            log4j.info((Object)"Er\u00e4ajo p\u00e4\u00e4ttyi");
            ConsoleWriter.writeLine("Er\u00e4ajo p\u00e4\u00e4ttyi: " + new Date() + ", kesto " + (System.currentTimeMillis() - start) + " ms");
        }
    }

    private static void shutdownPools(ExecutorService hoitoasiakirjaPool, ExecutorService palvelutapahtumaPool, ExecutorService dirExecutorService) {
        try {
            if (hoitoasiakirjaPool != null) {
                hoitoasiakirjaPool.shutdown();
                hoitoasiakirjaPool.awaitTermination(60L, TimeUnit.SECONDS);
            }
            if (palvelutapahtumaPool != null) {
                palvelutapahtumaPool.shutdown();
                palvelutapahtumaPool.awaitTermination(60L, TimeUnit.SECONDS);
            }
            if (dirExecutorService != null) {
                dirExecutorService.shutdown();
                dirExecutorService.awaitTermination(60L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException e) {
            log4j.error((Object)"Error on shutdown", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private static String makeLapLogDir(String dir, String lap) throws ConfigException {
        String targetDir = dir.endsWith(File.separator) ? dir + lap + File.separator : dir + File.separator + lap + File.separator;
        File lapPath = new File(targetDir);
        if (lapPath.exists()) {
            Logger.getLogger(Scheduler.class).error((Object)("Ei voida luoda lokihakemistoa:" + lapPath.getAbsolutePath()));
            InternalServiceError error = ErrorWrapperLoader.getInstance().getError("0018");
            throw new ConfigException(error);
        }
        lapPath.mkdirs();
        return lapPath.getAbsolutePath();
    }
}

