/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.common.components;

import fi.kanta.common.exception.UtilException;
import fi.kanta.common.util.InternalServiceError;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class DateHelper {
    Logger log = Logger.getLogger(DateHelper.class);
    private SimpleDateFormat xmlYear = null;
    private SimpleDateFormat xmlMonth = null;
    private SimpleDateFormat xmlDate = null;
    private SimpleDateFormat xmlDateHour = null;
    private SimpleDateFormat xmlMediumDate = null;
    private SimpleDateFormat xmlLongDate = null;
    private SimpleDateFormat oracleDate = null;
    private SimpleDateFormat oracleLongDate = null;
    private boolean acceptAllFormats = false;
    private static final Object nullDate = "nulldate";

    public DateHelper() {
        this.xmlDate = new SimpleDateFormat("yyyyMMdd");
        this.xmlLongDate = new SimpleDateFormat("yyyyMMddHHmmss");
        this.oracleDate = new SimpleDateFormat("MM/dd/yyyy");
        this.oracleLongDate = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        this.acceptAllFormats = false;
    }

    public DateHelper(boolean acceptAllFormats) {
        this.xmlYear = new SimpleDateFormat("yyyy");
        this.xmlMonth = new SimpleDateFormat("yyyyMM");
        this.xmlDate = new SimpleDateFormat("yyyyMMdd");
        this.xmlDateHour = new SimpleDateFormat("yyyyMMddHH");
        this.xmlMediumDate = new SimpleDateFormat("yyyyMMddHHmm");
        this.xmlLongDate = new SimpleDateFormat("yyyyMMddHHmmss");
        this.oracleDate = new SimpleDateFormat("MM/dd/yyyy");
        this.oracleLongDate = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        this.acceptAllFormats = acceptAllFormats;
    }

    public String toOracleDate(String logId, String origDate) throws UtilException {
        return this.toOracleDate(logId, origDate, this.oracleDate);
    }

    public String toOracleLongDate(String logId, String origDate) throws UtilException {
        return this.toOracleDate(logId, origDate, this.oracleLongDate);
    }

    public String toOracleDate(String logId, String origDate, SimpleDateFormat sdf) throws UtilException {
        Date tempDate = null;
        String retDate = null;
        ParsePosition pos = new ParsePosition(0);
        if (origDate == null || origDate.trim().length() == 0 || origDate.equals(nullDate)) {
            return "";
        }
        if (origDate.length() == "yyyyMMddHHmmss".length()) {
            tempDate = this.xmlLongDate.parse(origDate, pos);
        } else if (origDate.length() == "yyyyMMdd".length()) {
            tempDate = this.xmlDate.parse(origDate, pos);
        } else if (this.acceptAllFormats && origDate.length() == "yyyyMMddHHmm".length()) {
            tempDate = this.xmlMediumDate.parse(origDate, pos);
        } else if (this.acceptAllFormats && origDate.length() == "yyyyMMddHH".length()) {
            tempDate = this.xmlDateHour.parse(origDate, pos);
        } else if (this.acceptAllFormats && origDate.length() == "yyyy".length()) {
            tempDate = this.xmlYear.parse(origDate, pos);
        } else if (this.acceptAllFormats && origDate.length() == "yyyyMM".length()) {
            tempDate = this.xmlMonth.parse(origDate, pos);
        } else {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2001");
            error.setErrorDescription(origDate);
            error.setCommonError(true);
            throw new UtilException(error);
        }
        if (tempDate == null || pos.getErrorIndex() != -1) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2001");
            error.setErrorDescription(origDate);
            error.setCommonError(true);
            throw new UtilException(error);
        }
        retDate = sdf.format(tempDate);
        if (origDate.length() == "yyyyMMddHHmmss".length()) {
            if (!this.xmlLongDate.format(tempDate).equals(origDate)) {
                InternalServiceError error = new InternalServiceError();
                error.setErrorCode("2001");
                error.setErrorDescription(origDate);
                error.setCommonError(true);
                throw new UtilException(error);
            }
        } else if (origDate.length() == "yyyyMMdd".length()) {
            if (!this.xmlDate.format(tempDate).equals(origDate)) {
                InternalServiceError error = new InternalServiceError();
                error.setErrorCode("2001");
                error.setErrorDescription(origDate);
                error.setCommonError(true);
                throw new UtilException(error);
            }
        } else if (origDate.length() == "yyyyMMddHH".length()) {
            if (!this.xmlDateHour.format(tempDate).equals(origDate)) {
                InternalServiceError error = new InternalServiceError();
                error.setErrorCode("2001");
                error.setErrorDescription(origDate);
                error.setCommonError(true);
                throw new UtilException(error);
            }
        } else if (origDate.length() == "yyyyMMddHHmm".length()) {
            if (!this.xmlMediumDate.format(tempDate).equals(origDate)) {
                InternalServiceError error = new InternalServiceError();
                error.setErrorCode("2001");
                error.setErrorDescription(origDate);
                error.setCommonError(true);
                throw new UtilException(error);
            }
        } else if (origDate.length() == "yyyyMM".length()) {
            if (!this.xmlMonth.format(tempDate).equals(origDate)) {
                InternalServiceError error = new InternalServiceError();
                error.setErrorCode("2001");
                error.setErrorDescription(origDate);
                error.setCommonError(true);
                throw new UtilException(error);
            }
        } else if (origDate.length() == "yyyy".length() && !this.xmlYear.format(tempDate).equals(origDate)) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2001");
            error.setErrorDescription(origDate);
            error.setCommonError(true);
            throw new UtilException(error);
        }
        return retDate;
    }

    public Date toDate(String logId, String origDate) throws UtilException {
        return this.toDate(logId, origDate, this.oracleLongDate);
    }

    public Date toDate(String logId, String origDate, SimpleDateFormat sdf) throws UtilException {
        Date retDate = null;
        ParsePosition pos = new ParsePosition(0);
        if (origDate == null || origDate.trim().length() == 0 || origDate.equals(nullDate)) {
            return null;
        }
        if (origDate.length() == "yyyyMMddHHmmss".length()) {
            retDate = this.xmlLongDate.parse(origDate, pos);
        } else if (origDate.length() == "yyyyMMdd".length()) {
            retDate = this.xmlDate.parse(origDate, pos);
        } else if (this.acceptAllFormats && origDate.length() == "yyyyMMddHHmm".length()) {
            retDate = this.xmlMediumDate.parse(origDate, pos);
        } else if (this.acceptAllFormats && origDate.length() == "yyyyMMddHH".length()) {
            retDate = this.xmlDateHour.parse(origDate, pos);
        } else if (this.acceptAllFormats && origDate.length() == "yyyy".length()) {
            retDate = this.xmlYear.parse(origDate, pos);
        } else if (this.acceptAllFormats && origDate.length() == "yyyyMM".length()) {
            retDate = this.xmlMonth.parse(origDate, pos);
        } else {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2001");
            error.setErrorDescription(origDate);
            error.setCommonError(true);
            throw new UtilException(error);
        }
        if (retDate == null || pos.getErrorIndex() != -1) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2001");
            error.setErrorDescription(origDate);
            error.setCommonError(true);
            throw new UtilException(error);
        }
        if (origDate.length() == "yyyyMMddHHmmss".length()) {
            if (!this.xmlLongDate.format(retDate).equals(origDate)) {
                InternalServiceError error = new InternalServiceError();
                error.setErrorCode("2001");
                error.setErrorDescription(origDate);
                error.setCommonError(true);
                throw new UtilException(error);
            }
        } else if (origDate.length() == "yyyyMMdd".length()) {
            if (!this.xmlDate.format(retDate).equals(origDate)) {
                InternalServiceError error = new InternalServiceError();
                error.setErrorCode("2001");
                error.setErrorDescription(origDate);
                error.setCommonError(true);
                throw new UtilException(error);
            }
        } else if (origDate.length() == "yyyyMMddHH".length()) {
            if (!this.xmlDateHour.format(retDate).equals(origDate)) {
                InternalServiceError error = new InternalServiceError();
                error.setErrorCode("2001");
                error.setErrorDescription(origDate);
                error.setCommonError(true);
                throw new UtilException(error);
            }
        } else if (origDate.length() == "yyyyMMddHHmm".length()) {
            if (!this.xmlMediumDate.format(retDate).equals(origDate)) {
                InternalServiceError error = new InternalServiceError();
                error.setErrorCode("2001");
                error.setErrorDescription(origDate);
                error.setCommonError(true);
                throw new UtilException(error);
            }
        } else if (origDate.length() == "yyyyMM".length()) {
            if (!this.xmlMonth.format(retDate).equals(origDate)) {
                InternalServiceError error = new InternalServiceError();
                error.setErrorCode("2001");
                error.setErrorDescription(origDate);
                error.setCommonError(true);
                throw new UtilException(error);
            }
        } else if (origDate.length() == "yyyy".length() && !this.xmlYear.format(retDate).equals(origDate)) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2001");
            error.setErrorDescription(origDate);
            error.setCommonError(true);
            throw new UtilException(error);
        }
        return retDate;
    }

    public String toOracleDate(String origDate) throws UtilException {
        return this.toOracleDate("LogId puuttuu!", origDate);
    }

    public String toHL7ShortDate(Date origDate) {
        String rval = "";
        rval = origDate != null ? this.xmlDate.format(origDate) : "nulldate";
        return rval;
    }

    public String toHL7LongDate(Date origDate) {
        String rval = "";
        rval = origDate != null ? this.xmlLongDate.format(origDate) : "nulldate";
        return rval;
    }

    public Date parseDate(String logId, String dateString, String dateFormat) throws UtilException {
        Date returnDate = null;
        SimpleDateFormat sdf = null;
        if (dateString != null && !dateString.isEmpty() && !dateString.equals(nullDate)) {
            sdf = new SimpleDateFormat(dateFormat);
            ParsePosition pos = new ParsePosition(0);
            returnDate = sdf.parse(dateString, pos);
            if (returnDate == null || pos.getErrorIndex() != -1) {
                InternalServiceError error = new InternalServiceError();
                error.setErrorCode("2001");
                error.setErrorDescription(dateString);
                error.setCommonError(true);
                throw new UtilException(error);
            }
            if (pos.getIndex() != dateString.length()) {
                InternalServiceError error = new InternalServiceError();
                error.setErrorCode("2001");
                error.setErrorDescription(dateString);
                error.setCommonError(true);
                throw new UtilException(error);
            }
            if (!sdf.format(returnDate).equals(dateString)) {
                InternalServiceError error = new InternalServiceError();
                error.setErrorCode("2001");
                error.setErrorDescription(dateString);
                error.setCommonError(true);
                throw new UtilException(error);
            }
        }
        return returnDate;
    }

    public Date parseDate(String dateString, String dateFormat) throws UtilException {
        return this.parseDate("LogId puuttuu!", dateString, dateFormat);
    }

    public String getFormattedDate(String dateFormat) {
        return this.getFormattedDate(new Date(), dateFormat);
    }

    public String getFormattedDate(Date date, String dateFormat) {
        Locale locale = new Locale("fi", "FI");
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat, locale);
        return formatter.format(date);
    }
}

