/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.common.components;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Node;

public abstract class JaxbUtil {
    public static final String UTF_8 = "UTF-8";

    public static String marshall(Object object, String encoding) throws JAXBException, UnsupportedEncodingException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String result = "";
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
            Marshaller m = jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.setProperty("jaxb.encoding", (Object)encoding);
            m.marshal(object, (OutputStream)out);
            result = new String(out.toByteArray(), encoding);
        }
        catch (JAXBException e) {
            throw new JAXBException("Marshallointi ep\u00e4onnistui.", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        return result;
    }

    public static Object unmarshallerForSOAPMessage(String inputXml, Class<?> clazz, String encoding) throws JAXBException, IOException, SOAPException {
        Object result = null;
        try {
            SOAPMessage soapMessage = MessageFactory.newInstance().createMessage(null, (InputStream)new ByteArrayInputStream(inputXml.getBytes(encoding)));
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller u = jc.createUnmarshaller();
            result = u.unmarshal((Node)soapMessage.getSOAPBody().extractContentAsDocument());
        }
        catch (JAXBException e) {
            throw e;
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (SOAPException e) {
            throw e;
        }
        return result;
    }

    public static Object unmarshaller(InputStream xml, Class<?> clazz, String encoding) throws JAXBException {
        Object result = null;
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Unmarshaller u = jc.createUnmarshaller();
        result = u.unmarshal(xml);
        return result;
    }

    public static Object unmarshaller(Node node, Class<?> clazz, String encoding) throws JAXBException {
        Object result = null;
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Unmarshaller u = jc.createUnmarshaller();
        result = u.unmarshal(node);
        return result;
    }

    public static Object unmarshaller(String xml, Class<?> clazz, String encoding) throws JAXBException {
        Object result = null;
        StringReader reader = new StringReader(xml);
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Unmarshaller u = jc.createUnmarshaller();
        result = u.unmarshal((Reader)reader);
        return result;
    }

    public static Object unmarshaller(File file, Class<?> clazz, String encoding) throws JAXBException, FileNotFoundException {
        return JaxbUtil.unmarshaller(new FileInputStream(file), clazz, encoding);
    }
}

