/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.common.components;

import fi.kanta.common.components.IPropertyManager;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.exception.PropertyException;
import fi.kanta.common.util.InternalServiceError;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PropertyManager
implements IPropertyManager {
    Logger log = Logger.getLogger(PropertyManager.class);
    private LogHelper logHelper;
    private Properties properties;

    public PropertyManager(String logId, String file) throws PropertyException {
        InputStream fis = null;
        try {
            this.logHelper = new LogHelper();
            this.log.debug((Object)this.logHelper.formatMsgBgn(logId));
            this.properties = new Properties();
            this.log.debug((Object)this.logHelper.formatMsg(logId, "Reading file", file));
            fis = new FileInputStream(file);
            if (fis == null) {
                InternalServiceError error = new InternalServiceError();
                error.setErrorCode("2003");
                error.setErrorDescription(new StringBuffer("Tiedostoa '").append(file).append("' ei l\u00f6ytynyt"));
                error.setCommonError(true);
                throw new PropertyException(error);
            }
            this.properties.load(fis);
            this.log.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        catch (FileNotFoundException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2003");
            error.setCommonError(true);
            throw new PropertyException(error, (Throwable)ex);
        }
        catch (IOException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2003");
            error.setCommonError(true);
            throw new PropertyException(error, (Throwable)ex);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    this.log.error((Object)this.logHelper.formatMsg(logId), (Throwable)ex);
                }
            }
        }
    }

    @Override
    public String getValue(String logId, String key) throws PropertyException {
        String retStr = null;
        retStr = this.properties.getProperty(key);
        if (retStr == null || retStr.trim().equals("")) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2004");
            error.setErrorDescription(new StringBuffer("Parametria '").append(key).append("' ei l\u00f6ytynyt"));
            error.setCommonError(true);
            throw new PropertyException(error);
        }
        return retStr;
    }
}

