/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.common.components;

import fi.kanta.common.components.IXMLValidator;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.exception.ValidationException;
import fi.kanta.common.util.InternalServiceError;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class XMLValidator
implements IXMLValidator {
    Logger log = Logger.getLogger(XMLValidator.class);
    private LogHelper logHelper = new LogHelper();
    private SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");

    @Override
    public void setFeature(String logId, String name, boolean value) throws ValidationException {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)this.logHelper.formatMsgBgn(logId));
                this.log.debug((Object)this.logHelper.formatMsg(logId, "Setting feature name", name));
                this.log.debug((Object)this.logHelper.formatMsg(logId, "Setting feature value: " + value));
            }
            this.factory.setFeature(name, value);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)this.logHelper.formatMsgEnd(logId));
            }
        }
        catch (SAXNotSupportedException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2009");
            error.setErrorDescription(ex.getMessage());
            error.setCommonError(true);
            throw new ValidationException(error, (Throwable)ex);
        }
        catch (SAXNotRecognizedException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2009");
            error.setErrorDescription(ex.getMessage());
            error.setCommonError(true);
            throw new ValidationException(error, (Throwable)ex);
        }
    }

    @Override
    public void validateXML(String logId, Document document, String schemaName) throws ValidationException {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)this.logHelper.formatMsgBgn(logId));
            }
            StreamSource schemaFile = new StreamSource(new File(schemaName));
            Schema schema = this.factory.newSchema(schemaFile);
            Validator validator = schema.newValidator();
            validator.validate(new DOMSource(document));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)this.logHelper.formatMsgEnd(logId));
            }
        }
        catch (IOException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2009");
            error.setErrorDescription(ex.getMessage());
            error.setCommonError(true);
            throw new ValidationException(error, (Throwable)ex);
        }
        catch (SAXException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2009");
            error.setErrorDescription(ex.getMessage());
            error.setCommonError(true);
            throw new ValidationException(error, (Throwable)ex);
        }
    }

    @Override
    public void validateXML(String logId, Source source, Schema schema) throws ValidationException {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)this.logHelper.formatMsgBgn(logId));
            }
            Validator validator = schema.newValidator();
            validator.validate(source);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)this.logHelper.formatMsgEnd(logId));
            }
        }
        catch (IOException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2009");
            error.setErrorDescription(ex.getMessage());
            error.setCommonError(true);
            throw new ValidationException(error, (Throwable)ex);
        }
        catch (SAXException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2009");
            error.setErrorDescription(ex.getMessage());
            error.setCommonError(true);
            throw new ValidationException(error, (Throwable)ex);
        }
    }

    @Override
    public void validateXML(String logId, Document document, Schema schema) throws ValidationException {
        this.validateXML(logId, document, schema, false);
    }

    @Override
    public List<SAXParseException> validateXML(String logId, Document document, Schema schema, boolean collect) throws ValidationException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        Validator validator = schema.newValidator();
        final LinkedList<SAXParseException> exceptions = new LinkedList<SAXParseException>();
        if (collect) {
            validator.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    exceptions.add(exception);
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    exceptions.add(exception);
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    exceptions.add(exception);
                }
            });
        }
        try {
            validator.validate(new DOMSource(document));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)this.logHelper.formatMsgEnd(logId));
            }
            return exceptions;
        }
        catch (IOException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2009");
            error.setErrorDescription(ex.getMessage());
            error.setCommonError(true);
            throw new ValidationException(error, (Throwable)ex);
        }
        catch (SAXException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2009");
            error.setErrorDescription(ex.getMessage());
            error.setCommonError(true);
            throw new ValidationException(error, (Throwable)ex);
        }
    }

    @Override
    public void validateXML(String logId, Node node, Schema schema) throws ValidationException {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)this.logHelper.formatMsgBgn(logId));
            }
            Validator validator = schema.newValidator();
            validator.validate(new DOMSource(node));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)this.logHelper.formatMsgEnd(logId));
            }
        }
        catch (IOException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2009");
            error.setErrorDescription(ex.getMessage());
            error.setCommonError(true);
            throw new ValidationException(error, (Throwable)ex);
        }
        catch (SAXException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2009");
            error.setErrorDescription(ex.getMessage());
            error.setCommonError(true);
            throw new ValidationException(error, (Throwable)ex);
        }
    }
}

