/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.client;

import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import fi.kanta.arkistopalvelu.client.RekisteriPalveluResultDetails;
import fi.kanta.arkistopalvelu.util.ErrorWrapperArchive;
import fi.kanta.arkistopalvelu.util.MaakuntaRekisterinpitajaTiedot;
import fi.kanta.arkistopalvelu.util.configurations.ArkistopalveluConfigManager;
import fi.kanta.arkistopalvelu.util.configurations.RekisterinpitajaPalveluProperties;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.exception.UtilException;
import fi.kanta.common.util.InternalServiceError;
import java.net.URI;
import java.util.HashMap;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import org.apache.log4j.Logger;

public class RekisterinPitajapalveluClient {
    private static final String CUSTODIAN = "custodian";
    private static final String PALVELU_YKSIKKO = "palveluYksikko";
    private static final String LOG_ID = "logId";
    private static final Logger LOGGER = Logger.getLogger(RekisterinPitajapalveluClient.class);
    private static MediaType mediaType = MediaType.APPLICATION_JSON_TYPE;
    private static RekisterinpitajaPalveluProperties rekpitPalveluProperties = ArkistopalveluConfigManager.getInstance().getRekisterinpitajaPalveluProperties();
    private static LogHelper logHelper = new LogHelper();
    private static ErrorWrapperArchive errorWrapper = ErrorWrapperArchive.getInstance();

    private RekisterinPitajapalveluClient() {
    }

    public static MaakuntaRekisterinpitajaTiedot getMaakuntaRekisterinpitaja(String logId, String rekisterinpitaja, String palveluYksikko) throws UtilException {
        MaakuntaRekisterinpitajaTiedot maakuntaRekisterinpitaja;
        block7: {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)logHelper.formatMsgBgn(logId));
            }
            maakuntaRekisterinpitaja = null;
            try {
                String uri = RekisterinPitajapalveluClient.getMaakuntaRekisterinpitajaUri(logId, rekisterinpitaja);
                WebResource webResource = RekisterinPitajapalveluClient.buildClient(logId, uri);
                ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)webResource.queryParams(RekisterinPitajapalveluClient.createQueryParameterMap(logId, palveluYksikko)).type(mediaType).accept(new MediaType[]{mediaType})).get(ClientResponse.class);
                ClientResponse.Status status = clientResponse.getClientResponseStatus();
                if (status.getStatusCode() == ClientResponse.Status.OK.getStatusCode()) {
                    maakuntaRekisterinpitaja = (MaakuntaRekisterinpitajaTiedot)clientResponse.getEntity(MaakuntaRekisterinpitajaTiedot.class);
                    break block7;
                }
                if (status.getStatusCode() == ClientResponse.Status.NO_CONTENT.getStatusCode()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)"Maakuntarekisterinpit\u00e4j\u00e4\u00e4 ei l\u00f6ytynyt.");
                    }
                    break block7;
                }
                throw new UtilException(RekisterinPitajapalveluClient.getError(logId, (RekisteriPalveluResultDetails)clientResponse.getEntity(RekisteriPalveluResultDetails.class)));
            }
            catch (ClientHandlerException e) {
                InternalServiceError error = errorWrapper.getError("1144");
                error.setErrorMessage("Virhe yhteydess\u00e4 rekisterinpit\u00e4j\u00e4palvelu-sovellukseen");
                error.setErrorDescription(e.getMessage());
                LOGGER.error((Object)logHelper.formatMsg(logId, error));
                throw new UtilException(error, (Throwable)e);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)logHelper.formatMsgEnd(logId));
        }
        return maakuntaRekisterinpitaja;
    }

    private static MultivaluedMap<String, String> createQueryParameterMap(String logId, String palveluYksikko) {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)LOG_ID, (Object)logId);
        queryParams.add((Object)PALVELU_YKSIKKO, (Object)palveluYksikko);
        return queryParams;
    }

    public static String getMaakuntaRekisterinpitajaUri(String logId, String custodian) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)logHelper.formatMsgBgn(logId));
        }
        String basePath = rekpitPalveluProperties.getRekisterinpitajaPalveluUrl();
        String pathAnnotation = rekpitPalveluProperties.getCustodianPath();
        HashMap<String, String> pathParameterValues = new HashMap<String, String>();
        pathParameterValues.put(CUSTODIAN, custodian);
        String returnUri = null;
        UriBuilder builder = UriBuilder.fromUri((String)basePath);
        URI resolvedUri = builder.path(pathAnnotation).buildFromMap(pathParameterValues);
        if (resolvedUri != null) {
            returnUri = resolvedUri.toString();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)logHelper.formatMsgEnd(logId));
        }
        return returnUri;
    }

    private static WebResource buildClient(String logId, String uri) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)logHelper.formatMsgBgn(logId));
        }
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
        JacksonJaxbJsonProvider jacksonJsonProvider = new JacksonJaxbJsonProvider();
        jacksonJsonProvider.setMapper(mapper);
        clientConfig.getSingletons().add(jacksonJsonProvider);
        Client client = Client.create((ClientConfig)clientConfig);
        client.setConnectTimeout(Integer.valueOf(rekpitPalveluProperties.getRekisterinpitajaPalveluConnectTimeout().intValue()));
        client.setReadTimeout(Integer.valueOf(rekpitPalveluProperties.getRekisterinpitajaPalveluReadTimeout().intValue()));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)logHelper.formatMsgEnd(logId));
        }
        return client.resource(uri);
    }

    private static InternalServiceError getError(String logId, RekisteriPalveluResultDetails resultDetails) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)logHelper.formatMsgBgn(logId));
        }
        InternalServiceError error = ErrorWrapperArchive.getInstance().getError("1144");
        if (resultDetails != null && resultDetails.getErrorCode() != null && !resultDetails.getErrorCode().isEmpty()) {
            error.setErrorCode(resultDetails.getErrorCode());
            error.setErrorMessage(resultDetails.getErrorMessage());
            error.setErrorDescription(resultDetails.getDescription());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)logHelper.formatMsgEnd(logId));
        }
        return error;
    }
}

