/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.util;

import fi.kanta.arkistopalvelu.util.ErrorWrapperArchive;
import fi.kanta.arkistopalvelu.util.IArkistoXMLHelper;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.exception.UtilException;
import fi.kanta.common.util.InternalServiceError;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ArkistoXMLHelper
implements IArkistoXMLHelper {
    private static final Logger LOGGER = Logger.getLogger(ArkistoXMLHelper.class);
    private LogHelper logHelper;
    ErrorWrapperArchive errorWrapper = ErrorWrapperArchive.getInstance();

    public ArkistoXMLHelper() {
        this.logHelper = new LogHelper();
    }

    @Override
    public void appendXmlFragment(String logId, DocumentBuilder domBuilder, Node parent, Node fragment) throws IOException, SAXException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        if (parent != null) {
            parent.appendChild(parent.getOwnerDocument().importNode(fragment, true));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    @Override
    public Node getXmlFragmentNode(String logId, DocumentBuilder domBuilder, String fragment) throws IOException, SAXException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return domBuilder.parse(new InputSource(new StringReader(fragment))).getDocumentElement();
    }

    @Override
    public Element getLastElementFromNode(String logId, Node node) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        Element retElement = null;
        for (Node child = node.getLastChild(); child != null; child = child.getPreviousSibling()) {
            if (child.getNodeType() != 1) continue;
            retElement = (Element)child;
            break;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return retElement;
    }

    @Override
    public String parseNodeName(String name) {
        String nodeName = "";
        if (name != null) {
            int index = name.indexOf(":");
            nodeName = index > 0 ? name.substring(index + 1, name.length()) : name;
        }
        return nodeName;
    }

    @Override
    public Document createDocument(String logId, String hl7message, boolean namespaceaware, boolean useapache) throws ParserConfigurationException, SAXException, IOException {
        Document document = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(namespaceaware);
        factory.setValidating(false);
        factory.setIgnoringComments(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        document = builder.parse(new InputSource(new StringReader(hl7message)));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return document;
    }

    @Override
    public String toString(String logId, Element element) throws UtilException {
        String output = null;
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)this.logHelper.formatMsgBgn(logId));
            }
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(element), new StreamResult(writer));
            output = writer.getBuffer().toString();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)this.logHelper.formatMsgEnd(logId));
            }
        }
        catch (TransformerException e) {
            InternalServiceError error = this.errorWrapper.getError("1141");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error);
        }
        return output;
    }
}

