/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.util;

import fi.kanta.arkistopalvelu.util.ErrorWrapperArchive;
import fi.kanta.arkistopalvelu.util.IArkistoXPathHelperDOM;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.exception.UtilException;
import fi.kanta.common.util.HL7NamespaceContext;
import fi.kanta.common.util.InternalServiceError;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ArkistoXPathHelperDOM
implements IArkistoXPathHelperDOM {
    private static final Logger LOGGER = Logger.getLogger(ArkistoXPathHelperDOM.class);
    private LogHelper logHelper = new LogHelper();
    private ErrorWrapperArchive errorWrapper = ErrorWrapperArchive.getInstance();
    private XPath codeXpath = XPathFactory.newInstance().newXPath();

    public ArkistoXPathHelperDOM() {
        this.codeXpath.setNamespaceContext((NamespaceContext)new HL7NamespaceContext());
    }

    @Override
    public String getCode(String logId, Element element, String expression, boolean defNamespace) throws UtilException {
        String retStr = null;
        try {
            retStr = this.codeXpath.evaluate(this.generateDNExpression(logId, expression, defNamespace), element);
        }
        catch (NumberFormatException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        catch (XPathExpressionException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        return retStr;
    }

    @Override
    public String getCode(String logId, Element element, String expression) throws UtilException {
        return this.getCode(logId, element, expression, true);
    }

    @Override
    public String getCode(String logId, Document document, String expression) throws UtilException {
        return this.getCode(logId, document, expression, true);
    }

    @Override
    public String getCode(String logId, Document document, String expression, boolean defNamespace) throws UtilException {
        String retStr = null;
        try {
            retStr = this.codeXpath.evaluate(this.generateDNExpression(logId, expression, defNamespace), document);
        }
        catch (NumberFormatException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        catch (XPathExpressionException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        return retStr;
    }

    @Override
    public String getUniqueCodesFromNodeList(String logId, Node node, String expression, boolean defaultNamespace) throws UtilException {
        StringBuilder retStr = new StringBuilder();
        ArrayList<String> nodevalues = new ArrayList<String>();
        String t = "";
        boolean exists = false;
        NodeList nodes = null;
        try {
            if (node instanceof Document) {
                nodes = this.getNodeList(logId, (Document)node, expression, defaultNamespace);
            } else if (node instanceof Element) {
                nodes = this.getNodeList(logId, (Element)node, expression, defaultNamespace);
            }
            for (int i = 0; i < nodes.getLength(); ++i) {
                exists = false;
                String tt = nodes.item(i).getTextContent().trim();
                for (int j = 0; j < nodevalues.size(); ++j) {
                    t = (String)nodevalues.get(j);
                    if (!t.equals(tt)) continue;
                    exists = true;
                }
                if (exists) continue;
                nodevalues.add(tt);
                if (i > 0) {
                    retStr.append(" ");
                }
                retStr.append(tt);
            }
        }
        catch (NumberFormatException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        return retStr.toString();
    }

    @Override
    public String getUniqueCodesFromNodeList(String logId, Document document, String expression) throws UtilException {
        return this.getUniqueCodesFromNodeList(logId, document, expression, true);
    }

    @Override
    public List<String> getUniqueCVvaluesFromNodeList(String logId, Node node, String expression, String separator, boolean defNamespace, boolean allowNoCode) throws UtilException {
        ArrayList<String> rval = new ArrayList<String>();
        try {
            NodeList nodes = null;
            if (node instanceof Document) {
                nodes = this.getNodeList(logId, (Document)node, expression, defNamespace);
            } else if (node instanceof Element) {
                nodes = this.getNodeList(logId, (Element)node, expression, defNamespace);
            }
            if (nodes != null) {
                String nodeName = "";
                int y = nodes.getLength();
                for (int i = 0; i < y; ++i) {
                    Node nodeTmp = nodes.item(i);
                    NamedNodeMap map = nodeTmp.getAttributes();
                    String root = "";
                    String extension = "";
                    int x = map.getLength();
                    for (int j = 0; j < x; ++j) {
                        Node attrNode = map.item(j);
                        nodeName = attrNode.getNodeName();
                        if (nodeName.equals("codeSystem")) {
                            root = attrNode.getNodeValue();
                        }
                        if (!nodeName.equals("code")) continue;
                        extension = attrNode.getNodeValue();
                    }
                    Object value = "";
                    if (extension.length() > 0) {
                        value = root + separator + extension;
                    } else if (allowNoCode) {
                        value = root;
                    }
                    rval.add((String)value);
                }
            }
        }
        catch (NumberFormatException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        return rval;
    }

    @Override
    public List<String> getUniqueCVvaluesFromNodeList(String logId, Node node, String expression, String separator, boolean defNamespace) throws UtilException {
        return this.getUniqueCVvaluesFromNodeList(logId, node, expression, separator, defNamespace, true);
    }

    @Override
    public List<String> getUniqueCVvaluesFromNodeList(String logId, Document document, String expression, String separator) throws UtilException {
        return this.getUniqueCVvaluesFromNodeList(logId, document, expression, separator, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> getUniqueIIvaluesFromNodeList(String logId, Document document, String expression, boolean defNamespace, String separator) throws UtilException {
        ArrayList<String> rval = new ArrayList<String>();
        try {
            NodeList nodes = this.getNodeList(logId, document, expression, defNamespace);
            String nodeName = "";
            int y = nodes.getLength();
            for (int i = 0; i < y; ++i) {
                StringBuilder valueBuff;
                block8: {
                    Node node = nodes.item(i);
                    NamedNodeMap map = node.getAttributes();
                    String root = "";
                    String extension = "";
                    int x = map.getLength();
                    for (int j = 0; j < x; ++j) {
                        Node attrNode = map.item(j);
                        nodeName = attrNode.getNodeName();
                        if (nodeName.equals("root")) {
                            root = attrNode.getNodeValue();
                        }
                        if (!nodeName.equals("extension")) continue;
                        extension = attrNode.getNodeValue();
                    }
                    valueBuff = new StringBuilder();
                    if (extension.length() > 0) {
                        if (root != null && root.length() > 0) {
                            valueBuff.append(root).append(separator).append(extension);
                            break block8;
                        } else {
                            InternalServiceError error = this.errorWrapper.getError("1015");
                            error.setErrorDescription(new StringBuffer("node=").append(node.getLocalName()).append(" puuttuva @root vaikka @extension"));
                            LOGGER.error((Object)this.logHelper.formatMsg(logId, error));
                            throw new UtilException(error);
                        }
                    }
                    valueBuff.append(root);
                }
                rval.add(valueBuff.toString());
            }
            return rval;
        }
        catch (NumberFormatException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
    }

    @Override
    public List<String> getUniqueIIvaluesFromNodeList(String logId, Document document, String expression, String separator) throws UtilException {
        return this.getUniqueIIvaluesFromNodeList(logId, document, expression, true, separator);
    }

    @Override
    public NodeList getNodeList(String logId, Document document, String expression, boolean defNamespace) throws UtilException {
        return this.getNodeList(logId, document.getDocumentElement(), expression, defNamespace);
    }

    @Override
    public NodeList getNodeList(String logId, Document document, String expression) throws UtilException {
        return this.getNodeList(logId, document.getDocumentElement(), expression, true);
    }

    @Override
    public NodeList getNodeList(String logId, Element element, String expression) throws UtilException {
        return this.getNodeList(logId, element, expression, true);
    }

    @Override
    public NodeList getNodeList(String logId, Element element, String expression, boolean defNamespace) throws UtilException {
        NodeList nodes = null;
        try {
            nodes = (NodeList)this.codeXpath.evaluate(this.generateDNExpression(logId, expression, defNamespace), element, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        return nodes;
    }

    @Override
    public Node getNode(String logId, Document document, String expression) throws UtilException {
        return this.getNode(logId, document.getDocumentElement(), expression, true);
    }

    @Override
    public Node getNode(String logId, Document document, String expression, boolean namespace) throws UtilException {
        return this.getNode(logId, document.getDocumentElement(), expression, namespace);
    }

    @Override
    public Node getNode(String logId, Element element, String expression) throws UtilException {
        return this.getNode(logId, element, expression, true);
    }

    @Override
    public Node getNode(String logId, Element element, String expression, boolean defNamespace) throws UtilException {
        Node node = null;
        try {
            node = (Node)this.codeXpath.evaluate(this.generateDNExpression(logId, expression, defNamespace), element, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            InternalServiceError error = this.errorWrapper.getError("2010");
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        return node;
    }

    @Override
    public String getIIValue(String logId, Document cdadoc, String rootExpr, String extensionExpr) throws UtilException {
        return this.getIIValue(logId, cdadoc.getDocumentElement(), rootExpr, extensionExpr);
    }

    @Override
    public String getIIValue(String logId, Element cdadoc, String rootExpr, String extensionExpr) throws UtilException {
        Object rval = "";
        try {
            String root = this.getCode(logId, cdadoc, rootExpr);
            String extension = this.getCode(logId, cdadoc, extensionExpr);
            rval = extension.length() > 0 ? root + "." + extension : root;
        }
        catch (UtilException e) {
            InternalServiceError error = e.getInternalServiceError();
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        return rval;
    }

    @Override
    public String getIIValue(String logId, Element cdadoc, boolean defNamespace, String rootExpr, String extensionExpr) throws UtilException {
        Object rval = "";
        try {
            String root = this.getCode(logId, cdadoc, rootExpr, defNamespace);
            String extension = this.getCode(logId, cdadoc, extensionExpr, defNamespace);
            rval = extension.length() > 0 ? root + "." + extension : root;
        }
        catch (UtilException e) {
            InternalServiceError error = e.getInternalServiceError();
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        return rval;
    }

    @Override
    public String getIIValue(String logId, Document cdadoc, boolean defNamespace, String rootExpr, String extensionExpr) throws UtilException {
        Object rval = "";
        try {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)this.logHelper.formatMsgBgn(logId));
            }
            String root = this.getCode(logId, cdadoc, rootExpr, defNamespace);
            String extension = this.getCode(logId, cdadoc, extensionExpr, defNamespace);
            rval = extension.length() > 0 ? root + "." + extension : root;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)this.logHelper.formatMsgEnd(logId));
            }
        }
        catch (UtilException e) {
            InternalServiceError error = e.getInternalServiceError();
            LOGGER.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new UtilException(error, (Throwable)e);
        }
        return rval;
    }

    private String generateDNExpression(String logId, String expression, boolean defNamespace) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgBgn(logId));
        }
        String retExpression = expression;
        if (defNamespace) {
            retExpression = retExpression.replaceAll("/", "/:");
            retExpression = retExpression.replaceAll("/:@", "/@");
            retExpression = retExpression.replaceAll("/:\\.\\.", "/\\.\\.");
            retExpression = retExpression.replaceAll("/:/:", "//:");
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)this.logHelper.formatMsgEnd(logId));
        }
        return retExpression;
    }
}

