/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.util;

import fi.kanta.arkistopalvelu.util.ErrorMessages;
import fi.kanta.arkistopalvelu.util.configurations.ArkistopalveluConfigMiddleManager;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.util.InternalServiceError;
import fi.kanta.koodistopalvelu.webservices.virhekoodisto.ErrorCode;
import fi.kanta.koodistopalvelu.webservices.virhekoodisto.ErrorCodeIn;
import fi.kanta.koodistopalvelu.webservices.virhekoodisto.ErrorCodeResponse;
import fi.kanta.koodistopalvelu.webservices.virhekoodisto.ErrorCodeResponseDetails;
import fi.kanta.koodistopalvelu.webservices.virhekoodisto.Virhekoodisto;
import fi.kanta.koodistopalvelu.webservices.virhekoodisto.Virhekoodisto_Service;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.ws.BindingProvider;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class ErrorWrapperArchive {
    private static ErrorWrapperArchive me = null;
    private Map<String, InternalServiceError> internalErrors = null;
    private static final Logger LOGGER = Logger.getLogger(ErrorWrapperArchive.class);
    private LogHelper logHelper;

    public static final ErrorWrapperArchive getInstance() {
        return me;
    }

    private ErrorWrapperArchive() {
        this.init();
    }

    private void init() {
        this.logHelper = new LogHelper();
        LOGGER.debug((Object)this.logHelper.formatMsgBgn("20"));
        this.internalErrors = new HashMap<String, InternalServiceError>(ErrorMessages.ERROR_CODES.size() + 19);
        List<ErrorCodeResponse> responses = this.getCodes(this.generateErrorCodeRequest());
        if (responses != null) {
            for (int i = 0; i < responses.size(); ++i) {
                ErrorCode errorCode;
                ErrorCodeResponseDetails details;
                ErrorCodeResponse response = responses.get(i);
                if (response == null || (details = response.getErrorCodeResponseDetails()) == null || !details.getResultCode().equals("400000") || (errorCode = response.getErrorCode()) == null) continue;
                InternalServiceError error = new InternalServiceError();
                error.setErrorCode(errorCode.getInternalErrorCode());
                error.setErrorMessage(errorCode.getIntDescription());
                error.setErrorLevel(errorCode.getErrorLevelId());
                this.internalErrors.put(error.getErrorCode().substring(2, error.getErrorCode().length()), error);
            }
        }
        LOGGER.debug((Object)this.logHelper.formatMsgEnd("20"));
    }

    private List<ErrorCodeIn> generateErrorCodeRequest() {
        ArrayList<ErrorCodeIn> errorCodeInList = new ArrayList<ErrorCodeIn>(ErrorMessages.ERROR_CODES.size());
        for (Map.Entry<String, String> entry : ErrorMessages.ERROR_CODES.entrySet()) {
            ErrorCodeIn errorCodeIn = new ErrorCodeIn();
            StringBuffer code = new StringBuffer("20");
            code.append(entry.getValue());
            errorCodeIn.setInternalErrorCodeId(code.toString());
            errorCodeInList.add(errorCodeIn);
        }
        for (int i = 1; i <= 19; ++i) {
            ErrorCodeIn errorCodeIn = new ErrorCodeIn();
            StringBuffer code = new StringBuffer("20");
            int value = 2000 + i;
            code.append(value);
            errorCodeIn.setInternalErrorCodeId(code.toString());
            errorCodeInList.add(errorCodeIn);
        }
        return errorCodeInList;
    }

    public InternalServiceError getError(String errorCode) {
        InternalServiceError error = this.internalErrors.get(errorCode);
        InternalServiceError retError = new InternalServiceError();
        if (error == null) {
            retError.setErrorCode("9999");
            retError.setErrorMessage("Vakava sis\u00e4inen virhe.");
            retError.setErrorLevel("1");
            retError.setErrorDescription(new StringBuffer("Koodia '").append(errorCode).append("' ei l\u00f6ytynyt!"));
        } else {
            retError.setErrorCode(error.getErrorCode());
            retError.setErrorMessage(error.getErrorMessage());
            retError.setErrorLevel(error.getErrorLevel());
            retError.setErrorDescription(error.getErrorDescription());
            retError.setErrorCause(error.getErrorCause());
            retError.setCommonError(error.isCommonError());
        }
        return retError;
    }

    private List<ErrorCodeResponse> getCodes(List<ErrorCodeIn> inList) {
        List errorCodeOutList = null;
        try {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn("20"));
            String urlStr = new ArkistopalveluConfigMiddleManager().readArkistopalveluConfig("20", null).getArkistoProperties().getVirhekoodistourl();
            LOGGER.debug((Object)this.logHelper.formatMsg("20", urlStr));
            Virhekoodisto_Service service = new Virhekoodisto_Service();
            Virhekoodisto koodisto = service.getVirhekoodisto();
            BindingProvider bp = (BindingProvider)koodisto;
            bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", urlStr);
            errorCodeOutList = koodisto.getErrorCode(inList, "20");
            LOGGER.debug((Object)this.logHelper.formatMsgEnd("20"));
        }
        catch (ClassCastException | JAXBException | SAXException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("9999");
            error.setErrorMessage("Vakava sis\u00e4inen virhe.");
            error.setErrorLevel("1");
            LOGGER.error((Object)this.logHelper.formatMsg("20", error), ex);
        }
        return errorCodeOutList;
    }

    static {
        try {
            me = new ErrorWrapperArchive();
        }
        catch (Throwable e) {
            LOGGER.debug((Object)"Initialisointi ep\u00e4onnistui", e);
            throw e;
        }
    }
}

