<?xml version="1.0" encoding="UTF-8"?>
<!--Muunnostiedosto Kielto-lomakkeen tulostamista varten
Muutokset tulosteen muodostamisperiaatteisiin 10/2021:
- Kela-logo poistettu, Kanta-logo päivitetty
- Sivun asettelu muutettu Kanta-asiakirjapohjia mukailevaksi
- Ylätunnisteeseen lisätty potilaan nimi
- Alatunnisteesta ylätunnisteeseen siirretty sivunumero sekä tulosajankohta
- Alatunnisteesta poistettu lomakkeen omistajan määrittelyversio
- Tekstiotsikot siirretty header-osasta body-osaan
- Tulosteesta poistettu henkilötunnukset ja henkilötietojen taulukot
- Otsikointia muutettu 
- Poistettu allekirjoituksessa avustaneen tietojen lohko 
- Nimitietoihin otetaan näyttömuodosta kaikki nimet


-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:hl7="urn:hl7-org:v3" xmlns:hl7fi="urn:hl7finland" xmlns:java="http://xml.apache.org/xslt/java" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:kela="urn:kela">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<!-- Locations of image files -->
	<!-- Path, must end with \ (windows) or / (unix) -->
	<xsl:variable name="imagesPath" select="''"/>
	<xsl:variable name="kantaLogo" select="concat($imagesPath,'kanta_logotype_RGB.png')"/>
	<!-- ################# -->
	<xsl:variable name="XML" select="/"/>
	<!-- på svenska? -->
	<xsl:variable name="sv">
		<xsl:choose>
			<xsl:when test="string($XML/hl7:ClinicalDocument/hl7:languageCode/@code)='sv'">
				<xsl:value-of select="true()"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="false()"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:decimal-format name="format1" grouping-separator=" " decimal-separator=","/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="page-master-174104000" margin-left="20mm" margin-right="20mm" page-height="297mm" page-width="210mm" margin-top="10mm" margin-bottom="10mm">
				<fo:region-body margin-top="35mm" margin-bottom="15mm" column-count="1" column-gap="0.50in"/>
				<fo:region-before region-name="page-header" extent="35mm"/>
				<fo:region-after region-name="page-footer" extent="15mm"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:template match="/">
		<fo:root font-size="10pt">
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence master-reference="page-master-174104000" initial-page-number="auto" format="1"  force-page-count="no-force">
				<fo:static-content flow-name="page-header">
					<fo:block margin="0pt">
						<fo:table table-layout="fixed" width="100%">
							<fo:table-column column-width="90mm"/>
							<fo:table-column column-width="proportional-column-width(1)"/>
							<fo:table-column column-width="20mm"/>
							<fo:table-body start-indent="0pt" line-height="10pt">
								<fo:table-row height="28pt">
									<fo:table-cell display-align="center">
										<fo:block text-align="left">
											<fo:external-graphic content-height="8.4mm" scaling="uniform" src="{$kantaLogo}"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell display-align="center">
										<fo:block text-align="left">
											<fo:inline>												
													<xsl:choose>
															<xsl:when test="$sv='true'">
																<xsl:text>FÖRBUD MOT ATT LÄMNA UT UPPGIFTER /</xsl:text>
															</xsl:when>
															<xsl:otherwise>
																<xsl:text>TIETOJEN LUOVUTUSKIELTO / LUOVUTUSKIELLON PERUMINEN </xsl:text>
															</xsl:otherwise>
														</xsl:choose>													
											</fo:inline>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell display-align="center">
										<fo:block text-align="right">
											<xsl:call-template name="pages"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row height="36pt">
									<fo:table-cell padding="2pt" display-align="center">
										<fo:block text-align="left">
											<fo:inline>
												<xsl:value-of select="$XML//hl7:section[(hl7:code/@code='17' or hl7:code/@code='1.2.246.537.6.12.2002.331.17') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.331']/hl7:text"/>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell padding="2pt" display-align="center">
										<fo:block text-align="left">
											<fo:inline>
												<xsl:choose>
													<xsl:when test="system-property('xsl:vendor-url')='http://www.microsoft.com' or system-property('xsl:vendor-url')='http://www.altova.com'">
														<xsl:value-of select="kela:currentDate()"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="java:format(java:java.text.SimpleDateFormat.new('dd.MM.yyyy'), java:java.util.Date.new())"/>
													</xsl:otherwise>
												</xsl:choose>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:block>
				</fo:static-content>				
				<fo:static-content flow-name="page-footer">
					<fo:block-container height="0.49in" overflow="hidden" display-align="after">
						<fo:block>
							<fo:table width="100%" table-layout="fixed" border-spacing="2pt">
								<fo:table-column column-width="proportional-column-width(1)"/>
								<fo:table-body start-indent="0pt">
									<fo:table-row>
										<fo:table-cell padding="0" display-align="center">
											<fo:block text-align="center">
												<fo:inline>
													<xsl:value-of select="$XML//hl7:section[(hl7:code/@code='29' or hl7:code/@code='1.2.246.537.6.12.2002.331.29') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.331']/hl7:text"/>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
						</fo:block>
					</fo:block-container>
				</fo:static-content>
				
				<fo:flow flow-name="xsl-region-body">
				    <fo:block text-align="left" margin-left="0mm">
						<fo:inline font-size="16pt">						
								<xsl:choose>
										<xsl:when test="$sv='true'">
											<xsl:text>FÖRBUD MOT ATT LÄMNA UT UPPGIFTER/ÅTERKALLELSE AV FÖRBUDET</xsl:text>
										</xsl:when>
										<xsl:otherwise>
											<xsl:text>TIETOJEN LUOVUTUSKIELTO/LUOVUTUSKIELLON PERUMINEN</xsl:text>
										</xsl:otherwise>
									</xsl:choose>								
						</fo:inline>
						<fo:block space-after="20pt"/>
						<xsl:choose>
							<xsl:when test="$sv='true'">
								<fo:inline font-size="14pt">
									<xsl:text>Utlämnade av uppgifter som lagrats </xsl:text>
									<xsl:text>i patientdataarkivet</xsl:text>
								</fo:inline>
							</xsl:when>
							<xsl:otherwise>
								<fo:inline font-size="14pt">
									<xsl:text>Potilastiedon arkistoon </xsl:text>
									<xsl:text>tallennettujen tietojen luovuttaminen</xsl:text>
								</fo:inline>
							</xsl:otherwise>
						</xsl:choose>
						<fo:block/>
					</fo:block>
				
					<xsl:choose>
							<xsl:when test="$sv='true'">
								<fo:block margin-left="25mm" space-before="20pt" space-after="20pt" line-height="1.5">
									<fo:inline>
										<xsl:text>Jag har fått del av de uppgifter som finns som bilaga till denna handling och som gäller Kanta-tjänsterna, samt information om hur de förbud som jag meddelar påverkar behandlingen av mina patientuppgifter.</xsl:text>
									</fo:inline>
								</fo:block>
								<fo:block margin-left="25mm" space-before="20pt" space-after="20pt" line-height="1.5">
									<fo:inline>
										<xsl:text>Jag är medveten om att de uppgifter som omfattas av eventuella förbud mot utlämnande inte är tillgängliga, om jag inte nedan separat har gett mitt samtycke till att uppgifterna får lämnas ut i en nödsituation. Utan mitt samtycke kan uppgifterna inte användas ens i sådana situationer där jag på grund av en livshotande akut sjukdom eller skada är medvetslös och därför oförmögen att återkalla förbudet. Trots eventuella förbud är mina patientuppgifter ändå alltid tillgängliga för den tillhandahållare av hälso- och sjukvårdstjänster som har lagrat uppgifterna, även om denna inte får lämna ut dem.</xsl:text>
									</fo:inline>
								</fo:block>
								<fo:block margin-left="25mm" space-before="20pt" space-after="20pt" line-height="1.5">
									<fo:inline>
										<xsl:text>Förbudet mot att lämna ut uppgifter gäller tills vidare. Om jag så önskar kan jag hos en tillhandahållare av hälso- och sjukvårdstjänster eller via e-tjänsten Mina Kanta-sidor återkalla förbudet mot att lämna ut uppgifter eller meddela nya förbud.</xsl:text>
									</fo:inline>
								</fo:block>
								<fo:block margin-left="25mm" space-before="20pt" space-after="20pt" line-height="1.5">
									<fo:inline>
										<xsl:text>Det är förbjudet att via de riksomfattande informationssystemtjänsterna lämna ut uppgifter om mig som lagrats i det elektroniska patientdataarkivet till en annan tillhandahållare av hälso- och sjukvårdstjänster när det gäller följande servicehändelser och/eller tillhandahållare av hälso- och sjukvårdstjänster. De förbud som jag eventuellt har meddelat sjukvårdsdistriktets gemensamma patientregister gäller på samma sätt som tidigare.</xsl:text>
									</fo:inline>
								</fo:block>
							</xsl:when>
							<xsl:otherwise>
								<fo:block margin-left="25mm" space-before="20pt" space-after="20pt" line-height="1.5">
									<fo:inline>
										<xsl:text>Olen saanut ne Kanta-palveluja ja asettamieni kieltojen vaikutuksia potilastietojeni käsittelyyn koskevat tiedot, jotka ovat tämän asiakirjan liitteenä.</xsl:text>
									</fo:inline>
								</fo:block>
								<fo:block margin-left="25mm" space-before="20pt" space-after="20pt" line-height="1.5">
									<fo:inline>
										<xsl:text>Olen tietoinen siitä, että mahdollisten luovutuskieltojen kattamat tiedot eivät ole käytettävissä, ellen ole alla erikseen antanut suostumustani tietojen luovuttamiseen hätätilanteessa. Ilman suostumustani tietoja ei voi käyttää edes siinä tapauksessa, että olisin äkillisen henkeä uhkaavan sairauden tai loukkaantumisen vuoksi tajuton enkä sen vuoksi kykenisi peruuttamaan tekemääni kieltoa. Mahdollisista kielloista huolimatta potilastietoni ovat kuitenkin aina sen terveydenhuollon palvelujen antajan käytettävissä, joka on tallentanut tiedot, vaikka tämä ei saakaan luovuttaa tietoja.</xsl:text>
									</fo:inline>
								</fo:block>
								<fo:block margin-left="25mm" space-before="20pt" space-after="20pt" line-height="1.5">
									<fo:inline>
										<xsl:text>Tietojen luovutuskiellot ovat voimassa toistaiseksi. Voin halutessani peruuttaa tekemäni luovutuskiellon tai tehdä uusia kieltoja joko terveydenhuollon palvelujen antajan luona tai Omakanta-palvelussa.</xsl:text>
									</fo:inline>
								</fo:block>
								<fo:block margin-left="25mm" space-before="20pt" space-after="20pt" line-height="1.5">
									<fo:inline>
										<xsl:text>Potilastiedon arkistoon minusta tallennettujen tietojen luovuttaminen valtakunnallisten tietojärjestelmäpalvelujen kautta toiselle terveydenhuollon palvelujen antajalle on kielletty seuraavien käyntien/hoitojaksojen ja/tai terveydenhuollon palvelujen antajien osalta. Mahdolliset sairaanhoitopiirin yhteiseen potilastietorekisteriin tekemäni kiellot ovat voimassa kuten aiemmin.</xsl:text>
									</fo:inline>
								</fo:block>
							</xsl:otherwise>
						</xsl:choose>
						<fo:block/>
						<!-- Kieltojen tulostus alkaa -->
						<xsl:variable name="noOptOuts" select="$XML//hl7:section[(hl7:code/@code='5' or hl7:code/@code='1.2.246.537.6.12.2002.331.5') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.331']/hl7:entry/hl7:observation/hl7:value/@value"/>
						<fo:block margin="0pt" space-before="1.12em" space-after="1.12em" keep-with-next.within-page="always">
							<fo:inline font-size="12pt">
								<xsl:choose>
									<xsl:when test="$sv='true'">
										<xsl:text>Gällande förbud</xsl:text>
									</xsl:when>
									<xsl:otherwise>
										<xsl:text>Voimassa olevat kiellot</xsl:text>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:if test="string($noOptOuts)='true'">
									<xsl:choose>
										<xsl:when test="$sv='true'">
											<xsl:text>: Inga gällande förbud mot att lämna ut uppgifter</xsl:text>
										</xsl:when>
										<xsl:otherwise>
											<xsl:text>: Ei voimassa olevia tietojen luovutuskieltoja</xsl:text>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:if>
							</fo:inline>
						</fo:block>
						<xsl:choose>
							<xsl:when test="string($noOptOuts)='true'">
								</xsl:when>
							<xsl:otherwise>
								<fo:block margin="0pt" space-before="1.12em" space-after="1.12em" keep-with-next.within-page="always">
									<fo:inline  font-size="12pt">
										<xsl:choose>
											<xsl:when test="$sv='true'">
												<xsl:text>Servicehändelser, som det är förbjudet att lämna ut uppgifter om</xsl:text>
											</xsl:when>
											<xsl:otherwise>
												<xsl:text>Käynnit/hoitojaksot, joiden tietojen luovuttaminen on kielletty</xsl:text>
											</xsl:otherwise>
										</xsl:choose>
									</fo:inline>
								</fo:block>
								<fo:block  margin-left="25mm" space-before="1.12em" space-after="1.12em">
									<xsl:for-each select="$XML//hl7:section[(hl7:code/@code='6' or hl7:code/@code='1.2.246.537.6.12.2002.331.6') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.331']">
										<fo:inline>
											<xsl:choose>
												<xsl:when test="$sv='true'">
													<xsl:text>Tidpunkten för servicehändelsen: </xsl:text>
												</xsl:when>
												<xsl:otherwise>
													<xsl:text>Käynnin/hoitojakson ajankohta: </xsl:text>
												</xsl:otherwise>
											</xsl:choose>
										</fo:inline>
										<fo:inline>
											<xsl:for-each select="hl7:component/hl7:section[(hl7:code/@code='7' or hl7:code/@code='1.2.246.537.6.12.2002.331.7') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.331']/hl7:entry/hl7:observation/hl7:value">
												<xsl:call-template name="formatdatetime">
													<xsl:with-param name="datetime" select="hl7:low/@value"/>
													<xsl:with-param name="skipsec" select="true"/>
												</xsl:call-template>
												<xsl:text> – </xsl:text>
												<xsl:call-template name="formatdatetime">
													<xsl:with-param name="datetime" select="hl7:high/@value"/>
													<xsl:with-param name="skipsec" select="true"/>
												</xsl:call-template>
											</xsl:for-each>
										</fo:inline>
										<fo:block/>
										<fo:inline>
											<xsl:choose>
												<xsl:when test="$sv='true'">
													<xsl:text>Servicegivaren: </xsl:text>
												</xsl:when>
												<xsl:otherwise>
													<xsl:text>Palvelujen antaja: </xsl:text>
												</xsl:otherwise>
											</xsl:choose>
										</fo:inline>
										<xsl:for-each select="hl7:component/hl7:section[(hl7:code/@code='8' or hl7:code/@code='1.2.246.537.6.12.2002.331.8') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.331']/hl7:text">
											<fo:inline>
												<xsl:value-of select="."/>
												<xsl:text> </xsl:text>
											</fo:inline>
										</xsl:for-each>
										<fo:block/>
										<fo:block/>
									</xsl:for-each>
								</fo:block>
								<fo:block  margin="0pt" space-before="1.12em" space-after="1.12em" keep-with-next.within-page="always">
									<fo:inline font-size="12pt">
										<xsl:choose>
											<xsl:when test="$sv='true'">
												<xsl:text>Tillhandahållare av hälso- och sjukvårdstjänster och deras register, vars uppgifter det är förbjudet att lämna ut</xsl:text>
											</xsl:when>
											<xsl:otherwise>
												<xsl:text>Terveydenhuollon palvelujen antajat ja näiden rekisterit, joiden tietojen luovuttaminen on kielletty</xsl:text>
											</xsl:otherwise>
										</xsl:choose>
									</fo:inline>
									<fo:block margin-left="25mm" space-before="1.12em" space-after="1.12em">
										<xsl:for-each select="$XML//hl7:section[(hl7:code/@code='10' or hl7:code/@code='1.2.246.537.6.12.2002.331.10') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.331']">
											<fo:inline>
												<xsl:choose>
													<xsl:when test="$sv='true'">
														<xsl:text>Servicegivaren: </xsl:text>
													</xsl:when>
													<xsl:otherwise>
														<xsl:text>Palvelujen antaja: </xsl:text>
													</xsl:otherwise>
												</xsl:choose>
											</fo:inline>
											<xsl:for-each select="hl7:component/hl7:section[(hl7:code/@code='11' or hl7:code/@code='1.2.246.537.6.12.2002.331.11') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.331']/hl7:text">
												<fo:inline>
													<xsl:value-of select="."/>
													<xsl:text> </xsl:text>
												</fo:inline>
											</xsl:for-each>
											<fo:block/>
											<fo:inline>
												<xsl:choose>
													<xsl:when test="$sv='true'">
														<xsl:text>Förbjudna register: </xsl:text>
													</xsl:when>
													<xsl:otherwise>
														<xsl:text>Kielletyt rekisterit: </xsl:text>
													</xsl:otherwise>
												</xsl:choose>
											</fo:inline>
											<xsl:variable name="allRegistries" select="hl7:component/hl7:section[(hl7:code/@code='12' or hl7:code/@code='1.2.246.537.6.12.2002.331.12') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.331']/hl7:entry/hl7:observation/hl7:value/@value"/>
											<xsl:choose>
												<xsl:when test="string($allRegistries)='true'">
													<fo:inline>
														<xsl:choose>
															<xsl:when test="$sv='true'">
																<xsl:text>Alla register</xsl:text>
															</xsl:when>
															<xsl:otherwise>
																<xsl:text>Kaikki rekisterit</xsl:text>
															</xsl:otherwise>
														</xsl:choose>
													</fo:inline>
												</xsl:when>
												<xsl:otherwise>
													<xsl:for-each select="hl7:component/hl7:section[(hl7:code/@code='13' or hl7:code/@code='1.2.246.537.6.12.2002.331.13') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.331']/hl7:text">
														<fo:inline>
															<xsl:value-of select="."/>
															<xsl:text> </xsl:text>
														</fo:inline>
													</xsl:for-each>
												</xsl:otherwise>
											</xsl:choose>
											<fo:block/>
											<fo:block/>
										</xsl:for-each>
									</fo:block>
								</fo:block>
								<fo:block margin="0pt" space-before="1.12em" space-after="1.12em" keep-with-next.within-page="always">
									<fo:inline font-size="12pt">
										<xsl:choose>
											<xsl:when test="$sv='true'">
												<xsl:text>Utlämnande av uppgifter i en nödsituation</xsl:text>
											</xsl:when>
											<xsl:otherwise>
												<xsl:text>Luovuttaminen hätätilanteessa</xsl:text>
											</xsl:otherwise>
										</xsl:choose>
									</fo:inline>
								</fo:block>
								<fo:block margin-left="25mm" space-before="1.12em" space-after="1.12em">
									<fo:inline>
										<xsl:choose>
											<xsl:when test="$sv='true'">
												<xsl:text>De förbjudna uppgifterna får lämnas ut i en nödsituation: </xsl:text>
											</xsl:when>
											<xsl:otherwise>
												<xsl:text>Kielletyt tiedot voidaan luovuttaa hätätilanteessa: </xsl:text>
											</xsl:otherwise>
										</xsl:choose>
									</fo:inline>
									<xsl:variable name="emergency" select="$XML//hl7:section[(hl7:code/@code='14' or hl7:code/@code='1.2.246.537.6.12.2002.331.14') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.331']/hl7:component/hl7:section/hl7:entry/hl7:observation/hl7:value/@value">
										</xsl:variable>
									<fo:inline>
										<xsl:choose>
											<xsl:when test="string($emergency)='true'">
												<xsl:choose>
													<xsl:when test="$sv='true'">
														<xsl:text>( x ) ja (   ) ej</xsl:text>
													</xsl:when>
													<xsl:otherwise>
														<xsl:text>( x ) kyllä (   ) ei</xsl:text>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:when>
											<xsl:otherwise>
												<xsl:choose>
													<xsl:when test="$sv='true'">
														<xsl:text>(   ) ja ( x ) ej</xsl:text>
													</xsl:when>
													<xsl:otherwise>
														<xsl:text>(   ) kyllä ( x ) ei</xsl:text>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:otherwise>
										</xsl:choose>
									</fo:inline>
								</fo:block>
								<fo:block/>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Kieltojen tulostus loppuu -->
						<fo:block margin="0pt" space-before="1.12em" space-after="1.12em" keep-with-next.within-page="always">
						<fo:inline font-size="12pt">
							<xsl:choose>
								<xsl:when test="$sv='true'">
									<xsl:text>Patientens namn</xsl:text>
								</xsl:when>
								<xsl:otherwise>
									<xsl:text>Potilaan nimi</xsl:text>
								</xsl:otherwise>
							</xsl:choose>
						</fo:inline>
					</fo:block>
					<fo:block margin-left="25mm" space-before="1.12em" space-after="1.12em">
						<fo:inline>
							<xsl:value-of select="$XML//hl7:section[(hl7:code/@code='17' or hl7:code/@code='1.2.246.537.6.12.2002.331.17') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.331']/hl7:text"/>
						</fo:inline>
						</fo:block>						
						<!--<xsl:variable name="patientCannotSign" select="$XML//hl7:section[(hl7:code/@code='19' or hl7:code/@code='1.2.246.537.6.12.2002.331.19') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.331']/hl7:entry/hl7:observation/hl7:value/@value"/>
						<xsl:if test="string($patientCannotSign)='true'">
							<fo:block  margin-left="25mm" space-before="1.12em" space-after="1.12em">
								<fo:inline>
									<xsl:choose>
										<xsl:when test="$sv='true'">
											<xsl:text>Patienten är till exempel på grund av sjukdom eller skada oförmögen att underteckna förbudet mot att lämna ut uppgifter / återkallelsen av förbudet mot att lämna ut uppgifter. Motivering:&#160;</xsl:text>
										</xsl:when>
										<xsl:otherwise>
											<xsl:text>Potilas ei esimerkiksi sairauden tai vamman takia kykene allekirjoittamaan tietojen luovutuskieltoa / luovutuskiellon peruutusta. Peruste:&#160;</xsl:text>
										</xsl:otherwise>
									</xsl:choose>
								</fo:inline>
								<fo:inline>
									<xsl:value-of select="$XML//hl7:section[(hl7:code/@code='20' or hl7:code/@code='1.2.246.537.6.12.2002.331.20') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.331']/hl7:text"/>
								</fo:inline>
							</fo:block>
						</xsl:if>-->
						<fo:block margin="0pt" space-before="1.12em" space-after="1.12em" keep-with-next.within-page="always">
							<fo:inline font-size="12pt" keep-with-next.within-page="always">
								<xsl:choose>
									<xsl:when test="$sv='true'">
										<xsl:text>Underskrift av den som meddelar förbud mot att lämna ut uppgifter / återkallar förbudet mot att lämna ut uppgifter</xsl:text>
									</xsl:when>
									<xsl:otherwise>
										<xsl:text>Luovutuskiellon tekijä / luovutuskiellon peruuttaja</xsl:text>
									</xsl:otherwise>
								</xsl:choose>
							</fo:inline>
						</fo:block>
						<!--<xsl:if test="string($patientCannotSign)='true'">
							<fo:block margin="0pt" space-before="1.12em" space-after="1.12em" keep-with-next.within-page="always">
								<fo:inline font-weight="bold">
									<xsl:choose>
										<xsl:when test="$sv='true'">
											<xsl:text>För patientens räkning</xsl:text>
										</xsl:when>
										<xsl:otherwise>
											<xsl:text>Potilaan puolesta</xsl:text>
										</xsl:otherwise>
									</xsl:choose>
								</fo:inline>
							</fo:block>
						</xsl:if>-->
						<fo:block margin-left="25mm" space-before="1.12em" space-after="1.12em">
							<!--<fo:inline>
								<xsl:text>____________________________________&#160;&#160;&#160;</xsl:text>
							</fo:inline>-->
							<fo:inline>
								<xsl:for-each select="$XML//hl7:section[(hl7:code/@code='23' or hl7:code/@code='1.2.246.537.6.12.2002.331.23') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.331']/hl7:entry/hl7:observation/hl7:value">
									<xsl:call-template name="formatdatetime">
										<xsl:with-param name="datetime" select="@value"/>
										<xsl:with-param name="skipsec" select="true"/>
									</xsl:call-template>
								</xsl:for-each>
							</fo:inline>
						</fo:block>
						<fo:block margin-left="25mm" space-before="1.12em" space-after="1.12em">
							<fo:inline>
								<xsl:choose>
									<xsl:when test="$XML//hl7:section[(hl7:code/@code='22' or hl7:code/@code='1.2.246.537.6.12.2002.331.22') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.331']//hl7:given[@qualifier='CL']">
										<xsl:value-of select="$XML//hl7:section[(hl7:code/@code='22' or hl7:code/@code='1.2.246.537.6.12.2002.331.22') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.331']//hl7:given[@qualifier='CL']"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$XML//hl7:section[(hl7:code/@code='22' or hl7:code/@code='1.2.246.537.6.12.2002.331.22') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.331']//hl7:given[1]"/>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:text>&#160;</xsl:text>
								<xsl:value-of select="$XML//hl7:section[(hl7:code/@code='22' or hl7:code/@code='1.2.246.537.6.12.2002.331.22') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.331']//hl7:family"/>
							</fo:inline>
						</fo:block>
						<fo:block margin="0pt" space-before="1.12em" space-after="1.12em" keep-with-next.within-page="always">
							<fo:inline font-size="12pt" keep-with-next.within-page="always">
								<xsl:choose>
									<xsl:when test="$sv='true'">
										<xsl:text>Handlingen lagrades av</xsl:text>
									</xsl:when>
									<xsl:otherwise>
										<xsl:text>Asiakirjan tallentaja</xsl:text>
									</xsl:otherwise>
								</xsl:choose>
							</fo:inline>
						</fo:block>
						<fo:block margin-left="25mm" space-before="1.12em" space-after="1.12em">
							<xsl:for-each select="$XML//hl7:section[(hl7:code/@code='25' or hl7:code/@code='1.2.246.537.6.12.2002.331.25') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.331']/hl7:text">
								<fo:inline>
									<xsl:value-of select="."/>
									<xsl:text> </xsl:text>
								</fo:inline>
							</xsl:for-each>
							<fo:inline id="SV_RefID_PageTotal"/>
						</fo:block>
					<!--</fo:block>-->
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="formatdatetime">
		<xsl:param name="datetime"/>
		<xsl:param name="skiptime"/>
		<!-- skips time if value is not empty -->
		<xsl:param name="skipsec"/>
		<!-- skips seconds if value is not empty -->
		<!-- pp-->
		<xsl:if test='substring ($datetime, 7, 2)!=""'>
			<xsl:choose>
				<xsl:when test="substring($datetime,7,1)!='0'">
					<xsl:value-of select="substring ($datetime,7, 2)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="substring ($datetime,8, 1)"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:text>.</xsl:text>
		</xsl:if>
		<!-- kk-->
		<xsl:if test='substring ($datetime, 5, 2)!=""'>
			<xsl:choose>
				<xsl:when test="substring($datetime,5,1)!='0'">
					<xsl:value-of select="substring ($datetime,5, 2)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="substring ($datetime,6, 1)"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:text>.</xsl:text>
		</xsl:if>
		<!-- vvvv-->
		<xsl:value-of select="substring ($datetime, 1, 4)"/>
		<xsl:if test="$skiptime=''">
			<xsl:if test='substring ($datetime, 9, 2)!=""'>
				<xsl:text>&#160;</xsl:text>
				<!-- hh-->
				<xsl:choose>
					<xsl:when test="substring($datetime,9,1)!='0'">
						<xsl:value-of select="substring ($datetime,9, 2)"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="substring ($datetime,10, 1)"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<!-- mm -->
			<xsl:if test='substring ($datetime, 11, 2)!=""'>
				<xsl:text>.</xsl:text>
				<xsl:value-of select="substring ($datetime,11, 2)"/>
			</xsl:if>
			<!-- ss -->
			<xsl:if test='substring ($datetime, 13, 2)!="" and $skipsec=""'>
				<xsl:text>.</xsl:text>
				<xsl:value-of select="substring ($datetime,13, 2)"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template name="pages">
		<fo:block>
			<fo:page-number/> (<fo:page-number-citation ref-id="SV_RefID_PageTotal"/>)</fo:block>
	</xsl:template>
	<msxml:script xmlns:msxml="urn:schemas-microsoft-com:xslt" language="JavaScript" implements-prefix="kela">
		function currentDate(){
			var date = new Date();
			return date.getDate() + '.' + [date.getMonth() + 1] + "." + date.getYear();
		};
	</msxml:script>
</xsl:stylesheet>
