<?xml version="1.0" encoding="UTF-8"?>
<!--Muunnostiedosto Kielto-lomakkeen tulostamista varten
Muutokset tulosteen muodostamisperiaatteisiin 11/2021:
- Kela-logo poistettu, Kanta-logo päivitetty
- Sivun asettelu muutettu Kanta-asiakirjapohjia mukailevaksi
- Ylätunnisteeseen lisätty potilaan nimi
- Alatunnisteesta ylätunnisteeseen siirretty sivunumero sekä tulosajankohta
- Alatunnisteesta poistettu lomakkeen omistajan määrittelyversio
- Tekstiotsikot siirretty header-osasta body-osaan
- Tulosteesta poistettu henkilötunnukset ja henkilötietojen taulukot
- Otsikointia muutettu 
- Poistettu allekirjoituksessa avustaneen tietojen lohko 
- Nimitietoihin otetaan näyttömuodosta kaikki nimet
Muutos 27.11.2025:
- lisätty käytössä oleva lääke kohtaiset kiellot
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:hl7="urn:hl7-org:v3" xmlns:hl7fi="urn:hl7finland" xmlns:java="http://xml.apache.org/xslt/java" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:kela="urn:kela">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<!-- Locations of image files -->
	<!-- Path, must end with \ (windows) or / (unix) -->
	<xsl:variable name="imagesPath" select="''"/>
	<xsl:variable name="kantaLogoFI" select="concat($imagesPath,'kanta_logotype_RGB.png')"/>
	<!-- ################# -->
	<xsl:variable name="XML" select="/"/>
	<!-- på svenska? -->
	<xsl:variable name="sv">
		<xsl:choose>
			<xsl:when test="string($XML/hl7:ClinicalDocument/hl7:languageCode/@code)='sv'">
				<xsl:value-of select="true()"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="false()"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:template match="/">
		<fo:root font-size="10pt">
			<fo:layout-master-set>
				<fo:simple-page-master master-name="page-master-174104000" margin-left="0.78in" margin-right="0.78in" page-height="11.69in" page-width="8.27in" margin-top="0.39in" margin-bottom="0.39in">
					<fo:region-body margin-top="1.38in" margin-bottom="0.59in" column-count="1" column-gap="0.50in"/>
					<fo:region-before region-name="page-header" extent="1.38in"/>
					<fo:region-after region-name="page-footer" extent="0.59in"/>
				</fo:simple-page-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="page-master-174104000" initial-page-number="auto" force-page-count="no-force">
				<fo:static-content flow-name="page-header">
					<fo:block margin="0pt">
						<fo:table table-layout="fixed" width="100%">
							<fo:table-column column-width="90mm"/>
							<fo:table-column column-width="proportional-column-width(1)"/>
							<fo:table-column column-width="20mm"/>
							<fo:table-body start-indent="0pt" line-height="10pt">
								<fo:table-row height="28pt">
									<fo:table-cell display-align="center">
										<fo:block text-align="left">
											<fo:external-graphic content-height="8.4mm" scaling="uniform" src="{$kantaLogoFI}"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell display-align="center">
										<fo:block text-align="left">
											<fo:inline>												
													<xsl:choose>
															<xsl:when test="$sv='true'">
																<xsl:text>FÖRBUD MOT ATT LÄMNA UT UPPGIFTER/ÅTERKALLANDE AV FÖRBUDET</xsl:text>
															</xsl:when>
															<xsl:otherwise>
																<xsl:text>TIETOJEN LUOVUTUSKIELTO/LUOVUTUSKIELLON PERUMINEN </xsl:text>
															</xsl:otherwise>
														</xsl:choose>													
											</fo:inline>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell display-align="center">
										<fo:block text-align="right">
											<xsl:call-template name="pages"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row height="36pt">
									<fo:table-cell padding="2pt" display-align="center">
										<fo:block text-align="left">
											<fo:inline>
												<xsl:value-of select="$XML//hl7:section[(hl7:code/@code='16' or hl7:code/@code='1.2.246.537.6.12.2002.370.16') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']/hl7:text"/>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell padding="2pt" display-align="center">
										<fo:block text-align="left">
											<fo:inline>
												<xsl:choose>
													<xsl:when test="system-property('xsl:vendor-url')='http://www.microsoft.com' or system-property('xsl:vendor-url')='http://www.altova.com'">
														<xsl:value-of select="kela:currentDate()"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="java:format(java:java.text.SimpleDateFormat.new('dd.MM.yyyy'), java:java.util.Date.new())"/>
													</xsl:otherwise>
												</xsl:choose>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:block>
				</fo:static-content>
				<fo:static-content flow-name="page-footer">
					<fo:block-container height="0.49in" overflow="hidden" display-align="after">
						<fo:block>
							<fo:table width="100%" table-layout="fixed" border-spacing="2pt">
								<fo:table-column column-width="proportional-column-width(1)"/>
								<fo:table-body start-indent="0pt">
									<fo:table-row>
										<fo:table-cell font-size="10pt" padding="0" display-align="center">
											<!-- Kieltoasiakirjan tunnus-->
											<fo:block text-align="center">
												<fo:inline>
													<xsl:value-of select="$XML//hl7:section[(hl7:code/@code='30' or hl7:code/@code='1.2.246.537.6.12.2002.370.30') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']/hl7:text"/>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
						</fo:block>
					</fo:block-container>
				</fo:static-content>
				<fo:flow flow-name="xsl-region-body">
					<fo:block text-align="left" margin-left="0mm">
						<fo:inline font-size="16pt">						
								<xsl:choose>
										<xsl:when test="$sv='true'">
											<xsl:text>FÖRBUD MOT ATT LÄMNA UT UPPGIFTER/ÅTERKALLANDE AV FÖRBUDET</xsl:text>
										</xsl:when>
										<xsl:otherwise>
											<xsl:text>TIETOJEN LUOVUTUSKIELTO/LUOVUTUSKIELLON PERUMINEN</xsl:text>
										</xsl:otherwise>
									</xsl:choose>								
						</fo:inline>
						<fo:block space-after="20pt"/>
						<xsl:choose>
							<xsl:when test="$sv='true'">
								<fo:inline font-size="14pt">
									<xsl:text>Utlämnande av uppgifter som lagrats i Receptcentret </xsl:text>
								</fo:inline>
							</xsl:when>
							<xsl:otherwise>
								<fo:inline font-size="14pt">
									<xsl:text>Reseptikeskukseen tallennettujen tietojen luovuttaminen </xsl:text>
								</fo:inline>
							</xsl:otherwise>
						</xsl:choose>
						<fo:block/>
					</fo:block>
					<fo:block>
						<xsl:choose>
							<xsl:when test="$sv='true'">
								<fo:block margin-left="25mm" space-before="10pt" space-after="10pt" line-height="1.5">
									<fo:inline>
										<xsl:text>Du har meddelat ett förbud mot att medicineringsuppgifter lämnas ut. I det sammanhanget har du fått information om Kanta-tjänsterna och om hur förbudet mot att lämna ut uppgifter påverkar behandlingen av dina medicineringsuppgifter. Förbudet mot att lämna ut uppgifter innebär att uppgifter som omfattas av förbudet inte kan användas inom hälso- och sjukvården. Om du inte separat har tillåtit att dina uppgifter lämnas ut i en nödsituation, kan dina uppgifter inte användas ens i sådana situationer där du på grund av en livshotande akut sjukdom eller skada är medvetslös och därför oförmögen att återkalla ditt förbud. Om du har förbjudit att uppgifter om ett visst läkemedel lämnas ut och du ska köpa läkemedlet måste du på apoteket visa upp en patientanvisning eller en sammanställning som gäller läkemedlet i fråga.</xsl:text>
									</fo:inline>
								</fo:block>
								<fo:block margin-left="25mm" space-before="10pt" space-after="5pt" line-height="1.5">
									<fo:inline>
										<xsl:text>Även om du har förbjudit att uppgifter om ett visst läkemedel lämnas ut visas ändå följande uppgifter i Kanta-tjänsterna: </xsl:text>
									</fo:inline>
								</fo:block>
								<fo:block margin-left="39mm" space-before="10pt" space-after="10pt" line-height="1.5">
									<fo:inline>
										<xsl:text>•&#xA0;&#xA0;Läkaren ser uppgifter om alla HCI-läkemedel och narkotiska läkemedel som förskrivits för dig och anteckningarna om dem när hen skriver ut ett HCI- eller narkotikarecept (HCI-läkemedel är sådana som huvudsakligen påverkar det centrala nervsystemet).</xsl:text>
									</fo:inline>
								</fo:block>
								<fo:block margin-left="39mm" space-before="10pt" space-after="10pt" line-height="1.5">
									<fo:inline>
										 <xsl:text>•&#xA0;&#xA0;Tjänstetillhandahållaren inom hälso- och sjukvården eller socialvården eller den som förskriver läkemedlet ser uppgifterna om de recept du har begärt att få förnyade. </xsl:text> 
									</fo:inline>
								</fo:block>
								<fo:block margin-left="39mm" space-before="10pt" space-after="10pt" line-height="1.5">
									<fo:inline>
										 <xsl:text>•&#xA0;&#xA0;Om vårdrelationen fortsätter ser läkemedelsförskrivaren och den tjänstetillhandahållare som har sparat receptet uppgifterna om de recept de sparat och anteckningarna om dem. </xsl:text>
									</fo:inline>
								</fo:block>
								<fo:block margin-left="39mm" space-before="10pt" space-after="10pt" line-height="1.5">
									<fo:inline>
										 <xsl:text>•&#xA0;&#xA0;Läkemedelsförskrivaren ser uppgifterna om de recept som sparats på apoteket och de ändringar av doseringsanvisningen i recept som sparats av en sjukskötare, farmaceut eller provisor och där hen är antecknad som läkemedelsförskrivare samt uppgifterna om anteckningar som gäller dessa recept. </xsl:text>
										 </fo:inline>
								</fo:block>
								<fo:block margin-left="39mm" space-before="10pt" space-after="10pt" line-height="1.5">
										<fo:inline>
										  <xsl:text>•&#xA0;&#xA0;Vid störningar och fel i informationssystemen ser den tekniska personalen hos tjänstetillhandahållare inom hälso- och sjukvården, FPA eller informationssystemleverantören uppgifter i den omfattning som krävs för att störnings- och felsituationerna ska kunna åtgärdas.</xsl:text>
										</fo:inline>
								</fo:block>
								<fo:block margin-left="39mm" space-before="10pt" space-after="10pt" line-height="1.5">
									<fo:inline>
										  <xsl:text>•&#xA0;&#xA0;Läkemedelsförskrivaren eller tjänstetillhandahållaren inom hälso- och sjukvården ser uppgifterna om recept på biologiska läkemedel och expedieringsuppgifterna för tillsynen över egenkontroller över expedieringen av dessa läkemedel eller för myndighetsutredningar, för att tjänstetillhandahållaren själv ska kunna övervaka förskrivningen av läkemedlen och myndigheten vid behov utreda den. </xsl:text>
									</fo:inline>
								</fo:block>	
								<fo:block margin-left="39mm" space-before="10pt" space-after="10pt" line-height="1.5">
									<fo:inline>
										  <xsl:text>•&#xA0;&#xA0;Tjänstetillhandahållare inom hälso- och sjukvården eller socialvården ser uppgifterna om de handlingar de sparat och om anknytande anteckningar för utredningar som är relaterade till tillsynen. </xsl:text>
									</fo:inline>
								</fo:block>
								<fo:block margin-left="25mm" space-before="20pt" space-after="10pt" line-height="1.5">
									<fo:inline>
										<xsl:text>Förbuden mot utlämnande gäller tills vidare. Om du vill kan du återkalla ditt förbud mot utlämnande eller meddela nya förbud i MittKanta eller när du besöker en yrkesperson inom hälso- och sjukvården.</xsl:text>
									</fo:inline>
								</fo:block>
							</xsl:when>
							<xsl:otherwise>
								<fo:block margin-left="25mm" space-before="10pt" space-after="10pt" line-height="1.5">
									<fo:inline>
										<xsl:text>Olet tehnyt lääkitystietoihin liittyvän luovutuskiellon. Olet siinä yhteydessä saanut tietoa Kanta-palveluista ja siitä, miten luovutuskielto vaikuttaa lääkitystietojesi käsittelyyn. Tietojen luovutuskielto tarkoittaa sitä, että luovutuskieltojen alaiset tiedot eivät ole käytettävissä terveydenhuollossa. Jollet ole erikseen sallinut tietojesi luovuttamista hätätilanteessa, tietojasi ei voida käyttää edes siinä tapauksessa, että olisit äkillisen henkeä uhkaavan sairauden tai loukkaantumisen vuoksi tajuton, koska et kykenisi perumaan tekemääsi kieltoa. Jos olet kieltänyt tietyn lääkkeen tietojen luovuttamisen ja olet ostamassa lääkettä, sinun täytyy esittää apteekissa kieltämästäsi lääkkeestä potilasohje tai yhteenveto. 
 </xsl:text> 
									</fo:inline>
								</fo:block>
								<fo:block margin-left="25mm" space-before="10pt" space-after="5pt" line-height="1.5">
									<fo:inline>
										<xsl:text>Vaikka olet kieltänyt tietyn lääkkeen tietojesi luovuttamisen, Kanta-palveluissa näkyvät kuitenkin seuraavat tiedot:</xsl:text>
									</fo:inline>
								</fo:block>
								<fo:block margin-left="39mm" space-before="10pt" space-after="10pt" line-height="1.5">
									<fo:inline>
										<xsl:text>•&#xA0;&#xA0;Lääkäri näkee tiedot kaikista sinulle määrätyistä PKV- ja huumausainelääkkeistä ja niihin liittyvistä merkinnöistä silloin, kun hän on kirjoittamassa sinulle PKV- tai huumausainelääkemääräystä (PKV-lääke on pääasiallisesti keskushermostoon vaikuttava lääke).</xsl:text>
									</fo:inline>
								</fo:block>
								<fo:block margin-left="39mm" space-before="10pt" space-after="10pt" line-height="1.5">
									<fo:inline>
										 <xsl:text>•&#xA0;&#xA0;Terveydenhuollon tai sosiaalihuollon palvelunantaja tai lääkkeen määrääjä näkee tiedot uudistettavaksi pyytämistäsi lääkemääräyksistä.</xsl:text> 
									</fo:inline>
								</fo:block>
								<fo:block margin-left="39mm" space-before="10pt" space-after="10pt" line-height="1.5">
									<fo:inline>
										 <xsl:text>•&#xA0;&#xA0;Lääkkeen määrääjä ja lääkemääräyksen tallentanut palvelunantaja näkevät tiedot tallentamistaan lääkemääräyksistä ja näihin liittyvistä merkinnöistä, jos hoitosuhde jatkuu.</xsl:text>
									</fo:inline>
								</fo:block>
								<fo:block margin-left="39mm" space-before="10pt" space-after="10pt" line-height="1.5">
									<fo:inline>
										 <xsl:text>•&#xA0;&#xA0;Lääkkeen määrääjä näkee tiedot niistä apteekin tallentamista lääkemääräyksistä ja sairaanhoitajan, farmaseutin tai proviisorin tallentamista lääkemääräysten annostusohjeen muutoksista, joihin hänet on merkitty lääkkeen määrääjäksi, sekä tiedot näihin lääkemääräyksiin liittyvistä merkinnöistä.</xsl:text>
										 </fo:inline>
								</fo:block>
								<fo:block margin-left="39mm" space-before="10pt" space-after="10pt" line-height="1.5">
										<fo:inline>
										  <xsl:text>•&#xA0;&#xA0;Tietojärjestelmien häiriö- ja virhetilanteissa terveydenhuollon palvelunantajan, Kelan tai tietojärjestelmän toimittajan tekninen henkilöstö näkee tiedot siinä laajuudessa kuin häiriö- ja virhetilanteiden selvittely edellyttää.</xsl:text>
										</fo:inline>
								</fo:block>
								<fo:block margin-left="39mm" space-before="10pt" space-after="10pt" line-height="1.5">
									<fo:inline>
										  <xsl:text>•&#xA0;&#xA0;Lääkkeen määrääjä tai terveydenhuollon palvelunantaja näkee tietoja biologisten lääkkeiden lääkemääräyksistä ja toimituksista näiden lääkkeiden määräämisen omavalvontaa tai viranomaisselvityksiä varten, jotta palvelunantaja voi itse valvoa lääkkeiden määräämistä ja viranomainen tarvittaessa selvittää sitä.</xsl:text>
									</fo:inline>
								</fo:block>
								<fo:block margin-left="39mm" space-before="10pt" space-after="10pt" line-height="1.5">
									<fo:inline>
										  <xsl:text>•&#xA0;&#xA0;Terveydenhuollon tai sosiaalihuollon palvelunantaja näkee tiedot tallentamistaan asiakirjoista ja niihin liittyvistä merkinnöistä valvontaan liittyviä selvityksiä varten.</xsl:text>
									</fo:inline>
								</fo:block>
								<fo:block margin-left="25mm" space-before="20pt" space-after="10pt" line-height="1.5">
									<fo:inline>
										<xsl:text>Tietojen luovutuskiellot ovat voimassa toistaiseksi. Voit halutessasi perua tekemäsi luovutuskiellon tai tehdä uusia kieltoja OmaKannassa tai terveydenhuollon ammattihenkilön luona.</xsl:text>
									</fo:inline>
								</fo:block>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Kieltojen tulostus alkaa -->
						<xsl:variable name="noOptOuts" select="$XML//hl7:section[(hl7:code/@code='5' or hl7:code/@code='1.2.246.537.6.12.2002.370.5') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']/hl7:entry/hl7:observation/hl7:value/@value"/>
						<xsl:variable name="noOptOutsKOL" select="$XML//hl7:section[(hl7:code/@code='38' or hl7:code/@code='1.2.246.537.6.12.2002.370.38') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']//hl7:text"/>	
						<xsl:variable name="noOptOutsLM" select="$XML//hl7:section[(hl7:code/@code='9' or hl7:code/@code='1.2.246.537.6.12.2002.370.9') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']//hl7:text"/>	
						<fo:block margin="0pt" space-before="1.12em" space-after="1.12em" keep-with-next.within-page="always">
							<fo:inline font-size="12pt">
								<xsl:choose>
									<xsl:when test="$sv='true'">
										<xsl:text>Gällande förbud som avser recept</xsl:text>
									</xsl:when>
									<xsl:otherwise>
										<xsl:text>Voimassa olevat luovutuskiellot</xsl:text>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:if test="string($noOptOuts)='true'">
									<xsl:choose>
										<xsl:when test="$sv='true'">
											<xsl:text>: Patienten har inga gällande förbud mot att lämna ut receptuppgifter </xsl:text>
										</xsl:when>
										<xsl:otherwise>
											<xsl:text>: Potilaalla ei ole voimassa olevia luovutuskieltoja</xsl:text>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:if>
							</fo:inline>
						</fo:block>
						<xsl:choose>
							<xsl:when test="string($noOptOuts)='true'">
								</xsl:when>
							<xsl:otherwise>
							<fo:block margin="0pt" space-before="1.12em" space-after="1.12em" keep-with-next.within-page="always">
								<fo:inline font-size="12pt">
								<xsl:choose>
									<xsl:when test="$sv='true'">
								<xsl:choose>
									<xsl:when test="string($noOptOutsKOL)=''">
										<xsl:text>Patienten har inga gällande förbud mot att lämna ut receptuppgifter</xsl:text>
									</xsl:when>
									<xsl:otherwise>
										<xsl:text>Läkemedel som används, för vilket har meddelats förbud mot utlämnande av uppgifter</xsl:text>
									</xsl:otherwise>
								</xsl:choose>
									</xsl:when>
										<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="string($noOptOutsKOL)=''">
										<xsl:text>Potilaalla ei ole voimassa olevia lääkkeiden luovutuskieltoja</xsl:text>
										</xsl:when>
										<xsl:otherwise>
										<xsl:text>Lääke, jonka tietojen luovuttaminen on kielletty</xsl:text>
										</xsl:otherwise>
									</xsl:choose>
										</xsl:otherwise>
									</xsl:choose>
								</fo:inline>
							</fo:block>
								<fo:block margin-left="25mm" space-before="1.12em" space-after="1.12em">
									<xsl:for-each select="$XML//hl7:section[(hl7:code/@code='35' or hl7:code/@code='1.2.246.537.6.12.2002.370.35') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']">
										<fo:inline>
											<xsl:choose>
												<xsl:when test="$sv='true'">
													<xsl:text>Namnet på ett läkemedel: </xsl:text>
												</xsl:when>
												<xsl:otherwise>
													<xsl:text>Lääkkeen nimi: </xsl:text>
												</xsl:otherwise>
											</xsl:choose>
										</fo:inline>
										<fo:inline>
											<xsl:for-each select="hl7:component/hl7:section[(hl7:code/@code='38' or hl7:code/@code='1.2.246.537.6.12.2002.370.38') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']/hl7:text">
												<xsl:value-of select="."/>
											</xsl:for-each>
										</fo:inline>
										<fo:block/>
										<fo:inline>
											<xsl:choose>
												<xsl:when test="$sv='true'">
													<xsl:text>I textform den verksamma substansen i ett läkemedel: </xsl:text>
												</xsl:when>
												<xsl:otherwise>
													<xsl:text>Vaikuttava aine tekstinä: </xsl:text>
												</xsl:otherwise>
											</xsl:choose>
										</fo:inline>
										<fo:inline>
										<xsl:for-each select="hl7:component/hl7:section[(hl7:code/@code='37' or hl7:code/@code='1.2.246.537.6.12.2002.370.37') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']/hl7:text">
											<xsl:value-of select="."/>
										</xsl:for-each>
										</fo:inline>
										<fo:block margin="0pt" space-after="1.12em" keep-with-next.within-page="always"/>
									</xsl:for-each>
									<!--/fo:block>-->
								</fo:block>
								<fo:block margin="0pt" space-before="1.12em" space-after="1.12em" keep-with-next.within-page="always">
									<fo:inline font-size="12pt">
										<xsl:choose>
											<xsl:when test="$sv='true' and string($noOptOutsLM)=''">
												<xsl:text>Patienten har inga gällande förbud mot att lämna ut receptuppgifter</xsl:text>
											</xsl:when>
											<xsl:when test="$sv='true'">
												<xsl:text>Elektroniskt recept, som det är förbjudet att lämna ut uppgifter om</xsl:text>
											</xsl:when>
											<xsl:when test="string($noOptOutsLM)=''">
											<xsl:text>Potilaalla ei ole voimassa olevia lääkemääräystietojen luovutuskieltoja</xsl:text>
										   </xsl:when>
											<xsl:otherwise>
												<xsl:text>Sähköinen lääkemääräys, jonka tietojen luovuttaminen on kielletty</xsl:text>
											</xsl:otherwise>
										</xsl:choose>
									</fo:inline>
								</fo:block>
								<fo:block margin-left="25mm" space-before="1.12em" space-after="1.12em">
									<xsl:for-each select="$XML//hl7:section[(hl7:code/@code='7' or hl7:code/@code='1.2.246.537.6.12.2002.370.7') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']">
										<fo:inline>
											<xsl:choose>
												<xsl:when test="$sv='true'">
													<xsl:text>Förskrivningsdatum för läkemedlet: </xsl:text>
												</xsl:when>
												<xsl:otherwise>
													<xsl:text>Lääkkeen määräyspäivä: </xsl:text>
												</xsl:otherwise>
											</xsl:choose>
										</fo:inline>
										<fo:inline>
											<xsl:for-each select="hl7:component/hl7:section[(hl7:code/@code='12' or hl7:code/@code='1.2.246.537.6.12.2002.370.12') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']/hl7:entry/hl7:observation/hl7:value">
												<xsl:call-template name="formatdatetime">
													<xsl:with-param name="datetime" select="./@value"/>
													<xsl:with-param name="skiptime" select="true"/>
												</xsl:call-template>
											</xsl:for-each>
										</fo:inline>
										<fo:block/>
										<fo:inline>
											<xsl:choose>
												<xsl:when test="$sv='true'">
													<xsl:text>Namnet på den yrkesutbildade person som förskrivit läkemedlet: </xsl:text>
												</xsl:when>
												<xsl:otherwise>
													<xsl:text>Lääkkeen määrännyt ammattihenkilö: </xsl:text>
												</xsl:otherwise>
											</xsl:choose>
										</fo:inline>
										<fo:inline>
											<xsl:for-each select="hl7:component/hl7:section[(hl7:code/@code='11' or hl7:code/@code='1.2.246.537.6.12.2002.370.11') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']/hl7:text">
												<xsl:value-of select="."/>
												<xsl:text> </xsl:text>
											</xsl:for-each>
										</fo:inline>
										<fo:block/>
										<fo:inline>
											<xsl:choose>
												<xsl:when test="$sv='true'">
													<xsl:text>Namnet på preparat: </xsl:text>
												</xsl:when>
												<xsl:otherwise>
													<xsl:text>Valmisteen nimi: </xsl:text>
												</xsl:otherwise>
											</xsl:choose>
										</fo:inline>
										<fo:inline>
										<xsl:for-each select="hl7:component/hl7:section[(hl7:code/@code='9' or hl7:code/@code='1.2.246.537.6.12.2002.370.9') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']/hl7:text">
											<xsl:value-of select="."/>
										</xsl:for-each>
										</fo:inline>
										<fo:block margin="0pt" space-after="1.12em" keep-with-next.within-page="always"/>
									</xsl:for-each>
									<!--</fo:block>-->
								</fo:block>
								<fo:block margin="0pt" space-before="1.12em" space-after="1.12em" keep-with-next.within-page="always">
									<fo:inline font-size="12pt">
										<xsl:choose>
											<xsl:when test="$sv='true'">
												<xsl:text>Utlämnande av uppgifter i en nödsituation</xsl:text>
											</xsl:when>
											<xsl:otherwise>
												<xsl:text>Luovuttaminen hätätilanteessa</xsl:text>
											</xsl:otherwise>
										</xsl:choose>
									</fo:inline>
								</fo:block>
								<fo:block margin-left="25mm" space-before="1.12em" space-after="1.12em">
									<fo:inline>
										<xsl:choose>
											<xsl:when test="$sv='true'">
												<xsl:text>Uppgifter om recept kan lämnas ut i en nödsituation: </xsl:text>
											</xsl:when>
											<xsl:otherwise>
												<xsl:text>Lääkemääräyksien tiedot voidaan luovuttaa hätätilanteessa: </xsl:text>
											</xsl:otherwise>
										</xsl:choose>
									</fo:inline>
									<xsl:variable name="emergency" select="$XML//hl7:section[(hl7:code/@code='6' or hl7:code/@code='1.2.246.537.6.12.2002.370.6') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']/hl7:entry/hl7:observation/hl7:value/@value">
										</xsl:variable>
									<fo:inline>
										<xsl:choose>
											<xsl:when test="string($emergency)='true'">
												<xsl:choose>
													<xsl:when test="$sv='true'">
														<xsl:text>( x ) Ja (   ) Nej</xsl:text>
													</xsl:when>
													<xsl:otherwise>
														<xsl:text>( x ) Kyllä (   ) Ei</xsl:text>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:when>
											<xsl:otherwise>
												<xsl:choose>
													<xsl:when test="$sv='true'">
														<xsl:text>(   ) Ja ( x ) Nej</xsl:text>
													</xsl:when>
													<xsl:otherwise>
														<xsl:text>(   ) Kyllä ( x ) Ei</xsl:text>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:otherwise>
										</xsl:choose>
									</fo:inline>
								</fo:block>
								<fo:block/>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Kieltojen tulostus loppuu -->
						<fo:block margin="0pt" space-before="1.12em" space-after="1.12em" keep-with-next.within-page="always">
							<fo:inline font-size="12pt">
								<xsl:choose>
									<xsl:when test="$sv='true'">
										<xsl:text>Patientens namn</xsl:text>
									</xsl:when>
									<xsl:otherwise>
										<xsl:text>Potilaan nimi</xsl:text>
									</xsl:otherwise>
								</xsl:choose>
							</fo:inline>
						</fo:block>
						<fo:block margin-left="25mm" space-before="1.12em" space-after="1.12em">
						<fo:inline>
							<xsl:value-of select="$XML//hl7:section[(hl7:code/@code='16' or hl7:code/@code='1.2.246.537.6.12.2002.370.16') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']/hl7:text"/>
						</fo:inline>
						</fo:block>

						<!--xsl:variable name="patientCannotSign" select="$XML//hl7:section[(hl7:code/@code='18' or hl7:code/@code='1.2.246.537.6.12.2002.370.18') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']/hl7:entry/hl7:observation/hl7:value/@value"/>
						<xsl:if test="string($patientCannotSign)='true'">
							<fo:block margin="0pt" space-before="1.12em" space-after="1.12em">
								<fo:inline>
									<xsl:choose>
										<xsl:when test="$sv='true'">
											<xsl:text>Patienten är till exempel på grund av sjukdom eller skada oförmögen att underteckna förbudet mot att lämna ut receptuppgifter eller återkallelsen av förbudet mot att lämna ut uppgifter</xsl:text>
											<fo:block />
											<xsl:text>Ja, motivering:&#160;</xsl:text>
										</xsl:when>
										<xsl:otherwise>
											<xsl:text>Potilas ei esimerkiksi sairauden tai vamman takia kykene allekirjoittamaan lääkemääräystietojen luovutuskieltoa tai luovutuskiellon peruutusta </xsl:text>
											<fo:block />
											<xsl:text>Kyllä, peruste:&#160;</xsl:text>
										</xsl:otherwise>
									</xsl:choose>
								</fo:inline>
								<fo:inline>
									<xsl:value-of select="$XML//hl7:section[(hl7:code/@code='19' or hl7:code/@code='1.2.246.537.6.12.2002.370.19') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']/hl7:text"/>
								</fo:inline>
							</fo:block>
						</xsl:if-->
						<fo:block margin="0pt" space-before="1.12em" space-after="1.12em" keep-with-next.within-page="always">
							<fo:inline font-size="12pt" keep-with-next.within-page="always">
								<xsl:choose>
									<xsl:when test="$sv='true'">
										<xsl:text>Underskrift av den som meddelar förbud mot att lämna ut uppgifter / återkallar förbudet mot att lämna ut uppgifter</xsl:text>
									</xsl:when>
									<xsl:otherwise>
										<xsl:text>Luovutuskiellon tekijä / luovutuskiellon peruuttaja</xsl:text>
									</xsl:otherwise>
								</xsl:choose>
							</fo:inline>
						</fo:block>
						<!--xsl:if test="string($patientCannotSign)='true'">
							<fo:block margin="0pt" space-before="1.12em" space-after="1.12em" keep-with-next.within-page="always">
								<fo:inline font-weight="bold">
									<xsl:choose>
										<xsl:when test="$sv='true'">
											<xsl:text>På patientens vägnar </xsl:text>
										</xsl:when>
										<xsl:otherwise>
											<xsl:text>Potilaan puolesta</xsl:text>
										</xsl:otherwise>
									</xsl:choose>
								</fo:inline>
							</fo:block>
						</xsl:if-->
						<fo:block margin-left="25mm" space-before="1.12em" space-after="1.12em">
							<fo:inline>
								<xsl:for-each select="$XML//hl7:section[(hl7:code/@code='22' or hl7:code/@code='1.2.246.537.6.12.2002.370.22') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']/hl7:entry/hl7:observation/hl7:value">
									<xsl:call-template name="formatdatetime">
										<xsl:with-param name="datetime" select="@value"/>
										<xsl:with-param name="skipsec" select="true"/>
									</xsl:call-template>
								</xsl:for-each>
							</fo:inline>
						</fo:block>
						<fo:block margin-left="25mm" space-before="1.12em" space-after="1.12em">
							<fo:inline>
								<xsl:choose>
									<xsl:when test="$XML//hl7:section[(hl7:code/@code='21' or hl7:code/@code='1.2.246.537.6.12.2002.370.21') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']//hl7:given[@qualifier='CL']">
														<xsl:value-of select="$XML//hl7:section[(hl7:code/@code='21' or hl7:code/@code='1.2.246.537.6.12.2002.370.21') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']//hl7:given[@qualifier='CL']"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$XML//hl7:section[(hl7:code/@code='21' or hl7:code/@code='1.2.246.537.6.12.2002.370.21') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']//hl7:given[1]"/>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:text>&#160;</xsl:text>
								<xsl:value-of select="$XML//hl7:section[(hl7:code/@code='21' or hl7:code/@code='1.2.246.537.6.12.2002.370.21') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']//hl7:family"/>
							</fo:inline>
						</fo:block>
						<fo:block margin="0pt" space-before="1.12em" space-after="1.12em" keep-with-next.within-page="always">
							<fo:inline font-size="12pt" keep-with-next.within-page="always">
								<xsl:choose>
									<xsl:when test="$sv='true'">
										<xsl:text>Handlingen lagrades av</xsl:text>
									</xsl:when>
									<xsl:otherwise>
										<xsl:text>Asiakirjan tallentaja</xsl:text>
									</xsl:otherwise>
								</xsl:choose>
							</fo:inline>
						</fo:block>
						<fo:block margin-left="25mm" space-before="1.12em" space-after="1.12em">
							<fo:inline>
								<xsl:value-of select="$XML//hl7:section[(hl7:code/@code='26' or hl7:code/@code='1.2.246.537.6.12.2002.370.26') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']/hl7:text"/>
							</fo:inline>
							<!--xsl:for-each select="$XML//hl7:section[(hl7:code/@code='26' or hl7:code/@code='1.2.246.537.6.12.2002.370.26') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']/hl7:text">
								<fo:inline>
									<xsl:value-of select="."/>
									<xsl:text> </xsl:text>
								</fo:inline>
							</xsl:for-each-->
							<fo:inline id="SV_RefID_PageTotal"/>
						</fo:block>
					</fo:block>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="formatdatetime">
		<xsl:param name="datetime"/>
		<xsl:param name="skiptime"/>
		<!-- skips time if value is not empty -->
		<xsl:param name="skipsec"/>
		<!-- skips seconds if value is not empty -->
		<!-- pp-->
		<xsl:if test='substring ($datetime, 7, 2)!=""'>
			<xsl:choose>
				<xsl:when test="substring($datetime,7,1)!='0'">
					<xsl:value-of select="substring ($datetime,7, 2)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="substring ($datetime,8, 1)"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:text>.</xsl:text>
		</xsl:if>
		<!-- kk-->
		<xsl:if test='substring ($datetime, 5, 2)!=""'>
			<xsl:choose>
				<xsl:when test="substring($datetime,5,1)!='0'">
					<xsl:value-of select="substring ($datetime,5, 2)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="substring ($datetime,6, 1)"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:text>.</xsl:text>
		</xsl:if>
		<!-- vvvv-->
		<xsl:value-of select="substring ($datetime, 1, 4)"/>
		<xsl:if test="$skiptime=''">
			<xsl:if test='substring ($datetime, 9, 2)!=""'>
				<xsl:text>&#160;</xsl:text>
				<!-- hh-->
				<xsl:choose>
					<xsl:when test="substring($datetime,9,1)!='0'">
						<xsl:value-of select="substring ($datetime,9, 2)"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="substring ($datetime,10, 1)"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<!-- mm -->
			<xsl:if test='substring ($datetime, 11, 2)!=""'>
				<xsl:text>.</xsl:text>
				<xsl:value-of select="substring ($datetime,11, 2)"/>
			</xsl:if>
			<!-- ss -->
			<xsl:if test='substring ($datetime, 13, 2)!="" and $skipsec=""'>
				<xsl:text>.</xsl:text>
				<xsl:value-of select="substring ($datetime,13, 2)"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template name="pages">
		<fo:block>
			<fo:page-number/> (<fo:page-number-citation ref-id="SV_RefID_PageTotal"/>)</fo:block>
	</xsl:template>
	<msxml:script xmlns:msxml="urn:schemas-microsoft-com:xslt" language="JavaScript" implements-prefix="kela">
		function currentDate(){
			var date = new Date();
			return date.getDate() + '.' + [date.getMonth() + 1] + "." + date.getYear();
		};
	</msxml:script>
</xsl:stylesheet>
