<?xml version="1.0" encoding="UTF-8"?>
<!--Muunnostiedosto Luovutuslupa-lomakkeen tulostamista varten
Pohjana käytetty Suostumus-lomakkeen muunnostiedostoa
Muunnostiedosto tuottaa tulosteelle joko suostumuksen tai luovutusluvan tekstit XML-asiakirjan tiedon codeId 1 otsikkotekstin mukaisesti. 
Muutokset tulosteen muodostamisperiaatteisiin 10/2021:
- Kela-logo poistettu, Kanta-logo päivitetty
- Sivun asettelu muutettu Kanta-asiakirjapohjia mukailevaksi
- Ylätunnisteeseen lisätty potilaan nimi
- Alatunnisteesta ylätunnisteeseen siirretty sivunumero sekä tulosajankohta
- Alatunnisteesta poistettu lomakkeen omistajan määrittelyversio
- Tekstiotsikot siirretty header-osasta body-osaan
- Tulosteesta poistettu henkilötunnukset ja henkilötietojen taulukot
- Otsikointia muutettu 
- Poistettu allekirjoituksessa avustaneen tietojen lohkon näyttäminen
- Jos lomakkeella tiedot allekirjoituksessa avustamisesta, luovutusluvan / suostumuksen antajana näytetään potilas itse 
- Nimitietoihin otetaan näyttömuodosta kaikki nimet
Muutokset 10/2023: lisätty käsittely luovutusluvan tekstiversiolle PTA330.2024
- jos code 27 on ko. version tunniste, kyseessä aina luovutuslupa
- muuten tutkitaan lomakkeen pääotsikosta onko suostumus vai luovutuslupa.

-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:hl7="urn:hl7-org:v3" xmlns:hl7fi="urn:hl7finland" xmlns:java="http://xml.apache.org/xslt/java" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:kela="urn:kela">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<!-- Locations of image files -->
	<!-- Path, must end with \ (windows) or / (unix) -->
	<xsl:variable name="imagesPath" select="''"/>
	<xsl:variable name="kantaLogo" select="concat($imagesPath,'kanta_logotype_RGB.png')"/>
	<!-- ################# -->
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="cancellation">
		<xsl:choose>
			<xsl:when test="$XML//hl7:section[(hl7:code/@code='21' or hl7:code/@code='1.2.246.537.6.12.2002.330.21') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.330']">
				<xsl:value-of select="true()"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="false()"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="representativeInvolved">
		<xsl:choose>
			<xsl:when test="$XML//hl7:section[(hl7:code/@code='9' or hl7:code/@code='1.2.246.537.6.12.2002.330.9') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.330']/hl7:text">
				<xsl:value-of select="true()"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="false()"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<!-- på svenska? -->
	<xsl:variable name="sv">
		<xsl:choose>
			<xsl:when test="string($XML/hl7:ClinicalDocument/hl7:languageCode/@code)='sv'">
				<xsl:value-of select="true()"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="false()"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<!-- Luovutusluvan vai suostumuksen tekstit? Huom. Jos annettu version tunniste PTA33.2024, kyseessä aina luovutuslupa lomakkeen teksteistä riippumatta. -->
	<xsl:variable name="suostumus">
		<xsl:choose>
			<xsl:when test="(string($XML//hl7:section/hl7:code[(@code='1' or @code='1.2.246.537.6.12.2002.330.1') and @codeSystem='1.2.246.537.6.12.2002.330']/@displayName)='Suostumus' or string($XML//hl7:section/hl7:code[(@code='1' or @code='1.2.246.537.6.12.2002.330.1') and @codeSystem='1.2.246.537.6.12.2002.330']/@displayName)='Samtycke') and not(string($XML//hl7:section[hl7:code[(@code='27' or @code='1.2.246.537.6.12.2002.330.27') and @codeSystem='1.2.246.537.6.12.2002.330']]/hl7:text)='PTA330.2024')">
				<xsl:value-of select="true()"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="false()"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
		<!-- Luovutusluvan 2024-version tekstit vai vanhemmat tekstit? Korvaa tietosisällön code 3 pitkän tekstin, muut tekstin suostumus/luovutuslupa-valinnan mukaan. -->
	<xsl:variable name="luovutuslupa2024">
		<xsl:choose>
			<xsl:when test="string($XML//hl7:section[hl7:code[(@code='27' or @code='1.2.246.537.6.12.2002.330.27') and @codeSystem='1.2.246.537.6.12.2002.330']]/hl7:text)='PTA330.2024'">
				<xsl:value-of select="true()"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="false()"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:decimal-format name="format1" grouping-separator=" " decimal-separator=","/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="page-master-149464384" margin-left="20mm" margin-right="20mm" page-height="297mm" page-width="210mm" margin-top="10mm" margin-bottom="10mm">
				<fo:region-body margin-top="35mm" margin-bottom="15mm" column-count="1" column-gap="0.50in"/>
				<fo:region-before region-name="page-header" extent="35mm"/>
				<fo:region-after region-name="page-footer" extent="15mm"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:template match="/">
		<fo:root font-size="10pt">
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence master-reference="page-master-149464384" initial-page-number="auto" format="1" force-page-count="no-force">
				<fo:static-content flow-name="page-header">
					<fo:block margin="0pt">
						<fo:table table-layout="fixed" width="100%">
							<fo:table-column column-width="90mm"/>
							<fo:table-column column-width="proportional-column-width(1)"/>
							<fo:table-column column-width="20mm"/>
							<fo:table-body start-indent="0pt" line-height="10pt">
								<fo:table-row height="28pt">
									<fo:table-cell display-align="center">
										<fo:block text-align="left">
											<fo:external-graphic content-height="8.4mm" scaling="uniform" src="{$kantaLogo}"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell display-align="center">
										<fo:block text-align="left">
											<fo:inline>
												<xsl:choose>
													<xsl:when test="$cancellation='true'">
														<xsl:choose>
															<!--Ruotsinkielinen suostumuksen teksti-->
															<xsl:when test="$sv='true' and $suostumus='true'">
																<xsl:text>ÅTERKALLELSE AV SAMTYCKE</xsl:text>
															</xsl:when>
															<!--Suomenkielinen suostumuksen teksti-->
															<xsl:when test="$sv='false' and $suostumus='true'">
																<xsl:text>SUOSTUMUKSEN PERUUTUS</xsl:text>
															</xsl:when>
															<!--Ruotsinkielinen luovutusluvan teksti-->
															<xsl:when test="$sv='true' and $suostumus='false'">
																<xsl:text>ÅTERKALLANDE AV TILLSTÅND FÖR UTLÄMNANDE</xsl:text>
															</xsl:when>
															<!--Suomenkielinen luovutusluvan teksti-->
															<xsl:otherwise>
																<xsl:text>LUOVUTUSLUVAN PERUUTUS</xsl:text>
															</xsl:otherwise>
														</xsl:choose>
													</xsl:when>
													<xsl:otherwise>
														<xsl:choose>
															<!--Ruotsinkielinen suostumuksen teksti-->
															<xsl:when test="$sv='true' and $suostumus='true'">
																<xsl:text>SAMTYCKE</xsl:text>
															</xsl:when>
															<!--Suomenkielinen suostumuksen teksti-->
															<xsl:when test="$sv='false' and $suostumus='true'">
																<xsl:text>SUOSTUMUS</xsl:text>
															</xsl:when>
															<!--Ruotsinkielinen luovutusluvan teksti-->
															<xsl:when test="$sv='true' and $suostumus='false'">
																<xsl:text>TILLSTÅND FÖR UTLÄMNANDE</xsl:text>
															</xsl:when>
															<!--Suomenkielinen luovutusluvan teksti-->
															<xsl:otherwise>
																<xsl:text>LUOVUTUSLUPA</xsl:text>
															</xsl:otherwise>
														</xsl:choose>
													</xsl:otherwise>
												</xsl:choose>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell display-align="center">
										<fo:block text-align="right">
											<xsl:call-template name="pages"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row height="36pt">
									<fo:table-cell padding="2pt" display-align="center">
										<fo:block text-align="left">
											<fo:inline>
												<xsl:value-of select="$XML//hl7:section[(hl7:code/@code='5' or hl7:code/@code='1.2.246.537.6.12.2002.330.5') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.330']/hl7:text"/>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell padding="2pt" display-align="center">
										<fo:block text-align="left">
											<fo:inline>
												<xsl:choose>
													<xsl:when test="system-property('xsl:vendor-url')='http://www.microsoft.com' or system-property('xsl:vendor-url')='http://www.altova.com'">
														<xsl:value-of select="kela:currentDate()"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="java:format(java:java.text.SimpleDateFormat.new('dd.MM.yyyy'), java:java.util.Date.new())"/>
													</xsl:otherwise>
												</xsl:choose>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:block>
				</fo:static-content>
				<fo:static-content flow-name="page-footer">
					<fo:block-container height="0.49in" overflow="hidden" display-align="after">
						<fo:block>
							<fo:table width="100%" table-layout="fixed" border-spacing="2pt">
								<fo:table-column column-width="proportional-column-width(1)"/>
								<fo:table-body start-indent="0pt">
									<fo:table-row>
										<fo:table-cell padding="0" display-align="center">
											<fo:block text-align="center">
												<fo:inline>
													<xsl:value-of select="$XML//hl7:section[(hl7:code/@code='28' or hl7:code/@code='1.2.246.537.6.12.2002.330.28') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.330']/hl7:text"/>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
						</fo:block>
					</fo:block-container>
				</fo:static-content>
				<fo:flow flow-name="xsl-region-body">
					<fo:block text-align="left" margin-left="0mm">
						<fo:inline font-size="16pt">
							<xsl:choose>
								<xsl:when test="$cancellation='true'">
									<xsl:choose>
										<!--Ruotsinkielinen suostumuksen teksti-->
										<xsl:when test="$sv='true' and $suostumus='true'">
											<xsl:text>ÅTERKALLELSE AV SAMTYCKE</xsl:text>
										</xsl:when>
										<!--Suomenkielinen suostumuksen teksti-->
										<xsl:when test="$sv='false' and $suostumus='true'">
											<xsl:text>SUOSTUMUKSEN PERUUTUS</xsl:text>
										</xsl:when>
										<!--Ruotsinkielinen luovutusluvan teksti-->
										<xsl:when test="$sv='true' and $suostumus='false'">
											<xsl:text>ÅTERKALLANDE AV TILLSTÅND FÖR UTLÄMNANDE</xsl:text>
										</xsl:when>
										<!--Suomenkielinen luovutusluvan teksti-->
										<xsl:otherwise>
											<xsl:text>LUOVUTUSLUVAN PERUUTUS</xsl:text>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<!--Ruotsinkielinen suostumuksen teksti-->
										<xsl:when test="$sv='true' and $suostumus='true'">
											<xsl:text>SAMTYCKE</xsl:text>
										</xsl:when>
										<!--Suomenkielinen suostumuksen teksti-->
										<xsl:when test="$sv='false' and $suostumus='true'">
											<xsl:text>SUOSTUMUS</xsl:text>
										</xsl:when>
										<!--Ruotsinkielinen luovutusluvan teksti-->
										<xsl:when test="$sv='true' and $suostumus='false'">
											<xsl:text>TILLSTÅND FÖR UTLÄMNANDE</xsl:text>
										</xsl:when>
										<!--Suomenkielinen luovutusluvan teksti-->
										<xsl:otherwise>
											<xsl:text>LUOVUTUSLUPA</xsl:text>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</fo:inline>
						<fo:block space-after="20pt"/>
						<!--Sama tekstisisältö sekä suostumuksella että luovutusluvalla-->
						<xsl:choose>
							<xsl:when test="$sv='true'">
								<fo:inline font-size="14pt">
									<xsl:text>Utlämnade av uppgifter som lagrats </xsl:text>
									<xsl:choose>
										<xsl:when test="$representativeInvolved='true'">
											<xsl:text>i patientdataarkivet till en annan laglig företrädare</xsl:text>
										</xsl:when>
										<xsl:otherwise>
											<xsl:text>i patientdataarkivet</xsl:text>
										</xsl:otherwise>
									</xsl:choose>
								</fo:inline>
							</xsl:when>
							<xsl:otherwise>
								<fo:inline font-size="14pt">
									<xsl:text>Potilastiedon arkistoon </xsl:text>
									<xsl:text>tallennettujen tietojen luovuttaminen</xsl:text>
								</fo:inline>
							</xsl:otherwise>
						</xsl:choose>
						<fo:block/>
					</fo:block>
					<xsl:choose>
						<!--Ruotsinkielinen suostumuksen teksti-->
						<xsl:when test="$sv='true' and $suostumus='true'">
							<fo:block margin-left="25mm" space-before="20pt" space-after="20pt" line-height="1.5">
								<fo:inline>
									<xsl:text>Jag har fått del av de uppgifter som finns som bilaga till detta samtycke och som gäller Kanta-tjänsterna och det elektroniska arkivet samt fått information om hur de samtycken och förbud som jag ger påverkar behandlingen av mina patientuppgifter.</xsl:text>
								</fo:inline>
							</fo:block>
							<fo:block margin-left="25mm" space-before="0pt" space-after="20pt" line-height="1.5">
								<fo:inline>
									<xsl:text>Jag ger mitt samtycke till att de uppgifter om mig som finns lagrade i Patientdataarkivet får lämnas ut via de riksomfattande informationssystemtjänsterna till tillhandahållare av hälso- och sjukvårdstjänster för ordnande och tillhandahållande av min personliga hälso- och sjukvård.</xsl:text>
								</fo:inline>
							</fo:block>
							<fo:block margin-left="25mm" space-before="0pt" space-after="20pt" line-height="1.5">
								<fo:inline>
									<xsl:text>Mitt samtycke omfattar alla de uppgifter om mig som finns lagrade i Patientdataarkivet, och även de uppgifter som kommer att lagras där efter att jag gett mitt samtycke. Samtycket gäller tills vidare.</xsl:text>
								</fo:inline>
							</fo:block>
							<fo:block margin-left="25mm" space-before="0pt" space-after="20pt" line-height="1.5">
								<fo:inline>
									<xsl:text>Om jag så önskar kan jag hos en tillhandahållare av hälso- och sjukvårdstjänster eller via e-tjänsten Mina Kanta-sidor återkalla det samtycke som jag har gett.</xsl:text>
								</fo:inline>
							</fo:block>
							<fo:block margin-left="25mm" space-before="0pt" space-after="20pt" line-height="1.5">
								<fo:inline>
									<xsl:text>Om jag så önskar kan jag hos en tillhandahållare av hälso- och sjukvårdstjänster eller via e-tjänsten Mina Kanta-sidor förbjuda utlämnande av sådana uppgifter som jag särskilt specificerar. De förbud som jag eventuellt har anmält till sjukvårdsdistriktets gemensamma patientregister gäller på samma sätt som tidigare.</xsl:text>
								</fo:inline>
							</fo:block>
						</xsl:when>
						<!--Suomenkielinen suostumuksen teksti-->
						<xsl:when test="$sv='false' and $suostumus='true'">
							<fo:block margin-left="25mm" space-before="20pt" space-after="20pt" line-height="1.5">
								<fo:inline>
									<xsl:text>Olen saanut ne tiedot, jotka koskevat Kanta-palveluja, Potilastiedon arkistoa sekä antamieni suostumusten ja kieltojen vaikutuksia potilastietojeni käsittelyyn. Saamani tiedot ovat tämän suostumuksen liitteenä.</xsl:text>
								</fo:inline>
							</fo:block>
							<fo:block margin-left="25mm" space-before="0pt" space-after="20pt" line-height="1.5">
								<fo:inline>
									<xsl:text>Annan suostumukseni siihen, että Potilastiedon arkistoon minusta tallennettuja tietoja saa luovuttaa valtakunnallisten tietojärjestelmäpalvelujen kautta terveydenhuollon palvelujen antajille henkilökohtaisen terveyden- ja sairaanhoitoni järjestämiseksi ja toteuttamiseksi.</xsl:text>
								</fo:inline>
							</fo:block>
							<fo:block margin-left="25mm" space-before="0pt" space-after="20pt" line-height="1.5">
								<fo:inline>
									<xsl:text>Suostumus kattaa kaikki minusta Potilastiedon arkistoon tallennetut ja myös suostumuksen antamisen jälkeen tallennettavat tiedot. Suostumus on voimassa toistaiseksi.</xsl:text>
								</fo:inline>
							</fo:block>
							<fo:block margin-left="25mm" space-before="0pt" space-after="20pt" line-height="1.5">
								<fo:inline>
									<xsl:text>Voin halutessani peruuttaa antamani suostumuksen joko terveydenhuollon palvelujen antajan luona tai Omakanta-palvelussa.</xsl:text>
								</fo:inline>
							</fo:block>
							<fo:block margin-left="25mm" space-before="0pt" space-after="20pt" line-height="1.5">
								<fo:inline>
									<xsl:text>Voin halutessani kieltää erikseen määrittelemieni tietojen luovuttamisen joko terveydenhuollon palvelujen antajan luona tai Omakanta-palvelussa. Mahdolliset sairaanhoitopiirin yhteiseen potilastietorekisteriin tekemäni kiellot ovat voimassa kuten aiemmin.</xsl:text>
								</fo:inline>
							</fo:block>
						</xsl:when>
						<!--Ruotsinkielinen vanhan luovutusluvan teksti-->
						<xsl:when test="$sv='true' and $suostumus='false' and $luovutuslupa2024='false'">
							<fo:block margin-left="25mm" space-before="20pt" space-after="20pt" line-height="1.5">
								<fo:inline>
									<xsl:text>Jag har fått del av de uppgifter som gäller Kanta-tjänsterna och Patientdataarkivet samt fått information om hur det tillstånd för utlämnande och de förbud jag meddelat påverkar behandlingen av mina patientuppgifter.</xsl:text>
								</fo:inline>
							</fo:block>
							<fo:block margin-left="25mm" space-before="0pt" space-after="20pt" line-height="1.5">
								<fo:inline>
									<xsl:text>Jag ger tillstånd för utlämnande till att de uppgifter om mig som finns lagrade i Patientdataarkivet får lämnas ut via de riksomfattande informationssystemtjänsterna till tjänstetillhandahållare inom hälso- och sjukvården för ordnande och tillhandahållande av min personliga hälso- och sjukvård.</xsl:text>
								</fo:inline>
							</fo:block>
							<fo:block margin-left="25mm" space-before="0pt" space-after="20pt" line-height="1.5">
								<fo:inline>
									<xsl:text>Tillståndet för utlämnande omfattar alla de uppgifter om mig som finns lagrade i Patientdataarkivet och även de uppgifter som kommer att lagras där efter att jag gett tillstånd för utlämnande. Tillståndet för utlämnande gäller tills vidare.</xsl:text>
								</fo:inline>
							</fo:block>
							<fo:block margin-left="25mm" space-before="0pt" space-after="20pt" line-height="1.5">
								<fo:inline>
									<xsl:text>Om jag så önskar kan jag antingen hos en tjänstetillhandahållare inom hälso- och sjukvården eller via Mina Kanta-sidor återkalla mitt tillstånd för utlämnande.</xsl:text>
								</fo:inline>
							</fo:block>
							<fo:block margin-left="25mm" space-before="0pt" space-after="20pt" line-height="1.5">
								<fo:inline>
									<xsl:text>Om jag så önskar kan jag antingen hos en tjänstetillhandahållare inom hälso- och sjukvården eller via Mina Kanta-sidor förbjuda utlämnande av sådana uppgifter som jag särskilt specificerar.</xsl:text>
								</fo:inline>
							</fo:block>
						</xsl:when>
						<!--Ruotsinkielinen luovutusluvan 2024-version teksti-->
						<xsl:when test="$sv='true' and $luovutuslupa2024='true'">
							<fo:block margin-left="25mm" space-before="20pt" space-after="20pt" line-height="1.5">
								<fo:inline>
									<xsl:text>Jag ger personer som deltar i vården av mig tillstånd att läsa mina patientuppgifter som förts in i register hos en annan tjänstetillhandahållare inom hälso- och sjukvården.</xsl:text>
								</fo:inline>
							</fo:block>
							<fo:block margin-left="25mm" space-before="0pt" space-after="20pt" line-height="1.5">
								<fo:inline>
									<xsl:text>Tillståndet för utlämnande kan utnyttjas för att uppgifterna ska kunna röra sig både via Kanta-tjänsterna och på andra sätt, till exempel på papper.</xsl:text>
								</fo:inline>
							</fo:block>
							<fo:block margin-left="25mm" space-before="0pt" space-after="20pt" line-height="1.5">
								<fo:inline>
									<xsl:text>Tillståndet för utlämnande omfattar alla uppgifter om mig som förts in och som förs in efter det att tillståndet för utlämnande har meddelats. Tillståndet för utlämnande gäller tills vidare. Om jag så önskar kan jag återkalla mitt tillstånd för utlämnande i MittKanta eller hos en tjänstetillhandahållare inom hälso- och sjukvården. Jag kan också begränsa utlämnandet av mina uppgifter genom att förbjuda utlämnande av sådana uppgifter som jag särskilt specificerar.</xsl:text>
								</fo:inline>
							</fo:block>
						</xsl:when>
						<!--Suomenkielinen luovutusluvan 2024-version teksti-->
						<xsl:when test="$sv='false' and $luovutuslupa2024='true'">
							<fo:block margin-left="25mm" space-before="20pt" space-after="20pt" line-height="1.5">
								<fo:inline>
									<xsl:text>Annan hoitooni osallistuville henkilöille luvan katsoa potilastietojani, jotka on tallennettu toisten terveydenhuollon palvelunantajien rekistereihin.</xsl:text>
								</fo:inline>
							</fo:block>
							<fo:block margin-left="25mm" space-before="0pt" space-after="20pt" line-height="1.5">
								<fo:inline>
									<xsl:text>Luovutuslupaa voidaan hyödyntää tietojen liikkumiseen sekä Kanta-palvelujen kautta että muilla tavoilla, esimerkiksi paperilla.</xsl:text>
								</fo:inline>
							</fo:block>
							<fo:block margin-left="25mm" space-before="0pt" space-after="20pt" line-height="1.5">
								<fo:inline>
									<xsl:text>Luovutuslupa kattaa kaikki minusta tallennetut ja myös luovutusluvan antamisen jälkeen tallennettavat potilastiedot. Luovutuslupa on voimassa toistaiseksi. Voin halutessani peruuttaa antamani luovutusluvan joko OmaKannassa tai terveydenhuollon palvelunantajan luona. Voin halutessani myös rajata tietojeni luovuttamista kieltämällä erikseen määrittelemieni tietojen luovuttamisen.</xsl:text>
								</fo:inline>
							</fo:block>
						</xsl:when>														
						<!--Suomenkielinen vanhan luovutusluvan teksti -->
						<xsl:otherwise>
							<fo:block margin-left="25mm" space-before="20pt" space-after="20pt" line-height="1.5">
								<fo:inline>
									<xsl:text>Olen saanut ne tiedot, jotka koskevat Kanta-palveluja, Potilastiedon arkistoa ja antamieni luovutusluvan ja kieltojen vaikutuksia potilastietojeni käsittelyyn.</xsl:text>
								</fo:inline>
							</fo:block>
							<fo:block margin-left="25mm" space-before="0pt" space-after="20pt" line-height="1.5">
								<fo:inline>
									<xsl:text>Annan luovutusluvan siihen, että Potilastiedon arkistoon minusta tallennettuja tietoja saa luovuttaa valtakunnallisten tietojärjestelmäpalvelujen kautta terveydenhuollon palvelujen antajille henkilökohtaisen terveyden- ja sairaanhoitoni järjestämiseksi ja toteuttamiseksi.</xsl:text>
								</fo:inline>
							</fo:block>
							<fo:block margin-left="25mm" space-before="0pt" space-after="20pt" line-height="1.5">
								<fo:inline>
									<xsl:text>Luovutuslupa kattaa kaikki minusta Potilastiedon arkistoon tallennetut ja myös luovutusluvan antamisen jälkeen tallennettavat tiedot. Luovutuslupa on voimassa toistaiseksi.</xsl:text>
								</fo:inline>
							</fo:block>
							<fo:block margin-left="25mm" space-before="0pt" space-after="20pt" line-height="1.5">
								<fo:inline>
									<xsl:text>Voin halutessani peruuttaa antamani luovutusluvan joko terveydenhuollon palvelunantajan luona tai Omakannan kautta.</xsl:text>
								</fo:inline>
							</fo:block>
							<fo:block margin-left="25mm" space-before="0pt" space-after="20pt" line-height="1.5">
								<fo:inline>
									<xsl:text>Voin halutessani kieltää erikseen määrittelemieni tietojen luovuttamisen joko terveydenhuollon palvelunantajan luona tai Omakannan kautta.</xsl:text>
								</fo:inline>
							</fo:block>
						</xsl:otherwise>
					</xsl:choose>
					<fo:block/>
					<fo:block margin="0pt" space-before="1.12em" space-after="1.12em" keep-with-next.within-page="always">
						<fo:inline font-size="12pt">
							<xsl:choose>
								<xsl:when test="$sv='true'">
									<xsl:text>Patientens namn</xsl:text>
								</xsl:when>
								<xsl:otherwise>
									<xsl:text>Potilaan nimi</xsl:text>
								</xsl:otherwise>
							</xsl:choose>
						</fo:inline>
					</fo:block>
					<fo:block margin-left="25mm" space-before="1.12em" space-after="1.12em">
						<fo:inline>
							<xsl:value-of select="$XML//hl7:section[(hl7:code/@code='5' or hl7:code/@code='1.2.246.537.6.12.2002.330.5') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.330']/hl7:text"/>
						</fo:inline>
					</fo:block>
					<fo:block/>
					<xsl:if test="$representativeInvolved='true'">
						<fo:block margin="0pt" space-before="1.12em" space-after="1.12em" keep-with-next.within-page="always">
							<fo:inline font-size="12pt" keep-with-next.within-page="always">
								<xsl:choose>
									<xsl:when test="$cancellation='false'">
										<xsl:choose>
											<!--Ruotsinkielinen suostumuksen teksti-->
											<xsl:when test="$sv='true' and $suostumus='true'">
												<!--<xsl:text>Patientens lagliga företrädares personuppgifter om det är han eller hon som ger tillståndet för utlämnande</xsl:text>-->
												<xsl:text>Patientens laglig företrädare om det är han eller hon som meddelar samtycket</xsl:text>
											</xsl:when>
											<!--Suomenkielinen suostumuksen teksti-->
											<xsl:when test="$sv='false' and $suostumus='true'">
												<!--<xsl:text>Patientens lagliga företrädares personuppgifter om det är han eller hon som ger tillståndet för utlämnande</xsl:text>-->
												<xsl:text>Potilaan laillinen edustaja, jos hän toimii suostumuksen antajana</xsl:text>
											</xsl:when>
											<!--Ruotsinkielinen luovutusluvan teksti-->
											<xsl:when test="$sv='true' and $suostumus='false'">
												<!--<xsl:text>Patientens lagliga företrädares personuppgifter om det är han eller hon som ger tillståndet för utlämnande</xsl:text>-->
												<xsl:text>Patientens laglig företrädare om det är han eller hon som ger tillståndet för utlämnande</xsl:text>
											</xsl:when>
											<!--Suomenkielinen luovutusluvan teksti-->
											<xsl:otherwise>
												<!--<xsl:text>Potilaan laillisen edustajan henkilötiedot, jos hän toimii luovutusluvan antajana</xsl:text>-->
												<xsl:text>Potilaan laillinen edustaja, jos hän antaa luovutusluvan</xsl:text>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<xsl:choose>
											<!--Ruotsinkielinen suostumuksen teksti-->
											<xsl:when test="$sv='true' and $suostumus='true'">
												<!--<xsl:text>Patientens lagliga företrädares personuppgifter. Utlämnanden har getts av den lagliga företrädaren.</xsl:text>-->
												<xsl:text>Patientens laglig företrädare. Samtycket har getts av den lagliga företrädaren.</xsl:text>
											</xsl:when>
											<!--Suomenkielinen suostumuksen teksti-->
											<xsl:when test="$sv='false' and $suostumus='true'">
												<!--<xsl:text>Patientens lagliga företrädares personuppgifter. Utlämnanden har getts av den lagliga företrädaren.</xsl:text>-->
												<xsl:text>Potilaan laillinen edustaja henkilötiedot. Laillinen edustaja on toiminut suostumuksen antajana.</xsl:text>
											</xsl:when>
											<!--Ruotsinkielinen luovutusluvan teksti-->
											<xsl:when test="$sv='true' and $suostumus='false'">
												<!--<xsl:text>Patientens lagliga företrädares personuppgifter. Utlämnanden har getts av den lagliga företrädaren.</xsl:text>-->
												<xsl:text>Patientens laglig företrädare. Utlämnanden har getts av den lagliga företrädaren.</xsl:text>
											</xsl:when>
											<!--Suomenkielinen luovutusluvan teksti-->
											<xsl:otherwise>
												<!--<xsl:text>Potilaan laillisen edustajan henkilötiedot. Laillinen edustaja on toiminut luovutusluvan antajana.</xsl:text>-->
												<xsl:text>Potilaan laillinen edustaja. Laillinen edustaja on antanut luovutusluvan.</xsl:text>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>
							</fo:inline>
						</fo:block>
						<fo:block margin-left="25mm" space-before="1.12em" space-after="1.12em" line-height="1.5">
							<fo:inline>
								<!--Sama tekstisisältö sekä suostumuksella että luovutusluvalla-->
								<xsl:choose>
									<xsl:when test="$sv='true'">
										<xsl:text>En laglig företrädare kan till exempel vara ett minderårigt barns vårdnadshavare eller en intressebevakare som utsetts att sköta ärenden som gäller patientens hälsa.</xsl:text>
									</xsl:when>
									<xsl:otherwise>
										<xsl:text>Laillinen edustaja voi olla esimerkiksi alaikäisen lapsen huoltaja tai edunvalvoja, jonka tehtäväksi on määrätty potilaan terveyttä koskevien asioiden hoitaminen.</xsl:text>
									</xsl:otherwise>
								</xsl:choose>
							</fo:inline>
						</fo:block>
						<fo:block margin-left="25mm" space-before="1.12em" space-after="1.12em">
							<fo:inline>
								<xsl:value-of select="$XML//hl7:section[(hl7:code/@code='9' or hl7:code/@code='1.2.246.537.6.12.2002.330.9') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.330']/hl7:text"/>
							</fo:inline>
						</fo:block>
						<fo:block/>
					</xsl:if>
					<fo:block margin="0pt" space-before="1.12em" space-after="1.12em" keep-with-next.within-page="always">
						<fo:inline font-size="12pt">
							<xsl:choose>
								<xsl:when test="$cancellation='true'">
									<xsl:choose>
										<!--Ruotsinkielinen suostumuksen teksti-->
										<xsl:when test="$sv='true' and $suostumus='true'">
											<xsl:text>Gällande samtycke</xsl:text>
										</xsl:when>
										<!--Suomenkielinen suostumuksen teksti-->
										<xsl:when test="$sv='false' and $suostumus='true'">
											<xsl:text>Voimassaoleva suostumus</xsl:text>
										</xsl:when>
										<!--Ruotsinkielinen luovutusluvan teksti-->
										<xsl:when test="$sv='true' and $suostumus='false'">
											<xsl:text>Gällande tillstånd för utlämnande</xsl:text>
										</xsl:when>
										<!--Suomenkielinen luovutusluvan teksti-->
										<xsl:otherwise>
											<xsl:text>Voimassaoleva luovutuslupa</xsl:text>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<!--Ruotsinkielinen suostumuksen teksti-->
										<xsl:when test="$sv='true' and $suostumus='true'">
											<xsl:text>Den som ger samtycket</xsl:text>
										</xsl:when>
										<!--Suomenkielinen suostumuksen teksti-->
										<xsl:when test="$sv='false' and $suostumus='true'">
											<xsl:text>Suostumuksen antaja</xsl:text>
										</xsl:when>
										<!--Ruotsinkielinen luovutusluvan teksti-->
										<xsl:when test="$sv='true' and $suostumus='false'">
											<xsl:text>Den som ger tillståndet för utlämnande</xsl:text>
										</xsl:when>
										<!--Suomenkielinen luovutusluvan teksti-->
										<xsl:otherwise>
											<xsl:text>Luovutusluvan antaja</xsl:text>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</fo:inline>
					</fo:block>
					<!--Jos lomakkeella on tieto siitä, että avustaja avustanut allekirjoittamisessa, näytetään luovutusluvan antajana potilas. Allekirjoittamisen tietoja ei enää näytetä.-->
					<xsl:variable name="cannotSignOptIn" select="$XML//hl7:section[(hl7:code/@code='11' or hl7:code/@code='1.2.246.537.6.12.2002.330.11') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.330']/hl7:entry/hl7:observation/hl7:value/@value"/>
					<xsl:choose>
						<xsl:when test="$cannotSignOptIn='true'">
							<fo:block margin-left="25mm" space-before="1.12em" space-after="1.12em">
								<fo:inline>
									<xsl:value-of select="$XML//hl7:section[(hl7:code/@code='5' or hl7:code/@code='1.2.246.537.6.12.2002.330.5') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.330']/hl7:text"/>
									<xsl:text>&#160;&#160;&#160;</xsl:text>
								</fo:inline>
								<fo:inline>
									<xsl:for-each select="$XML//hl7:section[(hl7:code/@code='15' or hl7:code/@code='1.2.246.537.6.12.2002.330.15') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.330']/hl7:entry/hl7:observation/hl7:value">
										<xsl:call-template name="formatdatetime">
											<xsl:with-param name="datetime" select="@value"/>
											<xsl:with-param name="skipsec" select="true"/>
										</xsl:call-template>
									</xsl:for-each>
								</fo:inline>
							</fo:block>
						</xsl:when>
						<xsl:otherwise>
							<fo:block margin-left="25mm" space-before="1.12em" space-after="1.12em">
								<fo:inline>
									<xsl:value-of select="$XML//hl7:section[(hl7:code/@code='14' or hl7:code/@code='1.2.246.537.6.12.2002.330.14') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.330']/hl7:text"/>
								</fo:inline>
								<fo:inline>
									<xsl:text>&#160;&#160;&#160;</xsl:text>
									<xsl:for-each select="$XML//hl7:section[(hl7:code/@code='15' or hl7:code/@code='1.2.246.537.6.12.2002.330.15') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.330']/hl7:entry/hl7:observation/hl7:value">
										<xsl:call-template name="formatdatetime">
											<xsl:with-param name="datetime" select="@value"/>
											<xsl:with-param name="skipsec" select="true"/>
										</xsl:call-template>
									</xsl:for-each>
								</fo:inline>
							</fo:block>
						</xsl:otherwise>
					</xsl:choose>
					<fo:block/>
					<xsl:if test="$cancellation='true'">
						<fo:block margin="0pt" space-before="1.12em" space-after="1.12em" keep-with-next.within-page="always">
							<fo:inline font-size="12pt">
								<xsl:choose>
									<!--Ruotsinkielinen suostumuksen teksti-->
									<xsl:when test="$sv='true' and $suostumus='true'">
										<xsl:text>Återkallelse av samtycke</xsl:text>
									</xsl:when>
									<!--Suomenkielinen suostumuksen teksti-->
									<xsl:when test="$sv='false' and $suostumus='true'">
										<xsl:text>Suostumuksen peruuttaminen</xsl:text>
									</xsl:when>
									<!--Ruotsinkielinen luovutusluvan teksti-->
									<xsl:when test="$sv='true' and $suostumus='false'">
										<xsl:text>Återkallande av tillstånd för utlämnande</xsl:text>
									</xsl:when>
									<xsl:otherwise>
										<xsl:text>Luovutusluvan peruuttaminen</xsl:text>
									</xsl:otherwise>
								</xsl:choose>
							</fo:inline>
						</fo:block>
						<fo:block margin-left="25mm" space-before="0pt" space-after="20pt" line-height="1.5">
							<fo:inline>
								<xsl:choose>
									<!--Ruotsinkielinen suostumuksen teksti-->
									<xsl:when test="$sv='true' and $suostumus='true'">
										<xsl:text>Jag återkallar det samtycke som jag har gett ovan, enligt vilket de uppgifter om mig som har lagrats i Patientdataarkivet har fått lämnas ut för ordnande och tillhandahållande av min personliga hälso- och sjukvård. </xsl:text>
									</xsl:when>
									<!--Suomenkielinen suostumuksen teksti-->
									<xsl:when test="$sv='false' and $suostumus='true'">
										<xsl:text>Peruutan edellä olevan suostumuksen, jonka perusteella Potilastiedon arkistoon tallennettuja tietojani on saanut luovuttaa henkilökohtaisen terveyden- ja sairaanhoitoni järjestämiseksi ja toteuttamiseksi. </xsl:text>
									</xsl:when>
									<!--Ruotsinkielinen luovutusluvan teksti-->
									<xsl:when test="$sv='true' and $suostumus='false'">
										<xsl:text>Jag återkallar det tillstånd för utlämnande som jag har gett ovan, enligt vilket de uppgifter om mig som finns lagrade i Patientdataarkivet har fått lämnas ut för ordnande och tillhandahållande av min personliga hälso- och sjukvård.</xsl:text>
									</xsl:when>
									<xsl:otherwise>
										<xsl:text>Peruutan edellä olevan luovutusluvan, jonka perusteella Potilastiedon arkistoon tallennettuja tietojani on saanut luovuttaa henkilökohtaisen terveyden- ja sairaanhoitoni järjestämiseksi ja toteuttamiseksi.</xsl:text>
									</xsl:otherwise>
								</xsl:choose>
							</fo:inline>
						</fo:block>
						<fo:block margin="0pt" space-before="1.12em" space-after="1.12em" keep-with-next.within-page="always">
							<fo:inline font-size="12pt">
								<xsl:choose>
									<!--Ruotsinkielinen suostumuksen teksti-->
									<xsl:when test="$sv='true' and $suostumus='true'">
										<xsl:text>Den som återkallar samtycket</xsl:text>
									</xsl:when>
									<!--Suomenkielinen suostumuksen teksti-->
									<xsl:when test="$sv='false' and $suostumus='true'">
										<xsl:text>Suostumuksen peruuttaja</xsl:text>
									</xsl:when>
									<!--Ruotsinkielinen luovutusluvan teksti-->
									<xsl:when test="$sv='true' and $suostumus='false'">
										<xsl:text>Den som återkallar tillståndet för utlämnande</xsl:text>
									</xsl:when>
									<!--Suomenkielinen luovutusluvan teksti-->
									<xsl:otherwise>
										<xsl:text>Luovutusluvan peruuttaja</xsl:text>
									</xsl:otherwise>
								</xsl:choose>
							</fo:inline>
						</fo:block>
						<fo:block/>
						<fo:block margin-left="25mm" space-before="0pt" space-after="20pt">
							<!--Jos lomakkeella on tieto siitä, että avustaja avustanut allekirjoittamisessa, näytetään luovutusluvan peruuttajana potilas. Allekirjoittamisen tietoja ei enää näytetä.-->
							<xsl:variable name="cannotSignOptInCancellation" select="$XML//hl7:section[(hl7:code/@code='18' or hl7:code/@code='1.2.246.537.6.12.2002.330.18') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.330']//hl7:entry/hl7:observation/hl7:value/@value"/>
							<xsl:choose>
								<xsl:when test="$cannotSignOptInCancellation='true'">
									<fo:inline>
										<xsl:value-of select="$XML//hl7:section[(hl7:code/@code='5' or hl7:code/@code='1.2.246.537.6.12.2002.330.5') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.330']/hl7:text"/>
									</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<fo:inline>
										<xsl:value-of select="$XML//hl7:section[(hl7:code/@code='21' or hl7:code/@code='1.2.246.537.6.12.2002.330.21') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.330']/hl7:text"/>
									</fo:inline>
								</xsl:otherwise>
							</xsl:choose>
							<fo:inline>
								<xsl:text>&#160;&#160;&#160;</xsl:text>
								<xsl:for-each select="$XML//hl7:section[(hl7:code/@code='22' or hl7:code/@code='1.2.246.537.6.12.2002.330.22') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.330']/hl7:entry/hl7:observation/hl7:value">
									<xsl:call-template name="formatdatetime">
										<xsl:with-param name="datetime" select="@value"/>
										<xsl:with-param name="skipsec" select="true"/>
									</xsl:call-template>
								</xsl:for-each>
							</fo:inline>
						</fo:block>
						<fo:block/>
					</xsl:if>
					<fo:block margin="0pt" space-before="1.12em" space-after="1.12em" keep-with-next.within-page="always">
						<fo:inline font-size="12pt">
							<xsl:choose>
								<!--Ruotsinkielinen suostumuksen teksti-->
								<xsl:when test="$sv='true' and $suostumus='true'">
									<xsl:text>Handlingen lagrades av</xsl:text>
								</xsl:when>
								<!--Ruotsinkielinen luovutusluvan teksti-->
								<xsl:when test="$sv='true' and $suostumus='false'">
									<xsl:text>Handlingen sparades av</xsl:text>
								</xsl:when>
								<!--Suomenkielinen teksti sama luovutusluvassa ja suostuksessa						-->
								<xsl:otherwise>
									<xsl:text>Asiakirjan tallentaja</xsl:text>
								</xsl:otherwise>
							</xsl:choose>
						</fo:inline>
					</fo:block>
					<fo:block margin-left="25mm" space-before="1.12em" space-after="1.12em">
						<fo:inline>
							<xsl:value-of select="$XML//hl7:section[(hl7:code/@code='24' or hl7:code/@code='1.2.246.537.6.12.2002.330.24') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.330']/hl7:text"/>
						</fo:inline>
						<fo:inline id="SV_RefID_PageTotal"/>
					</fo:block>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="formatdatetime">
		<xsl:param name="datetime"/>
		<xsl:param name="skiptime"/>
		<!-- skips time if value is not empty -->
		<xsl:param name="skipsec"/>
		<!-- skips seconds if value is not empty -->
		<!-- pp-->
		<xsl:if test='substring ($datetime, 7, 2)!=""'>
			<xsl:choose>
				<xsl:when test="substring($datetime,7,1)!='0'">
					<xsl:value-of select="substring ($datetime,7, 2)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="substring ($datetime,8, 1)"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:text>.</xsl:text>
		</xsl:if>
		<!-- kk-->
		<xsl:if test='substring ($datetime, 5, 2)!=""'>
			<xsl:choose>
				<xsl:when test="substring($datetime,5,1)!='0'">
					<xsl:value-of select="substring ($datetime,5, 2)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="substring ($datetime,6, 1)"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:text>.</xsl:text>
		</xsl:if>
		<!-- vvvv-->
		<xsl:value-of select="substring ($datetime, 1, 4)"/>
		<xsl:if test="$skiptime=''">
			<xsl:if test='substring ($datetime, 9, 2)!=""'>
				<xsl:text>&#160;</xsl:text>
				<!-- hh-->
				<xsl:choose>
					<xsl:when test="substring($datetime,9,1)!='0'">
						<xsl:value-of select="substring ($datetime,9, 2)"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="substring ($datetime,10, 1)"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<!-- mm -->
			<xsl:if test='substring ($datetime, 11, 2)!=""'>
				<xsl:text>.</xsl:text>
				<xsl:value-of select="substring ($datetime,11, 2)"/>
			</xsl:if>
			<!-- ss -->
			<xsl:if test='substring ($datetime, 13, 2)!="" and $skipsec=""'>
				<xsl:text>.</xsl:text>
				<xsl:value-of select="substring ($datetime,13, 2)"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template name="pages">
		<fo:block>
			<fo:page-number/> (<fo:page-number-citation ref-id="SV_RefID_PageTotal"/>)</fo:block>
	</xsl:template>
	<msxml:script xmlns:msxml="urn:schemas-microsoft-com:xslt" language="JavaScript" implements-prefix="kela">
		function currentDate(){
			var date = new Date();
			return date.getDate() + '.' + [date.getMonth() + 1] + "." + date.getYear();
		};
	</msxml:script>
</xsl:stylesheet>
