<?xml version="1.0" encoding="UTF-8"?>
<!--Muunnostiedosto Kielto-lomakkeen tulostamista varten
Muutokset tulosteen muodostamisperiaatteisiin 11/2021:
- Kela-logo poistettu, Kanta-logo päivitetty
- Sivun asettelu muutettu Kanta-asiakirjapohjia mukailevaksi
- Ylätunnisteeseen lisätty potilaan nimi
- Alatunnisteesta ylätunnisteeseen siirretty sivunumero sekä tulosajankohta
- Alatunnisteesta poistettu lomakkeen omistajan määrittelyversio
- Tekstiotsikot siirretty header-osasta body-osaan
- Tulosteesta poistettu henkilötunnukset ja henkilötietojen taulukot
- Otsikointia muutettu 
- Poistettu allekirjoituksessa avustaneen tietojen lohko 
- Nimitietoihin otetaan näyttömuodosta kaikki nimet
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:hl7="urn:hl7-org:v3" xmlns:hl7fi="urn:hl7finland" xmlns:java="http://xml.apache.org/xslt/java" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:kela="urn:kela">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<!-- Locations of image files -->
	<!-- Path, must end with \ (windows) or / (unix) -->
	<xsl:variable name="imagesPath" select="''"/>
	<xsl:variable name="kantaLogoFI" select="concat($imagesPath,'kanta_logotype_RGB.png')"/>
	<!-- ################# -->
	<xsl:variable name="XML" select="/"/>
	<!-- på svenska? -->
	<xsl:variable name="sv">
		<xsl:choose>
			<xsl:when test="string($XML/hl7:ClinicalDocument/hl7:languageCode/@code)='sv'">
				<xsl:value-of select="true()"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="false()"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:template match="/">
		<fo:root font-size="10pt">
			<fo:layout-master-set>
				<fo:simple-page-master master-name="page-master-174104000" margin-left="0.78in" margin-right="0.78in" page-height="11.69in" page-width="8.27in" margin-top="0.39in" margin-bottom="0.39in">
					<fo:region-body margin-top="1.38in" margin-bottom="0.59in" column-count="1" column-gap="0.50in"/>
					<fo:region-before region-name="page-header" extent="1.38in"/>
					<fo:region-after region-name="page-footer" extent="0.59in"/>
				</fo:simple-page-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="page-master-174104000" initial-page-number="auto" force-page-count="no-force">
				<fo:static-content flow-name="page-header">
					<fo:block margin="0pt">
						<fo:table table-layout="fixed" width="100%">
							<fo:table-column column-width="90mm"/>
							<fo:table-column column-width="proportional-column-width(1)"/>
							<fo:table-column column-width="20mm"/>
							<fo:table-body start-indent="0pt" line-height="10pt">
								<fo:table-row height="28pt">
									<fo:table-cell display-align="center">
										<fo:block text-align="left">
											<fo:external-graphic content-height="8.4mm" scaling="uniform" src="{$kantaLogoFI}"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell display-align="center">
										<fo:block text-align="left">
											<fo:inline>												
													<xsl:choose>
															<xsl:when test="$sv='true'">
																<xsl:text>FÖRBUD MOT ATT LÄMNA UT UPPGIFTER/ÅTERKALLANDE AV FÖRBUDET</xsl:text>
															</xsl:when>
															<xsl:otherwise>
																<xsl:text>TIETOJEN LUOVUTUSKIELTO/LUOVUTUSKIELLON PERUMINEN </xsl:text>
															</xsl:otherwise>
														</xsl:choose>													
											</fo:inline>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell display-align="center">
										<fo:block text-align="right">
											<xsl:call-template name="pages"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row height="36pt">
									<fo:table-cell padding="2pt" display-align="center">
										<fo:block text-align="left">
											<fo:inline>
												<xsl:value-of select="$XML//hl7:section[(hl7:code/@code='16' or hl7:code/@code='1.2.246.537.6.12.2002.370.16') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']/hl7:text"/>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell padding="2pt" display-align="center">
										<fo:block text-align="left">
											<fo:inline>
												<xsl:choose>
													<xsl:when test="system-property('xsl:vendor-url')='http://www.microsoft.com' or system-property('xsl:vendor-url')='http://www.altova.com'">
														<xsl:value-of select="kela:currentDate()"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="java:format(java:java.text.SimpleDateFormat.new('dd.MM.yyyy'), java:java.util.Date.new())"/>
													</xsl:otherwise>
												</xsl:choose>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:block>
				</fo:static-content>
				<fo:static-content flow-name="page-footer">
					<fo:block-container height="0.49in" overflow="hidden" display-align="after">
						<fo:block>
							<fo:table width="100%" table-layout="fixed" border-spacing="2pt">
								<fo:table-column column-width="proportional-column-width(1)"/>
								<fo:table-body start-indent="0pt">
									<fo:table-row>
										<fo:table-cell font-size="10pt" padding="0" display-align="center">
											<!-- Kieltoasiakirjan tunnus-->
											<fo:block text-align="center">
												<fo:inline>
													<xsl:value-of select="$XML//hl7:section[(hl7:code/@code='30' or hl7:code/@code='1.2.246.537.6.12.2002.370.30') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']/hl7:text"/>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
						</fo:block>
					</fo:block-container>
				</fo:static-content>
				<fo:flow flow-name="xsl-region-body">
					<fo:block text-align="left" margin-left="0mm">
						<fo:inline font-size="16pt">						
								<xsl:choose>
										<xsl:when test="$sv='true'">
											<xsl:text>FÖRBUD MOT ATT LÄMNA UT UPPGIFTER/ÅTERKALLANDE AV FÖRBUDET</xsl:text>
										</xsl:when>
										<xsl:otherwise>
											<xsl:text>TIETOJEN LUOVUTUSKIELTO/LUOVUTUSKIELLON PERUMINEN</xsl:text>
										</xsl:otherwise>
									</xsl:choose>								
						</fo:inline>
						<fo:block space-after="20pt"/>
						<xsl:choose>
							<xsl:when test="$sv='true'">
								<fo:inline font-size="14pt">
									<xsl:text>Utlämnande av uppgifter som lagrats i Receptcentret </xsl:text>
								</fo:inline>
							</xsl:when>
							<xsl:otherwise>
								<fo:inline font-size="14pt">
									<xsl:text>Reseptikeskukseen tallennettujen tietojen luovuttaminen </xsl:text>
								</fo:inline>
							</xsl:otherwise>
						</xsl:choose>
						<fo:block/>
					</fo:block>
				
					<fo:block>
						<xsl:choose>
							<xsl:when test="$sv='true'">
								<fo:block margin-left="25mm" space-before="20pt" space-after="10pt" line-height="1.5">
									<fo:inline>
										<xsl:text>Jag har tagit del av informationen om Kanta-tjänsterna och om hur förbud mot att lämna ut uppgifter påverkar behandlingen av mina receptuppgifter. Jag förstår att när jag har meddelat ett förbud mot utlämnande av uppgifter betyder det att de uppgifter som omfattas av förbudet inte får användas inom hälso- och sjukvården, om jag inte separat har tillåtit att uppgifterna lämnas ut i en nödsituation. Utan mitt samtycke kan uppgifterna inte användas ens i sådana situationer där jag på grund av en livshotande akut sjukdom eller skada är medvetslös och därför oförmögen att återkalla det förbud som jag meddelat. I samband med att jag köper ett läkemedel som omfattas av förbud mot utlämnande måste jag på apoteket visa upp en patientanvisning eller en utskriven sammanställning som gäller det recept som jag har förbjudit. </xsl:text>
									</fo:inline>
								</fo:block>
								<fo:block margin-left="25mm" space-before="20pt" space-after="10pt" line-height="1.5">
									<fo:inline>
										<xsl:text>Oberoende av att ett recept omfattas av förbud mot utlämnande av uppgifter </xsl:text>
									</fo:inline>
								</fo:block>
								<fo:block margin-left="39mm" space-before="10pt" space-after="10pt" line-height="1.5">
									<fo:inline>
										<xsl:text>•&#xA0;&#xA0;visas uppgifter om alla HCI-läkemedel och narkotiska läkemedel som jag har blivit ordinerad samt expedieringsuppgifterna om dem, i sådana fall då en läkare tänker skriva ut ett recept på HCI-läkemedel eller narkotiska läkemedel till mig (HCI-läkemedel är ett läkemedel som huvudsakligen inverkar på det centrala nervsystemet),</xsl:text>
									</fo:inline>
								</fo:block>
								<fo:block margin-left="39mm" space-before="10pt" space-after="10pt" line-height="1.5">
									<fo:inline>
										 <xsl:text>•&#xA0;&#xA0;lämnas till en verksamhetsenhet för hälso- och sjukvård eller socialvård eller till en läkemedelsföreskrivare uppgifter om de recept som jag har bett att få förnyade  </xsl:text> 
									</fo:inline>
								</fo:block>
								<fo:block margin-left="39mm" space-before="10pt" space-after="10pt" line-height="1.5">
									<fo:inline>
										 <xsl:text>•&#xA0;&#xA0;lämnas till en läkemedelsförskrivare och till den tjänstetillhandahållare som sparat receptet under den tid en vårdrelation pågår, uppgifter om alla mina recept och expedieringsuppgifterna om dem </xsl:text>
									</fo:inline>
								</fo:block>
								<fo:block margin-left="39mm" space-before="10pt" space-after="10pt" line-height="1.5">
									<fo:inline>
										 <xsl:text>•&#xA0;&#xA0;lämnas till en läkemedelsförskrivare uppgifter om de pappers- och telefonrecept som apoteket lagrat i Receptcentret och för vilka han eller hon har antecknats som förskrivare, samt de expedieringsuppgifter som gäller dessa recept </xsl:text>
										 </fo:inline>
								</fo:block>
								<fo:block margin-left="39mm" space-before="10pt" space-after="10pt" line-height="1.5">
										<fo:inline>
										  <xsl:text>•&#xA0;&#xA0;vid störningar och problemsituationer i datasystemen visas uppgifter för den tekniska personalen hos tillhandahållare av hälso- och sjukvårdstjänster, Folkpensionsanstal-ten eller informationssystemets leverantör i den omfattning som krävs för att störning-arna ska kunna åtgärdas, </xsl:text>
										</fo:inline>
								</fo:block>
								<fo:block margin-left="39mm" space-before="10pt" space-after="20pt" line-height="1.5">
									<fo:inline>
										  <xsl:text>•&#xA0;&#xA0;för utredningar i anslutning till ett tillsynsärende visas uppgifter om handlingar som tjänstetillhandahållaren sparat i Receptcentret samt deras expedieringsuppgifter för tjänstetillhandahållare inom hälso- och sjukvården eller socialvården. </xsl:text>
									</fo:inline>
								</fo:block>
								<fo:block margin-left="25mm" space-before="20pt" space-after="10pt" line-height="1.5">
									<fo:inline>
										<xsl:text>Förbuden mot att lämna ut uppgifter gäller tills vidare. Om jag så önskar kan jag via e-tjänsten Mina Kanta-sidor återkalla ett förbud mot att lämna ut uppgifter, eller meddela nya förbud. De uppgifter om mig som har lagrats i Receptcentret lämnas tjänstetillhandahållare inom hälso- och sjukvården eller till apotek eller till läkemedelsförskrivare när det gäller de recept för vilka jag har meddelat förbud mot utlämnande av uppgifter.</xsl:text>
									</fo:inline>
								</fo:block>
							</xsl:when>
							<xsl:otherwise>
								<fo:block margin-left="25mm" space-before="20pt" space-after="20pt" line-height="1.5">
									<fo:inline>
										<xsl:text>Olen saanut Kanta-palveluita koskevat tiedot ja tiedon luovutuskieltojen vaikutuksista lääkemääräystietojeni käsittelyyn. </xsl:text> 
									</fo:inline>
								</fo:block>
								<fo:block margin-left="25mm" space-before="20pt" space-after="20pt" line-height="1.5">
									<fo:inline>
										<xsl:text>Ymmärrän, että tehtyäni luovutuskiellon, luovutuskieltojen alaiset tiedot eivät ole käytettävissä terveydenhuollossa, ellen ole erikseen antanut suostumustani tietojen luovuttamiseen hätätilanteessa. Ilman suostumustani tietoja ei voi käyttää edes siinä tapauksessa, että olisin äkillisen henkeä uhkaavan sairauden tai loukkaantumisen vuoksi tajuton, enkä sen vuoksi kykenisi peruuttamaan tekemääni kieltoa. Luovutuskiellon kohteena olevan lääkkeen oston yhteydessä minun tulee esittää apteekissa kieltämästäni lääkemääräyksestä potilasohje tai tulostettu yhteenveto. </xsl:text>
									</fo:inline>
								</fo:block>
								<fo:block margin-left="25mm" space-before="20pt" space-after="10pt" line-height="1.5">
									<fo:inline>
										<xsl:text>Lääkemääräykseen kohdistetusta luovutuskiellosta huolimatta näytetään </xsl:text>
									</fo:inline>
								</fo:block>
								<fo:block margin-left="39mm" space-before="10pt" space-after="10pt" line-height="1.5">
									<fo:inline>
										<xsl:text>•&#xA0;&#xA0;tiedot kaikista minulle määrätyistä PKV- ja huumausainelääkkeistä ja niiden toimitustiedoista silloin, kun lääkäri on kirjoittamassa minulle PKV- tai huumausainelääkemääräystä (PKV-lääke on pääasiallisesti keskushermostoon vaikuttava lääke), </xsl:text>
									</fo:inline>
								</fo:block>
								<fo:block margin-left="39mm" space-before="10pt" space-after="10pt" line-height="1.5">
									<fo:inline>
										 <xsl:text>•&#xA0;&#xA0;terveydenhuollon tai sosiaalihuollon toimintayksikölle tai lääkkeen määrääjälle tiedot uudistettavaksi pyytämistäni resepteistä, </xsl:text> 
									</fo:inline>
								</fo:block>
								<fo:block margin-left="39mm" space-before="10pt" space-after="10pt" line-height="1.5">
									<fo:inline>
										 <xsl:text>•&#xA0;&#xA0;lääkkeen määrääjälle ja lääkemääräyksen tallentaneelle palvelunantajalle hoitosuhteen jatkuessa tiedot kaikista lääkemääräyksistäni ja niiden toimitustiedoista, </xsl:text>
									</fo:inline>
								</fo:block>
								<fo:block margin-left="39mm" space-before="10pt" space-after="10pt" line-height="1.5">
									<fo:inline>
										 <xsl:text>•&#xA0;&#xA0;lääkkeen määrääjälle tiedot niistä apteekin Reseptikeskukseen tallentamista paperi- ja puhelinlääkemääräyksistä, joihin hänet on merkitty lääkkeen määrääjäksi, sekä näiden lääkemääräyksien toimitustiedoista, </xsl:text>
										 </fo:inline>
								</fo:block>
								<fo:block margin-left="39mm" space-before="10pt" space-after="10pt" line-height="1.5">
										<fo:inline>
										  <xsl:text>•&#xA0;&#xA0;tietojärjestelmien häiriö- ja virhetilanteissa terveydenhuollon palvelujen antajan, Kansaneläkelaitoksen tai tietojärjestelmän toimittajan tekniselle henkilöstölle tiedot siinä laajuudessa, kuin häiriötilanteen selvittely edellyttää, </xsl:text>
										</fo:inline>
								</fo:block>
								<fo:block margin-left="39mm" space-before="10pt" space-after="20pt" line-height="1.5">
									<fo:inline>
										  <xsl:text>•&#xA0;&#xA0;valvonta-asiaan liittyviä selvityksiä varten terveydenhuollon tai sosiaalihuollon palvelunantajalle tiedot palvelunantajan Reseptikeskukseen tallentamista asiakirjoista ja niiden toimitustiedoista. </xsl:text>
									</fo:inline>
								</fo:block>
								<fo:block margin-left="25mm" space-before="20pt" space-after="10pt" line-height="1.5">
									<fo:inline>
										<xsl:text>Tietojen luovutuskiellot ovat voimassa toistaiseksi. Voin halutessani peruuttaa tekemäni luovutuskiellon tai tehdä uusia kieltoja Omakanta-palvelun kautta. Reseptikeskukseen minusta tallennettuja tietoja ei luovuteta terveydenhuollon ja sosiaalihuollon palvelunantajille, apteekeille ja lääkkeenmäärääjille niistä lääkemääräyksistä, joista olen tehnyt luovutuskiellon.</xsl:text>
									</fo:inline>
								</fo:block>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Kieltojen tulostus alkaa -->
						<xsl:variable name="noOptOuts" select="$XML//hl7:section[(hl7:code/@code='5' or hl7:code/@code='1.2.246.537.6.12.2002.370.5') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']/hl7:entry/hl7:observation/hl7:value/@value"/>
						<fo:block margin="0pt" space-before="1.12em" space-after="1.12em" keep-with-next.within-page="always">
							<fo:inline font-size="12pt">
								<xsl:choose>
									<xsl:when test="$sv='true'">
										<xsl:text>Gällande förbud som avser recept</xsl:text>
									</xsl:when>
									<xsl:otherwise>
										<xsl:text>Voimassa olevat lääkemääräystietojen luovutuskiellot</xsl:text>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:if test="string($noOptOuts)='true'">
									<xsl:choose>
										<xsl:when test="$sv='true'">
											<xsl:text>: Patienten har inga gällande förbud mot att lämna ut receptuppgifter </xsl:text>
										</xsl:when>
										<xsl:otherwise>
											<xsl:text>: Potilaalla ei ole voimassa olevia lääkemääräystietojen luovutuskieltoja</xsl:text>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:if>
							</fo:inline>
						</fo:block>
						<xsl:choose>
							<xsl:when test="string($noOptOuts)='true'">
								</xsl:when>
							<xsl:otherwise>
								<fo:block margin="0pt" space-before="1.12em" space-after="1.12em" keep-with-next.within-page="always">
									<fo:inline font-size="12pt">
										<xsl:choose>
											<xsl:when test="$sv='true'">
												<xsl:text>Elektroniskt recept, som det är förbjudet att lämna ut uppgifter om </xsl:text>
											</xsl:when>
											<xsl:otherwise>
												<xsl:text>Sähköinen lääkemääräys, jonka tietojen luovuttaminen on kielletty </xsl:text>
											</xsl:otherwise>
										</xsl:choose>
									</fo:inline>
								</fo:block>
								<fo:block margin-left="25mm" space-before="1.12em" space-after="1.12em">
									<xsl:for-each select="$XML//hl7:section[(hl7:code/@code='7' or hl7:code/@code='1.2.246.537.6.12.2002.370.7') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']">
										<fo:inline>
											<xsl:choose>
												<xsl:when test="$sv='true'">
													<xsl:text>Förskrivningsdatum för läkemedlet: </xsl:text>
												</xsl:when>
												<xsl:otherwise>
													<xsl:text>Lääkkeen määräyspäivä: </xsl:text>
												</xsl:otherwise>
											</xsl:choose>
										</fo:inline>
										<fo:inline>
											<xsl:for-each select="hl7:component/hl7:section[(hl7:code/@code='12' or hl7:code/@code='1.2.246.537.6.12.2002.370.12') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']/hl7:entry/hl7:observation/hl7:value">
												<xsl:call-template name="formatdatetime">
													<xsl:with-param name="datetime" select="./@value"/>
													<xsl:with-param name="skiptime" select="true"/>
												</xsl:call-template>
											</xsl:for-each>
										</fo:inline>
										<fo:block/>
										<fo:inline>
											<xsl:choose>
												<xsl:when test="$sv='true'">
													<xsl:text>Namnet på den yrkesutbildade person som förskrivit läkemedlet: </xsl:text>
												</xsl:when>
												<xsl:otherwise>
													<xsl:text>Lääkkeen määrännyt ammattihenkilö: </xsl:text>
												</xsl:otherwise>
											</xsl:choose>
										</fo:inline>
										<fo:inline>
											<xsl:for-each select="hl7:component/hl7:section[(hl7:code/@code='11' or hl7:code/@code='1.2.246.537.6.12.2002.370.11') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']/hl7:text">
												<xsl:value-of select="."/>
												<xsl:text> </xsl:text>
											</xsl:for-each>
										</fo:inline>
										<fo:block/>
										<fo:inline>
											<xsl:choose>
												<xsl:when test="$sv='true'">
													<xsl:text>Namnet på preparat: </xsl:text>
												</xsl:when>
												<xsl:otherwise>
													<xsl:text>Valmisteen nimi: </xsl:text>
												</xsl:otherwise>
											</xsl:choose>
										</fo:inline>
										<fo:inline>
										<xsl:for-each select="hl7:component/hl7:section[(hl7:code/@code='9' or hl7:code/@code='1.2.246.537.6.12.2002.370.9') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']/hl7:text">
											<xsl:value-of select="."/>
										</xsl:for-each>
										</fo:inline>
										<fo:block margin="0pt" space-after="1.12em" keep-with-next.within-page="always"/>
									</xsl:for-each>
									<!--</fo:block>-->
								</fo:block>
								<fo:block margin="0pt" space-before="1.12em" space-after="1.12em" keep-with-next.within-page="always">
									<fo:inline font-size="12pt">
										<xsl:choose>
											<xsl:when test="$sv='true'">
												<xsl:text>Utlämnande av uppgifter i en nödsituation</xsl:text>
											</xsl:when>
											<xsl:otherwise>
												<xsl:text>Luovuttaminen hätätilanteessa</xsl:text>
											</xsl:otherwise>
										</xsl:choose>
									</fo:inline>
								</fo:block>
								<fo:block margin-left="25mm" space-before="1.12em" space-after="1.12em">
									<fo:inline>
										<xsl:choose>
											<xsl:when test="$sv='true'">
												<xsl:text>Uppgifter om recept kan lämnas ut i en nödsituation: </xsl:text>
											</xsl:when>
											<xsl:otherwise>
												<xsl:text>Lääkemääräyksien tiedot voidaan luovuttaa hätätilanteessa: </xsl:text>
											</xsl:otherwise>
										</xsl:choose>
									</fo:inline>
									<xsl:variable name="emergency" select="$XML//hl7:section[(hl7:code/@code='6' or hl7:code/@code='1.2.246.537.6.12.2002.370.6') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']/hl7:entry/hl7:observation/hl7:value/@value">
										</xsl:variable>
									<fo:inline>
										<xsl:choose>
											<xsl:when test="string($emergency)='true'">
												<xsl:choose>
													<xsl:when test="$sv='true'">
														<xsl:text>( x ) Ja (   ) Nej</xsl:text>
													</xsl:when>
													<xsl:otherwise>
														<xsl:text>( x ) Kyllä (   ) Ei</xsl:text>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:when>
											<xsl:otherwise>
												<xsl:choose>
													<xsl:when test="$sv='true'">
														<xsl:text>(   ) Ja ( x ) Nej</xsl:text>
													</xsl:when>
													<xsl:otherwise>
														<xsl:text>(   ) Kyllä ( x ) Ei</xsl:text>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:otherwise>
										</xsl:choose>
									</fo:inline>
								</fo:block>
								<fo:block/>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Kieltojen tulostus loppuu -->
						<fo:block margin="0pt" space-before="1.12em" space-after="1.12em" keep-with-next.within-page="always">
							<fo:inline font-size="12pt">
								<xsl:choose>
									<xsl:when test="$sv='true'">
										<xsl:text>Patientens namn</xsl:text>
									</xsl:when>
									<xsl:otherwise>
										<xsl:text>Potilaan nimi</xsl:text>
									</xsl:otherwise>
								</xsl:choose>
							</fo:inline>
						</fo:block>
						<fo:block margin-left="25mm" space-before="1.12em" space-after="1.12em">
						<fo:inline>
							<xsl:value-of select="$XML//hl7:section[(hl7:code/@code='16' or hl7:code/@code='1.2.246.537.6.12.2002.370.16') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']/hl7:text"/>
						</fo:inline>
						</fo:block>

						<!--xsl:variable name="patientCannotSign" select="$XML//hl7:section[(hl7:code/@code='18' or hl7:code/@code='1.2.246.537.6.12.2002.370.18') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']/hl7:entry/hl7:observation/hl7:value/@value"/>
						<xsl:if test="string($patientCannotSign)='true'">
							<fo:block margin="0pt" space-before="1.12em" space-after="1.12em">
								<fo:inline>
									<xsl:choose>
										<xsl:when test="$sv='true'">
											<xsl:text>Patienten är till exempel på grund av sjukdom eller skada oförmögen att underteckna förbudet mot att lämna ut receptuppgifter eller återkallelsen av förbudet mot att lämna ut uppgifter</xsl:text>
											<fo:block />
											<xsl:text>Ja, motivering:&#160;</xsl:text>
										</xsl:when>
										<xsl:otherwise>
											<xsl:text>Potilas ei esimerkiksi sairauden tai vamman takia kykene allekirjoittamaan lääkemääräystietojen luovutuskieltoa tai luovutuskiellon peruutusta </xsl:text>
											<fo:block />
											<xsl:text>Kyllä, peruste:&#160;</xsl:text>
										</xsl:otherwise>
									</xsl:choose>
								</fo:inline>
								<fo:inline>
									<xsl:value-of select="$XML//hl7:section[(hl7:code/@code='19' or hl7:code/@code='1.2.246.537.6.12.2002.370.19') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']/hl7:text"/>
								</fo:inline>
							</fo:block>
						</xsl:if-->
						<fo:block margin="0pt" space-before="1.12em" space-after="1.12em" keep-with-next.within-page="always">
							<fo:inline font-size="12pt" keep-with-next.within-page="always">
								<xsl:choose>
									<xsl:when test="$sv='true'">
										<xsl:text>Underskrift av den som meddelar förbud mot att lämna ut uppgifter / återkallar förbudet mot att lämna ut uppgifter</xsl:text>
									</xsl:when>
									<xsl:otherwise>
										<xsl:text>Luovutuskiellon tekijä / luovutuskiellon peruuttaja</xsl:text>
									</xsl:otherwise>
								</xsl:choose>
							</fo:inline>
						</fo:block>
						<!--xsl:if test="string($patientCannotSign)='true'">
							<fo:block margin="0pt" space-before="1.12em" space-after="1.12em" keep-with-next.within-page="always">
								<fo:inline font-weight="bold">
									<xsl:choose>
										<xsl:when test="$sv='true'">
											<xsl:text>På patientens vägnar </xsl:text>
										</xsl:when>
										<xsl:otherwise>
											<xsl:text>Potilaan puolesta</xsl:text>
										</xsl:otherwise>
									</xsl:choose>
								</fo:inline>
							</fo:block>
						</xsl:if-->
						<fo:block margin-left="25mm" space-before="1.12em" space-after="1.12em">
							<fo:inline>
								<xsl:for-each select="$XML//hl7:section[(hl7:code/@code='22' or hl7:code/@code='1.2.246.537.6.12.2002.370.22') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']/hl7:entry/hl7:observation/hl7:value">
									<xsl:call-template name="formatdatetime">
										<xsl:with-param name="datetime" select="@value"/>
										<xsl:with-param name="skipsec" select="true"/>
									</xsl:call-template>
								</xsl:for-each>
							</fo:inline>
						</fo:block>
						<fo:block margin-left="25mm" space-before="1.12em" space-after="1.12em">
							<fo:inline>
								<xsl:choose>
									<xsl:when test="$XML//hl7:section[(hl7:code/@code='21' or hl7:code/@code='1.2.246.537.6.12.2002.370.21') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']//hl7:given[@qualifier='CL']">
														<xsl:value-of select="$XML//hl7:section[(hl7:code/@code='21' or hl7:code/@code='1.2.246.537.6.12.2002.370.21') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']//hl7:given[@qualifier='CL']"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$XML//hl7:section[(hl7:code/@code='21' or hl7:code/@code='1.2.246.537.6.12.2002.370.21') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']//hl7:given[1]"/>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:text>&#160;</xsl:text>
								<xsl:value-of select="$XML//hl7:section[(hl7:code/@code='21' or hl7:code/@code='1.2.246.537.6.12.2002.370.21') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']//hl7:family"/>
							</fo:inline>
						</fo:block>
						<fo:block margin="0pt" space-before="1.12em" space-after="1.12em" keep-with-next.within-page="always">
							<fo:inline font-size="12pt" keep-with-next.within-page="always">
								<xsl:choose>
									<xsl:when test="$sv='true'">
										<xsl:text>Handlingen lagrades av</xsl:text>
									</xsl:when>
									<xsl:otherwise>
										<xsl:text>Asiakirjan tallentaja</xsl:text>
									</xsl:otherwise>
								</xsl:choose>
							</fo:inline>
						</fo:block>
						<fo:block margin-left="25mm" space-before="1.12em" space-after="1.12em">
							<fo:inline>
								<xsl:value-of select="$XML//hl7:section[(hl7:code/@code='26' or hl7:code/@code='1.2.246.537.6.12.2002.370.26') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']/hl7:text"/>
							</fo:inline>
							<!--xsl:for-each select="$XML//hl7:section[(hl7:code/@code='26' or hl7:code/@code='1.2.246.537.6.12.2002.370.26') and hl7:code/@codeSystem='1.2.246.537.6.12.2002.370']/hl7:text">
								<fo:inline>
									<xsl:value-of select="."/>
									<xsl:text> </xsl:text>
								</fo:inline>
							</xsl:for-each-->
							<fo:inline id="SV_RefID_PageTotal"/>
						</fo:block>
					</fo:block>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="formatdatetime">
		<xsl:param name="datetime"/>
		<xsl:param name="skiptime"/>
		<!-- skips time if value is not empty -->
		<xsl:param name="skipsec"/>
		<!-- skips seconds if value is not empty -->
		<!-- pp-->
		<xsl:if test='substring ($datetime, 7, 2)!=""'>
			<xsl:choose>
				<xsl:when test="substring($datetime,7,1)!='0'">
					<xsl:value-of select="substring ($datetime,7, 2)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="substring ($datetime,8, 1)"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:text>.</xsl:text>
		</xsl:if>
		<!-- kk-->
		<xsl:if test='substring ($datetime, 5, 2)!=""'>
			<xsl:choose>
				<xsl:when test="substring($datetime,5,1)!='0'">
					<xsl:value-of select="substring ($datetime,5, 2)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="substring ($datetime,6, 1)"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:text>.</xsl:text>
		</xsl:if>
		<!-- vvvv-->
		<xsl:value-of select="substring ($datetime, 1, 4)"/>
		<xsl:if test="$skiptime=''">
			<xsl:if test='substring ($datetime, 9, 2)!=""'>
				<xsl:text>&#160;</xsl:text>
				<!-- hh-->
				<xsl:choose>
					<xsl:when test="substring($datetime,9,1)!='0'">
						<xsl:value-of select="substring ($datetime,9, 2)"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="substring ($datetime,10, 1)"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<!-- mm -->
			<xsl:if test='substring ($datetime, 11, 2)!=""'>
				<xsl:text>.</xsl:text>
				<xsl:value-of select="substring ($datetime,11, 2)"/>
			</xsl:if>
			<!-- ss -->
			<xsl:if test='substring ($datetime, 13, 2)!="" and $skipsec=""'>
				<xsl:text>.</xsl:text>
				<xsl:value-of select="substring ($datetime,13, 2)"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template name="pages">
		<fo:block>
			<fo:page-number/> (<fo:page-number-citation ref-id="SV_RefID_PageTotal"/>)</fo:block>
	</xsl:template>
	<msxml:script xmlns:msxml="urn:schemas-microsoft-com:xslt" language="JavaScript" implements-prefix="kela">
		function currentDate(){
			var date = new Date();
			return date.getDate() + '.' + [date.getMonth() + 1] + "." + date.getYear();
		};
	</msxml:script>
</xsl:stylesheet>
