/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.jacoco;

import java.io.IOException;
import org.jacoco.agent.rt.IAgent;
import org.jacoco.agent.rt.RT;

class JacocoController {
    private static final String ERROR = "Unable to access JaCoCo Agent - make sure that you use JaCoCo and version not lower than 0.6.2.";
    private final IAgent agent;
    private boolean testStarted;
    static JacocoController singleton;

    private JacocoController() {
        try {
            this.agent = RT.getAgent();
        }
        catch (Exception | NoClassDefFoundError e) {
            throw new JacocoControllerError(ERROR, e);
        }
    }

    JacocoController(IAgent agent) {
        this.agent = agent;
    }

    public static synchronized JacocoController getInstance() {
        if (singleton == null) {
            singleton = new JacocoController();
        }
        return singleton;
    }

    public synchronized void onTestStart() {
        if (this.testStarted) {
            throw new JacocoControllerError("Looks like several tests executed in parallel in the same JVM, thus coverage per test can't be recorded correctly.");
        }
        this.dump("");
        this.testStarted = true;
    }

    public synchronized void onTestFinish(String name) {
        this.dump(name);
        this.testStarted = false;
    }

    private void dump(String sessionId) {
        this.agent.setSessionId(sessionId);
        try {
            this.agent.dump(true);
        }
        catch (IOException e) {
            throw new JacocoControllerError(e);
        }
    }

    public static class JacocoControllerError
    extends Error {
        public JacocoControllerError(String message) {
            super(message);
        }

        public JacocoControllerError(String message, Throwable cause) {
            super(message, cause);
        }

        public JacocoControllerError(Throwable cause) {
            super(cause);
        }
    }
}

