/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.common.components;

import fi.kanta.common.components.IFileManager;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.exception.FileManagerException;
import fi.kanta.common.util.InternalServiceError;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileManager
implements IFileManager {
    Logger log = LoggerFactory.getLogger(FileManager.class);
    private LogHelper logHelper = new LogHelper();

    @Override
    public String getFileAsString(String logId, String filename) throws FileManagerException {
        String retString = null;
        FileInputStream fis = null;
        try {
            this.log.debug(this.logHelper.formatMsgBgn(logId));
            this.log.debug(this.logHelper.formatMsg(logId, "reading file", filename));
            fis = new FileInputStream(filename);
            int fileLength = fis.available();
            byte[] fileBytes = new byte[fileLength];
            fis.read(fileBytes);
            retString = new String(fileBytes);
            this.log.debug(this.logHelper.formatMsgEnd(logId));
        }
        catch (FileNotFoundException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2002");
            error.setCommonError(true);
            throw new FileManagerException(error, (Throwable)ex);
        }
        catch (IOException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2002");
            error.setCommonError(true);
            throw new FileManagerException(error, (Throwable)ex);
        }
        catch (Exception e) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2002");
            error.setCommonError(true);
            throw new FileManagerException(error, (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    this.log.error(this.logHelper.formatMsg(logId), (Throwable)ex);
                }
            }
        }
        return retString;
    }
}

