/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.common.components;

import fi.kanta.common.components.LogHelper;
import fi.kanta.common.exception.UtilException;
import fi.kanta.common.util.InternalServiceError;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.UserTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceLocator {
    Logger log = LoggerFactory.getLogger(ServiceLocator.class);
    private InitialContext ic;
    private Map<String, Object> cache;
    private LogHelper logHelper;
    private static ServiceLocator me = null;

    private ServiceLocator() throws UtilException {
        try {
            this.logHelper = new LogHelper();
            this.ic = new InitialContext();
            this.cache = Collections.synchronizedMap(new HashMap());
        }
        catch (NamingException ne) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2008");
            error.setCommonError(true);
            throw new UtilException(error, (Throwable)ne);
        }
    }

    public static ServiceLocator getInstance() {
        return me;
    }

    public ExecutorService getExcecutorService(String logId, String name) throws UtilException {
        ExecutorService service = null;
        try {
            this.log.debug(this.logHelper.formatMsgBgn(logId));
            if (this.cache.containsKey(name)) {
                service = (ExecutorService)this.cache.get(name);
                this.log.debug(this.logHelper.formatMsg(logId, "Vanha ExecutorService l\u00f6ytyi", name));
            } else {
                service = Executors.newCachedThreadPool();
                if (service == null) {
                    InternalServiceError error = new InternalServiceError();
                    error.setErrorCode("2007");
                    error.setCommonError(true);
                    throw new UtilException(error);
                }
                this.log.debug(this.logHelper.formatMsg(logId, "Uusi ExecutorService luotiin", name));
                this.cache.put(name, service);
            }
            this.log.debug(this.logHelper.formatMsgEnd(logId));
        }
        catch (Exception ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2007");
            error.setCommonError(true);
            this.log.error(this.logHelper.formatMsg(logId, error));
            throw new UtilException(error, (Throwable)ex);
        }
        return service;
    }

    public ExecutorService getFixedExcecutorService(String logId, String name, int size) throws UtilException {
        ExecutorService service = null;
        try {
            this.log.debug(this.logHelper.formatMsgBgn(logId));
            if (this.cache.containsKey(name)) {
                service = (ExecutorService)this.cache.get(name);
                this.log.debug(this.logHelper.formatMsg(logId, "Vanha ExecutorService l\u00f6ytyi", name));
            } else {
                service = Executors.newFixedThreadPool(size);
                if (service == null) {
                    InternalServiceError error = new InternalServiceError();
                    error.setErrorCode("2007");
                    error.setCommonError(true);
                    throw new UtilException(error);
                }
                this.log.debug(this.logHelper.formatMsg(logId, "Uusi ExecutorService luotiin", name));
                this.cache.put(name, service);
            }
            this.log.debug(this.logHelper.formatMsgEnd(logId));
        }
        catch (Exception ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2007");
            error.setCommonError(true);
            throw new UtilException(error, (Throwable)ex);
        }
        return service;
    }

    public DataSource getDataSource(String logId, String jndiName) throws UtilException {
        DataSource ds = null;
        try {
            this.log.debug(this.logHelper.formatMsgBgn(logId));
            if (this.cache.containsKey(jndiName)) {
                ds = (DataSource)this.cache.get(jndiName);
                this.log.debug(this.logHelper.formatMsg(logId, "Vanha DataSource l\u00f6ytyi", jndiName));
            } else {
                ds = (DataSource)this.ic.lookup(jndiName);
                if (ds == null) {
                    InternalServiceError error = new InternalServiceError();
                    error.setErrorCode("2012");
                    error.setCommonError(true);
                    throw new UtilException(error);
                }
                this.log.debug(this.logHelper.formatMsg(logId, "Uusi DataSource luotiin", jndiName));
                this.cache.put(jndiName, ds);
            }
            this.log.debug(this.logHelper.formatMsgEnd(logId));
        }
        catch (Exception ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2012");
            error.setCommonError(true);
            throw new UtilException(error, (Throwable)ex);
        }
        return ds;
    }

    public UserTransaction getUserTransaction(String logId, String jndiName) throws UtilException {
        UserTransaction ut = null;
        try {
            this.log.debug(this.logHelper.formatMsgBgn(logId));
            if (this.cache.containsKey(jndiName)) {
                ut = (UserTransaction)this.cache.get(jndiName);
                this.log.debug(this.logHelper.formatMsg(logId, "Vanha DataSource l\u00f6ytyi", jndiName));
            } else {
                ut = (UserTransaction)this.ic.lookup(jndiName);
                if (ut == null) {
                    InternalServiceError error = new InternalServiceError();
                    error.setErrorCode("2012");
                    error.setCommonError(true);
                    throw new UtilException(error);
                }
                this.log.debug(this.logHelper.formatMsg(logId, "Uusi UserTransaction luotiin", jndiName));
                this.cache.put(jndiName, ut);
            }
            this.log.debug(this.logHelper.formatMsgEnd(logId));
        }
        catch (Exception ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2012");
            error.setCommonError(true);
            throw new UtilException(error, (Throwable)ex);
        }
        return ut;
    }

    static {
        try {
            me = new ServiceLocator();
        }
        catch (UtilException ex) {
            ex.printStackTrace();
        }
    }
}

