/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.version;

import org.verapdf.version.SemanticVersionNumber;

final class VersionNumberImpl
implements SemanticVersionNumber {
    private static final String separator = "\\.";
    private static final String preReleaseSeparator = "-";
    private static final String buildMetadataSeparator = "+";
    private final int major;
    private final int minor;
    private final int patch;

    private VersionNumberImpl(String version) {
        this(version.split(separator));
    }

    private VersionNumberImpl(String[] parts) {
        this(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
    }

    VersionNumberImpl(int[] parts) {
        this(parts[0], parts[1], parts[2]);
    }

    VersionNumberImpl(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    @Override
    public String getVersionString() {
        return String.format("%d.%d.%d", this.major, this.minor, this.patch);
    }

    @Override
    public int getMajor() {
        return this.major;
    }

    @Override
    public int getMinor() {
        return this.minor;
    }

    @Override
    public int getPatch() {
        return this.patch;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.patch;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VersionNumberImpl)) {
            return false;
        }
        VersionNumberImpl other = (VersionNumberImpl)obj;
        if (this.major != other.major) {
            return false;
        }
        if (this.minor != other.minor) {
            return false;
        }
        return this.patch == other.patch;
    }

    public String toString() {
        return this.getVersionString();
    }

    @Override
    public int compareTo(SemanticVersionNumber other) {
        return VersionNumberImpl.compare(this, other);
    }

    public static SemanticVersionNumber fromString(String versionString) {
        if (versionString == null) {
            throw new IllegalArgumentException("Argument versionString can not be null");
        }
        if (versionString.isEmpty()) {
            throw new IllegalArgumentException("Argument versionString can not be empty");
        }
        String strippedVersion = VersionNumberImpl.stripBuildMetadata(versionString);
        strippedVersion = VersionNumberImpl.stripPreRelease(versionString);
        return VersionNumberImpl.fromStrings(strippedVersion.split(separator));
    }

    public static SemanticVersionNumber fromStrings(String[] parts) {
        if (parts == null) {
            throw new IllegalArgumentException("Argument parts can not be null");
        }
        int[] intParts = new int[]{0, 0, 0};
        for (int iLoop = 0; iLoop < intParts.length && iLoop < parts.length; ++iLoop) {
            try {
                intParts[iLoop] = Integer.parseInt(parts[iLoop]);
                continue;
            }
            catch (NumberFormatException excep) {
                throw new IllegalArgumentException(String.format("NumberFormatException raised when converting \"%s\" to an int.", parts[iLoop]), excep);
            }
        }
        return VersionNumberImpl.fromInts(intParts);
    }

    public static SemanticVersionNumber fromInts(int[] parts) {
        if (parts == null) {
            throw new IllegalArgumentException("Argument parts can not be null");
        }
        if (parts.length != 3) {
            throw new IllegalArgumentException("Argument parts must be a three part array");
        }
        return VersionNumberImpl.fromInts(parts[0], parts[1], parts[2]);
    }

    public static SemanticVersionNumber fromInts(int major, int minor, int revision) {
        if (major < 0) {
            throw new IllegalArgumentException("Argument major can not be < 0");
        }
        if (minor < 0) {
            throw new IllegalArgumentException("Argument minor can not be < 0");
        }
        if (revision < 0) {
            throw new IllegalArgumentException("Argument revision can not be < 0");
        }
        return new VersionNumberImpl(major, minor, revision);
    }

    private static String stripBuildMetadata(String versionString) {
        if (!versionString.contains(buildMetadataSeparator)) {
            return versionString;
        }
        return versionString.substring(0, versionString.indexOf(buildMetadataSeparator));
    }

    private static String stripPreRelease(String versionString) {
        if (!versionString.contains(preReleaseSeparator)) {
            return versionString;
        }
        return versionString.substring(0, versionString.indexOf(preReleaseSeparator));
    }

    private static int compare(SemanticVersionNumber that, SemanticVersionNumber other) {
        int majorDiff = that.getMajor() - other.getMajor();
        if (majorDiff != 0) {
            return majorDiff;
        }
        int minorDiff = that.getMinor() - other.getMinor();
        if (minorDiff != 0) {
            return minorDiff;
        }
        int revisionDiff = that.getPatch() - other.getPatch();
        if (revisionDiff != 0) {
            return revisionDiff;
        }
        return 0;
    }
}

