/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm.classes;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.constantPool.AttributeWriter;
import mockit.asm.constantPool.ConstantPoolGeneration;
import mockit.asm.util.ByteVector;

final class InnerClassesWriter
extends AttributeWriter {
    @Nonnull
    private final ByteVector innerClasses = new ByteVector();
    @Nonnegative
    private int innerClassesCount;

    InnerClassesWriter(@Nonnull ConstantPoolGeneration cp) {
        super(cp, "InnerClasses");
    }

    void add(@Nonnull String name, @Nullable String outerName, @Nullable String innerName, int access) {
        this.innerClasses.putShort(this.cp.newClass(name));
        this.innerClasses.putShort(outerName == null ? 0 : this.cp.newClass(outerName));
        this.innerClasses.putShort(innerName == null ? 0 : this.cp.newUTF8(innerName));
        this.innerClasses.putShort(access);
        ++this.innerClassesCount;
    }

    @Override
    @Nonnegative
    public int getSize() {
        return 8 + this.innerClasses.getLength();
    }

    @Override
    public void put(@Nonnull ByteVector out) {
        this.put(out, 2 + this.innerClasses.getLength());
        out.putShort(this.innerClassesCount);
        out.putByteVector(this.innerClasses);
    }
}

