/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.modification;

import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.classes.ClassReader;
import mockit.coverage.modification.ClassSelection;
import mockit.coverage.modification.CoverageModifier;
import mockit.coverage.modification.VisitInterruptedException;

public final class ClassModification {
    @Nonnull
    private final Set<String> modifiedClasses = new HashSet<String>();
    @Nonnull
    final List<ProtectionDomain> protectionDomainsWithUniqueLocations = new ArrayList<ProtectionDomain>();
    @Nonnull
    private final ClassSelection classSelection = new ClassSelection();

    public boolean shouldConsiderClassesNotLoaded() {
        return !this.classSelection.loadedOnly;
    }

    boolean isToBeConsideredForCoverage(@Nonnull String className, @Nonnull ProtectionDomain protectionDomain) {
        return !this.modifiedClasses.contains(className) && this.classSelection.isSelected(className, protectionDomain);
    }

    @Nullable
    public byte[] modifyClass(@Nonnull String className, @Nonnull ProtectionDomain protectionDomain, @Nonnull byte[] originalClassfile) {
        if (this.isToBeConsideredForCoverage(className, protectionDomain)) {
            try {
                byte[] modifiedClassfile = ClassModification.modifyClassForCoverage(className, originalClassfile);
                this.registerModifiedClass(className, protectionDomain);
                return modifiedClassfile;
            }
            catch (VisitInterruptedException modifiedClassfile) {
            }
            catch (AssertionError | ClassCircularityError | RuntimeException e) {
                ((Throwable)e).printStackTrace();
            }
        }
        return null;
    }

    @Nonnull
    private static byte[] modifyClassForCoverage(@Nonnull String className, @Nonnull byte[] classBytecode) {
        byte[] modifiedBytecode = CoverageModifier.recoverModifiedByteCodeIfAvailable(className);
        if (modifiedBytecode != null) {
            return modifiedBytecode;
        }
        ClassReader cr = new ClassReader(classBytecode);
        CoverageModifier modifier = new CoverageModifier(cr);
        cr.accept(modifier);
        return modifier.toByteArray();
    }

    private void registerModifiedClass(@Nonnull String className, @Nonnull ProtectionDomain pd) {
        this.modifiedClasses.add(className);
        if (pd.getClassLoader() != null && pd.getCodeSource() != null && pd.getCodeSource().getLocation() != null) {
            this.addProtectionDomainIfHasUniqueNewPath(pd);
        }
    }

    private void addProtectionDomainIfHasUniqueNewPath(@Nonnull ProtectionDomain newPD) {
        String newPath = newPD.getCodeSource().getLocation().getPath();
        for (int i = this.protectionDomainsWithUniqueLocations.size() - 1; i >= 0; --i) {
            ProtectionDomain previousPD = this.protectionDomainsWithUniqueLocations.get(i);
            String previousPath = previousPD.getCodeSource().getLocation().getPath();
            if (previousPath.startsWith(newPath)) {
                return;
            }
            if (!newPath.startsWith(previousPath)) continue;
            this.protectionDomainsWithUniqueLocations.set(i, newPD);
            return;
        }
        this.protectionDomainsWithUniqueLocations.add(newPD);
    }
}

