/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting.parsing;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class LineElement
implements Iterable<LineElement> {
    private static final List<String> CONDITIONAL_OPERATORS = Arrays.asList("||", "&&", ":", "else", "?");
    private static final Pattern OPEN_TAG = Pattern.compile("<");
    private static final NoSuchElementException LAST_ELEMENT_REACHED = new NoSuchElementException();
    @Nonnull
    private final ElementType type;
    @Nonnull
    private final String text;
    @Nullable
    private String openingTag;
    @Nullable
    private String closingTag;
    @Nullable
    private LineElement next;
    @Nullable
    private ConditionalStatement conditionalStatement;
    private int parenthesesBalance;

    LineElement(@Nonnull ElementType type, @Nonnull String text) {
        this.type = type;
        this.text = OPEN_TAG.matcher(text).replaceAll("&lt;");
    }

    public boolean isCode() {
        return this.type == ElementType.CODE;
    }

    public boolean isComment() {
        return this.type == ElementType.COMMENT;
    }

    public boolean isKeyword(@Nonnull String keyword) {
        return this.isCode() && this.text.equals(keyword);
    }

    boolean isDotSeparator() {
        return this.type == ElementType.SEPARATOR && this.text.charAt(0) == '.';
    }

    @Nonnull
    public String getText() {
        return this.text;
    }

    @Nullable
    public LineElement getNext() {
        return this.next;
    }

    void setNext(@Nullable LineElement next) {
        this.next = next;
    }

    @Nullable
    public LineElement getNextCodeElement() {
        if (this.next != null) {
            for (LineElement element : this.next) {
                if (!element.isCode()) continue;
                return element;
            }
        }
        return null;
    }

    public void wrapText(@Nonnull String desiredOpeningTag, @Nonnull String desiredClosingTag) {
        this.openingTag = desiredOpeningTag;
        this.closingTag = desiredClosingTag;
    }

    @Nullable
    public LineElement appendUntilNextCodeElement(@Nonnull StringBuilder line) {
        LineElement element = this;
        while (!element.isCode()) {
            element.appendText(line);
            element = element.next;
            if (element == null) break;
            this.copyConditionalTrackingState(element);
        }
        return element;
    }

    private void copyConditionalTrackingState(@Nonnull LineElement destination) {
        destination.conditionalStatement = this.conditionalStatement;
        destination.parenthesesBalance = this.parenthesesBalance;
    }

    private void appendText(@Nonnull StringBuilder line) {
        if (this.openingTag == null) {
            line.append(this.text);
        } else {
            line.append(this.openingTag).append(this.text).append(this.closingTag);
        }
    }

    @Nullable
    public LineElement findNextBranchingPoint() {
        if (this.conditionalStatement == null) {
            this.conditionalStatement = ConditionalStatement.find(this.text);
        }
        if (this.isBranchingElement()) {
            if (this.next != null) {
                this.copyConditionalTrackingState(this.next);
            }
            return this;
        }
        if (this.conditionalStatement != null) {
            int balance = this.getParenthesisBalance();
            this.parenthesesBalance += balance;
            if (balance != 0 && this.parenthesesBalance == 0) {
                return this.next;
            }
        }
        if (this.next == null) {
            return null;
        }
        this.copyConditionalTrackingState(this.next);
        return this.next.findNextBranchingPoint();
    }

    public boolean isBranchingElement() {
        if (this.conditionalStatement == ConditionalStatement.FOR) {
            int p = this.text.indexOf(58);
            if (p < 0) {
                p = this.text.indexOf(59);
            }
            return p >= 0 && this.text.trim().length() == 1;
        }
        return CONDITIONAL_OPERATORS.contains(this.text);
    }

    private int getParenthesisBalance() {
        int balance = 0;
        int p = this.text.indexOf(40);
        while (p >= 0) {
            ++balance;
            p = this.text.indexOf(40, p + 1);
        }
        int q = this.text.indexOf(41);
        while (q >= 0) {
            --balance;
            q = this.text.indexOf(41, q + 1);
        }
        return balance;
    }

    @Nullable
    public LineElement findWord(@Nonnull String word) {
        for (LineElement element : this) {
            if (!element.isCode() || !word.equals(element.text)) continue;
            return element;
        }
        return null;
    }

    int getBraceBalanceUntilEndOfLine() {
        int balance = 0;
        for (LineElement element : this) {
            balance += element.getBraceBalance();
        }
        return balance;
    }

    private int getBraceBalance() {
        if (this.isCode() && this.text.length() == 1) {
            char c = this.text.charAt(0);
            if (c == '{') {
                return 1;
            }
            if (c == '}') {
                return -1;
            }
        }
        return 0;
    }

    public void appendAllBefore(@Nonnull StringBuilder line, @Nullable LineElement elementToStopBefore) {
        LineElement elementToPrint = this;
        do {
            elementToPrint.appendText(line);
        } while ((elementToPrint = elementToPrint.next) != null && elementToPrint != elementToStopBefore);
    }

    @Override
    @Nonnull
    public Iterator<LineElement> iterator() {
        return new Iterator<LineElement>(){
            @Nullable
            private LineElement current;
            {
                this.current = LineElement.this;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            @Nonnull
            public LineElement next() {
                if (this.current == null) {
                    throw LAST_ELEMENT_REACHED;
                }
                LineElement nextElement = this.current;
                this.current = this.current.next;
                return nextElement;
            }

            @Override
            public void remove() {
            }
        };
    }

    public String toString() {
        StringBuilder line = new StringBuilder(200);
        for (LineElement element : this) {
            element.appendText(line);
        }
        return line.toString();
    }

    static enum ElementType {
        CODE,
        COMMENT,
        SEPARATOR;

    }

    static enum ConditionalStatement {
        IF("if"),
        FOR("for"),
        WHILE("while");

        @Nonnull
        private final String keyword;

        private ConditionalStatement(String keyword) {
            this.keyword = keyword;
        }

        @Nullable
        static ConditionalStatement find(@Nonnull String keyword) {
            for (ConditionalStatement statement : ConditionalStatement.values()) {
                if (!statement.keyword.equals(keyword)) continue;
                return statement;
            }
            return null;
        }
    }
}

